```toml
[advisory]
id = "RUSTSEC-2020-0069"
package = "lettre"
date = "2020-11-11"
url = "https://github.com/lettre/lettre/pull/508/commits/bbe7cc5381c5380b54fb8bbb4f77a3725917ff0b"
categories = ["code-execution", "file-disclosure"]
keywords = ["email", "sendmail"]
aliases = ["CVE-2020-28247", "GHSA-vc2p-r46x-m3vx"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N"

[versions]
patched = [">= 0.10.0-alpha.4", "< 0.10.0-alpha.1, >= 0.9.5", "< 0.9.0, >= 0.8.4", "< 0.8.0, >= 0.7.1"]
unaffected = ["< 0.7.0"]

[affected.functions]
# sendmail transport
"lettre::sendmail::SendmailTransport::send" = ["< 0.10.0-alpha.1"]
"lettre::transport::sendmail::SendmailTransport::send" = [">= 0.10.0-alpha.1, <= 0.10.0-alpha.3"]
"lettre::transport::sendmail::SendmailTransport::send_raw" = [">= 0.10.0-alpha.1, <= 0.10.0-alpha.3"]
```

# Argument injection in sendmail transport

Affected versions of lettre allowed argument injection
to the sendmail command. It was possible, using forged `to` addresses,
to pass arbitrary arguments to the sendmail executable.

Depending on the implementation (original sendmail, postfix, exim, etc.)
it could be possible in some cases to write email data into arbitrary files (using sendmail's
logging features).
 
The flaw is corrected by modifying the executed command to stop parsing arguments
before passing the destination addresses.

NOTE: This vulnerability only affects the `sendmail` transport. Others, including `smtp`, are not
affected.

This vulnerability was reported by vin01.
