```toml
[advisory]
id = "RUSTSEC-2023-0058"
package = "inventory"
date = "2023-09-10"
url = "https://github.com/dtolnay/inventory/pull/42"
informational = "unsound"
categories = ["thread-safety"]
keywords = ["life-before-main"]
aliases = ["GHSA-36xm-35qq-795w"]

[versions]
patched = [">= 0.2.0"]
```

# Exposes reference to non-Sync data to an arbitrary thread

Affected versions do not enforce a `Sync` bound on the type of caller-provided
value held in the plugin registry. References to these values are made
accessible to arbitrary threads other than the one that constructed them.

A caller could use this flaw to submit thread-unsafe data into inventory, then
access it as a reference simultaneously from multiple threads.

The flaw was corrected by enforcing that data submitted by the caller into
inventory is `Sync`.
