```toml
[advisory]
id = "RUSTSEC-2023-0057"
package = "inventory"
date = "2023-09-10"
url = "https://github.com/dtolnay/inventory/pull/43"
informational = "unsound"
keywords = ["life-before-main"]
aliases = ["GHSA-ghc8-5cgm-5rpf"]

[versions]
patched = [">= 0.2.0"]
```

# Fails to prohibit standard library access prior to initialization of Rust standard library runtime

Affected versions allow arbitrary caller-provided code to execute before the
lifetime of `main`.

If the caller-provided code accesses particular pieces of the standard library
that require an initialized Rust runtime, such as `std::io` or `std::thread`,
these may not behave as documented. Panics are likely; UB is possible.

The flaw was corrected by enforcing that only code written within the
`inventory` crate, which is guaranteed not to access runtime-dependent parts of
the standard library, runs before `main`. Caller-provided code is restricted to
running at compile time.
