```toml
[advisory]
id = "RUSTSEC-2021-0042"
package = "insert_many"
aliases = ["CVE-2021-29933", "GHSA-29hg-r7c7-54fr"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2021-01-26"
url = "https://github.com/rphmeier/insert_many/issues/1"
categories = ["memory-corruption"]
keywords = ["memory-safety", "double-free"]

[versions]
patched = []
```

# insert_many can drop elements twice on panic

Affected versions of `insert_many` used `ptr::copy` to move over items in a
vector to make space before inserting, duplicating their ownership. It then
iterated over a provided `Iterator` to insert the new items.

If the iterator's `.next()` method panics then the vector would drop the same
elements twice.
