```toml
[advisory]
id = "RUSTSEC-2021-0052"
package = "id-map"
aliases = ["CVE-2021-30455", "CVE-2021-30456", "CVE-2021-30457", "GHSA-8gmx-cpcg-f8h5", "GHSA-rccq-j2m7-8fwr", "GHSA-vfqx-hv88-f9cv"]
date = "2021-02-26"
url = "https://github.com/andrewhickman/id-map/issues/3"
categories = ["memory-corruption"]
keywords = ["memory-safety", "double-free"]

[versions]
patched = []
```

# Multiple functions can cause double-frees

The following functions in the crate are affected:

## `IdMap::clone_from`

The `clone_from` implementation for `IdMap` drops the values present in the
map and then begins cloning values from the other map. If a `.clone()` call
pancics, then the afformentioned dropped elements can be freed again.

## `get_or_insert`

`get_or_insert` reserves space for a value, before calling the user provided
insertion function `f`. If the function `f` panics then uninitialized or
previously freed memory can be dropped.

## `remove_set`

When removing a set of elements, `ptr::drop_in_place` is called on each of the
element to be removed. If the `Drop` impl of one of these elements panics then
the previously dropped elements can be dropped again.
