```toml
[advisory]
id = "RUSTSEC-2020-0008"
package = "hyper"
aliases = ["CVE-2020-35863", "GHSA-h3qr-rq2j-74w4"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["format-injection"]
date = "2020-03-19"
keywords = ["http", "request-smuggling"]
url = "https://github.com/hyperium/hyper/issues/1925"

[versions]
patched = [">= 0.12.34"]
unaffected = ["< 0.11.0"]
```

# Flaw in hyper allows request smuggling by sending a body in GET requests

Vulnerable versions of hyper allow GET requests to have bodies, even if there is
no Transfer-Encoding or Content-Length header.  As per the HTTP 1.1
specification, such requests do not have bodies, so the body will be interpreted
as a separate HTTP request.

This allows an attacker who can control the body and method of an HTTP request
made by hyper to inject a request with headers that would not otherwise be
allowed, as demonstrated by sending a malformed HTTP request from a Substrate
runtime.  This allows bypassing CORS restrictions.  In combination with other
vulnerabilities, such as an exploitable web server listening on loopback, it may
allow remote code execution.

The flaw was corrected in hyper version 0.12.34.
