```toml
[advisory]
id = "RUSTSEC-2020-0145"
package = "heapless"
date = "2020-11-02"
url = "https://github.com/japaric/heapless/issues/181"
categories = ["memory-corruption", "memory-exposure"]
keywords = ["use-after-free"]
informational = "unsound"
aliases = ["CVE-2020-36464", "GHSA-qgwf-r2jj-2ccv"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"

[affected.functions]
"heapless::vec::IntoIter::clone" = ["<= 0.6"]

[versions]
patched = [">= 0.6.1"]
```

# Use-after-free when cloning a partially consumed `Vec` iterator

The `IntoIter` `Clone` implementation clones the whole underlying `Vec`.
If the iterator is partially consumed the consumed items will be copied, thus creating a use-after-free access.

A proof of concept is available in the original bug report.
