```toml
[advisory]
id = "RUSTSEC-2020-0104"
package = "gfwx"
aliases = ["CVE-2020-36211", "GHSA-xp6v-qx65-4pp7"]
cvss = "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H"
date = "2020-12-08"
url = "https://github.com/Devolutions/gfwx-rs/issues/7"
categories = ["memory-corruption", "thread-safety"]

[versions]
patched = [">= 0.3.0"]
```

# ImageChunkMut needs bounds on its Send and Sync traits

In the affected versions of this crate, `ImageChunkMut<'_, T>` unconditionally implements `Send` and `Sync`, allowing to create data races.

This can result in a memory corruption or undefined behavior when non thread-safe types are moved and referenced across thread boundaries.

The flaw was corrected in commit e7fb2f5 by adding `T: Send` bound to the `Send` impl and adding `T: Sync` bound to the `Sync` impl.
