```toml
[advisory]
id = "RUSTSEC-2021-0123"
package = "fruity"
aliases = ["CVE-2021-43620", "GHSA-h352-g5vw-3926"]
date = "2021-11-14"
url = "https://github.com/nvzqz/fruity/issues/14"

[affected.functions]
"fruity::foundation::NSString::to_str" = ["< 0.3.0, >= 0.1.0"]
"fruity::foundation::NSString::to_str_with_nul" = ["< 0.3.0, >= 0.1.0"]
"fruity::foundation::NSString::to_string" = ["< 0.3.0, >= 0.1.0"]
"fruity::foundation::NSString::to_string_with_nul" = ["< 0.3.0, >= 0.1.0"]

[versions]
patched = [">= 0.3.0"]
unaffected = ["< 0.1.0"]
```

# Converting `NSString` to a String Truncates at Null Bytes

Methods of [`NSString`] for conversion to a string may return a partial result.
Since they call [`CStr::from_ptr`] on a pointer to the string buffer, the
string is terminated at the first null byte, which might not be the end of the
string.

In addition to the vulnerable functions listed for this issue, the
implementations of [`Display`], [`PartialEq`], [`PartialOrd`], and [`ToString`]
for [`NSString`] are also affected, since they call those functions.

## Impact

Since [`NSString`] is commonly used as the type for paths by the [Foundation]
framework, null byte truncation might allow for easily bypassing file extension
checks. For example, if a file name is provided by a user and validated to have
one of a specific set of extensions, with validation taking place before
truncation, an attacker can add an accepted extension after a null byte (e.g.,
`file.exe\0.txt`). After truncation, the file name used by the application
would be `file.exe`.

It would be better to generate unique names for files, instead of using
user-provided names, but not all applications take this approach.

## Example:

```rust
let string = NSString::from_str("null\0byte");
println!("{}", string);
```

That example only prints the string "null".

[`CStr::from_ptr`]: https://doc.rust-lang.org/std/ffi/struct.CStr.html#method.from_ptr
[`Display`]: https://doc.rust-lang.org/std/fmt/trait.Display.html
[Foundation]: https://developer.apple.com/documentation/foundation
[`NSString`]: https://docs.rs/fruity/0.2.0/fruity/foundation/struct.NSString.html
[`PartialEq`]: https://doc.rust-lang.org/std/cmp/trait.PartialEq.html
[`PartialOrd`]: https://doc.rust-lang.org/std/cmp/trait.PartialOrd.html
[`ToString`]: https://doc.rust-lang.org/std/string/trait.ToString.html
