```toml
[advisory]
id = "RUSTSEC-2020-0052"
package = "crossbeam-channel"
aliases = ["CVE-2020-15254", "CVE-2020-35904", "GHSA-m8h8-v6jh-c762", "GHSA-v5m7-53cv-f3hx"]
categories = ["memory-corruption"]
date = "2020-06-26"
url = "https://github.com/crossbeam-rs/crossbeam/pull/533"

[versions]
patched = [">= 0.4.4"]
unaffected = ["< 0.4.3"]
```

# Undefined Behavior in bounded channel

The affected version of this crate's the `bounded` channel incorrectly assumes that `Vec::from_iter` has allocated capacity that same as the number of iterator elements. `Vec::from_iter` does not actually guarantee that and may allocate extra memory. The destructor of the `bounded` channel reconstructs `Vec` from the raw pointer based on the incorrect assumes described above. This is unsound and causing deallocation with the incorrect capacity when `Vec::from_iter` has allocated different sizes with the number of iterator elements.
