```toml
[advisory]
id = "RUSTSEC-2023-0014"
package = "cortex-m-rt"
date = "2023-02-13"
informational = "unsound"
url = "https://github.com/rust-embedded/cortex-m/discussions/469"
aliases = ["GHSA-xw5j-gv2g-mjm2"]

[versions]
patched = [">= 0.7.3"]
unaffected = ["<= 0.7.0"]
```

# Miscompilation in cortex-m-rt 0.7.1 and 0.7.2

Version 0.7.1 of the `cortex-m-rt` crate introduced a regression causing the stack to NOT be eight-byte aligned prior to calling `main` (or any other specified entrypoint), violating the [stack ABI of AAPCS32], the default ABI used by all Cortex-M targets. This regression is also present in version 0.7.2 of the `cortex-m-rt` crate.

This regression can cause certain compiler optimizations (which assume the eight-byte alignment) to produce incorrect behavior at runtime. This incorrect behavior has been [observed in real-world applications].

**It is advised that ALL users of `v0.7.1` and `v0.7.2` of the `cortex-m-rt` crate update to the latest version (`v0.7.3`), AS SOON AS POSSIBLE.** Users of `v0.7.0` and prior versions of `cortex-m-rt` are not affected by this regression.

It will be necessary to rebuild all affected firmware binaries, and flash or deploy the new firmware binaries to affected devices.

[stack ABI of AAPCS32]: https://github.com/ARM-software/abi-aa/blob/edd7460d87493fff124b8b5713acf71ffc06ee91/aapcs32/aapcs32.rst#6212stack-constraints-at-a-public-interface
[observed in real-world applications]: https://github.com/peter9477/test2
