```toml
[advisory]
id = "RUSTSEC-2021-0010"
package = "containers"
aliases = ["CVE-2021-25907", "GHSA-cv7x-6rc6-pq5v"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-01-12"
url = "https://github.com/strake/containers.rs/issues/2"
categories = ["memory-corruption"]

[versions]
patched = [">= 0.9.11"]
```

# panic safety: double drop may happen within `util::{mutate, mutate2}`

Upon panic in a user-provided function `f`, `fn mutate()` & `fn mutate2` drops twice a same object.

Affected versions of this crate did not guard against double drop while temporarily duplicating an object's ownership with `ptr::read()`.

Dropping a same object can result in memory corruption.

The flaw was corrected in version "0.9.11" by fixing the code to abort upon panic.
