```toml
[advisory]
id = "RUSTSEC-2022-0066"
package = "conduit-hyper"
date = "2022-10-30"
url = "https://github.com/conduit-rust/conduit-hyper/security/advisories/GHSA-9398-5ghf-7pr6"
categories = ["denial-of-service"]
aliases = ["GHSA-9398-5ghf-7pr6", "CVE-2022-39294"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = [">= 0.4.2"]
unaffected = ["< 0.2.0-alpha.3"]
```

# Denial of Service from unchecked request length

Prior to version 0.4.2, `conduit-hyper` did not check any limit on a request's
length before calling `hyper::body::to_bytes`. An attacker could send a
malicious request with an abnormally large `Content-Length`, which could lead
to a panic if memory allocation failed for that request.

In version 0.4.2, `conduit-hyper` sets an internal limit of 128 MiB per
request, otherwise returning status 400 ("Bad Request").
