```toml
[advisory]
id = "RUSTSEC-2021-0087"
package = "columnar"
date = "2021-01-07"
url = "https://github.com/frankmcsherry/columnar/issues/6"
categories = ["memory-exposure"]
informational = "unsound"
aliases = ["CVE-2021-45685", "GHSA-9mp7-45qh-r8j8", "GHSA-cxcc-q839-2cw9"]

[versions]
patched = [">= 0.1.0"]
```

# columnar: `Read` on uninitialized buffer may cause UB (ColumnarReadExt::read_typed_vec())

Affected versions of this crate passes an uninitialized buffer to a user-provided `Read` implementation (`ColumnarReadExt::read_typed_vec()`).

Arbitrary `Read` implementations can read from the uninitialized buffer (memory exposure) and also can return incorrect number of bytes written to the buffer.
Reading from uninitialized memory produces undefined values that can quickly invoke undefined behavior.
