```toml
[advisory]
id = "RUSTSEC-2024-0017"
package = "cassandra-cpp"
date = "2024-02-28"
url = "https://github.com/Metaswitch/cassandra-rs/security/advisories/GHSA-x9xc-63hg-vcfq"
informational = "unsound"
categories = ["memory-corruption", "memory-exposure"]
keywords = ["memory-safety", "use-after-free"]
aliases = ["CVE-2024-27284", "GHSA-x9xc-63hg-vcfq"]

[versions]
patched = [">= 3.0.0"]
```

# Non-idiomatic use of iterators leads to use after free

Code that attempts to use an item (e.g., a row) returned by an iterator after the iterator has advanced to the next item will be accessing freed memory and experience undefined behaviour. Code that uses the item and then advances the iterator is unaffected. This problem has always existed.

This is a use-after-free bug, so it's rated high severity. If your code uses a pre-3.0.0 version of cassandra-rs, and uses an item returned by a cassandra-rs iterator after calling `next()` on that iterator, then it is vulnerable. However, such code will almost always fail immediately - so we believe it is unlikely that any code using this pattern would have reached production. For peace of mind, we recommend you upgrade anyway.

## Patches

The problem has been fixed in version 3.0.0 (commit 299e6ac50f87eb2823a373baec37b590a74994ee). Users should upgrade to ensure their code cannot use the problematic pattern. There is an upgrade guide in the project README.

## Workarounds

Ensure all usage fits the expected pattern. For example, use `get_first_row()` rather than an iterator, or completely process an item before advancing the iterator with `next()`.
