```toml
[advisory]
id = "RUSTSEC-2021-0131"

package = "brotli-sys"
date = "2021-12-20"
url = "https://github.com/bitemyapp/brotli2-rs/issues/45"
references = ["https://github.com/google/brotli/releases/tag/v1.0.9"]
categories = ["memory-corruption"]
keywords = ["integer-overflow"]
aliases = ["CVE-2020-8927"]

[affected]

# There isn't a patch for brotli2-sys, but version 1.0.9 of google/brotli is patched
[versions]
patched = []
```
# Integer overflow in the bundled Brotli C library

A buffer overflow exists in the Brotli library versions prior to 1.0.8 where an attacker controlling the input length of a "one-shot" decompression request to a script can trigger a crash, which happens when copying over chunks of data larger than 2 GiB.

An updated version of `brotli-sys` has not been released. If one cannot update the C library, its authors recommend to use the "streaming" API as opposed to the "one-shot" API, and impose chunk size limits.

In Rust the issue can be mitigated by migrating to the `brotli` crate, which provides a Rust implementation of Brotli compression and decompression that is not affected by this issue.
