```toml
[advisory]
id = "RUSTSEC-2021-0008"
package = "bra"
aliases = ["CVE-2021-25905", "GHSA-j8qq-58cr-8cc7"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H"
date = "2021-01-02"
url = "https://github.com/Enet4/bra-rs/issues/1"
categories = ["memory-exposure"]

[versions]
patched = [">= 0.1.1"]
```

# reading on uninitialized buffer can cause UB (`impl<R> BufRead for GreedyAccessReader<R>`)

Affected versions of this crate creates an uninitialized buffer and passes it to user-provided `Read` implementation.

This is unsound, because it allows safe Rust code to exhibit an undefined behavior (read from uninitialized memory).

The flaw was corrected in version 0.1.1 by zero-initializing a newly allocated buffer
before handing it to a user-provided `Read` implementation. 
