```toml
[advisory]
id = "RUSTSEC-2023-0062"
package = "bcder"
date = "2023-09-13"
url = "https://nlnetlabs.nl/downloads/bcder/CVE-2023-39914.txt"
categories = ["denial-of-service"]
keywords = ["example", "freeform", "keywords"]
aliases = ["CVE-2023-39914", "GHSA-6jmw-6mxw-w4jc"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
references = ["https://github.com/NLnetLabs/bcder/pull/74"]

[versions]
patched = [">= 0.7.3"]
```

# BER/CER/DER decoder panics on invalid input

Due to insufficient checking of input data, decoding certain data sequences
can lead to _bcder_ panicking rather than returning an error. This can affect
both the actual decoding stage as well as accessing content of types that
utilized delayed decoding.

bcder 0.7.3 fixes these issues by more thoroughly checking inputs and
returning errors as expected.

