```toml
[advisory]
id = "RUSTSEC-2021-0090"
package = "ash"
date = "2021-01-07"
url = "https://github.com/MaikKlein/ash/issues/354"
categories = ["memory-exposure"]
informational = "unsound"
aliases = ["CVE-2021-45688", "GHSA-64wv-8vwp-xgw2", "GHSA-qj69-c89v-jwq2"]

[versions]
patched = [">= 0.33.1"]
```

# Reading on uninitialized memory may cause UB ( `util::read_spv()` )

Affected versions of this crate passes an uninitialized buffer to a user-provided `Read` implementation.

Arbitrary `Read` implementations can read from the uninitialized buffer (memory exposure) and also can return incorrect number of bytes written to the buffer.
Reading from uninitialized memory produces undefined values that can quickly invoke undefined behavior.
