```toml
[advisory]
id = "RUSTSEC-2022-0012"
package = "arrow2"
date = "2022-03-04"
url = "https://github.com/jorgecarleitao/arrow2/issues/880"
categories = ["memory-corruption"]
aliases = ["GHSA-5j8w-r7g8-5472"]

[versions]
patched = [">= 0.7.1, < 0.8", ">= 0.8.2, < 0.9", ">= 0.9.2, < 0.10", ">= 0.10.0"]
```

# Arrow2 allows double free in `safe` code

The struct `Ffi_ArrowArray` implements `#derive(Clone)` that is inconsistent with
its custom implementation of `Drop`, resulting in a double free when cloned.

Cloning this struct in `safe` results in a segmentation fault, which is unsound.

This derive was removed from this struct. All users are advised to either:
* bump the patch version of this crate (for versions `v0.7,v0.8,v0.9`), or
* migrate to a more recent version of  the crate (when using `<0.7`).

Doing so elimitates this vulnerability (code no longer compiles).
