```toml
[advisory]
id = "RUSTSEC-2020-0149"
package = "appendix"
date = "2020-11-15"
url = "https://github.com/krl/appendix/issues/6"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36469", "GHSA-fvhr-7j8m-3cvc"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = []
```

# Data race and memory safety issue in `Index`

The `appendix` crate implements a key-value mapping data structure called
`Index<K, V>` that is stored on disk. The crate allows for any type to inhabit
the generic `K` and `V` type parameters and implements Send and Sync for them
unconditionally.

Using a type that is not marked as `Send` or `Sync` with `Index` can allow it
to be used across multiple threads leading to data races. Additionally using
reference types for the keys or values will lead to the segmentation faults
in the crate's code.
