```toml
[advisory]
id = "RUSTSEC-2024-0433"
package = "age"
date = "2024-12-18"
url = "https://github.com/str4d/rage/security/advisories/GHSA-4fg7-vxc8-qx5w"
categories = ["code-execution"]
aliases = ["GHSA-4fg7-vxc8-qx5w"]
related = ["GHSA-32gq-x56h-299c"]

[affected.functions]
"age::plugin::Identity::from_str" = [
    "0.6.0",
    ">= 0.7.0, < 0.7.2",
    ">= 0.8.0, < 0.8.2",
    ">= 0.9.0, < 0.9.3",
    "0.10.0",
    "0.11.0",
]
"age::plugin::Identity::default_for_plugin" = [
    ">= 0.7.0, < 0.7.2",
    ">= 0.8.0, < 0.8.2",
    ">= 0.9.0, < 0.9.3",
    "0.10.0",
    "0.11.0",
]
"age::plugin::IdentityPluginV1::new" = [
    "0.6.0",
    ">= 0.7.0, < 0.7.2",
    ">= 0.8.0, < 0.8.2",
    ">= 0.9.0, < 0.9.3",
    "0.10.0",
    "0.11.0",
]
"age::plugin::Recipient::from_str" = [
    "0.6.0",
    ">= 0.7.0, < 0.7.2",
    ">= 0.8.0, < 0.8.2",
    ">= 0.9.0, < 0.9.3",
    "0.10.0",
    "0.11.0",
]
"age::plugin::RecipientPluginV1::new" = [
    "0.6.0",
    ">= 0.7.0, < 0.7.2",
    ">= 0.8.0, < 0.8.2",
    ">= 0.9.0, < 0.9.3",
    "0.10.0",
    "0.11.0",
]

[versions]
patched = [
    ">= 0.6.1, < 0.7.0",
    ">= 0.7.2, < 0.8.0",
    ">= 0.8.2, < 0.9.0",
    ">= 0.9.3, < 0.10.0",
    ">= 0.10.1, < 0.11.0",
    ">= 0.11.1",
]
unaffected = ["< 0.6.0"]
```

# Malicious plugin names, recipients, or identities can cause arbitrary binary execution

A plugin name containing a path separator may allow an attacker to execute an arbitrary
binary.

Such a plugin name can be provided through an attacker-controlled input to the following
`age` APIs when the `plugin` feature flag is enabled:
- [`age::plugin::Identity::from_str`](https://docs.rs/age/0.11.0/age/plugin/struct.Identity.html#impl-FromStr-for-Identity)
  (or equivalently [`str::parse::<age::plugin::Identity>()`](https://doc.rust-lang.org/stable/core/primitive.str.html#method.parse))
- [`age::plugin::Identity::default_for_plugin`](https://docs.rs/age/0.11.0/age/plugin/struct.Identity.html#method.default_for_plugin)
- [`age::plugin::IdentityPluginV1::new`](https://docs.rs/age/0.11.0/age/plugin/struct.IdentityPluginV1.html#method.new)
  (the `plugin_name` argument)
- [`age::plugin::Recipient::from_str`](https://docs.rs/age/0.11.0/age/plugin/struct.Recipient.html#impl-FromStr-for-Recipient)
  (or equivalently [`str::parse::<age::plugin::Recipient>()`](https://doc.rust-lang.org/stable/core/primitive.str.html#method.parse))
- [`age::plugin::RecipientPluginV1::new`](https://docs.rs/age/0.11.0/age/plugin/struct.RecipientPluginV1.html#method.new)
  (the `plugin_name` argument)

On UNIX systems, a directory matching `age-plugin-*` needs to exist in the working
directory for the attack to succeed.

The binary is executed with a single flag, either `--age-plugin=recipient-v1` or
`--age-plugin=identity-v1`. The standard input includes the recipient or identity string,
and the random file key (if encrypting) or the header of the file (if decrypting). The
format is constrained by the [age-plugin](https://c2sp.org/age-plugin) protocol.

An equivalent issue was fixed in [the reference Go implementation of age](https://github.com/FiloSottile/age),
see advisory [GHSA-32gq-x56h-299c](https://github.com/FiloSottile/age/security/advisories/GHSA-32gq-x56h-299c).

Thanks to ⬡-49016 for reporting this issue.
