```toml
[advisory]
id = "RUSTSEC-2021-0045"
package = "adtensor"
aliases = ["CVE-2021-29936", "GHSA-rg4m-gww5-7p47"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-01-11"
url = "https://github.com/charles-r-earp/adtensor/issues/4"
categories = ["memory-corruption"]
keywords = ["memory-safety"]

[versions]
patched = []
```

# FromIterator implementation for Vector/Matrix can drop uninitialized memory

The `FromIterator<T>` methods for `Vector` and `Matrix` rely on the type
parameter `N` to allocate space in the iterable.

If the passed in `N` type parameter is larger than the number of items returned
by the iterator, it can lead to uninitialized memory being left in the
`Vector` or `Matrix` type which gets dropped.
