```toml
[advisory]
id = "RUSTSEC-2018-0019"
package = "actix-web"
categories = ["memory-corruption"]
date = "2018-06-08"
url = "https://github.com/actix/actix-web/issues/289"
aliases = ["CVE-2018-25024", "CVE-2018-25025", "CVE-2018-25026", "GHSA-7x36-h62w-vw65", "GHSA-9qj6-4rfq-vm84", "GHSA-fgfm-hqjw-3265", "GHSA-w65j-g6c7-g3m4"]

[versions]
patched = [">= 0.7.15"]
```

# Multiple memory safety issues

Affected versions contain multiple memory safety issues, such as:

 - Unsoundly coercing immutable references to mutable references
 - Unsoundly extending lifetimes of strings
 - Adding the `Send` marker trait to objects that cannot be safely sent between threads

This may result in a variety of memory corruption scenarios, most likely use-after-free.
 
A significant refactoring effort has been conducted to resolve these issues.
