```toml
[advisory]
id = "RUSTSEC-2020-0046"
package = "actix-service"
aliases = ["CVE-2020-35899", "GHSA-whc7-5p35-4ww2"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
categories = ["memory-corruption"]
date = "2020-01-08"
informational = "unsound"
url = "https://github.com/actix/actix-net/pull/158"

[versions]
patched = [">= 1.0.6"]
```

# bespoke Cell implementation allows obtaining several mutable references to the same data

The custom implementation of a Cell primitive in the affected versions of this crate
does not keep track of mutable references to the underlying data.

This allows obtaining several mutable references to the same object
which may result in arbitrary memory corruption, most likely use-after-free.

The flaw was corrected by switching from a bespoke `Cell<T>` implementation to `Rc<RefCell<T>>`.
