```toml
[advisory]
id = "RUSTSEC-2020-0048"
package = "actix-http"
aliases = ["CVE-2020-35901", "GHSA-v3j6-xf77-8r9c"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["memory-corruption"]
date = "2020-01-24"
url = "https://github.com/actix/actix-web/issues/1321"

[versions]
patched = [">= 2.0.0-alpha.1"]
```

# Use-after-free in BodyStream due to lack of pinning

Affected versions of this crate did not require the buffer wrapped in `BodyStream` to be pinned,
but treated it as if it had a fixed location in memory. This may result in a use-after-free.
 
The flaw was corrected by making the trait `MessageBody` require `Unpin`
and making `poll_next()` function accept `Pin<&mut Self>` instead of `&mut self`.
