// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddAccessGrant = "AddAccessGrant"

// AddAccessGrantRequest generates a "aws/request.Request" representing the
// client's request for the AddAccessGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddAccessGrant for more information on using the AddAccessGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddAccessGrantRequest method.
//	req, resp := client.AddAccessGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddAccessGrant
func (c *SSM) AddAccessGrantRequest(input *AddAccessGrantInput) (req *request.Request, output *AddAccessGrantOutput) {
	op := &request.Operation{
		Name:       opAddAccessGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAccessGrantInput{}
	}

	output = &AddAccessGrantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddAccessGrant API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation AddAccessGrant for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidParameterException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddAccessGrant
func (c *SSM) AddAccessGrant(input *AddAccessGrantInput) (*AddAccessGrantOutput, error) {
	req, out := c.AddAccessGrantRequest(input)
	return out, req.Send()
}

// AddAccessGrantWithContext is the same as AddAccessGrant with the addition of
// the ability to pass a context and additional request options.
//
// See AddAccessGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) AddAccessGrantWithContext(ctx aws.Context, input *AddAccessGrantInput, opts ...request.Option) (*AddAccessGrantOutput, error) {
	req, out := c.AddAccessGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddEventsForExploreSsmActions = "AddEventsForExploreSsmActions"

// AddEventsForExploreSsmActionsRequest generates a "aws/request.Request" representing the
// client's request for the AddEventsForExploreSsmActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddEventsForExploreSsmActions for more information on using the AddEventsForExploreSsmActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddEventsForExploreSsmActionsRequest method.
//	req, resp := client.AddEventsForExploreSsmActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddEventsForExploreSsmActions
func (c *SSM) AddEventsForExploreSsmActionsRequest(input *AddEventsForExploreSsmActionsInput) (req *request.Request, output *AddEventsForExploreSsmActionsOutput) {
	op := &request.Operation{
		Name:       opAddEventsForExploreSsmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddEventsForExploreSsmActionsInput{}
	}

	output = &AddEventsForExploreSsmActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddEventsForExploreSsmActions API operation for Amazon Simple Systems Management Service.
//
// # Adding explore event
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation AddEventsForExploreSsmActions for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddEventsForExploreSsmActions
func (c *SSM) AddEventsForExploreSsmActions(input *AddEventsForExploreSsmActionsInput) (*AddEventsForExploreSsmActionsOutput, error) {
	req, out := c.AddEventsForExploreSsmActionsRequest(input)
	return out, req.Send()
}

// AddEventsForExploreSsmActionsWithContext is the same as AddEventsForExploreSsmActions with the addition of
// the ability to pass a context and additional request options.
//
// See AddEventsForExploreSsmActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) AddEventsForExploreSsmActionsWithContext(ctx aws.Context, input *AddEventsForExploreSsmActionsInput, opts ...request.Option) (*AddEventsForExploreSsmActionsOutput, error) {
	req, out := c.AddEventsForExploreSsmActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddTagsToResourceRequest method.
//	req, resp := client.AddTagsToResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource
func (c *SSM) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for Amazon Simple Systems Management Service.
//
// Adds or overwrites one or more tags for the specified resource. Tags are
// metadata that you can assign to your automations, documents, managed nodes,
// maintenance windows, Parameter Store parameters, and patch baselines. Tags
// enable you to categorize your resources in different ways, for example, by
// purpose, owner, or environment. Each tag consists of a key and an optional
// value, both of which you define. For example, you could define a set of tags
// for your account's managed nodes that helps you track each node's owner and
// stack level. For example:
//
//   - Key=Owner,Value=DbAdmin
//
//   - Key=Owner,Value=SysAdmin
//
//   - Key=Owner,Value=Dev
//
//   - Key=Stack,Value=Production
//
//   - Key=Stack,Value=Pre-Production
//
//   - Key=Stack,Value=Test
//
// Most resources can have a maximum of 50 tags. Automations can have a maximum
// of 5 tags.
//
// We recommend that you devise a set of tag keys that meets your needs for
// each resource type. Using a consistent set of tag keys makes it easier for
// you to manage your resources. You can search and filter the resources based
// on the tags you add. Tags don't have any semantic meaning to and are interpreted
// strictly as a string of characters.
//
// For more information about using tags with Amazon Elastic Compute Cloud (Amazon
// EC2) instances, see Tag your Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceType
//     The resource type isn't valid. For example, if you are attempting to tag
//     an EC2 instance, the instance must be a registered managed node.
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - TooManyTagsError
//     The Targets parameter includes too many tags. Remove one or more tags and
//     try the command again.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource
func (c *SSM) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssignResource = "AssignResource"

// AssignResourceRequest generates a "aws/request.Request" representing the
// client's request for the AssignResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignResource for more information on using the AssignResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssignResourceRequest method.
//	req, resp := client.AssignResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AssignResource
func (c *SSM) AssignResourceRequest(input *AssignResourceInput) (req *request.Request, output *AssignResourceOutput) {
	op := &request.Operation{
		Name:       opAssignResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignResourceInput{}
	}

	output = &AssignResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssignResource API operation for Amazon Simple Systems Management Service.
//
// # Assigns a resource to an assignee
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation AssignResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidParameterException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AssignResource
func (c *SSM) AssignResource(input *AssignResourceInput) (*AssignResourceOutput, error) {
	req, out := c.AssignResourceRequest(input)
	return out, req.Send()
}

// AssignResourceWithContext is the same as AssignResource with the addition of
// the ability to pass a context and additional request options.
//
// See AssignResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) AssignResourceWithContext(ctx aws.Context, input *AssignResourceInput, opts ...request.Option) (*AssignResourceOutput, error) {
	req, out := c.AssignResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateOpsItemRelatedItem = "AssociateOpsItemRelatedItem"

// AssociateOpsItemRelatedItemRequest generates a "aws/request.Request" representing the
// client's request for the AssociateOpsItemRelatedItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateOpsItemRelatedItem for more information on using the AssociateOpsItemRelatedItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateOpsItemRelatedItemRequest method.
//	req, resp := client.AssociateOpsItemRelatedItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AssociateOpsItemRelatedItem
func (c *SSM) AssociateOpsItemRelatedItemRequest(input *AssociateOpsItemRelatedItemInput) (req *request.Request, output *AssociateOpsItemRelatedItemOutput) {
	op := &request.Operation{
		Name:       opAssociateOpsItemRelatedItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateOpsItemRelatedItemInput{}
	}

	output = &AssociateOpsItemRelatedItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateOpsItemRelatedItem API operation for Amazon Simple Systems Management Service.
//
// Associates a related item to a Systems Manager OpsCenter OpsItem. For example,
// you can associate an Incident Manager incident or analysis with an OpsItem.
// Incident Manager and OpsCenter are capabilities of Amazon Web Services Systems
// Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation AssociateOpsItemRelatedItem for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsItemNotFoundException
//     The specified OpsItem ID doesn't exist. Verify the ID and try again.
//
//   - OpsItemConflictException
//     The specified OpsItem is in the process of being deleted.
//
//   - OpsItemLimitExceededException
//     The request caused OpsItems to exceed one or more quotas.
//
//   - OpsItemInvalidParameterException
//     A specified parameter argument isn't valid. Verify the available arguments
//     and try again.
//
//   - OpsItemRelatedItemAlreadyExistsException
//     The Amazon Resource Name (ARN) is already associated with the OpsItem.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AssociateOpsItemRelatedItem
func (c *SSM) AssociateOpsItemRelatedItem(input *AssociateOpsItemRelatedItemInput) (*AssociateOpsItemRelatedItemOutput, error) {
	req, out := c.AssociateOpsItemRelatedItemRequest(input)
	return out, req.Send()
}

// AssociateOpsItemRelatedItemWithContext is the same as AssociateOpsItemRelatedItem with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateOpsItemRelatedItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) AssociateOpsItemRelatedItemWithContext(ctx aws.Context, input *AssociateOpsItemRelatedItemInput, opts ...request.Option) (*AssociateOpsItemRelatedItemOutput, error) {
	req, out := c.AssociateOpsItemRelatedItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelCommand = "CancelCommand"

// CancelCommandRequest generates a "aws/request.Request" representing the
// client's request for the CancelCommand operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCommand for more information on using the CancelCommand
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelCommandRequest method.
//	req, resp := client.CancelCommandRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand
func (c *SSM) CancelCommandRequest(input *CancelCommandInput) (req *request.Request, output *CancelCommandOutput) {
	op := &request.Operation{
		Name:       opCancelCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelCommandInput{}
	}

	output = &CancelCommandOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelCommand API operation for Amazon Simple Systems Management Service.
//
// Attempts to cancel the command specified by the Command ID. There is no guarantee
// that the command will be terminated and the underlying process stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CancelCommand for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidCommandId
//     The specified command ID isn't valid. Verify the ID and try again.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - DuplicateInstanceId
//     You can't specify a managed node ID in more than one association.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand
func (c *SSM) CancelCommand(input *CancelCommandInput) (*CancelCommandOutput, error) {
	req, out := c.CancelCommandRequest(input)
	return out, req.Send()
}

// CancelCommandWithContext is the same as CancelCommand with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCommand for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CancelCommandWithContext(ctx aws.Context, input *CancelCommandInput, opts ...request.Option) (*CancelCommandOutput, error) {
	req, out := c.CancelCommandRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelMaintenanceWindowExecution = "CancelMaintenanceWindowExecution"

// CancelMaintenanceWindowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the CancelMaintenanceWindowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelMaintenanceWindowExecution for more information on using the CancelMaintenanceWindowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelMaintenanceWindowExecutionRequest method.
//	req, resp := client.CancelMaintenanceWindowExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution
func (c *SSM) CancelMaintenanceWindowExecutionRequest(input *CancelMaintenanceWindowExecutionInput) (req *request.Request, output *CancelMaintenanceWindowExecutionOutput) {
	op := &request.Operation{
		Name:       opCancelMaintenanceWindowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelMaintenanceWindowExecutionInput{}
	}

	output = &CancelMaintenanceWindowExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelMaintenanceWindowExecution API operation for Amazon Simple Systems Management Service.
//
// Stops a maintenance window execution that is already in progress and cancels
// any tasks in the window that haven't already starting running. Tasks already
// in progress will continue to completion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CancelMaintenanceWindowExecution for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution
func (c *SSM) CancelMaintenanceWindowExecution(input *CancelMaintenanceWindowExecutionInput) (*CancelMaintenanceWindowExecutionOutput, error) {
	req, out := c.CancelMaintenanceWindowExecutionRequest(input)
	return out, req.Send()
}

// CancelMaintenanceWindowExecutionWithContext is the same as CancelMaintenanceWindowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See CancelMaintenanceWindowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CancelMaintenanceWindowExecutionWithContext(ctx aws.Context, input *CancelMaintenanceWindowExecutionInput, opts ...request.Option) (*CancelMaintenanceWindowExecutionOutput, error) {
	req, out := c.CancelMaintenanceWindowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateActivation = "CreateActivation"

// CreateActivationRequest generates a "aws/request.Request" representing the
// client's request for the CreateActivation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateActivation for more information on using the CreateActivation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateActivationRequest method.
//	req, resp := client.CreateActivationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation
func (c *SSM) CreateActivationRequest(input *CreateActivationInput) (req *request.Request, output *CreateActivationOutput) {
	op := &request.Operation{
		Name:       opCreateActivation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateActivationInput{}
	}

	output = &CreateActivationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateActivation API operation for Amazon Simple Systems Management Service.
//
// Generates an activation code and activation ID you can use to register your
// on-premises servers, edge devices, or virtual machine (VM) with Amazon Web
// Services Systems Manager. Registering these machines with Systems Manager
// makes it possible to manage them using Systems Manager capabilities. You
// use the activation code and ID when installing SSM Agent on machines in your
// hybrid environment. For more information about requirements for managing
// on-premises machines using Systems Manager, see Using Amazon Web Services
// Systems Manager in hybrid and multicloud environments (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-hybrid-multicloud.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises
// servers and VMs that are configured for Systems Manager are all called managed
// nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateActivation for usage and error information.
//
// Returned Error Types:
//
//   - RegistrationLimitExceeded
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation
func (c *SSM) CreateActivation(input *CreateActivationInput) (*CreateActivationOutput, error) {
	req, out := c.CreateActivationRequest(input)
	return out, req.Send()
}

// CreateActivationWithContext is the same as CreateActivation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateActivation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateActivationWithContext(ctx aws.Context, input *CreateActivationInput, opts ...request.Option) (*CreateActivationOutput, error) {
	req, out := c.CreateActivationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssociation = "CreateAssociation"

// CreateAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssociation for more information on using the CreateAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAssociationRequest method.
//	req, resp := client.CreateAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation
func (c *SSM) CreateAssociationRequest(input *CreateAssociationInput) (req *request.Request, output *CreateAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationInput{}
	}

	output = &CreateAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssociation API operation for Amazon Simple Systems Management Service.
//
// A State Manager association defines the state that you want to maintain on
// your managed nodes. For example, an association can specify that anti-virus
// software must be installed and running on your managed nodes, or that certain
// ports must be closed. For static targets, the association specifies a schedule
// for when the configuration is reapplied. For dynamic targets, such as an
// Amazon Web Services resource group or an Amazon Web Services autoscaling
// group, State Manager, a capability of Amazon Web Services Systems Manager
// applies the configuration when new managed nodes are added to the group.
// The association also specifies actions to take when applying the configuration.
// For example, an association for anti-virus software might run once a day.
// If the software isn't installed, then State Manager installs it. If the software
// is installed, but the service isn't running, then the association might instruct
// State Manager to start the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateAssociation for usage and error information.
//
// Returned Error Types:
//
//   - AssociationAlreadyExists
//     The specified association already exists.
//
//   - AssociationLimitExceeded
//     You can have at most 2,000 active associations.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - UnsupportedPlatformType
//     The document doesn't support the platform type of the given managed node
//     IDs. For example, you sent an document for a Windows managed node to a Linux
//     node.
//
//   - InvalidOutputLocation
//     The output location isn't valid or doesn't exist.
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
//   - InvalidTarget
//     The target isn't valid or doesn't exist. It might not be configured for Systems
//     Manager or you might not have permission to perform the operation.
//
//   - InvalidSchedule
//     The schedule is invalid. Verify your cron or rate expression and try again.
//
//   - InvalidTargetMaps
//     TargetMap parameter isn't valid.
//
//   - InvalidTag
//     The specified tag key or value isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation
func (c *SSM) CreateAssociation(input *CreateAssociationInput) (*CreateAssociationOutput, error) {
	req, out := c.CreateAssociationRequest(input)
	return out, req.Send()
}

// CreateAssociationWithContext is the same as CreateAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateAssociationWithContext(ctx aws.Context, input *CreateAssociationInput, opts ...request.Option) (*CreateAssociationOutput, error) {
	req, out := c.CreateAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssociationBatch = "CreateAssociationBatch"

// CreateAssociationBatchRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssociationBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssociationBatch for more information on using the CreateAssociationBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAssociationBatchRequest method.
//	req, resp := client.CreateAssociationBatchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch
func (c *SSM) CreateAssociationBatchRequest(input *CreateAssociationBatchInput) (req *request.Request, output *CreateAssociationBatchOutput) {
	op := &request.Operation{
		Name:       opCreateAssociationBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationBatchInput{}
	}

	output = &CreateAssociationBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssociationBatch API operation for Amazon Simple Systems Management Service.
//
// Associates the specified Amazon Web Services Systems Manager document (SSM
// document) with the specified managed nodes or targets.
//
// When you associate a document with one or more managed nodes using IDs or
// tags, Amazon Web Services Systems Manager Agent (SSM Agent) running on the
// managed node processes the document and configures the node as specified.
//
// If you associate a document with a managed node that already has an associated
// document, the system returns the AssociationAlreadyExists exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateAssociationBatch for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
//   - DuplicateInstanceId
//     You can't specify a managed node ID in more than one association.
//
//   - AssociationLimitExceeded
//     You can have at most 2,000 active associations.
//
//   - UnsupportedPlatformType
//     The document doesn't support the platform type of the given managed node
//     IDs. For example, you sent an document for a Windows managed node to a Linux
//     node.
//
//   - InvalidOutputLocation
//     The output location isn't valid or doesn't exist.
//
//   - InvalidTarget
//     The target isn't valid or doesn't exist. It might not be configured for Systems
//     Manager or you might not have permission to perform the operation.
//
//   - InvalidSchedule
//     The schedule is invalid. Verify your cron or rate expression and try again.
//
//   - InvalidTargetMaps
//     TargetMap parameter isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch
func (c *SSM) CreateAssociationBatch(input *CreateAssociationBatchInput) (*CreateAssociationBatchOutput, error) {
	req, out := c.CreateAssociationBatchRequest(input)
	return out, req.Send()
}

// CreateAssociationBatchWithContext is the same as CreateAssociationBatch with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssociationBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateAssociationBatchWithContext(ctx aws.Context, input *CreateAssociationBatchInput, opts ...request.Option) (*CreateAssociationBatchOutput, error) {
	req, out := c.CreateAssociationBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDocument = "CreateDocument"

// CreateDocumentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDocument for more information on using the CreateDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDocumentRequest method.
//	req, resp := client.CreateDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument
func (c *SSM) CreateDocumentRequest(input *CreateDocumentInput) (req *request.Request, output *CreateDocumentOutput) {
	op := &request.Operation{
		Name:       opCreateDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDocumentInput{}
	}

	output = &CreateDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDocument API operation for Amazon Simple Systems Management Service.
//
// Creates a Amazon Web Services Systems Manager (SSM document). An SSM document
// defines the actions that Systems Manager performs on your managed nodes.
// For more information about SSM documents, including information about supported
// schemas, features, and syntax, see Amazon Web Services Systems Manager Documents
// (https://docs.aws.amazon.com/systems-manager/latest/userguide/documents.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateDocument for usage and error information.
//
// Returned Error Types:
//
//   - DocumentAlreadyExists
//     The specified document already exists.
//
//   - MaxDocumentSizeExceeded
//     The size limit of a document is 64 KB.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocumentContent
//     The content for the document isn't valid.
//
//   - DocumentLimitExceeded
//     You can have at most 500 active SSM documents.
//
//   - InvalidDocumentSchemaVersion
//     The version of the document schema isn't supported.
//
//   - AutomationDefinitionNotFoundException
//     An Automation runbook with the specified name couldn't be found.
//
//   - AutomationDefinitionVersionNotFoundException
//     An Automation runbook with the specified name and version couldn't be found.
//
//   - InvalidDocumentOperation
//     You attempted to delete a document while it is still shared. You must stop
//     sharing the document before you can delete it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument
func (c *SSM) CreateDocument(input *CreateDocumentInput) (*CreateDocumentOutput, error) {
	req, out := c.CreateDocumentRequest(input)
	return out, req.Send()
}

// CreateDocumentWithContext is the same as CreateDocument with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateDocumentWithContext(ctx aws.Context, input *CreateDocumentInput, opts ...request.Option) (*CreateDocumentOutput, error) {
	req, out := c.CreateDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMaintenanceWindow = "CreateMaintenanceWindow"

// CreateMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the CreateMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMaintenanceWindow for more information on using the CreateMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMaintenanceWindowRequest method.
//	req, resp := client.CreateMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow
func (c *SSM) CreateMaintenanceWindowRequest(input *CreateMaintenanceWindowInput) (req *request.Request, output *CreateMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opCreateMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMaintenanceWindowInput{}
	}

	output = &CreateMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMaintenanceWindow API operation for Amazon Simple Systems Management Service.
//
// Creates a new maintenance window.
//
// The value you specify for Duration determines the specific end time for the
// maintenance window based on the time it begins. No maintenance window tasks
// are permitted to start after the resulting endtime minus the number of hours
// you specify for Cutoff. For example, if the maintenance window starts at
// 3 PM, the duration is three hours, and the value you specify for Cutoff is
// one hour, no maintenance window tasks can start after 5 PM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//
//   - IdempotentParameterMismatch
//     Error returned when an idempotent operation is retried and the parameters
//     don't match the original call to the API with the same idempotency token.
//
//   - ResourceLimitExceededException
//     Error returned when the caller has exceeded the default resource quotas.
//     For example, too many maintenance windows or patch baselines have been created.
//
//     For information about resource quotas in Systems Manager, see Systems Manager
//     service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow
func (c *SSM) CreateMaintenanceWindow(input *CreateMaintenanceWindowInput) (*CreateMaintenanceWindowOutput, error) {
	req, out := c.CreateMaintenanceWindowRequest(input)
	return out, req.Send()
}

// CreateMaintenanceWindowWithContext is the same as CreateMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateMaintenanceWindowWithContext(ctx aws.Context, input *CreateMaintenanceWindowInput, opts ...request.Option) (*CreateMaintenanceWindowOutput, error) {
	req, out := c.CreateMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOpsItem = "CreateOpsItem"

// CreateOpsItemRequest generates a "aws/request.Request" representing the
// client's request for the CreateOpsItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOpsItem for more information on using the CreateOpsItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateOpsItemRequest method.
//	req, resp := client.CreateOpsItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem
func (c *SSM) CreateOpsItemRequest(input *CreateOpsItemInput) (req *request.Request, output *CreateOpsItemOutput) {
	op := &request.Operation{
		Name:       opCreateOpsItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOpsItemInput{}
	}

	output = &CreateOpsItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOpsItem API operation for Amazon Simple Systems Management Service.
//
// Creates a new OpsItem. You must have permission in Identity and Access Management
// (IAM) to create a new OpsItem. For more information, see Set up OpsCenter
// (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Operations engineers and IT professionals use Amazon Web Services Systems
// Manager OpsCenter to view, investigate, and remediate operational issues
// impacting the performance and health of their Amazon Web Services resources.
// For more information, see Amazon Web Services Systems Manager OpsCenter (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateOpsItem for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsCenterInvalidArgumentException
//
//   - OpsItemAlreadyExistsException
//     The OpsItem already exists.
//
//   - OpsItemLimitExceededException
//     The request caused OpsItems to exceed one or more quotas.
//
//   - OpsItemInvalidParameterException
//     A specified parameter argument isn't valid. Verify the available arguments
//     and try again.
//
//   - OpsItemAccessDeniedException
//     You don't have permission to view OpsItems in the specified account. Verify
//     that your account is configured either as a Systems Manager delegated administrator
//     or that you are logged into the Organizations management account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem
func (c *SSM) CreateOpsItem(input *CreateOpsItemInput) (*CreateOpsItemOutput, error) {
	req, out := c.CreateOpsItemRequest(input)
	return out, req.Send()
}

// CreateOpsItemWithContext is the same as CreateOpsItem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOpsItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateOpsItemWithContext(ctx aws.Context, input *CreateOpsItemInput, opts ...request.Option) (*CreateOpsItemOutput, error) {
	req, out := c.CreateOpsItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOpsItemGroup = "CreateOpsItemGroup"

// CreateOpsItemGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateOpsItemGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOpsItemGroup for more information on using the CreateOpsItemGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateOpsItemGroupRequest method.
//	req, resp := client.CreateOpsItemGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItemGroup
func (c *SSM) CreateOpsItemGroupRequest(input *CreateOpsItemGroupInput) (req *request.Request, output *CreateOpsItemGroupOutput) {
	op := &request.Operation{
		Name:       opCreateOpsItemGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOpsItemGroupInput{}
	}

	output = &CreateOpsItemGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOpsItemGroup API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateOpsItemGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidParameterException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItemGroup
func (c *SSM) CreateOpsItemGroup(input *CreateOpsItemGroupInput) (*CreateOpsItemGroupOutput, error) {
	req, out := c.CreateOpsItemGroupRequest(input)
	return out, req.Send()
}

// CreateOpsItemGroupWithContext is the same as CreateOpsItemGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOpsItemGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateOpsItemGroupWithContext(ctx aws.Context, input *CreateOpsItemGroupInput, opts ...request.Option) (*CreateOpsItemGroupOutput, error) {
	req, out := c.CreateOpsItemGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOpsMetadata = "CreateOpsMetadata"

// CreateOpsMetadataRequest generates a "aws/request.Request" representing the
// client's request for the CreateOpsMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOpsMetadata for more information on using the CreateOpsMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateOpsMetadataRequest method.
//	req, resp := client.CreateOpsMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata
func (c *SSM) CreateOpsMetadataRequest(input *CreateOpsMetadataInput) (req *request.Request, output *CreateOpsMetadataOutput) {
	op := &request.Operation{
		Name:       opCreateOpsMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOpsMetadataInput{}
	}

	output = &CreateOpsMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOpsMetadata API operation for Amazon Simple Systems Management Service.
//
// If you create a new application in Application Manager, Amazon Web Services
// Systems Manager calls this API operation to specify information about the
// new application, including the application type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateOpsMetadata for usage and error information.
//
// Returned Error Types:
//
//   - OpsMetadataAlreadyExistsException
//     An OpsMetadata object already exists for the selected resource.
//
//   - OpsMetadataTooManyUpdatesException
//     The system is processing too many concurrent updates. Wait a few moments
//     and try again.
//
//   - OpsMetadataInvalidArgumentException
//     One of the arguments passed is invalid.
//
//   - OpsMetadataLimitExceededException
//     Your account reached the maximum number of OpsMetadata objects allowed by
//     Application Manager. The maximum is 200 OpsMetadata objects. Delete one or
//     more OpsMetadata object and try again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata
func (c *SSM) CreateOpsMetadata(input *CreateOpsMetadataInput) (*CreateOpsMetadataOutput, error) {
	req, out := c.CreateOpsMetadataRequest(input)
	return out, req.Send()
}

// CreateOpsMetadataWithContext is the same as CreateOpsMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOpsMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateOpsMetadataWithContext(ctx aws.Context, input *CreateOpsMetadataInput, opts ...request.Option) (*CreateOpsMetadataOutput, error) {
	req, out := c.CreateOpsMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePatchBaseline = "CreatePatchBaseline"

// CreatePatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePatchBaseline for more information on using the CreatePatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePatchBaselineRequest method.
//	req, resp := client.CreatePatchBaselineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline
func (c *SSM) CreatePatchBaselineRequest(input *CreatePatchBaselineInput) (req *request.Request, output *CreatePatchBaselineOutput) {
	op := &request.Operation{
		Name:       opCreatePatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePatchBaselineInput{}
	}

	output = &CreatePatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePatchBaseline API operation for Amazon Simple Systems Management Service.
//
// Creates a patch baseline.
//
// For information about valid key-value pairs in PatchFilters for each supported
// operating system type, see PatchFilter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreatePatchBaseline for usage and error information.
//
// Returned Error Types:
//
//   - IdempotentParameterMismatch
//     Error returned when an idempotent operation is retried and the parameters
//     don't match the original call to the API with the same idempotency token.
//
//   - ResourceLimitExceededException
//     Error returned when the caller has exceeded the default resource quotas.
//     For example, too many maintenance windows or patch baselines have been created.
//
//     For information about resource quotas in Systems Manager, see Systems Manager
//     service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline
func (c *SSM) CreatePatchBaseline(input *CreatePatchBaselineInput) (*CreatePatchBaselineOutput, error) {
	req, out := c.CreatePatchBaselineRequest(input)
	return out, req.Send()
}

// CreatePatchBaselineWithContext is the same as CreatePatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreatePatchBaselineWithContext(ctx aws.Context, input *CreatePatchBaselineInput, opts ...request.Option) (*CreatePatchBaselineOutput, error) {
	req, out := c.CreatePatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceDataSync = "CreateResourceDataSync"

// CreateResourceDataSyncRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceDataSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceDataSync for more information on using the CreateResourceDataSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResourceDataSyncRequest method.
//	req, resp := client.CreateResourceDataSyncRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync
func (c *SSM) CreateResourceDataSyncRequest(input *CreateResourceDataSyncInput) (req *request.Request, output *CreateResourceDataSyncOutput) {
	op := &request.Operation{
		Name:       opCreateResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceDataSyncInput{}
	}

	output = &CreateResourceDataSyncOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateResourceDataSync API operation for Amazon Simple Systems Management Service.
//
// A resource data sync helps you view data from multiple sources in a single
// location. Amazon Web Services Systems Manager offers two types of resource
// data sync: SyncToDestination and SyncFromSource.
//
// You can configure Systems Manager Inventory to use the SyncToDestination
// type to synchronize Inventory data from multiple Amazon Web Services Regions
// to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information,
// see Creating a resource data sync for Inventory (https://docs.aws.amazon.com/systems-manager/latest/userguide/inventory-create-resource-data-sync.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// You can configure Systems Manager Explorer to use the SyncFromSource type
// to synchronize operational work items (OpsItems) and operational data (OpsData)
// from multiple Amazon Web Services Regions to a single Amazon S3 bucket. This
// type can synchronize OpsItems and OpsData from multiple Amazon Web Services
// accounts and Amazon Web Services Regions or EntireOrganization by using Organizations.
// For more information, see Setting up Systems Manager Explorer to display
// data from multiple accounts and Regions (https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// A resource data sync is an asynchronous operation that returns immediately.
// After a successful initial sync is completed, the system continuously syncs
// data. To check the status of a sync, use the ListResourceDataSync.
//
// By default, data isn't encrypted in Amazon S3. We strongly recommend that
// you enable encryption in Amazon S3 to ensure secure data storage. We also
// recommend that you secure access to the Amazon S3 bucket by creating a restrictive
// bucket policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateResourceDataSync for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourceDataSyncCountExceededException
//     You have exceeded the allowed maximum sync configurations.
//
//   - ResourceDataSyncAlreadyExistsException
//     A sync configuration with the same name already exists.
//
//   - ResourceDataSyncInvalidConfigurationException
//     The specified sync configuration is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync
func (c *SSM) CreateResourceDataSync(input *CreateResourceDataSyncInput) (*CreateResourceDataSyncOutput, error) {
	req, out := c.CreateResourceDataSyncRequest(input)
	return out, req.Send()
}

// CreateResourceDataSyncWithContext is the same as CreateResourceDataSync with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceDataSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateResourceDataSyncWithContext(ctx aws.Context, input *CreateResourceDataSyncInput, opts ...request.Option) (*CreateResourceDataSyncOutput, error) {
	req, out := c.CreateResourceDataSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteActivation = "DeleteActivation"

// DeleteActivationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActivation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteActivation for more information on using the DeleteActivation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteActivationRequest method.
//	req, resp := client.DeleteActivationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation
func (c *SSM) DeleteActivationRequest(input *DeleteActivationInput) (req *request.Request, output *DeleteActivationOutput) {
	op := &request.Operation{
		Name:       opDeleteActivation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteActivationInput{}
	}

	output = &DeleteActivationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteActivation API operation for Amazon Simple Systems Management Service.
//
// Deletes an activation. You aren't required to delete an activation. If you
// delete an activation, you can no longer use it to register additional managed
// nodes. Deleting an activation doesn't de-register managed nodes. You must
// manually de-register managed nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteActivation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidActivationId
//     The activation ID isn't valid. Verify that you entered the correct ActivationId
//     or ActivationCode and try again.
//
//   - InvalidActivation
//     The activation isn't valid. The activation might have been deleted, or the
//     ActivationId and the ActivationCode don't match.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation
func (c *SSM) DeleteActivation(input *DeleteActivationInput) (*DeleteActivationOutput, error) {
	req, out := c.DeleteActivationRequest(input)
	return out, req.Send()
}

// DeleteActivationWithContext is the same as DeleteActivation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteActivation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteActivationWithContext(ctx aws.Context, input *DeleteActivationInput, opts ...request.Option) (*DeleteActivationOutput, error) {
	req, out := c.DeleteActivationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssociation = "DeleteAssociation"

// DeleteAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssociation for more information on using the DeleteAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAssociationRequest method.
//	req, resp := client.DeleteAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation
func (c *SSM) DeleteAssociationRequest(input *DeleteAssociationInput) (req *request.Request, output *DeleteAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssociationInput{}
	}

	output = &DeleteAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssociation API operation for Amazon Simple Systems Management Service.
//
// Disassociates the specified Amazon Web Services Systems Manager document
// (SSM document) from the specified managed node. If you created the association
// by using the Targets parameter, then you must delete the association by using
// the association ID.
//
// When you disassociate a document from a managed node, it doesn't change the
// configuration of the node. To change the configuration state of a managed
// node after you disassociate a document, you must create a new document with
// the desired configuration and associate it with the node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteAssociation for usage and error information.
//
// Returned Error Types:
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation
func (c *SSM) DeleteAssociation(input *DeleteAssociationInput) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	return out, req.Send()
}

// DeleteAssociationWithContext is the same as DeleteAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteAssociationWithContext(ctx aws.Context, input *DeleteAssociationInput, opts ...request.Option) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCommands = "DeleteCommands"

// DeleteCommandsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCommands operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCommands for more information on using the DeleteCommands
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCommandsRequest method.
//	req, resp := client.DeleteCommandsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteCommands
func (c *SSM) DeleteCommandsRequest(input *DeleteCommandsInput) (req *request.Request, output *DeleteCommandsOutput) {
	op := &request.Operation{
		Name:       opDeleteCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCommandsInput{}
	}

	output = &DeleteCommandsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCommands API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteCommands for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - CommandNotFound
//
//   - CommandNotInTerminalState
//
//   - DuplicateCommandId
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteCommands
func (c *SSM) DeleteCommands(input *DeleteCommandsInput) (*DeleteCommandsOutput, error) {
	req, out := c.DeleteCommandsRequest(input)
	return out, req.Send()
}

// DeleteCommandsWithContext is the same as DeleteCommands with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCommands for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteCommandsWithContext(ctx aws.Context, input *DeleteCommandsInput, opts ...request.Option) (*DeleteCommandsOutput, error) {
	req, out := c.DeleteCommandsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDocument = "DeleteDocument"

// DeleteDocumentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDocument for more information on using the DeleteDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDocumentRequest method.
//	req, resp := client.DeleteDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument
func (c *SSM) DeleteDocumentRequest(input *DeleteDocumentInput) (req *request.Request, output *DeleteDocumentOutput) {
	op := &request.Operation{
		Name:       opDeleteDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDocumentInput{}
	}

	output = &DeleteDocumentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDocument API operation for Amazon Simple Systems Management Service.
//
// Deletes the Amazon Web Services Systems Manager document (SSM document) and
// all managed node associations to the document.
//
// Before you delete the document, we recommend that you use DeleteAssociation
// to disassociate all managed nodes that are associated with the document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteDocument for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentOperation
//     You attempted to delete a document while it is still shared. You must stop
//     sharing the document before you can delete it.
//
//   - AssociatedInstances
//     You must disassociate a document from all managed nodes before you can delete
//     it.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument
func (c *SSM) DeleteDocument(input *DeleteDocumentInput) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	return out, req.Send()
}

// DeleteDocumentWithContext is the same as DeleteDocument with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteDocumentWithContext(ctx aws.Context, input *DeleteDocumentInput, opts ...request.Option) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInventory = "DeleteInventory"

// DeleteInventoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInventory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInventory for more information on using the DeleteInventory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInventoryRequest method.
//	req, resp := client.DeleteInventoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory
func (c *SSM) DeleteInventoryRequest(input *DeleteInventoryInput) (req *request.Request, output *DeleteInventoryOutput) {
	op := &request.Operation{
		Name:       opDeleteInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInventoryInput{}
	}

	output = &DeleteInventoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInventory API operation for Amazon Simple Systems Management Service.
//
// Delete a custom inventory type or the data associated with a custom Inventory
// type. Deleting a custom inventory type is also referred to as deleting a
// custom inventory schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteInventory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
//   - InvalidOptionException
//     The delete inventory option specified isn't valid. Verify the option and
//     try again.
//
//   - InvalidDeleteInventoryParametersException
//     One or more of the parameters specified for the delete operation isn't valid.
//     Verify all parameters and try again.
//
//   - InvalidInventoryRequestException
//     The request isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory
func (c *SSM) DeleteInventory(input *DeleteInventoryInput) (*DeleteInventoryOutput, error) {
	req, out := c.DeleteInventoryRequest(input)
	return out, req.Send()
}

// DeleteInventoryWithContext is the same as DeleteInventory with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInventory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteInventoryWithContext(ctx aws.Context, input *DeleteInventoryInput, opts ...request.Option) (*DeleteInventoryOutput, error) {
	req, out := c.DeleteInventoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMaintenanceWindow = "DeleteMaintenanceWindow"

// DeleteMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMaintenanceWindow for more information on using the DeleteMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMaintenanceWindowRequest method.
//	req, resp := client.DeleteMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow
func (c *SSM) DeleteMaintenanceWindowRequest(input *DeleteMaintenanceWindowInput) (req *request.Request, output *DeleteMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opDeleteMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMaintenanceWindowInput{}
	}

	output = &DeleteMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMaintenanceWindow API operation for Amazon Simple Systems Management Service.
//
// Deletes a maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow
func (c *SSM) DeleteMaintenanceWindow(input *DeleteMaintenanceWindowInput) (*DeleteMaintenanceWindowOutput, error) {
	req, out := c.DeleteMaintenanceWindowRequest(input)
	return out, req.Send()
}

// DeleteMaintenanceWindowWithContext is the same as DeleteMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteMaintenanceWindowWithContext(ctx aws.Context, input *DeleteMaintenanceWindowInput, opts ...request.Option) (*DeleteMaintenanceWindowOutput, error) {
	req, out := c.DeleteMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOpsItem = "DeleteOpsItem"

// DeleteOpsItemRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOpsItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOpsItem for more information on using the DeleteOpsItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteOpsItemRequest method.
//	req, resp := client.DeleteOpsItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsItem
func (c *SSM) DeleteOpsItemRequest(input *DeleteOpsItemInput) (req *request.Request, output *DeleteOpsItemOutput) {
	op := &request.Operation{
		Name:       opDeleteOpsItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOpsItemInput{}
	}

	output = &DeleteOpsItemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOpsItem API operation for Amazon Simple Systems Management Service.
//
// Delete an OpsItem.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteOpsItem for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsItemInvalidParameterException
//     A specified parameter argument isn't valid. Verify the available arguments
//     and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsItem
func (c *SSM) DeleteOpsItem(input *DeleteOpsItemInput) (*DeleteOpsItemOutput, error) {
	req, out := c.DeleteOpsItemRequest(input)
	return out, req.Send()
}

// DeleteOpsItemWithContext is the same as DeleteOpsItem with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOpsItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteOpsItemWithContext(ctx aws.Context, input *DeleteOpsItemInput, opts ...request.Option) (*DeleteOpsItemOutput, error) {
	req, out := c.DeleteOpsItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOpsMetadata = "DeleteOpsMetadata"

// DeleteOpsMetadataRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOpsMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOpsMetadata for more information on using the DeleteOpsMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteOpsMetadataRequest method.
//	req, resp := client.DeleteOpsMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata
func (c *SSM) DeleteOpsMetadataRequest(input *DeleteOpsMetadataInput) (req *request.Request, output *DeleteOpsMetadataOutput) {
	op := &request.Operation{
		Name:       opDeleteOpsMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOpsMetadataInput{}
	}

	output = &DeleteOpsMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOpsMetadata API operation for Amazon Simple Systems Management Service.
//
// Delete OpsMetadata related to an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteOpsMetadata for usage and error information.
//
// Returned Error Types:
//
//   - OpsMetadataNotFoundException
//     The OpsMetadata object doesn't exist.
//
//   - OpsMetadataInvalidArgumentException
//     One of the arguments passed is invalid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata
func (c *SSM) DeleteOpsMetadata(input *DeleteOpsMetadataInput) (*DeleteOpsMetadataOutput, error) {
	req, out := c.DeleteOpsMetadataRequest(input)
	return out, req.Send()
}

// DeleteOpsMetadataWithContext is the same as DeleteOpsMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOpsMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteOpsMetadataWithContext(ctx aws.Context, input *DeleteOpsMetadataInput, opts ...request.Option) (*DeleteOpsMetadataOutput, error) {
	req, out := c.DeleteOpsMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteParameter = "DeleteParameter"

// DeleteParameterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteParameter for more information on using the DeleteParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteParameterRequest method.
//	req, resp := client.DeleteParameterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter
func (c *SSM) DeleteParameterRequest(input *DeleteParameterInput) (req *request.Request, output *DeleteParameterOutput) {
	op := &request.Operation{
		Name:       opDeleteParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteParameterInput{}
	}

	output = &DeleteParameterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteParameter API operation for Amazon Simple Systems Management Service.
//
// Delete a parameter from the system. After deleting a parameter, wait for
// at least 30 seconds to create a parameter with the same name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteParameter for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ParameterNotFound
//     The parameter couldn't be found. Verify the name and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter
func (c *SSM) DeleteParameter(input *DeleteParameterInput) (*DeleteParameterOutput, error) {
	req, out := c.DeleteParameterRequest(input)
	return out, req.Send()
}

// DeleteParameterWithContext is the same as DeleteParameter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteParameterWithContext(ctx aws.Context, input *DeleteParameterInput, opts ...request.Option) (*DeleteParameterOutput, error) {
	req, out := c.DeleteParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteParameters = "DeleteParameters"

// DeleteParametersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteParameters for more information on using the DeleteParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteParametersRequest method.
//	req, resp := client.DeleteParametersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters
func (c *SSM) DeleteParametersRequest(input *DeleteParametersInput) (req *request.Request, output *DeleteParametersOutput) {
	op := &request.Operation{
		Name:       opDeleteParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteParametersInput{}
	}

	output = &DeleteParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteParameters API operation for Amazon Simple Systems Management Service.
//
// Delete a list of parameters. After deleting a parameter, wait for at least
// 30 seconds to create a parameter with the same name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteParameters for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters
func (c *SSM) DeleteParameters(input *DeleteParametersInput) (*DeleteParametersOutput, error) {
	req, out := c.DeleteParametersRequest(input)
	return out, req.Send()
}

// DeleteParametersWithContext is the same as DeleteParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteParametersWithContext(ctx aws.Context, input *DeleteParametersInput, opts ...request.Option) (*DeleteParametersOutput, error) {
	req, out := c.DeleteParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePatchBaseline = "DeletePatchBaseline"

// DeletePatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePatchBaseline for more information on using the DeletePatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePatchBaselineRequest method.
//	req, resp := client.DeletePatchBaselineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline
func (c *SSM) DeletePatchBaselineRequest(input *DeletePatchBaselineInput) (req *request.Request, output *DeletePatchBaselineOutput) {
	op := &request.Operation{
		Name:       opDeletePatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePatchBaselineInput{}
	}

	output = &DeletePatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePatchBaseline API operation for Amazon Simple Systems Management Service.
//
// Deletes a patch baseline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeletePatchBaseline for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     Error returned if an attempt is made to delete a patch baseline that is registered
//     for a patch group.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline
func (c *SSM) DeletePatchBaseline(input *DeletePatchBaselineInput) (*DeletePatchBaselineOutput, error) {
	req, out := c.DeletePatchBaselineRequest(input)
	return out, req.Send()
}

// DeletePatchBaselineWithContext is the same as DeletePatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeletePatchBaselineWithContext(ctx aws.Context, input *DeletePatchBaselineInput, opts ...request.Option) (*DeletePatchBaselineOutput, error) {
	req, out := c.DeletePatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceDataSync = "DeleteResourceDataSync"

// DeleteResourceDataSyncRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceDataSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceDataSync for more information on using the DeleteResourceDataSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourceDataSyncRequest method.
//	req, resp := client.DeleteResourceDataSyncRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync
func (c *SSM) DeleteResourceDataSyncRequest(input *DeleteResourceDataSyncInput) (req *request.Request, output *DeleteResourceDataSyncOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceDataSyncInput{}
	}

	output = &DeleteResourceDataSyncOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceDataSync API operation for Amazon Simple Systems Management Service.
//
// Deletes a resource data sync configuration. After the configuration is deleted,
// changes to data on managed nodes are no longer synced to or from the target.
// Deleting a sync configuration doesn't delete data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteResourceDataSync for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourceDataSyncNotFoundException
//     The specified sync name wasn't found.
//
//   - ResourceDataSyncInvalidConfigurationException
//     The specified sync configuration is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync
func (c *SSM) DeleteResourceDataSync(input *DeleteResourceDataSyncInput) (*DeleteResourceDataSyncOutput, error) {
	req, out := c.DeleteResourceDataSyncRequest(input)
	return out, req.Send()
}

// DeleteResourceDataSyncWithContext is the same as DeleteResourceDataSync with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceDataSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteResourceDataSyncWithContext(ctx aws.Context, input *DeleteResourceDataSyncInput, opts ...request.Option) (*DeleteResourceDataSyncOutput, error) {
	req, out := c.DeleteResourceDataSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourcePolicy
func (c *SSM) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for Amazon Simple Systems Management Service.
//
// # Removes resource policy associated with a SSM resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourcePolicyInvalidParameterException
//     One or more parameters specified for the call aren't valid. Verify the parameters
//     and their values and try again.
//
//   - ResourcePolicyConflictException
//     The hash provided in the call doesn't match the stored hash. This exception
//     is thrown when trying to update an obsolete policy version or when multiple
//     requests to update a policy are sent.
//
//   - ResourceNotFoundException
//     The specified parameter to be shared could not be found.
//
//   - ResourcePolicyNotFoundException
//     No policies with the specified policy ID and hash could be found.
//
//   - MalformedResourcePolicyDocumentException
//     The specified policy document is malformed or invalid, or excessive PutResourcePolicy
//     or DeleteResourcePolicy calls have been made.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourcePolicy
func (c *SSM) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterManagedInstance = "DeregisterManagedInstance"

// DeregisterManagedInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterManagedInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterManagedInstance for more information on using the DeregisterManagedInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterManagedInstanceRequest method.
//	req, resp := client.DeregisterManagedInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance
func (c *SSM) DeregisterManagedInstanceRequest(input *DeregisterManagedInstanceInput) (req *request.Request, output *DeregisterManagedInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterManagedInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterManagedInstanceInput{}
	}

	output = &DeregisterManagedInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterManagedInstance API operation for Amazon Simple Systems Management Service.
//
// Removes the server or virtual machine from the list of registered servers.
// You can reregister the node again at any time. If you don't plan to use Run
// Command on the server, we suggest uninstalling SSM Agent first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeregisterManagedInstance for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance
func (c *SSM) DeregisterManagedInstance(input *DeregisterManagedInstanceInput) (*DeregisterManagedInstanceOutput, error) {
	req, out := c.DeregisterManagedInstanceRequest(input)
	return out, req.Send()
}

// DeregisterManagedInstanceWithContext is the same as DeregisterManagedInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterManagedInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeregisterManagedInstanceWithContext(ctx aws.Context, input *DeregisterManagedInstanceInput, opts ...request.Option) (*DeregisterManagedInstanceOutput, error) {
	req, out := c.DeregisterManagedInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterPatchBaselineForPatchGroup = "DeregisterPatchBaselineForPatchGroup"

// DeregisterPatchBaselineForPatchGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterPatchBaselineForPatchGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterPatchBaselineForPatchGroup for more information on using the DeregisterPatchBaselineForPatchGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterPatchBaselineForPatchGroupRequest method.
//	req, resp := client.DeregisterPatchBaselineForPatchGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup
func (c *SSM) DeregisterPatchBaselineForPatchGroupRequest(input *DeregisterPatchBaselineForPatchGroupInput) (req *request.Request, output *DeregisterPatchBaselineForPatchGroupOutput) {
	op := &request.Operation{
		Name:       opDeregisterPatchBaselineForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterPatchBaselineForPatchGroupInput{}
	}

	output = &DeregisterPatchBaselineForPatchGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterPatchBaselineForPatchGroup API operation for Amazon Simple Systems Management Service.
//
// Removes a patch group from a patch baseline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeregisterPatchBaselineForPatchGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup
func (c *SSM) DeregisterPatchBaselineForPatchGroup(input *DeregisterPatchBaselineForPatchGroupInput) (*DeregisterPatchBaselineForPatchGroupOutput, error) {
	req, out := c.DeregisterPatchBaselineForPatchGroupRequest(input)
	return out, req.Send()
}

// DeregisterPatchBaselineForPatchGroupWithContext is the same as DeregisterPatchBaselineForPatchGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterPatchBaselineForPatchGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeregisterPatchBaselineForPatchGroupWithContext(ctx aws.Context, input *DeregisterPatchBaselineForPatchGroupInput, opts ...request.Option) (*DeregisterPatchBaselineForPatchGroupOutput, error) {
	req, out := c.DeregisterPatchBaselineForPatchGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTargetFromMaintenanceWindow = "DeregisterTargetFromMaintenanceWindow"

// DeregisterTargetFromMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTargetFromMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTargetFromMaintenanceWindow for more information on using the DeregisterTargetFromMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterTargetFromMaintenanceWindowRequest method.
//	req, resp := client.DeregisterTargetFromMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow
func (c *SSM) DeregisterTargetFromMaintenanceWindowRequest(input *DeregisterTargetFromMaintenanceWindowInput) (req *request.Request, output *DeregisterTargetFromMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opDeregisterTargetFromMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTargetFromMaintenanceWindowInput{}
	}

	output = &DeregisterTargetFromMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTargetFromMaintenanceWindow API operation for Amazon Simple Systems Management Service.
//
// Removes a target from a maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeregisterTargetFromMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - TargetInUseException
//     You specified the Safe option for the DeregisterTargetFromMaintenanceWindow
//     operation, but the target is still referenced in a task.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow
func (c *SSM) DeregisterTargetFromMaintenanceWindow(input *DeregisterTargetFromMaintenanceWindowInput) (*DeregisterTargetFromMaintenanceWindowOutput, error) {
	req, out := c.DeregisterTargetFromMaintenanceWindowRequest(input)
	return out, req.Send()
}

// DeregisterTargetFromMaintenanceWindowWithContext is the same as DeregisterTargetFromMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTargetFromMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeregisterTargetFromMaintenanceWindowWithContext(ctx aws.Context, input *DeregisterTargetFromMaintenanceWindowInput, opts ...request.Option) (*DeregisterTargetFromMaintenanceWindowOutput, error) {
	req, out := c.DeregisterTargetFromMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTaskFromMaintenanceWindow = "DeregisterTaskFromMaintenanceWindow"

// DeregisterTaskFromMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTaskFromMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTaskFromMaintenanceWindow for more information on using the DeregisterTaskFromMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterTaskFromMaintenanceWindowRequest method.
//	req, resp := client.DeregisterTaskFromMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow
func (c *SSM) DeregisterTaskFromMaintenanceWindowRequest(input *DeregisterTaskFromMaintenanceWindowInput) (req *request.Request, output *DeregisterTaskFromMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opDeregisterTaskFromMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTaskFromMaintenanceWindowInput{}
	}

	output = &DeregisterTaskFromMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTaskFromMaintenanceWindow API operation for Amazon Simple Systems Management Service.
//
// Removes a task from a maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeregisterTaskFromMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow
func (c *SSM) DeregisterTaskFromMaintenanceWindow(input *DeregisterTaskFromMaintenanceWindowInput) (*DeregisterTaskFromMaintenanceWindowOutput, error) {
	req, out := c.DeregisterTaskFromMaintenanceWindowRequest(input)
	return out, req.Send()
}

// DeregisterTaskFromMaintenanceWindowWithContext is the same as DeregisterTaskFromMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTaskFromMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeregisterTaskFromMaintenanceWindowWithContext(ctx aws.Context, input *DeregisterTaskFromMaintenanceWindowInput, opts ...request.Option) (*DeregisterTaskFromMaintenanceWindowOutput, error) {
	req, out := c.DeregisterTaskFromMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActivations = "DescribeActivations"

// DescribeActivationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActivations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActivations for more information on using the DescribeActivations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeActivationsRequest method.
//	req, resp := client.DescribeActivationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations
func (c *SSM) DescribeActivationsRequest(input *DescribeActivationsInput) (req *request.Request, output *DescribeActivationsOutput) {
	op := &request.Operation{
		Name:       opDescribeActivations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeActivationsInput{}
	}

	output = &DescribeActivationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActivations API operation for Amazon Simple Systems Management Service.
//
// Describes details about the activation, such as the date and time the activation
// was created, its expiration date, the Identity and Access Management (IAM)
// role assigned to the managed nodes in the activation, and the number of nodes
// registered by using this activation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeActivations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations
func (c *SSM) DescribeActivations(input *DescribeActivationsInput) (*DescribeActivationsOutput, error) {
	req, out := c.DescribeActivationsRequest(input)
	return out, req.Send()
}

// DescribeActivationsWithContext is the same as DescribeActivations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActivations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeActivationsWithContext(ctx aws.Context, input *DescribeActivationsInput, opts ...request.Option) (*DescribeActivationsOutput, error) {
	req, out := c.DescribeActivationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeActivationsPages iterates over the pages of a DescribeActivations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeActivations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeActivations operation.
//	pageNum := 0
//	err := client.DescribeActivationsPages(params,
//	    func(page *ssm.DescribeActivationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeActivationsPages(input *DescribeActivationsInput, fn func(*DescribeActivationsOutput, bool) bool) error {
	return c.DescribeActivationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeActivationsPagesWithContext same as DescribeActivationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeActivationsPagesWithContext(ctx aws.Context, input *DescribeActivationsInput, fn func(*DescribeActivationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeActivationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeActivationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeActivationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAssociation = "DescribeAssociation"

// DescribeAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssociation for more information on using the DescribeAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAssociationRequest method.
//	req, resp := client.DescribeAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation
func (c *SSM) DescribeAssociationRequest(input *DescribeAssociationInput) (req *request.Request, output *DescribeAssociationOutput) {
	op := &request.Operation{
		Name:       opDescribeAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssociationInput{}
	}

	output = &DescribeAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssociation API operation for Amazon Simple Systems Management Service.
//
// Describes the association for the specified target or managed node. If you
// created the association by using the Targets parameter, then you must retrieve
// the association by using the association ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAssociation for usage and error information.
//
// Returned Error Types:
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
//   - InvalidAssociationVersion
//     The version you specified isn't valid. Use ListAssociationVersions to view
//     all versions of an association according to the association ID. Or, use the
//     $LATEST parameter to view the latest version of the association.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation
func (c *SSM) DescribeAssociation(input *DescribeAssociationInput) (*DescribeAssociationOutput, error) {
	req, out := c.DescribeAssociationRequest(input)
	return out, req.Send()
}

// DescribeAssociationWithContext is the same as DescribeAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAssociationWithContext(ctx aws.Context, input *DescribeAssociationInput, opts ...request.Option) (*DescribeAssociationOutput, error) {
	req, out := c.DescribeAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssociationExecutionTargets = "DescribeAssociationExecutionTargets"

// DescribeAssociationExecutionTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssociationExecutionTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssociationExecutionTargets for more information on using the DescribeAssociationExecutionTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAssociationExecutionTargetsRequest method.
//	req, resp := client.DescribeAssociationExecutionTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets
func (c *SSM) DescribeAssociationExecutionTargetsRequest(input *DescribeAssociationExecutionTargetsInput) (req *request.Request, output *DescribeAssociationExecutionTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeAssociationExecutionTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAssociationExecutionTargetsInput{}
	}

	output = &DescribeAssociationExecutionTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssociationExecutionTargets API operation for Amazon Simple Systems Management Service.
//
// Views information about a specific execution of a specific association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAssociationExecutionTargets for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - AssociationExecutionDoesNotExist
//     The specified execution ID doesn't exist. Verify the ID number and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets
func (c *SSM) DescribeAssociationExecutionTargets(input *DescribeAssociationExecutionTargetsInput) (*DescribeAssociationExecutionTargetsOutput, error) {
	req, out := c.DescribeAssociationExecutionTargetsRequest(input)
	return out, req.Send()
}

// DescribeAssociationExecutionTargetsWithContext is the same as DescribeAssociationExecutionTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssociationExecutionTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAssociationExecutionTargetsWithContext(ctx aws.Context, input *DescribeAssociationExecutionTargetsInput, opts ...request.Option) (*DescribeAssociationExecutionTargetsOutput, error) {
	req, out := c.DescribeAssociationExecutionTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAssociationExecutionTargetsPages iterates over the pages of a DescribeAssociationExecutionTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAssociationExecutionTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAssociationExecutionTargets operation.
//	pageNum := 0
//	err := client.DescribeAssociationExecutionTargetsPages(params,
//	    func(page *ssm.DescribeAssociationExecutionTargetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeAssociationExecutionTargetsPages(input *DescribeAssociationExecutionTargetsInput, fn func(*DescribeAssociationExecutionTargetsOutput, bool) bool) error {
	return c.DescribeAssociationExecutionTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAssociationExecutionTargetsPagesWithContext same as DescribeAssociationExecutionTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAssociationExecutionTargetsPagesWithContext(ctx aws.Context, input *DescribeAssociationExecutionTargetsInput, fn func(*DescribeAssociationExecutionTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAssociationExecutionTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAssociationExecutionTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAssociationExecutionTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAssociationExecutions = "DescribeAssociationExecutions"

// DescribeAssociationExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssociationExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssociationExecutions for more information on using the DescribeAssociationExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAssociationExecutionsRequest method.
//	req, resp := client.DescribeAssociationExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions
func (c *SSM) DescribeAssociationExecutionsRequest(input *DescribeAssociationExecutionsInput) (req *request.Request, output *DescribeAssociationExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAssociationExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAssociationExecutionsInput{}
	}

	output = &DescribeAssociationExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssociationExecutions API operation for Amazon Simple Systems Management Service.
//
// Views all executions for a specific association ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAssociationExecutions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions
func (c *SSM) DescribeAssociationExecutions(input *DescribeAssociationExecutionsInput) (*DescribeAssociationExecutionsOutput, error) {
	req, out := c.DescribeAssociationExecutionsRequest(input)
	return out, req.Send()
}

// DescribeAssociationExecutionsWithContext is the same as DescribeAssociationExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssociationExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAssociationExecutionsWithContext(ctx aws.Context, input *DescribeAssociationExecutionsInput, opts ...request.Option) (*DescribeAssociationExecutionsOutput, error) {
	req, out := c.DescribeAssociationExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAssociationExecutionsPages iterates over the pages of a DescribeAssociationExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAssociationExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAssociationExecutions operation.
//	pageNum := 0
//	err := client.DescribeAssociationExecutionsPages(params,
//	    func(page *ssm.DescribeAssociationExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeAssociationExecutionsPages(input *DescribeAssociationExecutionsInput, fn func(*DescribeAssociationExecutionsOutput, bool) bool) error {
	return c.DescribeAssociationExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAssociationExecutionsPagesWithContext same as DescribeAssociationExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAssociationExecutionsPagesWithContext(ctx aws.Context, input *DescribeAssociationExecutionsInput, fn func(*DescribeAssociationExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAssociationExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAssociationExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAssociationExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAutomationActions = "DescribeAutomationActions"

// DescribeAutomationActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutomationActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutomationActions for more information on using the DescribeAutomationActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAutomationActionsRequest method.
//	req, resp := client.DescribeAutomationActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationActions
func (c *SSM) DescribeAutomationActionsRequest(input *DescribeAutomationActionsInput) (req *request.Request, output *DescribeAutomationActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAutomationActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutomationActionsInput{}
	}

	output = &DescribeAutomationActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutomationActions API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAutomationActions for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationActions
func (c *SSM) DescribeAutomationActions(input *DescribeAutomationActionsInput) (*DescribeAutomationActionsOutput, error) {
	req, out := c.DescribeAutomationActionsRequest(input)
	return out, req.Send()
}

// DescribeAutomationActionsWithContext is the same as DescribeAutomationActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutomationActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAutomationActionsWithContext(ctx aws.Context, input *DescribeAutomationActionsInput, opts ...request.Option) (*DescribeAutomationActionsOutput, error) {
	req, out := c.DescribeAutomationActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutomationExecutionParameters = "DescribeAutomationExecutionParameters"

// DescribeAutomationExecutionParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutomationExecutionParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutomationExecutionParameters for more information on using the DescribeAutomationExecutionParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAutomationExecutionParametersRequest method.
//	req, resp := client.DescribeAutomationExecutionParametersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutionParameters
func (c *SSM) DescribeAutomationExecutionParametersRequest(input *DescribeAutomationExecutionParametersInput) (req *request.Request, output *DescribeAutomationExecutionParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeAutomationExecutionParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutomationExecutionParametersInput{}
	}

	output = &DescribeAutomationExecutionParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutomationExecutionParameters API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAutomationExecutionParameters for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutionParameters
func (c *SSM) DescribeAutomationExecutionParameters(input *DescribeAutomationExecutionParametersInput) (*DescribeAutomationExecutionParametersOutput, error) {
	req, out := c.DescribeAutomationExecutionParametersRequest(input)
	return out, req.Send()
}

// DescribeAutomationExecutionParametersWithContext is the same as DescribeAutomationExecutionParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutomationExecutionParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAutomationExecutionParametersWithContext(ctx aws.Context, input *DescribeAutomationExecutionParametersInput, opts ...request.Option) (*DescribeAutomationExecutionParametersOutput, error) {
	req, out := c.DescribeAutomationExecutionParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutomationExecutions = "DescribeAutomationExecutions"

// DescribeAutomationExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutomationExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutomationExecutions for more information on using the DescribeAutomationExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAutomationExecutionsRequest method.
//	req, resp := client.DescribeAutomationExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions
func (c *SSM) DescribeAutomationExecutionsRequest(input *DescribeAutomationExecutionsInput) (req *request.Request, output *DescribeAutomationExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAutomationExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAutomationExecutionsInput{}
	}

	output = &DescribeAutomationExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutomationExecutions API operation for Amazon Simple Systems Management Service.
//
// Provides details about all active and terminated Automation executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAutomationExecutions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidFilterValue
//     The filter value isn't valid. Verify the value and try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions
func (c *SSM) DescribeAutomationExecutions(input *DescribeAutomationExecutionsInput) (*DescribeAutomationExecutionsOutput, error) {
	req, out := c.DescribeAutomationExecutionsRequest(input)
	return out, req.Send()
}

// DescribeAutomationExecutionsWithContext is the same as DescribeAutomationExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutomationExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAutomationExecutionsWithContext(ctx aws.Context, input *DescribeAutomationExecutionsInput, opts ...request.Option) (*DescribeAutomationExecutionsOutput, error) {
	req, out := c.DescribeAutomationExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAutomationExecutionsPages iterates over the pages of a DescribeAutomationExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAutomationExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAutomationExecutions operation.
//	pageNum := 0
//	err := client.DescribeAutomationExecutionsPages(params,
//	    func(page *ssm.DescribeAutomationExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeAutomationExecutionsPages(input *DescribeAutomationExecutionsInput, fn func(*DescribeAutomationExecutionsOutput, bool) bool) error {
	return c.DescribeAutomationExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAutomationExecutionsPagesWithContext same as DescribeAutomationExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAutomationExecutionsPagesWithContext(ctx aws.Context, input *DescribeAutomationExecutionsInput, fn func(*DescribeAutomationExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAutomationExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAutomationExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAutomationExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAutomationStepExecutions = "DescribeAutomationStepExecutions"

// DescribeAutomationStepExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutomationStepExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutomationStepExecutions for more information on using the DescribeAutomationStepExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAutomationStepExecutionsRequest method.
//	req, resp := client.DescribeAutomationStepExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions
func (c *SSM) DescribeAutomationStepExecutionsRequest(input *DescribeAutomationStepExecutionsInput) (req *request.Request, output *DescribeAutomationStepExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAutomationStepExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAutomationStepExecutionsInput{}
	}

	output = &DescribeAutomationStepExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutomationStepExecutions API operation for Amazon Simple Systems Management Service.
//
// Information about all active and terminated step executions in an Automation
// workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAutomationStepExecutions for usage and error information.
//
// Returned Error Types:
//
//   - AutomationExecutionNotFoundException
//     There is no automation execution information for the requested automation
//     execution ID.
//
//   - InvalidAutomationExecutionParametersException
//     The supplied parameters for invoking the specified Automation runbook are
//     incorrect. For example, they may not match the set of parameters permitted
//     for the specified Automation document.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidFilterValue
//     The filter value isn't valid. Verify the value and try again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions
func (c *SSM) DescribeAutomationStepExecutions(input *DescribeAutomationStepExecutionsInput) (*DescribeAutomationStepExecutionsOutput, error) {
	req, out := c.DescribeAutomationStepExecutionsRequest(input)
	return out, req.Send()
}

// DescribeAutomationStepExecutionsWithContext is the same as DescribeAutomationStepExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutomationStepExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAutomationStepExecutionsWithContext(ctx aws.Context, input *DescribeAutomationStepExecutionsInput, opts ...request.Option) (*DescribeAutomationStepExecutionsOutput, error) {
	req, out := c.DescribeAutomationStepExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAutomationStepExecutionsPages iterates over the pages of a DescribeAutomationStepExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAutomationStepExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAutomationStepExecutions operation.
//	pageNum := 0
//	err := client.DescribeAutomationStepExecutionsPages(params,
//	    func(page *ssm.DescribeAutomationStepExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeAutomationStepExecutionsPages(input *DescribeAutomationStepExecutionsInput, fn func(*DescribeAutomationStepExecutionsOutput, bool) bool) error {
	return c.DescribeAutomationStepExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAutomationStepExecutionsPagesWithContext same as DescribeAutomationStepExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAutomationStepExecutionsPagesWithContext(ctx aws.Context, input *DescribeAutomationStepExecutionsInput, fn func(*DescribeAutomationStepExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAutomationStepExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAutomationStepExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAutomationStepExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAvailablePatches = "DescribeAvailablePatches"

// DescribeAvailablePatchesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAvailablePatches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAvailablePatches for more information on using the DescribeAvailablePatches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAvailablePatchesRequest method.
//	req, resp := client.DescribeAvailablePatchesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches
func (c *SSM) DescribeAvailablePatchesRequest(input *DescribeAvailablePatchesInput) (req *request.Request, output *DescribeAvailablePatchesOutput) {
	op := &request.Operation{
		Name:       opDescribeAvailablePatches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAvailablePatchesInput{}
	}

	output = &DescribeAvailablePatchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAvailablePatches API operation for Amazon Simple Systems Management Service.
//
// Lists all patches eligible to be included in a patch baseline.
//
// Currently, DescribeAvailablePatches supports only the Amazon Linux 1, Amazon
// Linux 2, and Windows Server operating systems.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAvailablePatches for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches
func (c *SSM) DescribeAvailablePatches(input *DescribeAvailablePatchesInput) (*DescribeAvailablePatchesOutput, error) {
	req, out := c.DescribeAvailablePatchesRequest(input)
	return out, req.Send()
}

// DescribeAvailablePatchesWithContext is the same as DescribeAvailablePatches with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAvailablePatches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAvailablePatchesWithContext(ctx aws.Context, input *DescribeAvailablePatchesInput, opts ...request.Option) (*DescribeAvailablePatchesOutput, error) {
	req, out := c.DescribeAvailablePatchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAvailablePatchesPages iterates over the pages of a DescribeAvailablePatches operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAvailablePatches method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAvailablePatches operation.
//	pageNum := 0
//	err := client.DescribeAvailablePatchesPages(params,
//	    func(page *ssm.DescribeAvailablePatchesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeAvailablePatchesPages(input *DescribeAvailablePatchesInput, fn func(*DescribeAvailablePatchesOutput, bool) bool) error {
	return c.DescribeAvailablePatchesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAvailablePatchesPagesWithContext same as DescribeAvailablePatchesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAvailablePatchesPagesWithContext(ctx aws.Context, input *DescribeAvailablePatchesInput, fn func(*DescribeAvailablePatchesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAvailablePatchesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAvailablePatchesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAvailablePatchesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDocument = "DescribeDocument"

// DescribeDocumentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocument for more information on using the DescribeDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentRequest method.
//	req, resp := client.DescribeDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument
func (c *SSM) DescribeDocumentRequest(input *DescribeDocumentInput) (req *request.Request, output *DescribeDocumentOutput) {
	op := &request.Operation{
		Name:       opDescribeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentInput{}
	}

	output = &DescribeDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocument API operation for Amazon Simple Systems Management Service.
//
// Describes the specified Amazon Web Services Systems Manager document (SSM
// document).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocument for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument
func (c *SSM) DescribeDocument(input *DescribeDocumentInput) (*DescribeDocumentOutput, error) {
	req, out := c.DescribeDocumentRequest(input)
	return out, req.Send()
}

// DescribeDocumentWithContext is the same as DescribeDocument with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentWithContext(ctx aws.Context, input *DescribeDocumentInput, opts ...request.Option) (*DescribeDocumentOutput, error) {
	req, out := c.DescribeDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentInternal = "DescribeDocumentInternal"

// DescribeDocumentInternalRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentInternal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentInternal for more information on using the DescribeDocumentInternal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentInternalRequest method.
//	req, resp := client.DescribeDocumentInternalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentInternal
func (c *SSM) DescribeDocumentInternalRequest(input *DescribeDocumentInternalInput) (req *request.Request, output *DescribeDocumentInternalOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentInternal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentInternalInput{}
	}

	output = &DescribeDocumentInternalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentInternal API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocumentInternal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentInternal
func (c *SSM) DescribeDocumentInternal(input *DescribeDocumentInternalInput) (*DescribeDocumentInternalOutput, error) {
	req, out := c.DescribeDocumentInternalRequest(input)
	return out, req.Send()
}

// DescribeDocumentInternalWithContext is the same as DescribeDocumentInternal with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentInternal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentInternalWithContext(ctx aws.Context, input *DescribeDocumentInternalInput, opts ...request.Option) (*DescribeDocumentInternalOutput, error) {
	req, out := c.DescribeDocumentInternalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentParameters = "DescribeDocumentParameters"

// DescribeDocumentParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentParameters for more information on using the DescribeDocumentParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentParametersRequest method.
//	req, resp := client.DescribeDocumentParametersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentParameters
func (c *SSM) DescribeDocumentParametersRequest(input *DescribeDocumentParametersInput) (req *request.Request, output *DescribeDocumentParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentParametersInput{}
	}

	output = &DescribeDocumentParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentParameters API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocumentParameters for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentParameters
func (c *SSM) DescribeDocumentParameters(input *DescribeDocumentParametersInput) (*DescribeDocumentParametersOutput, error) {
	req, out := c.DescribeDocumentParametersRequest(input)
	return out, req.Send()
}

// DescribeDocumentParametersWithContext is the same as DescribeDocumentParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentParametersWithContext(ctx aws.Context, input *DescribeDocumentParametersInput, opts ...request.Option) (*DescribeDocumentParametersOutput, error) {
	req, out := c.DescribeDocumentParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentPermission = "DescribeDocumentPermission"

// DescribeDocumentPermissionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentPermission for more information on using the DescribeDocumentPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentPermissionRequest method.
//	req, resp := client.DescribeDocumentPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission
func (c *SSM) DescribeDocumentPermissionRequest(input *DescribeDocumentPermissionInput) (req *request.Request, output *DescribeDocumentPermissionOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentPermissionInput{}
	}

	output = &DescribeDocumentPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentPermission API operation for Amazon Simple Systems Management Service.
//
// Describes the permissions for a Amazon Web Services Systems Manager document
// (SSM document). If you created the document, you are the owner. If a document
// is shared, it can either be shared privately (by specifying a user's Amazon
// Web Services account ID) or publicly (All).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocumentPermission for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidPermissionType
//     The permission type isn't supported. Share is the only supported permission
//     type.
//
//   - InvalidDocumentOperation
//     You attempted to delete a document while it is still shared. You must stop
//     sharing the document before you can delete it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission
func (c *SSM) DescribeDocumentPermission(input *DescribeDocumentPermissionInput) (*DescribeDocumentPermissionOutput, error) {
	req, out := c.DescribeDocumentPermissionRequest(input)
	return out, req.Send()
}

// DescribeDocumentPermissionWithContext is the same as DescribeDocumentPermission with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentPermissionWithContext(ctx aws.Context, input *DescribeDocumentPermissionInput, opts ...request.Option) (*DescribeDocumentPermissionOutput, error) {
	req, out := c.DescribeDocumentPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentSchema = "DescribeDocumentSchema"

// DescribeDocumentSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentSchema for more information on using the DescribeDocumentSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentSchemaRequest method.
//	req, resp := client.DescribeDocumentSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentSchema
func (c *SSM) DescribeDocumentSchemaRequest(input *DescribeDocumentSchemaInput) (req *request.Request, output *DescribeDocumentSchemaOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentSchemaInput{}
	}

	output = &DescribeDocumentSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentSchema API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocumentSchema for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocumentType
//     The SSM document type isn't valid. Valid document types are described in
//     the DocumentType property.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentSchema
func (c *SSM) DescribeDocumentSchema(input *DescribeDocumentSchemaInput) (*DescribeDocumentSchemaOutput, error) {
	req, out := c.DescribeDocumentSchemaRequest(input)
	return out, req.Send()
}

// DescribeDocumentSchemaWithContext is the same as DescribeDocumentSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentSchemaWithContext(ctx aws.Context, input *DescribeDocumentSchemaInput, opts ...request.Option) (*DescribeDocumentSchemaOutput, error) {
	req, out := c.DescribeDocumentSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentStepSchema = "DescribeDocumentStepSchema"

// DescribeDocumentStepSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentStepSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentStepSchema for more information on using the DescribeDocumentStepSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentStepSchemaRequest method.
//	req, resp := client.DescribeDocumentStepSchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentStepSchema
func (c *SSM) DescribeDocumentStepSchemaRequest(input *DescribeDocumentStepSchemaInput) (req *request.Request, output *DescribeDocumentStepSchemaOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentStepSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentStepSchemaInput{}
	}

	output = &DescribeDocumentStepSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentStepSchema API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocumentStepSchema for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidPluginName
//     The plugin name isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentStepSchema
func (c *SSM) DescribeDocumentStepSchema(input *DescribeDocumentStepSchemaInput) (*DescribeDocumentStepSchemaOutput, error) {
	req, out := c.DescribeDocumentStepSchemaRequest(input)
	return out, req.Send()
}

// DescribeDocumentStepSchemaWithContext is the same as DescribeDocumentStepSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentStepSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentStepSchemaWithContext(ctx aws.Context, input *DescribeDocumentStepSchemaInput, opts ...request.Option) (*DescribeDocumentStepSchemaOutput, error) {
	req, out := c.DescribeDocumentStepSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentSteps = "DescribeDocumentSteps"

// DescribeDocumentStepsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentSteps for more information on using the DescribeDocumentSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDocumentStepsRequest method.
//	req, resp := client.DescribeDocumentStepsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentSteps
func (c *SSM) DescribeDocumentStepsRequest(input *DescribeDocumentStepsInput) (req *request.Request, output *DescribeDocumentStepsOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentStepsInput{}
	}

	output = &DescribeDocumentStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentSteps API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocumentSteps for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocumentType
//     The SSM document type isn't valid. Valid document types are described in
//     the DocumentType property.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentSteps
func (c *SSM) DescribeDocumentSteps(input *DescribeDocumentStepsInput) (*DescribeDocumentStepsOutput, error) {
	req, out := c.DescribeDocumentStepsRequest(input)
	return out, req.Send()
}

// DescribeDocumentStepsWithContext is the same as DescribeDocumentSteps with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentStepsWithContext(ctx aws.Context, input *DescribeDocumentStepsInput, opts ...request.Option) (*DescribeDocumentStepsOutput, error) {
	req, out := c.DescribeDocumentStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEffectiveInstanceAssociations = "DescribeEffectiveInstanceAssociations"

// DescribeEffectiveInstanceAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEffectiveInstanceAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEffectiveInstanceAssociations for more information on using the DescribeEffectiveInstanceAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEffectiveInstanceAssociationsRequest method.
//	req, resp := client.DescribeEffectiveInstanceAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations
func (c *SSM) DescribeEffectiveInstanceAssociationsRequest(input *DescribeEffectiveInstanceAssociationsInput) (req *request.Request, output *DescribeEffectiveInstanceAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeEffectiveInstanceAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEffectiveInstanceAssociationsInput{}
	}

	output = &DescribeEffectiveInstanceAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEffectiveInstanceAssociations API operation for Amazon Simple Systems Management Service.
//
// All associations for the managed nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeEffectiveInstanceAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations
func (c *SSM) DescribeEffectiveInstanceAssociations(input *DescribeEffectiveInstanceAssociationsInput) (*DescribeEffectiveInstanceAssociationsOutput, error) {
	req, out := c.DescribeEffectiveInstanceAssociationsRequest(input)
	return out, req.Send()
}

// DescribeEffectiveInstanceAssociationsWithContext is the same as DescribeEffectiveInstanceAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEffectiveInstanceAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeEffectiveInstanceAssociationsWithContext(ctx aws.Context, input *DescribeEffectiveInstanceAssociationsInput, opts ...request.Option) (*DescribeEffectiveInstanceAssociationsOutput, error) {
	req, out := c.DescribeEffectiveInstanceAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEffectiveInstanceAssociationsPages iterates over the pages of a DescribeEffectiveInstanceAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEffectiveInstanceAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEffectiveInstanceAssociations operation.
//	pageNum := 0
//	err := client.DescribeEffectiveInstanceAssociationsPages(params,
//	    func(page *ssm.DescribeEffectiveInstanceAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeEffectiveInstanceAssociationsPages(input *DescribeEffectiveInstanceAssociationsInput, fn func(*DescribeEffectiveInstanceAssociationsOutput, bool) bool) error {
	return c.DescribeEffectiveInstanceAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEffectiveInstanceAssociationsPagesWithContext same as DescribeEffectiveInstanceAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeEffectiveInstanceAssociationsPagesWithContext(ctx aws.Context, input *DescribeEffectiveInstanceAssociationsInput, fn func(*DescribeEffectiveInstanceAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEffectiveInstanceAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEffectiveInstanceAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEffectiveInstanceAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEffectivePatchesForPatchBaseline = "DescribeEffectivePatchesForPatchBaseline"

// DescribeEffectivePatchesForPatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEffectivePatchesForPatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEffectivePatchesForPatchBaseline for more information on using the DescribeEffectivePatchesForPatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEffectivePatchesForPatchBaselineRequest method.
//	req, resp := client.DescribeEffectivePatchesForPatchBaselineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline
func (c *SSM) DescribeEffectivePatchesForPatchBaselineRequest(input *DescribeEffectivePatchesForPatchBaselineInput) (req *request.Request, output *DescribeEffectivePatchesForPatchBaselineOutput) {
	op := &request.Operation{
		Name:       opDescribeEffectivePatchesForPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEffectivePatchesForPatchBaselineInput{}
	}

	output = &DescribeEffectivePatchesForPatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEffectivePatchesForPatchBaseline API operation for Amazon Simple Systems Management Service.
//
// Retrieves the current effective patches (the patch and the approval state)
// for the specified patch baseline. Applies to patch baselines for Windows
// only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeEffectivePatchesForPatchBaseline for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - UnsupportedOperatingSystem
//     The operating systems you specified isn't supported, or the operation isn't
//     supported for the operating system.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline
func (c *SSM) DescribeEffectivePatchesForPatchBaseline(input *DescribeEffectivePatchesForPatchBaselineInput) (*DescribeEffectivePatchesForPatchBaselineOutput, error) {
	req, out := c.DescribeEffectivePatchesForPatchBaselineRequest(input)
	return out, req.Send()
}

// DescribeEffectivePatchesForPatchBaselineWithContext is the same as DescribeEffectivePatchesForPatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEffectivePatchesForPatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeEffectivePatchesForPatchBaselineWithContext(ctx aws.Context, input *DescribeEffectivePatchesForPatchBaselineInput, opts ...request.Option) (*DescribeEffectivePatchesForPatchBaselineOutput, error) {
	req, out := c.DescribeEffectivePatchesForPatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEffectivePatchesForPatchBaselinePages iterates over the pages of a DescribeEffectivePatchesForPatchBaseline operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEffectivePatchesForPatchBaseline method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEffectivePatchesForPatchBaseline operation.
//	pageNum := 0
//	err := client.DescribeEffectivePatchesForPatchBaselinePages(params,
//	    func(page *ssm.DescribeEffectivePatchesForPatchBaselineOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeEffectivePatchesForPatchBaselinePages(input *DescribeEffectivePatchesForPatchBaselineInput, fn func(*DescribeEffectivePatchesForPatchBaselineOutput, bool) bool) error {
	return c.DescribeEffectivePatchesForPatchBaselinePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEffectivePatchesForPatchBaselinePagesWithContext same as DescribeEffectivePatchesForPatchBaselinePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeEffectivePatchesForPatchBaselinePagesWithContext(ctx aws.Context, input *DescribeEffectivePatchesForPatchBaselineInput, fn func(*DescribeEffectivePatchesForPatchBaselineOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEffectivePatchesForPatchBaselineInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEffectivePatchesForPatchBaselineRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEffectivePatchesForPatchBaselineOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceAssociationsStatus = "DescribeInstanceAssociationsStatus"

// DescribeInstanceAssociationsStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceAssociationsStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceAssociationsStatus for more information on using the DescribeInstanceAssociationsStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceAssociationsStatusRequest method.
//	req, resp := client.DescribeInstanceAssociationsStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus
func (c *SSM) DescribeInstanceAssociationsStatusRequest(input *DescribeInstanceAssociationsStatusInput) (req *request.Request, output *DescribeInstanceAssociationsStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAssociationsStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceAssociationsStatusInput{}
	}

	output = &DescribeInstanceAssociationsStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceAssociationsStatus API operation for Amazon Simple Systems Management Service.
//
// The status of the associations for the managed nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeInstanceAssociationsStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
//   - InvalidAssociationVersion
//     The version you specified isn't valid. Use ListAssociationVersions to view
//     all versions of an association according to the association ID. Or, use the
//     $LATEST parameter to view the latest version of the association.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus
func (c *SSM) DescribeInstanceAssociationsStatus(input *DescribeInstanceAssociationsStatusInput) (*DescribeInstanceAssociationsStatusOutput, error) {
	req, out := c.DescribeInstanceAssociationsStatusRequest(input)
	return out, req.Send()
}

// DescribeInstanceAssociationsStatusWithContext is the same as DescribeInstanceAssociationsStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceAssociationsStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstanceAssociationsStatusWithContext(ctx aws.Context, input *DescribeInstanceAssociationsStatusInput, opts ...request.Option) (*DescribeInstanceAssociationsStatusOutput, error) {
	req, out := c.DescribeInstanceAssociationsStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceAssociationsStatusPages iterates over the pages of a DescribeInstanceAssociationsStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceAssociationsStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstanceAssociationsStatus operation.
//	pageNum := 0
//	err := client.DescribeInstanceAssociationsStatusPages(params,
//	    func(page *ssm.DescribeInstanceAssociationsStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeInstanceAssociationsStatusPages(input *DescribeInstanceAssociationsStatusInput, fn func(*DescribeInstanceAssociationsStatusOutput, bool) bool) error {
	return c.DescribeInstanceAssociationsStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceAssociationsStatusPagesWithContext same as DescribeInstanceAssociationsStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstanceAssociationsStatusPagesWithContext(ctx aws.Context, input *DescribeInstanceAssociationsStatusInput, fn func(*DescribeInstanceAssociationsStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceAssociationsStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceAssociationsStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstanceAssociationsStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceInformation = "DescribeInstanceInformation"

// DescribeInstanceInformationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceInformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceInformation for more information on using the DescribeInstanceInformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceInformationRequest method.
//	req, resp := client.DescribeInstanceInformationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation
func (c *SSM) DescribeInstanceInformationRequest(input *DescribeInstanceInformationInput) (req *request.Request, output *DescribeInstanceInformationOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceInformationInput{}
	}

	output = &DescribeInstanceInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceInformation API operation for Amazon Simple Systems Management Service.
//
// Provides information about one or more of your managed nodes, including the
// operating system platform, SSM Agent version, association status, and IP
// address. This operation does not return information for nodes that are either
// Stopped or Terminated.
//
// If you specify one or more node IDs, the operation returns information for
// those managed nodes. If you don't specify node IDs, it returns information
// for all your managed nodes. If you specify a node ID that isn't valid or
// a node that you don't own, you receive an error.
//
// The IamRole field returned for this API operation is the role assigned to
// an Amazon EC2 instance configured with a Systems Manager Quick Setup host
// management configuration or the role assigned to an on-premises managed node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeInstanceInformation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidActivationId
//     The activation ID isn't valid. Verify that you entered the correct ActivationId
//     or ActivationCode and try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidInstanceInformationFilterValue
//     The specified filter value isn't valid.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation
func (c *SSM) DescribeInstanceInformation(input *DescribeInstanceInformationInput) (*DescribeInstanceInformationOutput, error) {
	req, out := c.DescribeInstanceInformationRequest(input)
	return out, req.Send()
}

// DescribeInstanceInformationWithContext is the same as DescribeInstanceInformation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstanceInformationWithContext(ctx aws.Context, input *DescribeInstanceInformationInput, opts ...request.Option) (*DescribeInstanceInformationOutput, error) {
	req, out := c.DescribeInstanceInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceInformationPages iterates over the pages of a DescribeInstanceInformation operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceInformation method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstanceInformation operation.
//	pageNum := 0
//	err := client.DescribeInstanceInformationPages(params,
//	    func(page *ssm.DescribeInstanceInformationOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeInstanceInformationPages(input *DescribeInstanceInformationInput, fn func(*DescribeInstanceInformationOutput, bool) bool) error {
	return c.DescribeInstanceInformationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceInformationPagesWithContext same as DescribeInstanceInformationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstanceInformationPagesWithContext(ctx aws.Context, input *DescribeInstanceInformationInput, fn func(*DescribeInstanceInformationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceInformationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceInformationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstanceInformationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstancePatchStates = "DescribeInstancePatchStates"

// DescribeInstancePatchStatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstancePatchStates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstancePatchStates for more information on using the DescribeInstancePatchStates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstancePatchStatesRequest method.
//	req, resp := client.DescribeInstancePatchStatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates
func (c *SSM) DescribeInstancePatchStatesRequest(input *DescribeInstancePatchStatesInput) (req *request.Request, output *DescribeInstancePatchStatesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstancePatchStates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancePatchStatesInput{}
	}

	output = &DescribeInstancePatchStatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstancePatchStates API operation for Amazon Simple Systems Management Service.
//
// Retrieves the high-level patch state of one or more managed nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeInstancePatchStates for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates
func (c *SSM) DescribeInstancePatchStates(input *DescribeInstancePatchStatesInput) (*DescribeInstancePatchStatesOutput, error) {
	req, out := c.DescribeInstancePatchStatesRequest(input)
	return out, req.Send()
}

// DescribeInstancePatchStatesWithContext is the same as DescribeInstancePatchStates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstancePatchStates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchStatesWithContext(ctx aws.Context, input *DescribeInstancePatchStatesInput, opts ...request.Option) (*DescribeInstancePatchStatesOutput, error) {
	req, out := c.DescribeInstancePatchStatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstancePatchStatesPages iterates over the pages of a DescribeInstancePatchStates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstancePatchStates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstancePatchStates operation.
//	pageNum := 0
//	err := client.DescribeInstancePatchStatesPages(params,
//	    func(page *ssm.DescribeInstancePatchStatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeInstancePatchStatesPages(input *DescribeInstancePatchStatesInput, fn func(*DescribeInstancePatchStatesOutput, bool) bool) error {
	return c.DescribeInstancePatchStatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstancePatchStatesPagesWithContext same as DescribeInstancePatchStatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchStatesPagesWithContext(ctx aws.Context, input *DescribeInstancePatchStatesInput, fn func(*DescribeInstancePatchStatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstancePatchStatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstancePatchStatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstancePatchStatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstancePatchStatesForPatchGroup = "DescribeInstancePatchStatesForPatchGroup"

// DescribeInstancePatchStatesForPatchGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstancePatchStatesForPatchGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstancePatchStatesForPatchGroup for more information on using the DescribeInstancePatchStatesForPatchGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstancePatchStatesForPatchGroupRequest method.
//	req, resp := client.DescribeInstancePatchStatesForPatchGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup
func (c *SSM) DescribeInstancePatchStatesForPatchGroupRequest(input *DescribeInstancePatchStatesForPatchGroupInput) (req *request.Request, output *DescribeInstancePatchStatesForPatchGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeInstancePatchStatesForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancePatchStatesForPatchGroupInput{}
	}

	output = &DescribeInstancePatchStatesForPatchGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstancePatchStatesForPatchGroup API operation for Amazon Simple Systems Management Service.
//
// Retrieves the high-level patch state for the managed nodes in the specified
// patch group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeInstancePatchStatesForPatchGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup
func (c *SSM) DescribeInstancePatchStatesForPatchGroup(input *DescribeInstancePatchStatesForPatchGroupInput) (*DescribeInstancePatchStatesForPatchGroupOutput, error) {
	req, out := c.DescribeInstancePatchStatesForPatchGroupRequest(input)
	return out, req.Send()
}

// DescribeInstancePatchStatesForPatchGroupWithContext is the same as DescribeInstancePatchStatesForPatchGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstancePatchStatesForPatchGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchStatesForPatchGroupWithContext(ctx aws.Context, input *DescribeInstancePatchStatesForPatchGroupInput, opts ...request.Option) (*DescribeInstancePatchStatesForPatchGroupOutput, error) {
	req, out := c.DescribeInstancePatchStatesForPatchGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstancePatchStatesForPatchGroupPages iterates over the pages of a DescribeInstancePatchStatesForPatchGroup operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstancePatchStatesForPatchGroup method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstancePatchStatesForPatchGroup operation.
//	pageNum := 0
//	err := client.DescribeInstancePatchStatesForPatchGroupPages(params,
//	    func(page *ssm.DescribeInstancePatchStatesForPatchGroupOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeInstancePatchStatesForPatchGroupPages(input *DescribeInstancePatchStatesForPatchGroupInput, fn func(*DescribeInstancePatchStatesForPatchGroupOutput, bool) bool) error {
	return c.DescribeInstancePatchStatesForPatchGroupPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstancePatchStatesForPatchGroupPagesWithContext same as DescribeInstancePatchStatesForPatchGroupPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchStatesForPatchGroupPagesWithContext(ctx aws.Context, input *DescribeInstancePatchStatesForPatchGroupInput, fn func(*DescribeInstancePatchStatesForPatchGroupOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstancePatchStatesForPatchGroupInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstancePatchStatesForPatchGroupRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstancePatchStatesForPatchGroupOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstancePatches = "DescribeInstancePatches"

// DescribeInstancePatchesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstancePatches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstancePatches for more information on using the DescribeInstancePatches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstancePatchesRequest method.
//	req, resp := client.DescribeInstancePatchesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches
func (c *SSM) DescribeInstancePatchesRequest(input *DescribeInstancePatchesInput) (req *request.Request, output *DescribeInstancePatchesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstancePatches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancePatchesInput{}
	}

	output = &DescribeInstancePatchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstancePatches API operation for Amazon Simple Systems Management Service.
//
// Retrieves information about the patches on the specified managed node and
// their state relative to the patch baseline being used for the node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeInstancePatches for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches
func (c *SSM) DescribeInstancePatches(input *DescribeInstancePatchesInput) (*DescribeInstancePatchesOutput, error) {
	req, out := c.DescribeInstancePatchesRequest(input)
	return out, req.Send()
}

// DescribeInstancePatchesWithContext is the same as DescribeInstancePatches with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstancePatches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchesWithContext(ctx aws.Context, input *DescribeInstancePatchesInput, opts ...request.Option) (*DescribeInstancePatchesOutput, error) {
	req, out := c.DescribeInstancePatchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstancePatchesPages iterates over the pages of a DescribeInstancePatches operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstancePatches method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstancePatches operation.
//	pageNum := 0
//	err := client.DescribeInstancePatchesPages(params,
//	    func(page *ssm.DescribeInstancePatchesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeInstancePatchesPages(input *DescribeInstancePatchesInput, fn func(*DescribeInstancePatchesOutput, bool) bool) error {
	return c.DescribeInstancePatchesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstancePatchesPagesWithContext same as DescribeInstancePatchesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchesPagesWithContext(ctx aws.Context, input *DescribeInstancePatchesInput, fn func(*DescribeInstancePatchesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstancePatchesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstancePatchesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstancePatchesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceProperties = "DescribeInstanceProperties"

// DescribeInstancePropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceProperties for more information on using the DescribeInstanceProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstancePropertiesRequest method.
//	req, resp := client.DescribeInstancePropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceProperties
func (c *SSM) DescribeInstancePropertiesRequest(input *DescribeInstancePropertiesInput) (req *request.Request, output *DescribeInstancePropertiesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancePropertiesInput{}
	}

	output = &DescribeInstancePropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceProperties API operation for Amazon Simple Systems Management Service.
//
// An API operation used by the Systems Manager console to display information
// about Systems Manager managed nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeInstanceProperties for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidActivationId
//     The activation ID isn't valid. Verify that you entered the correct ActivationId
//     or ActivationCode and try again.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidInstancePropertyFilterValue
//     The specified filter value isn't valid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceProperties
func (c *SSM) DescribeInstanceProperties(input *DescribeInstancePropertiesInput) (*DescribeInstancePropertiesOutput, error) {
	req, out := c.DescribeInstancePropertiesRequest(input)
	return out, req.Send()
}

// DescribeInstancePropertiesWithContext is the same as DescribeInstanceProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePropertiesWithContext(ctx aws.Context, input *DescribeInstancePropertiesInput, opts ...request.Option) (*DescribeInstancePropertiesOutput, error) {
	req, out := c.DescribeInstancePropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstancePropertiesPages iterates over the pages of a DescribeInstanceProperties operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceProperties method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstanceProperties operation.
//	pageNum := 0
//	err := client.DescribeInstancePropertiesPages(params,
//	    func(page *ssm.DescribeInstancePropertiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeInstancePropertiesPages(input *DescribeInstancePropertiesInput, fn func(*DescribeInstancePropertiesOutput, bool) bool) error {
	return c.DescribeInstancePropertiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstancePropertiesPagesWithContext same as DescribeInstancePropertiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePropertiesPagesWithContext(ctx aws.Context, input *DescribeInstancePropertiesInput, fn func(*DescribeInstancePropertiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstancePropertiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstancePropertiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstancePropertiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInventoryDeletions = "DescribeInventoryDeletions"

// DescribeInventoryDeletionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInventoryDeletions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInventoryDeletions for more information on using the DescribeInventoryDeletions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInventoryDeletionsRequest method.
//	req, resp := client.DescribeInventoryDeletionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions
func (c *SSM) DescribeInventoryDeletionsRequest(input *DescribeInventoryDeletionsInput) (req *request.Request, output *DescribeInventoryDeletionsOutput) {
	op := &request.Operation{
		Name:       opDescribeInventoryDeletions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInventoryDeletionsInput{}
	}

	output = &DescribeInventoryDeletionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInventoryDeletions API operation for Amazon Simple Systems Management Service.
//
// Describes a specific delete inventory operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeInventoryDeletions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDeletionIdException
//     The ID specified for the delete operation doesn't exist or isn't valid. Verify
//     the ID and try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions
func (c *SSM) DescribeInventoryDeletions(input *DescribeInventoryDeletionsInput) (*DescribeInventoryDeletionsOutput, error) {
	req, out := c.DescribeInventoryDeletionsRequest(input)
	return out, req.Send()
}

// DescribeInventoryDeletionsWithContext is the same as DescribeInventoryDeletions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInventoryDeletions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInventoryDeletionsWithContext(ctx aws.Context, input *DescribeInventoryDeletionsInput, opts ...request.Option) (*DescribeInventoryDeletionsOutput, error) {
	req, out := c.DescribeInventoryDeletionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInventoryDeletionsPages iterates over the pages of a DescribeInventoryDeletions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInventoryDeletions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInventoryDeletions operation.
//	pageNum := 0
//	err := client.DescribeInventoryDeletionsPages(params,
//	    func(page *ssm.DescribeInventoryDeletionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeInventoryDeletionsPages(input *DescribeInventoryDeletionsInput, fn func(*DescribeInventoryDeletionsOutput, bool) bool) error {
	return c.DescribeInventoryDeletionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInventoryDeletionsPagesWithContext same as DescribeInventoryDeletionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInventoryDeletionsPagesWithContext(ctx aws.Context, input *DescribeInventoryDeletionsInput, fn func(*DescribeInventoryDeletionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInventoryDeletionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInventoryDeletionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInventoryDeletionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMaintenanceWindowExecutionTaskInvocations = "DescribeMaintenanceWindowExecutionTaskInvocations"

// DescribeMaintenanceWindowExecutionTaskInvocationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowExecutionTaskInvocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowExecutionTaskInvocations for more information on using the DescribeMaintenanceWindowExecutionTaskInvocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMaintenanceWindowExecutionTaskInvocationsRequest method.
//	req, resp := client.DescribeMaintenanceWindowExecutionTaskInvocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations
func (c *SSM) DescribeMaintenanceWindowExecutionTaskInvocationsRequest(input *DescribeMaintenanceWindowExecutionTaskInvocationsInput) (req *request.Request, output *DescribeMaintenanceWindowExecutionTaskInvocationsOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowExecutionTaskInvocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMaintenanceWindowExecutionTaskInvocationsInput{}
	}

	output = &DescribeMaintenanceWindowExecutionTaskInvocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowExecutionTaskInvocations API operation for Amazon Simple Systems Management Service.
//
// Retrieves the individual task executions (one per target) for a particular
// task run as part of a maintenance window execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeMaintenanceWindowExecutionTaskInvocations for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations
func (c *SSM) DescribeMaintenanceWindowExecutionTaskInvocations(input *DescribeMaintenanceWindowExecutionTaskInvocationsInput) (*DescribeMaintenanceWindowExecutionTaskInvocationsOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionTaskInvocationsRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionTaskInvocationsWithContext is the same as DescribeMaintenanceWindowExecutionTaskInvocations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowExecutionTaskInvocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionTaskInvocationsWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionTaskInvocationsInput, opts ...request.Option) (*DescribeMaintenanceWindowExecutionTaskInvocationsOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionTaskInvocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionTaskInvocationsPages iterates over the pages of a DescribeMaintenanceWindowExecutionTaskInvocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMaintenanceWindowExecutionTaskInvocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMaintenanceWindowExecutionTaskInvocations operation.
//	pageNum := 0
//	err := client.DescribeMaintenanceWindowExecutionTaskInvocationsPages(params,
//	    func(page *ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeMaintenanceWindowExecutionTaskInvocationsPages(input *DescribeMaintenanceWindowExecutionTaskInvocationsInput, fn func(*DescribeMaintenanceWindowExecutionTaskInvocationsOutput, bool) bool) error {
	return c.DescribeMaintenanceWindowExecutionTaskInvocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMaintenanceWindowExecutionTaskInvocationsPagesWithContext same as DescribeMaintenanceWindowExecutionTaskInvocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionTaskInvocationsPagesWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionTaskInvocationsInput, fn func(*DescribeMaintenanceWindowExecutionTaskInvocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMaintenanceWindowExecutionTaskInvocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMaintenanceWindowExecutionTaskInvocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMaintenanceWindowExecutionTaskInvocationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMaintenanceWindowExecutionTasks = "DescribeMaintenanceWindowExecutionTasks"

// DescribeMaintenanceWindowExecutionTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowExecutionTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowExecutionTasks for more information on using the DescribeMaintenanceWindowExecutionTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMaintenanceWindowExecutionTasksRequest method.
//	req, resp := client.DescribeMaintenanceWindowExecutionTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks
func (c *SSM) DescribeMaintenanceWindowExecutionTasksRequest(input *DescribeMaintenanceWindowExecutionTasksInput) (req *request.Request, output *DescribeMaintenanceWindowExecutionTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowExecutionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMaintenanceWindowExecutionTasksInput{}
	}

	output = &DescribeMaintenanceWindowExecutionTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowExecutionTasks API operation for Amazon Simple Systems Management Service.
//
// For a given maintenance window execution, lists the tasks that were run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeMaintenanceWindowExecutionTasks for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks
func (c *SSM) DescribeMaintenanceWindowExecutionTasks(input *DescribeMaintenanceWindowExecutionTasksInput) (*DescribeMaintenanceWindowExecutionTasksOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionTasksRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionTasksWithContext is the same as DescribeMaintenanceWindowExecutionTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowExecutionTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionTasksWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionTasksInput, opts ...request.Option) (*DescribeMaintenanceWindowExecutionTasksOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionTasksPages iterates over the pages of a DescribeMaintenanceWindowExecutionTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMaintenanceWindowExecutionTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMaintenanceWindowExecutionTasks operation.
//	pageNum := 0
//	err := client.DescribeMaintenanceWindowExecutionTasksPages(params,
//	    func(page *ssm.DescribeMaintenanceWindowExecutionTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeMaintenanceWindowExecutionTasksPages(input *DescribeMaintenanceWindowExecutionTasksInput, fn func(*DescribeMaintenanceWindowExecutionTasksOutput, bool) bool) error {
	return c.DescribeMaintenanceWindowExecutionTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMaintenanceWindowExecutionTasksPagesWithContext same as DescribeMaintenanceWindowExecutionTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionTasksPagesWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionTasksInput, fn func(*DescribeMaintenanceWindowExecutionTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMaintenanceWindowExecutionTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMaintenanceWindowExecutionTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMaintenanceWindowExecutionTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMaintenanceWindowExecutions = "DescribeMaintenanceWindowExecutions"

// DescribeMaintenanceWindowExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowExecutions for more information on using the DescribeMaintenanceWindowExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMaintenanceWindowExecutionsRequest method.
//	req, resp := client.DescribeMaintenanceWindowExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions
func (c *SSM) DescribeMaintenanceWindowExecutionsRequest(input *DescribeMaintenanceWindowExecutionsInput) (req *request.Request, output *DescribeMaintenanceWindowExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMaintenanceWindowExecutionsInput{}
	}

	output = &DescribeMaintenanceWindowExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowExecutions API operation for Amazon Simple Systems Management Service.
//
// Lists the executions of a maintenance window. This includes information about
// when the maintenance window was scheduled to be active, and information about
// tasks registered and run with the maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeMaintenanceWindowExecutions for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions
func (c *SSM) DescribeMaintenanceWindowExecutions(input *DescribeMaintenanceWindowExecutionsInput) (*DescribeMaintenanceWindowExecutionsOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionsRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionsWithContext is the same as DescribeMaintenanceWindowExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionsWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionsInput, opts ...request.Option) (*DescribeMaintenanceWindowExecutionsOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionsPages iterates over the pages of a DescribeMaintenanceWindowExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMaintenanceWindowExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMaintenanceWindowExecutions operation.
//	pageNum := 0
//	err := client.DescribeMaintenanceWindowExecutionsPages(params,
//	    func(page *ssm.DescribeMaintenanceWindowExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeMaintenanceWindowExecutionsPages(input *DescribeMaintenanceWindowExecutionsInput, fn func(*DescribeMaintenanceWindowExecutionsOutput, bool) bool) error {
	return c.DescribeMaintenanceWindowExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMaintenanceWindowExecutionsPagesWithContext same as DescribeMaintenanceWindowExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionsPagesWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionsInput, fn func(*DescribeMaintenanceWindowExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMaintenanceWindowExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMaintenanceWindowExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMaintenanceWindowExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMaintenanceWindowSchedule = "DescribeMaintenanceWindowSchedule"

// DescribeMaintenanceWindowScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowSchedule for more information on using the DescribeMaintenanceWindowSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMaintenanceWindowScheduleRequest method.
//	req, resp := client.DescribeMaintenanceWindowScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule
func (c *SSM) DescribeMaintenanceWindowScheduleRequest(input *DescribeMaintenanceWindowScheduleInput) (req *request.Request, output *DescribeMaintenanceWindowScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMaintenanceWindowScheduleInput{}
	}

	output = &DescribeMaintenanceWindowScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowSchedule API operation for Amazon Simple Systems Management Service.
//
// Retrieves information about upcoming executions of a maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeMaintenanceWindowSchedule for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule
func (c *SSM) DescribeMaintenanceWindowSchedule(input *DescribeMaintenanceWindowScheduleInput) (*DescribeMaintenanceWindowScheduleOutput, error) {
	req, out := c.DescribeMaintenanceWindowScheduleRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowScheduleWithContext is the same as DescribeMaintenanceWindowSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowScheduleWithContext(ctx aws.Context, input *DescribeMaintenanceWindowScheduleInput, opts ...request.Option) (*DescribeMaintenanceWindowScheduleOutput, error) {
	req, out := c.DescribeMaintenanceWindowScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMaintenanceWindowSchedulePages iterates over the pages of a DescribeMaintenanceWindowSchedule operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMaintenanceWindowSchedule method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMaintenanceWindowSchedule operation.
//	pageNum := 0
//	err := client.DescribeMaintenanceWindowSchedulePages(params,
//	    func(page *ssm.DescribeMaintenanceWindowScheduleOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeMaintenanceWindowSchedulePages(input *DescribeMaintenanceWindowScheduleInput, fn func(*DescribeMaintenanceWindowScheduleOutput, bool) bool) error {
	return c.DescribeMaintenanceWindowSchedulePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMaintenanceWindowSchedulePagesWithContext same as DescribeMaintenanceWindowSchedulePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowSchedulePagesWithContext(ctx aws.Context, input *DescribeMaintenanceWindowScheduleInput, fn func(*DescribeMaintenanceWindowScheduleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMaintenanceWindowScheduleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMaintenanceWindowScheduleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMaintenanceWindowScheduleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMaintenanceWindowTargets = "DescribeMaintenanceWindowTargets"

// DescribeMaintenanceWindowTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowTargets for more information on using the DescribeMaintenanceWindowTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMaintenanceWindowTargetsRequest method.
//	req, resp := client.DescribeMaintenanceWindowTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets
func (c *SSM) DescribeMaintenanceWindowTargetsRequest(input *DescribeMaintenanceWindowTargetsInput) (req *request.Request, output *DescribeMaintenanceWindowTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMaintenanceWindowTargetsInput{}
	}

	output = &DescribeMaintenanceWindowTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowTargets API operation for Amazon Simple Systems Management Service.
//
// Lists the targets registered with the maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeMaintenanceWindowTargets for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets
func (c *SSM) DescribeMaintenanceWindowTargets(input *DescribeMaintenanceWindowTargetsInput) (*DescribeMaintenanceWindowTargetsOutput, error) {
	req, out := c.DescribeMaintenanceWindowTargetsRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowTargetsWithContext is the same as DescribeMaintenanceWindowTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowTargetsWithContext(ctx aws.Context, input *DescribeMaintenanceWindowTargetsInput, opts ...request.Option) (*DescribeMaintenanceWindowTargetsOutput, error) {
	req, out := c.DescribeMaintenanceWindowTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMaintenanceWindowTargetsPages iterates over the pages of a DescribeMaintenanceWindowTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMaintenanceWindowTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMaintenanceWindowTargets operation.
//	pageNum := 0
//	err := client.DescribeMaintenanceWindowTargetsPages(params,
//	    func(page *ssm.DescribeMaintenanceWindowTargetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeMaintenanceWindowTargetsPages(input *DescribeMaintenanceWindowTargetsInput, fn func(*DescribeMaintenanceWindowTargetsOutput, bool) bool) error {
	return c.DescribeMaintenanceWindowTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMaintenanceWindowTargetsPagesWithContext same as DescribeMaintenanceWindowTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowTargetsPagesWithContext(ctx aws.Context, input *DescribeMaintenanceWindowTargetsInput, fn func(*DescribeMaintenanceWindowTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMaintenanceWindowTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMaintenanceWindowTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMaintenanceWindowTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMaintenanceWindowTasks = "DescribeMaintenanceWindowTasks"

// DescribeMaintenanceWindowTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowTasks for more information on using the DescribeMaintenanceWindowTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMaintenanceWindowTasksRequest method.
//	req, resp := client.DescribeMaintenanceWindowTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks
func (c *SSM) DescribeMaintenanceWindowTasksRequest(input *DescribeMaintenanceWindowTasksInput) (req *request.Request, output *DescribeMaintenanceWindowTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMaintenanceWindowTasksInput{}
	}

	output = &DescribeMaintenanceWindowTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowTasks API operation for Amazon Simple Systems Management Service.
//
// Lists the tasks in a maintenance window.
//
// For maintenance window tasks without a specified target, you can't supply
// values for --max-errors and --max-concurrency. Instead, the system inserts
// a placeholder value of 1, which may be reported in the response to this command.
// These values don't affect the running of your task and can be ignored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeMaintenanceWindowTasks for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks
func (c *SSM) DescribeMaintenanceWindowTasks(input *DescribeMaintenanceWindowTasksInput) (*DescribeMaintenanceWindowTasksOutput, error) {
	req, out := c.DescribeMaintenanceWindowTasksRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowTasksWithContext is the same as DescribeMaintenanceWindowTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowTasksWithContext(ctx aws.Context, input *DescribeMaintenanceWindowTasksInput, opts ...request.Option) (*DescribeMaintenanceWindowTasksOutput, error) {
	req, out := c.DescribeMaintenanceWindowTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMaintenanceWindowTasksPages iterates over the pages of a DescribeMaintenanceWindowTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMaintenanceWindowTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMaintenanceWindowTasks operation.
//	pageNum := 0
//	err := client.DescribeMaintenanceWindowTasksPages(params,
//	    func(page *ssm.DescribeMaintenanceWindowTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeMaintenanceWindowTasksPages(input *DescribeMaintenanceWindowTasksInput, fn func(*DescribeMaintenanceWindowTasksOutput, bool) bool) error {
	return c.DescribeMaintenanceWindowTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMaintenanceWindowTasksPagesWithContext same as DescribeMaintenanceWindowTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowTasksPagesWithContext(ctx aws.Context, input *DescribeMaintenanceWindowTasksInput, fn func(*DescribeMaintenanceWindowTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMaintenanceWindowTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMaintenanceWindowTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMaintenanceWindowTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMaintenanceWindows = "DescribeMaintenanceWindows"

// DescribeMaintenanceWindowsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindows for more information on using the DescribeMaintenanceWindows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMaintenanceWindowsRequest method.
//	req, resp := client.DescribeMaintenanceWindowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows
func (c *SSM) DescribeMaintenanceWindowsRequest(input *DescribeMaintenanceWindowsInput) (req *request.Request, output *DescribeMaintenanceWindowsOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMaintenanceWindowsInput{}
	}

	output = &DescribeMaintenanceWindowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindows API operation for Amazon Simple Systems Management Service.
//
// Retrieves the maintenance windows in an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeMaintenanceWindows for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows
func (c *SSM) DescribeMaintenanceWindows(input *DescribeMaintenanceWindowsInput) (*DescribeMaintenanceWindowsOutput, error) {
	req, out := c.DescribeMaintenanceWindowsRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowsWithContext is the same as DescribeMaintenanceWindows with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowsWithContext(ctx aws.Context, input *DescribeMaintenanceWindowsInput, opts ...request.Option) (*DescribeMaintenanceWindowsOutput, error) {
	req, out := c.DescribeMaintenanceWindowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMaintenanceWindowsPages iterates over the pages of a DescribeMaintenanceWindows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMaintenanceWindows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMaintenanceWindows operation.
//	pageNum := 0
//	err := client.DescribeMaintenanceWindowsPages(params,
//	    func(page *ssm.DescribeMaintenanceWindowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeMaintenanceWindowsPages(input *DescribeMaintenanceWindowsInput, fn func(*DescribeMaintenanceWindowsOutput, bool) bool) error {
	return c.DescribeMaintenanceWindowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMaintenanceWindowsPagesWithContext same as DescribeMaintenanceWindowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowsPagesWithContext(ctx aws.Context, input *DescribeMaintenanceWindowsInput, fn func(*DescribeMaintenanceWindowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMaintenanceWindowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMaintenanceWindowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMaintenanceWindowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMaintenanceWindowsForTarget = "DescribeMaintenanceWindowsForTarget"

// DescribeMaintenanceWindowsForTargetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowsForTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowsForTarget for more information on using the DescribeMaintenanceWindowsForTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMaintenanceWindowsForTargetRequest method.
//	req, resp := client.DescribeMaintenanceWindowsForTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget
func (c *SSM) DescribeMaintenanceWindowsForTargetRequest(input *DescribeMaintenanceWindowsForTargetInput) (req *request.Request, output *DescribeMaintenanceWindowsForTargetOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowsForTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMaintenanceWindowsForTargetInput{}
	}

	output = &DescribeMaintenanceWindowsForTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowsForTarget API operation for Amazon Simple Systems Management Service.
//
// Retrieves information about the maintenance window targets or tasks that
// a managed node is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeMaintenanceWindowsForTarget for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget
func (c *SSM) DescribeMaintenanceWindowsForTarget(input *DescribeMaintenanceWindowsForTargetInput) (*DescribeMaintenanceWindowsForTargetOutput, error) {
	req, out := c.DescribeMaintenanceWindowsForTargetRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowsForTargetWithContext is the same as DescribeMaintenanceWindowsForTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowsForTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowsForTargetWithContext(ctx aws.Context, input *DescribeMaintenanceWindowsForTargetInput, opts ...request.Option) (*DescribeMaintenanceWindowsForTargetOutput, error) {
	req, out := c.DescribeMaintenanceWindowsForTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMaintenanceWindowsForTargetPages iterates over the pages of a DescribeMaintenanceWindowsForTarget operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMaintenanceWindowsForTarget method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMaintenanceWindowsForTarget operation.
//	pageNum := 0
//	err := client.DescribeMaintenanceWindowsForTargetPages(params,
//	    func(page *ssm.DescribeMaintenanceWindowsForTargetOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeMaintenanceWindowsForTargetPages(input *DescribeMaintenanceWindowsForTargetInput, fn func(*DescribeMaintenanceWindowsForTargetOutput, bool) bool) error {
	return c.DescribeMaintenanceWindowsForTargetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMaintenanceWindowsForTargetPagesWithContext same as DescribeMaintenanceWindowsForTargetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowsForTargetPagesWithContext(ctx aws.Context, input *DescribeMaintenanceWindowsForTargetInput, fn func(*DescribeMaintenanceWindowsForTargetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMaintenanceWindowsForTargetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMaintenanceWindowsForTargetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMaintenanceWindowsForTargetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOpsItems = "DescribeOpsItems"

// DescribeOpsItemsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOpsItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOpsItems for more information on using the DescribeOpsItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOpsItemsRequest method.
//	req, resp := client.DescribeOpsItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems
func (c *SSM) DescribeOpsItemsRequest(input *DescribeOpsItemsInput) (req *request.Request, output *DescribeOpsItemsOutput) {
	op := &request.Operation{
		Name:       opDescribeOpsItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOpsItemsInput{}
	}

	output = &DescribeOpsItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOpsItems API operation for Amazon Simple Systems Management Service.
//
// Query a set of OpsItems. You must have permission in Identity and Access
// Management (IAM) to query a list of OpsItems. For more information, see Set
// up OpsCenter (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Operations engineers and IT professionals use Amazon Web Services Systems
// Manager OpsCenter to view, investigate, and remediate operational issues
// impacting the performance and health of their Amazon Web Services resources.
// For more information, see Amazon Web Services Systems Manager OpsCenter (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeOpsItems for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsCenterInvalidArgumentException
//
//   - OpsItemAccessDeniedException
//     You don't have permission to view OpsItems in the specified account. Verify
//     that your account is configured either as a Systems Manager delegated administrator
//     or that you are logged into the Organizations management account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems
func (c *SSM) DescribeOpsItems(input *DescribeOpsItemsInput) (*DescribeOpsItemsOutput, error) {
	req, out := c.DescribeOpsItemsRequest(input)
	return out, req.Send()
}

// DescribeOpsItemsWithContext is the same as DescribeOpsItems with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOpsItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeOpsItemsWithContext(ctx aws.Context, input *DescribeOpsItemsInput, opts ...request.Option) (*DescribeOpsItemsOutput, error) {
	req, out := c.DescribeOpsItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOpsItemsPages iterates over the pages of a DescribeOpsItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOpsItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeOpsItems operation.
//	pageNum := 0
//	err := client.DescribeOpsItemsPages(params,
//	    func(page *ssm.DescribeOpsItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeOpsItemsPages(input *DescribeOpsItemsInput, fn func(*DescribeOpsItemsOutput, bool) bool) error {
	return c.DescribeOpsItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOpsItemsPagesWithContext same as DescribeOpsItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeOpsItemsPagesWithContext(ctx aws.Context, input *DescribeOpsItemsInput, fn func(*DescribeOpsItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOpsItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOpsItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOpsItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeParameters = "DescribeParameters"

// DescribeParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeParameters for more information on using the DescribeParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeParametersRequest method.
//	req, resp := client.DescribeParametersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters
func (c *SSM) DescribeParametersRequest(input *DescribeParametersInput) (req *request.Request, output *DescribeParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeParametersInput{}
	}

	output = &DescribeParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeParameters API operation for Amazon Simple Systems Management Service.
//
// Lists the parameters in your Amazon Web Services account or the parameters
// shared with you when you enable the Shared (https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribeParameters.html#systemsmanager-DescribeParameters-request-Shared)
// option.
//
// Request results are returned on a best-effort basis. If you specify MaxResults
// in the request, the response includes information up to the limit specified.
// The number of items returned, however, can be between zero and the value
// of MaxResults. If the service reaches an internal limit while processing
// the results, it stops the operation and returns the matching values up to
// that point and a NextToken. You can specify the NextToken in a subsequent
// call to get the next set of results.
//
// If you change the KMS key alias for the KMS key used to encrypt a parameter,
// then you must also update the key alias the parameter uses to reference KMS.
// Otherwise, DescribeParameters retrieves whatever the original key alias was
// referencing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeParameters for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidFilterOption
//     The specified filter option isn't valid. Valid options are Equals and BeginsWith.
//     For Path filter, valid options are Recursive and OneLevel.
//
//   - InvalidFilterValue
//     The filter value isn't valid. Verify the value and try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters
func (c *SSM) DescribeParameters(input *DescribeParametersInput) (*DescribeParametersOutput, error) {
	req, out := c.DescribeParametersRequest(input)
	return out, req.Send()
}

// DescribeParametersWithContext is the same as DescribeParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeParametersWithContext(ctx aws.Context, input *DescribeParametersInput, opts ...request.Option) (*DescribeParametersOutput, error) {
	req, out := c.DescribeParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeParametersPages iterates over the pages of a DescribeParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeParameters operation.
//	pageNum := 0
//	err := client.DescribeParametersPages(params,
//	    func(page *ssm.DescribeParametersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeParametersPages(input *DescribeParametersInput, fn func(*DescribeParametersOutput, bool) bool) error {
	return c.DescribeParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeParametersPagesWithContext same as DescribeParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeParametersPagesWithContext(ctx aws.Context, input *DescribeParametersInput, fn func(*DescribeParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeParametersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePatchBaselines = "DescribePatchBaselines"

// DescribePatchBaselinesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePatchBaselines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePatchBaselines for more information on using the DescribePatchBaselines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePatchBaselinesRequest method.
//	req, resp := client.DescribePatchBaselinesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines
func (c *SSM) DescribePatchBaselinesRequest(input *DescribePatchBaselinesInput) (req *request.Request, output *DescribePatchBaselinesOutput) {
	op := &request.Operation{
		Name:       opDescribePatchBaselines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePatchBaselinesInput{}
	}

	output = &DescribePatchBaselinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePatchBaselines API operation for Amazon Simple Systems Management Service.
//
// Lists the patch baselines in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribePatchBaselines for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines
func (c *SSM) DescribePatchBaselines(input *DescribePatchBaselinesInput) (*DescribePatchBaselinesOutput, error) {
	req, out := c.DescribePatchBaselinesRequest(input)
	return out, req.Send()
}

// DescribePatchBaselinesWithContext is the same as DescribePatchBaselines with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePatchBaselines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchBaselinesWithContext(ctx aws.Context, input *DescribePatchBaselinesInput, opts ...request.Option) (*DescribePatchBaselinesOutput, error) {
	req, out := c.DescribePatchBaselinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePatchBaselinesPages iterates over the pages of a DescribePatchBaselines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePatchBaselines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribePatchBaselines operation.
//	pageNum := 0
//	err := client.DescribePatchBaselinesPages(params,
//	    func(page *ssm.DescribePatchBaselinesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribePatchBaselinesPages(input *DescribePatchBaselinesInput, fn func(*DescribePatchBaselinesOutput, bool) bool) error {
	return c.DescribePatchBaselinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePatchBaselinesPagesWithContext same as DescribePatchBaselinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchBaselinesPagesWithContext(ctx aws.Context, input *DescribePatchBaselinesInput, fn func(*DescribePatchBaselinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePatchBaselinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePatchBaselinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePatchBaselinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePatchGroupState = "DescribePatchGroupState"

// DescribePatchGroupStateRequest generates a "aws/request.Request" representing the
// client's request for the DescribePatchGroupState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePatchGroupState for more information on using the DescribePatchGroupState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePatchGroupStateRequest method.
//	req, resp := client.DescribePatchGroupStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState
func (c *SSM) DescribePatchGroupStateRequest(input *DescribePatchGroupStateInput) (req *request.Request, output *DescribePatchGroupStateOutput) {
	op := &request.Operation{
		Name:       opDescribePatchGroupState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePatchGroupStateInput{}
	}

	output = &DescribePatchGroupStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePatchGroupState API operation for Amazon Simple Systems Management Service.
//
// Returns high-level aggregated patch compliance state information for a patch
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribePatchGroupState for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState
func (c *SSM) DescribePatchGroupState(input *DescribePatchGroupStateInput) (*DescribePatchGroupStateOutput, error) {
	req, out := c.DescribePatchGroupStateRequest(input)
	return out, req.Send()
}

// DescribePatchGroupStateWithContext is the same as DescribePatchGroupState with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePatchGroupState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchGroupStateWithContext(ctx aws.Context, input *DescribePatchGroupStateInput, opts ...request.Option) (*DescribePatchGroupStateOutput, error) {
	req, out := c.DescribePatchGroupStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePatchGroups = "DescribePatchGroups"

// DescribePatchGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePatchGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePatchGroups for more information on using the DescribePatchGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePatchGroupsRequest method.
//	req, resp := client.DescribePatchGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups
func (c *SSM) DescribePatchGroupsRequest(input *DescribePatchGroupsInput) (req *request.Request, output *DescribePatchGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribePatchGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePatchGroupsInput{}
	}

	output = &DescribePatchGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePatchGroups API operation for Amazon Simple Systems Management Service.
//
// Lists all patch groups that have been registered with patch baselines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribePatchGroups for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups
func (c *SSM) DescribePatchGroups(input *DescribePatchGroupsInput) (*DescribePatchGroupsOutput, error) {
	req, out := c.DescribePatchGroupsRequest(input)
	return out, req.Send()
}

// DescribePatchGroupsWithContext is the same as DescribePatchGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePatchGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchGroupsWithContext(ctx aws.Context, input *DescribePatchGroupsInput, opts ...request.Option) (*DescribePatchGroupsOutput, error) {
	req, out := c.DescribePatchGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePatchGroupsPages iterates over the pages of a DescribePatchGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePatchGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribePatchGroups operation.
//	pageNum := 0
//	err := client.DescribePatchGroupsPages(params,
//	    func(page *ssm.DescribePatchGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribePatchGroupsPages(input *DescribePatchGroupsInput, fn func(*DescribePatchGroupsOutput, bool) bool) error {
	return c.DescribePatchGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePatchGroupsPagesWithContext same as DescribePatchGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchGroupsPagesWithContext(ctx aws.Context, input *DescribePatchGroupsInput, fn func(*DescribePatchGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePatchGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePatchGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePatchGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePatchProperties = "DescribePatchProperties"

// DescribePatchPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePatchProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePatchProperties for more information on using the DescribePatchProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePatchPropertiesRequest method.
//	req, resp := client.DescribePatchPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties
func (c *SSM) DescribePatchPropertiesRequest(input *DescribePatchPropertiesInput) (req *request.Request, output *DescribePatchPropertiesOutput) {
	op := &request.Operation{
		Name:       opDescribePatchProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePatchPropertiesInput{}
	}

	output = &DescribePatchPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePatchProperties API operation for Amazon Simple Systems Management Service.
//
// Lists the properties of available patches organized by product, product family,
// classification, severity, and other properties of available patches. You
// can use the reported properties in the filters you specify in requests for
// operations such as CreatePatchBaseline, UpdatePatchBaseline, DescribeAvailablePatches,
// and DescribePatchBaselines.
//
// The following section lists the properties that can be used in filters for
// each major operating system type:
//
// AMAZON_LINUX
//
// Valid properties: PRODUCT | CLASSIFICATION | SEVERITY
//
// AMAZON_LINUX_2
//
// Valid properties: PRODUCT | CLASSIFICATION | SEVERITY
//
// AMAZON_LINUX_2023
//
// Valid properties: PRODUCT | CLASSIFICATION | SEVERITY
//
// # CENTOS
//
// Valid properties: PRODUCT | CLASSIFICATION | SEVERITY
//
// # DEBIAN
//
// Valid properties: PRODUCT | PRIORITY
//
// # MACOS
//
// Valid properties: PRODUCT | CLASSIFICATION
//
// ORACLE_LINUX
//
// Valid properties: PRODUCT | CLASSIFICATION | SEVERITY
//
// REDHAT_ENTERPRISE_LINUX
//
// Valid properties: PRODUCT | CLASSIFICATION | SEVERITY
//
// # SUSE
//
// Valid properties: PRODUCT | CLASSIFICATION | SEVERITY
//
// # UBUNTU
//
// Valid properties: PRODUCT | PRIORITY
//
// # WINDOWS
//
// Valid properties: PRODUCT | PRODUCT_FAMILY | CLASSIFICATION | MSRC_SEVERITY
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribePatchProperties for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties
func (c *SSM) DescribePatchProperties(input *DescribePatchPropertiesInput) (*DescribePatchPropertiesOutput, error) {
	req, out := c.DescribePatchPropertiesRequest(input)
	return out, req.Send()
}

// DescribePatchPropertiesWithContext is the same as DescribePatchProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePatchProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchPropertiesWithContext(ctx aws.Context, input *DescribePatchPropertiesInput, opts ...request.Option) (*DescribePatchPropertiesOutput, error) {
	req, out := c.DescribePatchPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePatchPropertiesPages iterates over the pages of a DescribePatchProperties operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePatchProperties method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribePatchProperties operation.
//	pageNum := 0
//	err := client.DescribePatchPropertiesPages(params,
//	    func(page *ssm.DescribePatchPropertiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribePatchPropertiesPages(input *DescribePatchPropertiesInput, fn func(*DescribePatchPropertiesOutput, bool) bool) error {
	return c.DescribePatchPropertiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePatchPropertiesPagesWithContext same as DescribePatchPropertiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchPropertiesPagesWithContext(ctx aws.Context, input *DescribePatchPropertiesInput, fn func(*DescribePatchPropertiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePatchPropertiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePatchPropertiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePatchPropertiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSessions = "DescribeSessions"

// DescribeSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSessions for more information on using the DescribeSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSessionsRequest method.
//	req, resp := client.DescribeSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions
func (c *SSM) DescribeSessionsRequest(input *DescribeSessionsInput) (req *request.Request, output *DescribeSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSessionsInput{}
	}

	output = &DescribeSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSessions API operation for Amazon Simple Systems Management Service.
//
// Retrieves a list of all active sessions (both connected and disconnected)
// or terminated sessions from the past 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeSessions for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions
func (c *SSM) DescribeSessions(input *DescribeSessionsInput) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	return out, req.Send()
}

// DescribeSessionsWithContext is the same as DescribeSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeSessionsWithContext(ctx aws.Context, input *DescribeSessionsInput, opts ...request.Option) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSessionsPages iterates over the pages of a DescribeSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeSessions operation.
//	pageNum := 0
//	err := client.DescribeSessionsPages(params,
//	    func(page *ssm.DescribeSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) DescribeSessionsPages(input *DescribeSessionsInput, fn func(*DescribeSessionsOutput, bool) bool) error {
	return c.DescribeSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSessionsPagesWithContext same as DescribeSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeSessionsPagesWithContext(ctx aws.Context, input *DescribeSessionsInput, fn func(*DescribeSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisassociateOpsItemRelatedItem = "DisassociateOpsItemRelatedItem"

// DisassociateOpsItemRelatedItemRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateOpsItemRelatedItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateOpsItemRelatedItem for more information on using the DisassociateOpsItemRelatedItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateOpsItemRelatedItemRequest method.
//	req, resp := client.DisassociateOpsItemRelatedItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DisassociateOpsItemRelatedItem
func (c *SSM) DisassociateOpsItemRelatedItemRequest(input *DisassociateOpsItemRelatedItemInput) (req *request.Request, output *DisassociateOpsItemRelatedItemOutput) {
	op := &request.Operation{
		Name:       opDisassociateOpsItemRelatedItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateOpsItemRelatedItemInput{}
	}

	output = &DisassociateOpsItemRelatedItemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateOpsItemRelatedItem API operation for Amazon Simple Systems Management Service.
//
// Deletes the association between an OpsItem and a related item. For example,
// this API operation can delete an Incident Manager incident from an OpsItem.
// Incident Manager is a capability of Amazon Web Services Systems Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DisassociateOpsItemRelatedItem for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsItemConflictException
//     The specified OpsItem is in the process of being deleted.
//
//   - OpsItemRelatedItemAssociationNotFoundException
//     The association wasn't found using the parameters you specified in the call.
//     Verify the information and try again.
//
//   - OpsItemNotFoundException
//     The specified OpsItem ID doesn't exist. Verify the ID and try again.
//
//   - OpsItemInvalidParameterException
//     A specified parameter argument isn't valid. Verify the available arguments
//     and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DisassociateOpsItemRelatedItem
func (c *SSM) DisassociateOpsItemRelatedItem(input *DisassociateOpsItemRelatedItemInput) (*DisassociateOpsItemRelatedItemOutput, error) {
	req, out := c.DisassociateOpsItemRelatedItemRequest(input)
	return out, req.Send()
}

// DisassociateOpsItemRelatedItemWithContext is the same as DisassociateOpsItemRelatedItem with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateOpsItemRelatedItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DisassociateOpsItemRelatedItemWithContext(ctx aws.Context, input *DisassociateOpsItemRelatedItemInput, opts ...request.Option) (*DisassociateOpsItemRelatedItemOutput, error) {
	req, out := c.DisassociateOpsItemRelatedItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExecuteApi = "ExecuteApi"

// ExecuteApiRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteApi for more information on using the ExecuteApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteApiRequest method.
//	req, resp := client.ExecuteApiRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ExecuteApi
func (c *SSM) ExecuteApiRequest(input *ExecuteApiInput) (req *request.Request, output *ExecuteApiOutput) {
	op := &request.Operation{
		Name:       opExecuteApi,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecuteApiInput{}
	}

	output = &ExecuteApiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteApi API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ExecuteApi for usage and error information.
//
// Returned Error Types:
//
//   - ExecuteApiSourceServiceExecutionException
//
//   - ExecuteApiInvalidParameterException
//
//   - ExecuteApiUnknownOperationException
//
//   - ExecuteApiIncompletePermissionException
//
//   - ExecuteApiAccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ExecuteApi
func (c *SSM) ExecuteApi(input *ExecuteApiInput) (*ExecuteApiOutput, error) {
	req, out := c.ExecuteApiRequest(input)
	return out, req.Send()
}

// ExecuteApiWithContext is the same as ExecuteApi with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ExecuteApiWithContext(ctx aws.Context, input *ExecuteApiInput, opts ...request.Option) (*ExecuteApiOutput, error) {
	req, out := c.ExecuteApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExploreSsmActions = "ExploreSsmActions"

// ExploreSsmActionsRequest generates a "aws/request.Request" representing the
// client's request for the ExploreSsmActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExploreSsmActions for more information on using the ExploreSsmActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExploreSsmActionsRequest method.
//	req, resp := client.ExploreSsmActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ExploreSsmActions
func (c *SSM) ExploreSsmActionsRequest(input *ExploreSsmActionsInput) (req *request.Request, output *ExploreSsmActionsOutput) {
	op := &request.Operation{
		Name:       opExploreSsmActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExploreSsmActionsInput{}
	}

	output = &ExploreSsmActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExploreSsmActions API operation for Amazon Simple Systems Management Service.
//
// # Explore Action Api
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ExploreSsmActions for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ExploreSsmActions
func (c *SSM) ExploreSsmActions(input *ExploreSsmActionsInput) (*ExploreSsmActionsOutput, error) {
	req, out := c.ExploreSsmActionsRequest(input)
	return out, req.Send()
}

// ExploreSsmActionsWithContext is the same as ExploreSsmActions with the addition of
// the ability to pass a context and additional request options.
//
// See ExploreSsmActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ExploreSsmActionsWithContext(ctx aws.Context, input *ExploreSsmActionsInput, opts ...request.Option) (*ExploreSsmActionsOutput, error) {
	req, out := c.ExploreSsmActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessToken = "GetAccessToken"

// GetAccessTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessToken for more information on using the GetAccessToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessTokenRequest method.
//	req, resp := client.GetAccessTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAccessToken
func (c *SSM) GetAccessTokenRequest(input *GetAccessTokenInput) (req *request.Request, output *GetAccessTokenOutput) {
	op := &request.Operation{
		Name:       opGetAccessToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccessTokenInput{}
	}

	output = &GetAccessTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccessToken API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetAccessToken for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourceNotFoundException
//     The specified parameter to be shared could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAccessToken
func (c *SSM) GetAccessToken(input *GetAccessTokenInput) (*GetAccessTokenOutput, error) {
	req, out := c.GetAccessTokenRequest(input)
	return out, req.Send()
}

// GetAccessTokenWithContext is the same as GetAccessToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetAccessTokenWithContext(ctx aws.Context, input *GetAccessTokenInput, opts ...request.Option) (*GetAccessTokenOutput, error) {
	req, out := c.GetAccessTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAutomationAction = "GetAutomationAction"

// GetAutomationActionRequest generates a "aws/request.Request" representing the
// client's request for the GetAutomationAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAutomationAction for more information on using the GetAutomationAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAutomationActionRequest method.
//	req, resp := client.GetAutomationActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationAction
func (c *SSM) GetAutomationActionRequest(input *GetAutomationActionInput) (req *request.Request, output *GetAutomationActionOutput) {
	op := &request.Operation{
		Name:       opGetAutomationAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAutomationActionInput{}
	}

	output = &GetAutomationActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAutomationAction API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetAutomationAction for usage and error information.
//
// Returned Error Types:
//
//   - AutomationActionNotFoundException
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationAction
func (c *SSM) GetAutomationAction(input *GetAutomationActionInput) (*GetAutomationActionOutput, error) {
	req, out := c.GetAutomationActionRequest(input)
	return out, req.Send()
}

// GetAutomationActionWithContext is the same as GetAutomationAction with the addition of
// the ability to pass a context and additional request options.
//
// See GetAutomationAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetAutomationActionWithContext(ctx aws.Context, input *GetAutomationActionInput, opts ...request.Option) (*GetAutomationActionOutput, error) {
	req, out := c.GetAutomationActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAutomationExecution = "GetAutomationExecution"

// GetAutomationExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetAutomationExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAutomationExecution for more information on using the GetAutomationExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAutomationExecutionRequest method.
//	req, resp := client.GetAutomationExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution
func (c *SSM) GetAutomationExecutionRequest(input *GetAutomationExecutionInput) (req *request.Request, output *GetAutomationExecutionOutput) {
	op := &request.Operation{
		Name:       opGetAutomationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAutomationExecutionInput{}
	}

	output = &GetAutomationExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAutomationExecution API operation for Amazon Simple Systems Management Service.
//
// Get detailed information about a particular Automation execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetAutomationExecution for usage and error information.
//
// Returned Error Types:
//
//   - AutomationExecutionNotFoundException
//     There is no automation execution information for the requested automation
//     execution ID.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution
func (c *SSM) GetAutomationExecution(input *GetAutomationExecutionInput) (*GetAutomationExecutionOutput, error) {
	req, out := c.GetAutomationExecutionRequest(input)
	return out, req.Send()
}

// GetAutomationExecutionWithContext is the same as GetAutomationExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetAutomationExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetAutomationExecutionWithContext(ctx aws.Context, input *GetAutomationExecutionInput, opts ...request.Option) (*GetAutomationExecutionOutput, error) {
	req, out := c.GetAutomationExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCalendar = "GetCalendar"

// GetCalendarRequest generates a "aws/request.Request" representing the
// client's request for the GetCalendar operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCalendar for more information on using the GetCalendar
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCalendarRequest method.
//	req, resp := client.GetCalendarRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendar
func (c *SSM) GetCalendarRequest(input *GetCalendarInput) (req *request.Request, output *GetCalendarOutput) {
	op := &request.Operation{
		Name:       opGetCalendar,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCalendarInput{}
	}

	output = &GetCalendarOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCalendar API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetCalendar for usage and error information.
//
// Returned Error Types:
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentType
//     The SSM document type isn't valid. Valid document types are described in
//     the DocumentType property.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - UnsupportedCalendarException
//     The calendar entry contained in the specified SSM document isn't supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendar
func (c *SSM) GetCalendar(input *GetCalendarInput) (*GetCalendarOutput, error) {
	req, out := c.GetCalendarRequest(input)
	return out, req.Send()
}

// GetCalendarWithContext is the same as GetCalendar with the addition of
// the ability to pass a context and additional request options.
//
// See GetCalendar for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetCalendarWithContext(ctx aws.Context, input *GetCalendarInput, opts ...request.Option) (*GetCalendarOutput, error) {
	req, out := c.GetCalendarRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCalendarState = "GetCalendarState"

// GetCalendarStateRequest generates a "aws/request.Request" representing the
// client's request for the GetCalendarState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCalendarState for more information on using the GetCalendarState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCalendarStateRequest method.
//	req, resp := client.GetCalendarStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState
func (c *SSM) GetCalendarStateRequest(input *GetCalendarStateInput) (req *request.Request, output *GetCalendarStateOutput) {
	op := &request.Operation{
		Name:       opGetCalendarState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCalendarStateInput{}
	}

	output = &GetCalendarStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCalendarState API operation for Amazon Simple Systems Management Service.
//
// Gets the state of a Amazon Web Services Systems Manager change calendar at
// the current time or a specified time. If you specify a time, GetCalendarState
// returns the state of the calendar at that specific time, and returns the
// next time that the change calendar state will transition. If you don't specify
// a time, GetCalendarState uses the current time. Change Calendar entries have
// two possible states: OPEN or CLOSED.
//
// If you specify more than one calendar in a request, the command returns the
// status of OPEN only if all calendars in the request are open. If one or more
// calendars in the request are closed, the status returned is CLOSED.
//
// For more information about Change Calendar, a capability of Amazon Web Services
// Systems Manager, see Amazon Web Services Systems Manager Change Calendar
// (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetCalendarState for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentType
//     The SSM document type isn't valid. Valid document types are described in
//     the DocumentType property.
//
//   - UnsupportedCalendarException
//     The calendar entry contained in the specified SSM document isn't supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState
func (c *SSM) GetCalendarState(input *GetCalendarStateInput) (*GetCalendarStateOutput, error) {
	req, out := c.GetCalendarStateRequest(input)
	return out, req.Send()
}

// GetCalendarStateWithContext is the same as GetCalendarState with the addition of
// the ability to pass a context and additional request options.
//
// See GetCalendarState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetCalendarStateWithContext(ctx aws.Context, input *GetCalendarStateInput, opts ...request.Option) (*GetCalendarStateOutput, error) {
	req, out := c.GetCalendarStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCommandInteractiveToken = "GetCommandInteractiveToken"

// GetCommandInteractiveTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetCommandInteractiveToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCommandInteractiveToken for more information on using the GetCommandInteractiveToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCommandInteractiveTokenRequest method.
//	req, resp := client.GetCommandInteractiveTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInteractiveToken
func (c *SSM) GetCommandInteractiveTokenRequest(input *GetCommandInteractiveTokenInput) (req *request.Request, output *GetCommandInteractiveTokenOutput) {
	op := &request.Operation{
		Name:       opGetCommandInteractiveToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCommandInteractiveTokenInput{}
	}

	output = &GetCommandInteractiveTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCommandInteractiveToken API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetCommandInteractiveToken for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidCommandId
//     The specified command ID isn't valid. Verify the ID and try again.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvocationDoesNotExist
//     The command ID and managed node ID you specified didn't match any invocations.
//     Verify the command ID and the managed node ID and try again.
//
//   - CommandNotInteractive
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInteractiveToken
func (c *SSM) GetCommandInteractiveToken(input *GetCommandInteractiveTokenInput) (*GetCommandInteractiveTokenOutput, error) {
	req, out := c.GetCommandInteractiveTokenRequest(input)
	return out, req.Send()
}

// GetCommandInteractiveTokenWithContext is the same as GetCommandInteractiveToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetCommandInteractiveToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetCommandInteractiveTokenWithContext(ctx aws.Context, input *GetCommandInteractiveTokenInput, opts ...request.Option) (*GetCommandInteractiveTokenOutput, error) {
	req, out := c.GetCommandInteractiveTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCommandInvocation = "GetCommandInvocation"

// GetCommandInvocationRequest generates a "aws/request.Request" representing the
// client's request for the GetCommandInvocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCommandInvocation for more information on using the GetCommandInvocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCommandInvocationRequest method.
//	req, resp := client.GetCommandInvocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation
func (c *SSM) GetCommandInvocationRequest(input *GetCommandInvocationInput) (req *request.Request, output *GetCommandInvocationOutput) {
	op := &request.Operation{
		Name:       opGetCommandInvocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCommandInvocationInput{}
	}

	output = &GetCommandInvocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCommandInvocation API operation for Amazon Simple Systems Management Service.
//
// Returns detailed information about command execution for an invocation or
// plugin. The Run Command API follows an eventual consistency model, due to
// the distributed nature of the system supporting the API. This means that
// the result of an API command you run that affects your resources might not
// be immediately visible to all subsequent commands you run. You should keep
// this in mind when you carry out an API command that immediately follows a
// previous API command.
//
// GetCommandInvocation only gives the execution status of a plugin in a document.
// To get the command execution status on a specific managed node, use ListCommandInvocations.
// To get the command execution status across managed nodes, use ListCommands.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetCommandInvocation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidCommandId
//     The specified command ID isn't valid. Verify the ID and try again.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidPluginName
//     The plugin name isn't valid.
//
//   - InvocationDoesNotExist
//     The command ID and managed node ID you specified didn't match any invocations.
//     Verify the command ID and the managed node ID and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation
func (c *SSM) GetCommandInvocation(input *GetCommandInvocationInput) (*GetCommandInvocationOutput, error) {
	req, out := c.GetCommandInvocationRequest(input)
	return out, req.Send()
}

// GetCommandInvocationWithContext is the same as GetCommandInvocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetCommandInvocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetCommandInvocationWithContext(ctx aws.Context, input *GetCommandInvocationInput, opts ...request.Option) (*GetCommandInvocationOutput, error) {
	req, out := c.GetCommandInvocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectionStatus = "GetConnectionStatus"

// GetConnectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectionStatus for more information on using the GetConnectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConnectionStatusRequest method.
//	req, resp := client.GetConnectionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus
func (c *SSM) GetConnectionStatusRequest(input *GetConnectionStatusInput) (req *request.Request, output *GetConnectionStatusOutput) {
	op := &request.Operation{
		Name:       opGetConnectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConnectionStatusInput{}
	}

	output = &GetConnectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectionStatus API operation for Amazon Simple Systems Management Service.
//
// Retrieves the Session Manager connection status for a managed node to determine
// whether it is running and ready to receive Session Manager connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetConnectionStatus for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus
func (c *SSM) GetConnectionStatus(input *GetConnectionStatusInput) (*GetConnectionStatusOutput, error) {
	req, out := c.GetConnectionStatusRequest(input)
	return out, req.Send()
}

// GetConnectionStatusWithContext is the same as GetConnectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetConnectionStatusWithContext(ctx aws.Context, input *GetConnectionStatusInput, opts ...request.Option) (*GetConnectionStatusOutput, error) {
	req, out := c.GetConnectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDefaultPatchBaseline = "GetDefaultPatchBaseline"

// GetDefaultPatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the GetDefaultPatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDefaultPatchBaseline for more information on using the GetDefaultPatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDefaultPatchBaselineRequest method.
//	req, resp := client.GetDefaultPatchBaselineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline
func (c *SSM) GetDefaultPatchBaselineRequest(input *GetDefaultPatchBaselineInput) (req *request.Request, output *GetDefaultPatchBaselineOutput) {
	op := &request.Operation{
		Name:       opGetDefaultPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDefaultPatchBaselineInput{}
	}

	output = &GetDefaultPatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDefaultPatchBaseline API operation for Amazon Simple Systems Management Service.
//
// Retrieves the default patch baseline. Amazon Web Services Systems Manager
// supports creating multiple default patch baselines. For example, you can
// create a default patch baseline for each operating system.
//
// If you don't specify an operating system value, the default patch baseline
// for Windows is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetDefaultPatchBaseline for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline
func (c *SSM) GetDefaultPatchBaseline(input *GetDefaultPatchBaselineInput) (*GetDefaultPatchBaselineOutput, error) {
	req, out := c.GetDefaultPatchBaselineRequest(input)
	return out, req.Send()
}

// GetDefaultPatchBaselineWithContext is the same as GetDefaultPatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See GetDefaultPatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetDefaultPatchBaselineWithContext(ctx aws.Context, input *GetDefaultPatchBaselineInput, opts ...request.Option) (*GetDefaultPatchBaselineOutput, error) {
	req, out := c.GetDefaultPatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployablePatchSnapshotForInstance = "GetDeployablePatchSnapshotForInstance"

// GetDeployablePatchSnapshotForInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployablePatchSnapshotForInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployablePatchSnapshotForInstance for more information on using the GetDeployablePatchSnapshotForInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeployablePatchSnapshotForInstanceRequest method.
//	req, resp := client.GetDeployablePatchSnapshotForInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance
func (c *SSM) GetDeployablePatchSnapshotForInstanceRequest(input *GetDeployablePatchSnapshotForInstanceInput) (req *request.Request, output *GetDeployablePatchSnapshotForInstanceOutput) {
	op := &request.Operation{
		Name:       opGetDeployablePatchSnapshotForInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeployablePatchSnapshotForInstanceInput{}
	}

	output = &GetDeployablePatchSnapshotForInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployablePatchSnapshotForInstance API operation for Amazon Simple Systems Management Service.
//
// Retrieves the current snapshot for the patch baseline the managed node uses.
// This API is primarily used by the AWS-RunPatchBaseline Systems Manager document
// (SSM document).
//
// If you run the command locally, such as with the Command Line Interface (CLI),
// the system attempts to use your local Amazon Web Services credentials and
// the operation fails. To avoid this, you can run the command in the Amazon
// Web Services Systems Manager console. Use Run Command, a capability of Amazon
// Web Services Systems Manager, with an SSM document that enables you to target
// a managed node with a script or command. For example, run the command using
// the AWS-RunShellScript document or the AWS-RunPowerShellScript document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetDeployablePatchSnapshotForInstance for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - UnsupportedOperatingSystem
//     The operating systems you specified isn't supported, or the operation isn't
//     supported for the operating system.
//
//   - UnsupportedFeatureRequiredException
//     Patching for applications released by Microsoft is only available on EC2
//     instances and advanced instances. To patch applications released by Microsoft
//     on on-premises servers and VMs, you must enable advanced instances. For more
//     information, see Turning on the advanced-instances tier (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html)
//     in the Amazon Web Services Systems Manager User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance
func (c *SSM) GetDeployablePatchSnapshotForInstance(input *GetDeployablePatchSnapshotForInstanceInput) (*GetDeployablePatchSnapshotForInstanceOutput, error) {
	req, out := c.GetDeployablePatchSnapshotForInstanceRequest(input)
	return out, req.Send()
}

// GetDeployablePatchSnapshotForInstanceWithContext is the same as GetDeployablePatchSnapshotForInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployablePatchSnapshotForInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetDeployablePatchSnapshotForInstanceWithContext(ctx aws.Context, input *GetDeployablePatchSnapshotForInstanceInput, opts ...request.Option) (*GetDeployablePatchSnapshotForInstanceOutput, error) {
	req, out := c.GetDeployablePatchSnapshotForInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocument = "GetDocument"

// GetDocumentRequest generates a "aws/request.Request" representing the
// client's request for the GetDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocument for more information on using the GetDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDocumentRequest method.
//	req, resp := client.GetDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument
func (c *SSM) GetDocumentRequest(input *GetDocumentInput) (req *request.Request, output *GetDocumentOutput) {
	op := &request.Operation{
		Name:       opGetDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentInput{}
	}

	output = &GetDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocument API operation for Amazon Simple Systems Management Service.
//
// Gets the contents of the specified Amazon Web Services Systems Manager document
// (SSM document).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetDocument for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument
func (c *SSM) GetDocument(input *GetDocumentInput) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	return out, req.Send()
}

// GetDocumentWithContext is the same as GetDocument with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetDocumentWithContext(ctx aws.Context, input *GetDocumentInput, opts ...request.Option) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentInternal = "GetDocumentInternal"

// GetDocumentInternalRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentInternal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentInternal for more information on using the GetDocumentInternal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDocumentInternalRequest method.
//	req, resp := client.GetDocumentInternalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocumentInternal
func (c *SSM) GetDocumentInternalRequest(input *GetDocumentInternalInput) (req *request.Request, output *GetDocumentInternalOutput) {
	op := &request.Operation{
		Name:       opGetDocumentInternal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentInternalInput{}
	}

	output = &GetDocumentInternalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentInternal API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetDocumentInternal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocumentInternal
func (c *SSM) GetDocumentInternal(input *GetDocumentInternalInput) (*GetDocumentInternalOutput, error) {
	req, out := c.GetDocumentInternalRequest(input)
	return out, req.Send()
}

// GetDocumentInternalWithContext is the same as GetDocumentInternal with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentInternal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetDocumentInternalWithContext(ctx aws.Context, input *GetDocumentInternalInput, opts ...request.Option) (*GetDocumentInternalOutput, error) {
	req, out := c.GetDocumentInternalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExecutionPreview = "GetExecutionPreview"

// GetExecutionPreviewRequest generates a "aws/request.Request" representing the
// client's request for the GetExecutionPreview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExecutionPreview for more information on using the GetExecutionPreview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExecutionPreviewRequest method.
//	req, resp := client.GetExecutionPreviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetExecutionPreview
func (c *SSM) GetExecutionPreviewRequest(input *GetExecutionPreviewInput) (req *request.Request, output *GetExecutionPreviewOutput) {
	op := &request.Operation{
		Name:       opGetExecutionPreview,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetExecutionPreviewInput{}
	}

	output = &GetExecutionPreviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExecutionPreview API operation for Amazon Simple Systems Management Service.
//
// Initiates the process of retrieving an existing preview that shows the effects
// that running a specified Automation runbook would have on the targeted resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetExecutionPreview for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourceNotFoundException
//     The specified parameter to be shared could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetExecutionPreview
func (c *SSM) GetExecutionPreview(input *GetExecutionPreviewInput) (*GetExecutionPreviewOutput, error) {
	req, out := c.GetExecutionPreviewRequest(input)
	return out, req.Send()
}

// GetExecutionPreviewWithContext is the same as GetExecutionPreview with the addition of
// the ability to pass a context and additional request options.
//
// See GetExecutionPreview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetExecutionPreviewWithContext(ctx aws.Context, input *GetExecutionPreviewInput, opts ...request.Option) (*GetExecutionPreviewOutput, error) {
	req, out := c.GetExecutionPreviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInventory = "GetInventory"

// GetInventoryRequest generates a "aws/request.Request" representing the
// client's request for the GetInventory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInventory for more information on using the GetInventory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInventoryRequest method.
//	req, resp := client.GetInventoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory
func (c *SSM) GetInventoryRequest(input *GetInventoryInput) (req *request.Request, output *GetInventoryOutput) {
	op := &request.Operation{
		Name:       opGetInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInventoryInput{}
	}

	output = &GetInventoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInventory API operation for Amazon Simple Systems Management Service.
//
// Query inventory information. This includes managed node status, such as Stopped
// or Terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetInventory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidInventoryGroupException
//     The specified inventory group isn't valid.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
//   - InvalidAggregatorException
//     The specified aggregator isn't valid for the group type. Verify that the
//     aggregator you provided is supported.
//
//   - InvalidResultAttributeException
//     The specified inventory item result attribute isn't valid.
//
//   - InvalidInventoryResourceTypeException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory
func (c *SSM) GetInventory(input *GetInventoryInput) (*GetInventoryOutput, error) {
	req, out := c.GetInventoryRequest(input)
	return out, req.Send()
}

// GetInventoryWithContext is the same as GetInventory with the addition of
// the ability to pass a context and additional request options.
//
// See GetInventory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetInventoryWithContext(ctx aws.Context, input *GetInventoryInput, opts ...request.Option) (*GetInventoryOutput, error) {
	req, out := c.GetInventoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInventoryPages iterates over the pages of a GetInventory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInventory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetInventory operation.
//	pageNum := 0
//	err := client.GetInventoryPages(params,
//	    func(page *ssm.GetInventoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) GetInventoryPages(input *GetInventoryInput, fn func(*GetInventoryOutput, bool) bool) error {
	return c.GetInventoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInventoryPagesWithContext same as GetInventoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetInventoryPagesWithContext(ctx aws.Context, input *GetInventoryInput, fn func(*GetInventoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInventoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInventoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetInventoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInventorySchema = "GetInventorySchema"

// GetInventorySchemaRequest generates a "aws/request.Request" representing the
// client's request for the GetInventorySchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInventorySchema for more information on using the GetInventorySchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInventorySchemaRequest method.
//	req, resp := client.GetInventorySchemaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema
func (c *SSM) GetInventorySchemaRequest(input *GetInventorySchemaInput) (req *request.Request, output *GetInventorySchemaOutput) {
	op := &request.Operation{
		Name:       opGetInventorySchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInventorySchemaInput{}
	}

	output = &GetInventorySchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInventorySchema API operation for Amazon Simple Systems Management Service.
//
// Return a list of inventory type names for the account, or return a list of
// attribute names for a specific Inventory item type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetInventorySchema for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidInventoryResourceIdException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema
func (c *SSM) GetInventorySchema(input *GetInventorySchemaInput) (*GetInventorySchemaOutput, error) {
	req, out := c.GetInventorySchemaRequest(input)
	return out, req.Send()
}

// GetInventorySchemaWithContext is the same as GetInventorySchema with the addition of
// the ability to pass a context and additional request options.
//
// See GetInventorySchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetInventorySchemaWithContext(ctx aws.Context, input *GetInventorySchemaInput, opts ...request.Option) (*GetInventorySchemaOutput, error) {
	req, out := c.GetInventorySchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInventorySchemaPages iterates over the pages of a GetInventorySchema operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInventorySchema method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetInventorySchema operation.
//	pageNum := 0
//	err := client.GetInventorySchemaPages(params,
//	    func(page *ssm.GetInventorySchemaOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) GetInventorySchemaPages(input *GetInventorySchemaInput, fn func(*GetInventorySchemaOutput, bool) bool) error {
	return c.GetInventorySchemaPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInventorySchemaPagesWithContext same as GetInventorySchemaPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetInventorySchemaPagesWithContext(ctx aws.Context, input *GetInventorySchemaInput, fn func(*GetInventorySchemaOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInventorySchemaInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInventorySchemaRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetInventorySchemaOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetMaintenanceWindow = "GetMaintenanceWindow"

// GetMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindow for more information on using the GetMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMaintenanceWindowRequest method.
//	req, resp := client.GetMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow
func (c *SSM) GetMaintenanceWindowRequest(input *GetMaintenanceWindowInput) (req *request.Request, output *GetMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowInput{}
	}

	output = &GetMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindow API operation for Amazon Simple Systems Management Service.
//
// Retrieves a maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow
func (c *SSM) GetMaintenanceWindow(input *GetMaintenanceWindowInput) (*GetMaintenanceWindowOutput, error) {
	req, out := c.GetMaintenanceWindowRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowWithContext is the same as GetMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowWithContext(ctx aws.Context, input *GetMaintenanceWindowInput, opts ...request.Option) (*GetMaintenanceWindowOutput, error) {
	req, out := c.GetMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindowExecution = "GetMaintenanceWindowExecution"

// GetMaintenanceWindowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindowExecution for more information on using the GetMaintenanceWindowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMaintenanceWindowExecutionRequest method.
//	req, resp := client.GetMaintenanceWindowExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution
func (c *SSM) GetMaintenanceWindowExecutionRequest(input *GetMaintenanceWindowExecutionInput) (req *request.Request, output *GetMaintenanceWindowExecutionOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowExecutionInput{}
	}

	output = &GetMaintenanceWindowExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindowExecution API operation for Amazon Simple Systems Management Service.
//
// Retrieves details about a specific a maintenance window execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetMaintenanceWindowExecution for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution
func (c *SSM) GetMaintenanceWindowExecution(input *GetMaintenanceWindowExecutionInput) (*GetMaintenanceWindowExecutionOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowExecutionWithContext is the same as GetMaintenanceWindowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowExecutionWithContext(ctx aws.Context, input *GetMaintenanceWindowExecutionInput, opts ...request.Option) (*GetMaintenanceWindowExecutionOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindowExecutionTask = "GetMaintenanceWindowExecutionTask"

// GetMaintenanceWindowExecutionTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindowExecutionTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindowExecutionTask for more information on using the GetMaintenanceWindowExecutionTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMaintenanceWindowExecutionTaskRequest method.
//	req, resp := client.GetMaintenanceWindowExecutionTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask
func (c *SSM) GetMaintenanceWindowExecutionTaskRequest(input *GetMaintenanceWindowExecutionTaskInput) (req *request.Request, output *GetMaintenanceWindowExecutionTaskOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindowExecutionTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowExecutionTaskInput{}
	}

	output = &GetMaintenanceWindowExecutionTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindowExecutionTask API operation for Amazon Simple Systems Management Service.
//
// Retrieves the details about a specific task run as part of a maintenance
// window execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetMaintenanceWindowExecutionTask for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask
func (c *SSM) GetMaintenanceWindowExecutionTask(input *GetMaintenanceWindowExecutionTaskInput) (*GetMaintenanceWindowExecutionTaskOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionTaskRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowExecutionTaskWithContext is the same as GetMaintenanceWindowExecutionTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindowExecutionTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowExecutionTaskWithContext(ctx aws.Context, input *GetMaintenanceWindowExecutionTaskInput, opts ...request.Option) (*GetMaintenanceWindowExecutionTaskOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindowExecutionTaskInvocation = "GetMaintenanceWindowExecutionTaskInvocation"

// GetMaintenanceWindowExecutionTaskInvocationRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindowExecutionTaskInvocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindowExecutionTaskInvocation for more information on using the GetMaintenanceWindowExecutionTaskInvocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMaintenanceWindowExecutionTaskInvocationRequest method.
//	req, resp := client.GetMaintenanceWindowExecutionTaskInvocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation
func (c *SSM) GetMaintenanceWindowExecutionTaskInvocationRequest(input *GetMaintenanceWindowExecutionTaskInvocationInput) (req *request.Request, output *GetMaintenanceWindowExecutionTaskInvocationOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindowExecutionTaskInvocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowExecutionTaskInvocationInput{}
	}

	output = &GetMaintenanceWindowExecutionTaskInvocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindowExecutionTaskInvocation API operation for Amazon Simple Systems Management Service.
//
// Retrieves information about a specific task running on a specific target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetMaintenanceWindowExecutionTaskInvocation for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation
func (c *SSM) GetMaintenanceWindowExecutionTaskInvocation(input *GetMaintenanceWindowExecutionTaskInvocationInput) (*GetMaintenanceWindowExecutionTaskInvocationOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionTaskInvocationRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowExecutionTaskInvocationWithContext is the same as GetMaintenanceWindowExecutionTaskInvocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindowExecutionTaskInvocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowExecutionTaskInvocationWithContext(ctx aws.Context, input *GetMaintenanceWindowExecutionTaskInvocationInput, opts ...request.Option) (*GetMaintenanceWindowExecutionTaskInvocationOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionTaskInvocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindowTask = "GetMaintenanceWindowTask"

// GetMaintenanceWindowTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindowTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindowTask for more information on using the GetMaintenanceWindowTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMaintenanceWindowTaskRequest method.
//	req, resp := client.GetMaintenanceWindowTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask
func (c *SSM) GetMaintenanceWindowTaskRequest(input *GetMaintenanceWindowTaskInput) (req *request.Request, output *GetMaintenanceWindowTaskOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindowTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowTaskInput{}
	}

	output = &GetMaintenanceWindowTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindowTask API operation for Amazon Simple Systems Management Service.
//
// Retrieves the details of a maintenance window task.
//
// For maintenance window tasks without a specified target, you can't supply
// values for --max-errors and --max-concurrency. Instead, the system inserts
// a placeholder value of 1, which may be reported in the response to this command.
// These values don't affect the running of your task and can be ignored.
//
// To retrieve a list of tasks in a maintenance window, instead use the DescribeMaintenanceWindowTasks
// command.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetMaintenanceWindowTask for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask
func (c *SSM) GetMaintenanceWindowTask(input *GetMaintenanceWindowTaskInput) (*GetMaintenanceWindowTaskOutput, error) {
	req, out := c.GetMaintenanceWindowTaskRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowTaskWithContext is the same as GetMaintenanceWindowTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindowTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowTaskWithContext(ctx aws.Context, input *GetMaintenanceWindowTaskInput, opts ...request.Option) (*GetMaintenanceWindowTaskOutput, error) {
	req, out := c.GetMaintenanceWindowTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetManifest = "GetManifest"

// GetManifestRequest generates a "aws/request.Request" representing the
// client's request for the GetManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetManifest for more information on using the GetManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetManifestRequest method.
//	req, resp := client.GetManifestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetManifest
func (c *SSM) GetManifestRequest(input *GetManifestInput) (req *request.Request, output *GetManifestOutput) {
	op := &request.Operation{
		Name:       opGetManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetManifestInput{}
	}

	output = &GetManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetManifest API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetManifest for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The specified parameter to be shared could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetManifest
func (c *SSM) GetManifest(input *GetManifestInput) (*GetManifestOutput, error) {
	req, out := c.GetManifestRequest(input)
	return out, req.Send()
}

// GetManifestWithContext is the same as GetManifest with the addition of
// the ability to pass a context and additional request options.
//
// See GetManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetManifestWithContext(ctx aws.Context, input *GetManifestInput, opts ...request.Option) (*GetManifestOutput, error) {
	req, out := c.GetManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOpsItem = "GetOpsItem"

// GetOpsItemRequest generates a "aws/request.Request" representing the
// client's request for the GetOpsItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOpsItem for more information on using the GetOpsItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOpsItemRequest method.
//	req, resp := client.GetOpsItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItem
func (c *SSM) GetOpsItemRequest(input *GetOpsItemInput) (req *request.Request, output *GetOpsItemOutput) {
	op := &request.Operation{
		Name:       opGetOpsItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpsItemInput{}
	}

	output = &GetOpsItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOpsItem API operation for Amazon Simple Systems Management Service.
//
// Get information about an OpsItem by using the ID. You must have permission
// in Identity and Access Management (IAM) to view information about an OpsItem.
// For more information, see Set up OpsCenter (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Operations engineers and IT professionals use Amazon Web Services Systems
// Manager OpsCenter to view, investigate, and remediate operational issues
// impacting the performance and health of their Amazon Web Services resources.
// For more information, see Amazon Web Services Systems Manager OpsCenter (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetOpsItem for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsCenterInvalidArgumentException
//
//   - OpsItemNotFoundException
//     The specified OpsItem ID doesn't exist. Verify the ID and try again.
//
//   - OpsItemAccessDeniedException
//     You don't have permission to view OpsItems in the specified account. Verify
//     that your account is configured either as a Systems Manager delegated administrator
//     or that you are logged into the Organizations management account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItem
func (c *SSM) GetOpsItem(input *GetOpsItemInput) (*GetOpsItemOutput, error) {
	req, out := c.GetOpsItemRequest(input)
	return out, req.Send()
}

// GetOpsItemWithContext is the same as GetOpsItem with the addition of
// the ability to pass a context and additional request options.
//
// See GetOpsItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetOpsItemWithContext(ctx aws.Context, input *GetOpsItemInput, opts ...request.Option) (*GetOpsItemOutput, error) {
	req, out := c.GetOpsItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOpsItemGroup = "GetOpsItemGroup"

// GetOpsItemGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetOpsItemGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOpsItemGroup for more information on using the GetOpsItemGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOpsItemGroupRequest method.
//	req, resp := client.GetOpsItemGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItemGroup
func (c *SSM) GetOpsItemGroupRequest(input *GetOpsItemGroupInput) (req *request.Request, output *GetOpsItemGroupOutput) {
	op := &request.Operation{
		Name:       opGetOpsItemGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpsItemGroupInput{}
	}

	output = &GetOpsItemGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOpsItemGroup API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetOpsItemGroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidParameterException
//
//   - OpsItemGroupNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItemGroup
func (c *SSM) GetOpsItemGroup(input *GetOpsItemGroupInput) (*GetOpsItemGroupOutput, error) {
	req, out := c.GetOpsItemGroupRequest(input)
	return out, req.Send()
}

// GetOpsItemGroupWithContext is the same as GetOpsItemGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetOpsItemGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetOpsItemGroupWithContext(ctx aws.Context, input *GetOpsItemGroupInput, opts ...request.Option) (*GetOpsItemGroupOutput, error) {
	req, out := c.GetOpsItemGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOpsMetadata = "GetOpsMetadata"

// GetOpsMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetOpsMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOpsMetadata for more information on using the GetOpsMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOpsMetadataRequest method.
//	req, resp := client.GetOpsMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsMetadata
func (c *SSM) GetOpsMetadataRequest(input *GetOpsMetadataInput) (req *request.Request, output *GetOpsMetadataOutput) {
	op := &request.Operation{
		Name:       opGetOpsMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpsMetadataInput{}
	}

	output = &GetOpsMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOpsMetadata API operation for Amazon Simple Systems Management Service.
//
// View operational metadata related to an application in Application Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetOpsMetadata for usage and error information.
//
// Returned Error Types:
//
//   - OpsMetadataNotFoundException
//     The OpsMetadata object doesn't exist.
//
//   - OpsMetadataInvalidArgumentException
//     One of the arguments passed is invalid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsMetadata
func (c *SSM) GetOpsMetadata(input *GetOpsMetadataInput) (*GetOpsMetadataOutput, error) {
	req, out := c.GetOpsMetadataRequest(input)
	return out, req.Send()
}

// GetOpsMetadataWithContext is the same as GetOpsMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetOpsMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetOpsMetadataWithContext(ctx aws.Context, input *GetOpsMetadataInput, opts ...request.Option) (*GetOpsMetadataOutput, error) {
	req, out := c.GetOpsMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOpsSummary = "GetOpsSummary"

// GetOpsSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetOpsSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOpsSummary for more information on using the GetOpsSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOpsSummaryRequest method.
//	req, resp := client.GetOpsSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary
func (c *SSM) GetOpsSummaryRequest(input *GetOpsSummaryInput) (req *request.Request, output *GetOpsSummaryOutput) {
	op := &request.Operation{
		Name:       opGetOpsSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetOpsSummaryInput{}
	}

	output = &GetOpsSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOpsSummary API operation for Amazon Simple Systems Management Service.
//
// View a summary of operations metadata (OpsData) based on specified filters
// and aggregators. OpsData can include information about Amazon Web Services
// Systems Manager OpsCenter operational workitems (OpsItems) as well as information
// about any Amazon Web Services resource or service configured to report OpsData
// to Amazon Web Services Systems Manager Explorer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetOpsSummary for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourceDataSyncNotFoundException
//     The specified sync name wasn't found.
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidResourceType
//     The resource type isn't valid. For example, if you are attempting to tag
//     an EC2 instance, the instance must be a registered managed node.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
//   - InvalidAggregatorException
//     The specified aggregator isn't valid for the group type. Verify that the
//     aggregator you provided is supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary
func (c *SSM) GetOpsSummary(input *GetOpsSummaryInput) (*GetOpsSummaryOutput, error) {
	req, out := c.GetOpsSummaryRequest(input)
	return out, req.Send()
}

// GetOpsSummaryWithContext is the same as GetOpsSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetOpsSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetOpsSummaryWithContext(ctx aws.Context, input *GetOpsSummaryInput, opts ...request.Option) (*GetOpsSummaryOutput, error) {
	req, out := c.GetOpsSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetOpsSummaryPages iterates over the pages of a GetOpsSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetOpsSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetOpsSummary operation.
//	pageNum := 0
//	err := client.GetOpsSummaryPages(params,
//	    func(page *ssm.GetOpsSummaryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) GetOpsSummaryPages(input *GetOpsSummaryInput, fn func(*GetOpsSummaryOutput, bool) bool) error {
	return c.GetOpsSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetOpsSummaryPagesWithContext same as GetOpsSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetOpsSummaryPagesWithContext(ctx aws.Context, input *GetOpsSummaryInput, fn func(*GetOpsSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetOpsSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetOpsSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetOpsSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetParameter = "GetParameter"

// GetParameterRequest generates a "aws/request.Request" representing the
// client's request for the GetParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParameter for more information on using the GetParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParameterRequest method.
//	req, resp := client.GetParameterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter
func (c *SSM) GetParameterRequest(input *GetParameterInput) (req *request.Request, output *GetParameterOutput) {
	op := &request.Operation{
		Name:       opGetParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParameterInput{}
	}

	output = &GetParameterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParameter API operation for Amazon Simple Systems Management Service.
//
// Get information about a single parameter by specifying the parameter name.
//
// To get information about more than one parameter at a time, use the GetParameters
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetParameter for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidKeyId
//     The query key ID isn't valid.
//
//   - ParameterNotFound
//     The parameter couldn't be found. Verify the name and try again.
//
//   - ParameterVersionNotFound
//     The specified parameter version wasn't found. Verify the parameter name and
//     version, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter
func (c *SSM) GetParameter(input *GetParameterInput) (*GetParameterOutput, error) {
	req, out := c.GetParameterRequest(input)
	return out, req.Send()
}

// GetParameterWithContext is the same as GetParameter with the addition of
// the ability to pass a context and additional request options.
//
// See GetParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParameterWithContext(ctx aws.Context, input *GetParameterInput, opts ...request.Option) (*GetParameterOutput, error) {
	req, out := c.GetParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParameterHistory = "GetParameterHistory"

// GetParameterHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetParameterHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParameterHistory for more information on using the GetParameterHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParameterHistoryRequest method.
//	req, resp := client.GetParameterHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory
func (c *SSM) GetParameterHistoryRequest(input *GetParameterHistoryInput) (req *request.Request, output *GetParameterHistoryOutput) {
	op := &request.Operation{
		Name:       opGetParameterHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetParameterHistoryInput{}
	}

	output = &GetParameterHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParameterHistory API operation for Amazon Simple Systems Management Service.
//
// Retrieves the history of all changes to a parameter.
//
// If you change the KMS key alias for the KMS key used to encrypt a parameter,
// then you must also update the key alias the parameter uses to reference KMS.
// Otherwise, GetParameterHistory retrieves whatever the original key alias
// was referencing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetParameterHistory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ParameterNotFound
//     The parameter couldn't be found. Verify the name and try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidKeyId
//     The query key ID isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory
func (c *SSM) GetParameterHistory(input *GetParameterHistoryInput) (*GetParameterHistoryOutput, error) {
	req, out := c.GetParameterHistoryRequest(input)
	return out, req.Send()
}

// GetParameterHistoryWithContext is the same as GetParameterHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetParameterHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParameterHistoryWithContext(ctx aws.Context, input *GetParameterHistoryInput, opts ...request.Option) (*GetParameterHistoryOutput, error) {
	req, out := c.GetParameterHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetParameterHistoryPages iterates over the pages of a GetParameterHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetParameterHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetParameterHistory operation.
//	pageNum := 0
//	err := client.GetParameterHistoryPages(params,
//	    func(page *ssm.GetParameterHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) GetParameterHistoryPages(input *GetParameterHistoryInput, fn func(*GetParameterHistoryOutput, bool) bool) error {
	return c.GetParameterHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetParameterHistoryPagesWithContext same as GetParameterHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParameterHistoryPagesWithContext(ctx aws.Context, input *GetParameterHistoryInput, fn func(*GetParameterHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetParameterHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetParameterHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetParameterHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetParameterMetadataInternal = "GetParameterMetadataInternal"

// GetParameterMetadataInternalRequest generates a "aws/request.Request" representing the
// client's request for the GetParameterMetadataInternal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParameterMetadataInternal for more information on using the GetParameterMetadataInternal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParameterMetadataInternalRequest method.
//	req, resp := client.GetParameterMetadataInternalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterMetadataInternal
func (c *SSM) GetParameterMetadataInternalRequest(input *GetParameterMetadataInternalInput) (req *request.Request, output *GetParameterMetadataInternalOutput) {
	op := &request.Operation{
		Name:       opGetParameterMetadataInternal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParameterMetadataInternalInput{}
	}

	output = &GetParameterMetadataInternalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParameterMetadataInternal API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetParameterMetadataInternal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ParameterNotFound
//     The parameter couldn't be found. Verify the name and try again.
//
//   - OpsMetadataNotFoundException
//     The OpsMetadata object doesn't exist.
//
//   - OpsMetadataInvalidArgumentException
//     One of the arguments passed is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterMetadataInternal
func (c *SSM) GetParameterMetadataInternal(input *GetParameterMetadataInternalInput) (*GetParameterMetadataInternalOutput, error) {
	req, out := c.GetParameterMetadataInternalRequest(input)
	return out, req.Send()
}

// GetParameterMetadataInternalWithContext is the same as GetParameterMetadataInternal with the addition of
// the ability to pass a context and additional request options.
//
// See GetParameterMetadataInternal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParameterMetadataInternalWithContext(ctx aws.Context, input *GetParameterMetadataInternalInput, opts ...request.Option) (*GetParameterMetadataInternalOutput, error) {
	req, out := c.GetParameterMetadataInternalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParameters = "GetParameters"

// GetParametersRequest generates a "aws/request.Request" representing the
// client's request for the GetParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParameters for more information on using the GetParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParametersRequest method.
//	req, resp := client.GetParametersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters
func (c *SSM) GetParametersRequest(input *GetParametersInput) (req *request.Request, output *GetParametersOutput) {
	op := &request.Operation{
		Name:       opGetParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParametersInput{}
	}

	output = &GetParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParameters API operation for Amazon Simple Systems Management Service.
//
// Get information about one or more parameters by specifying multiple parameter
// names.
//
// To get information about a single parameter, you can use the GetParameter
// operation instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetParameters for usage and error information.
//
// Returned Error Types:
//
//   - InvalidKeyId
//     The query key ID isn't valid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters
func (c *SSM) GetParameters(input *GetParametersInput) (*GetParametersOutput, error) {
	req, out := c.GetParametersRequest(input)
	return out, req.Send()
}

// GetParametersWithContext is the same as GetParameters with the addition of
// the ability to pass a context and additional request options.
//
// See GetParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParametersWithContext(ctx aws.Context, input *GetParametersInput, opts ...request.Option) (*GetParametersOutput, error) {
	req, out := c.GetParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParametersByPath = "GetParametersByPath"

// GetParametersByPathRequest generates a "aws/request.Request" representing the
// client's request for the GetParametersByPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParametersByPath for more information on using the GetParametersByPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetParametersByPathRequest method.
//	req, resp := client.GetParametersByPathRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath
func (c *SSM) GetParametersByPathRequest(input *GetParametersByPathInput) (req *request.Request, output *GetParametersByPathOutput) {
	op := &request.Operation{
		Name:       opGetParametersByPath,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetParametersByPathInput{}
	}

	output = &GetParametersByPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParametersByPath API operation for Amazon Simple Systems Management Service.
//
// Retrieve information about one or more parameters under a specified level
// in a hierarchy.
//
// Request results are returned on a best-effort basis. If you specify MaxResults
// in the request, the response includes information up to the limit specified.
// The number of items returned, however, can be between zero and the value
// of MaxResults. If the service reaches an internal limit while processing
// the results, it stops the operation and returns the matching values up to
// that point and a NextToken. You can specify the NextToken in a subsequent
// call to get the next set of results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetParametersByPath for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidFilterOption
//     The specified filter option isn't valid. Valid options are Equals and BeginsWith.
//     For Path filter, valid options are Recursive and OneLevel.
//
//   - InvalidFilterValue
//     The filter value isn't valid. Verify the value and try again.
//
//   - InvalidKeyId
//     The query key ID isn't valid.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath
func (c *SSM) GetParametersByPath(input *GetParametersByPathInput) (*GetParametersByPathOutput, error) {
	req, out := c.GetParametersByPathRequest(input)
	return out, req.Send()
}

// GetParametersByPathWithContext is the same as GetParametersByPath with the addition of
// the ability to pass a context and additional request options.
//
// See GetParametersByPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParametersByPathWithContext(ctx aws.Context, input *GetParametersByPathInput, opts ...request.Option) (*GetParametersByPathOutput, error) {
	req, out := c.GetParametersByPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetParametersByPathPages iterates over the pages of a GetParametersByPath operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetParametersByPath method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetParametersByPath operation.
//	pageNum := 0
//	err := client.GetParametersByPathPages(params,
//	    func(page *ssm.GetParametersByPathOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) GetParametersByPathPages(input *GetParametersByPathInput, fn func(*GetParametersByPathOutput, bool) bool) error {
	return c.GetParametersByPathPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetParametersByPathPagesWithContext same as GetParametersByPathPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParametersByPathPagesWithContext(ctx aws.Context, input *GetParametersByPathInput, fn func(*GetParametersByPathOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetParametersByPathInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetParametersByPathRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetParametersByPathOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetPatchBaseline = "GetPatchBaseline"

// GetPatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the GetPatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPatchBaseline for more information on using the GetPatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPatchBaselineRequest method.
//	req, resp := client.GetPatchBaselineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline
func (c *SSM) GetPatchBaselineRequest(input *GetPatchBaselineInput) (req *request.Request, output *GetPatchBaselineOutput) {
	op := &request.Operation{
		Name:       opGetPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPatchBaselineInput{}
	}

	output = &GetPatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPatchBaseline API operation for Amazon Simple Systems Management Service.
//
// Retrieves information about a patch baseline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetPatchBaseline for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline
func (c *SSM) GetPatchBaseline(input *GetPatchBaselineInput) (*GetPatchBaselineOutput, error) {
	req, out := c.GetPatchBaselineRequest(input)
	return out, req.Send()
}

// GetPatchBaselineWithContext is the same as GetPatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See GetPatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetPatchBaselineWithContext(ctx aws.Context, input *GetPatchBaselineInput, opts ...request.Option) (*GetPatchBaselineOutput, error) {
	req, out := c.GetPatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPatchBaselineForPatchGroup = "GetPatchBaselineForPatchGroup"

// GetPatchBaselineForPatchGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetPatchBaselineForPatchGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPatchBaselineForPatchGroup for more information on using the GetPatchBaselineForPatchGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPatchBaselineForPatchGroupRequest method.
//	req, resp := client.GetPatchBaselineForPatchGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup
func (c *SSM) GetPatchBaselineForPatchGroupRequest(input *GetPatchBaselineForPatchGroupInput) (req *request.Request, output *GetPatchBaselineForPatchGroupOutput) {
	op := &request.Operation{
		Name:       opGetPatchBaselineForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPatchBaselineForPatchGroupInput{}
	}

	output = &GetPatchBaselineForPatchGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPatchBaselineForPatchGroup API operation for Amazon Simple Systems Management Service.
//
// Retrieves the patch baseline that should be used for the specified patch
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetPatchBaselineForPatchGroup for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup
func (c *SSM) GetPatchBaselineForPatchGroup(input *GetPatchBaselineForPatchGroupInput) (*GetPatchBaselineForPatchGroupOutput, error) {
	req, out := c.GetPatchBaselineForPatchGroupRequest(input)
	return out, req.Send()
}

// GetPatchBaselineForPatchGroupWithContext is the same as GetPatchBaselineForPatchGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetPatchBaselineForPatchGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetPatchBaselineForPatchGroupWithContext(ctx aws.Context, input *GetPatchBaselineForPatchGroupInput, opts ...request.Option) (*GetPatchBaselineForPatchGroupOutput, error) {
	req, out := c.GetPatchBaselineForPatchGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicies = "GetResourcePolicies"

// GetResourcePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicies for more information on using the GetResourcePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePoliciesRequest method.
//	req, resp := client.GetResourcePoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetResourcePolicies
func (c *SSM) GetResourcePoliciesRequest(input *GetResourcePoliciesInput) (req *request.Request, output *GetResourcePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcePoliciesInput{}
	}

	output = &GetResourcePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicies API operation for Amazon Simple Systems Management Service.
//
// # Fetches resource policies associated with a SSM resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetResourcePolicies for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourcePolicyInvalidParameterException
//     One or more parameters specified for the call aren't valid. Verify the parameters
//     and their values and try again.
//
//   - ResourceNotFoundException
//     The specified parameter to be shared could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetResourcePolicies
func (c *SSM) GetResourcePolicies(input *GetResourcePoliciesInput) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	return out, req.Send()
}

// GetResourcePoliciesWithContext is the same as GetResourcePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetResourcePoliciesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, opts ...request.Option) (*GetResourcePoliciesOutput, error) {
	req, out := c.GetResourcePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourcePoliciesPages iterates over the pages of a GetResourcePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourcePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetResourcePolicies operation.
//	pageNum := 0
//	err := client.GetResourcePoliciesPages(params,
//	    func(page *ssm.GetResourcePoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) GetResourcePoliciesPages(input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool) error {
	return c.GetResourcePoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourcePoliciesPagesWithContext same as GetResourcePoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetResourcePoliciesPagesWithContext(ctx aws.Context, input *GetResourcePoliciesInput, fn func(*GetResourcePoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourcePoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourcePoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourcePoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetResourcePolicyInternal = "GetResourcePolicyInternal"

// GetResourcePolicyInternalRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicyInternal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicyInternal for more information on using the GetResourcePolicyInternal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePolicyInternalRequest method.
//	req, resp := client.GetResourcePolicyInternalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetResourcePolicyInternal
func (c *SSM) GetResourcePolicyInternalRequest(input *GetResourcePolicyInternalInput) (req *request.Request, output *GetResourcePolicyInternalOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicyInternal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourcePolicyInternalInput{}
	}

	output = &GetResourcePolicyInternalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicyInternal API operation for Amazon Simple Systems Management Service.
//
// # Internal API to get the resource policy on a resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetResourcePolicyInternal for usage and error information.
//
// Returned Error Types:
//
//   - RAMInvalidParameterException
//     RAM call contains invalid parameter
//
//   - RAMResourceNotFoundException
//     ROS cannot find a resource with the given resource ARN
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetResourcePolicyInternal
func (c *SSM) GetResourcePolicyInternal(input *GetResourcePolicyInternalInput) (*GetResourcePolicyInternalOutput, error) {
	req, out := c.GetResourcePolicyInternalRequest(input)
	return out, req.Send()
}

// GetResourcePolicyInternalWithContext is the same as GetResourcePolicyInternal with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicyInternal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetResourcePolicyInternalWithContext(ctx aws.Context, input *GetResourcePolicyInternalInput, opts ...request.Option) (*GetResourcePolicyInternalOutput, error) {
	req, out := c.GetResourcePolicyInternalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceSetting = "GetServiceSetting"

// GetServiceSettingRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceSetting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceSetting for more information on using the GetServiceSetting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceSettingRequest method.
//	req, resp := client.GetServiceSettingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting
func (c *SSM) GetServiceSettingRequest(input *GetServiceSettingInput) (req *request.Request, output *GetServiceSettingOutput) {
	op := &request.Operation{
		Name:       opGetServiceSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceSettingInput{}
	}

	output = &GetServiceSettingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceSetting API operation for Amazon Simple Systems Management Service.
//
// ServiceSetting is an account-level setting for an Amazon Web Services service.
// This setting defines how a user interacts with or uses a service or a feature
// of a service. For example, if an Amazon Web Services service charges money
// to the account based on feature or service usage, then the Amazon Web Services
// service team might create a default setting of false. This means the user
// can't use this feature unless they change the setting to true and intentionally
// opt in for a paid feature.
//
// Services map a SettingId object to a setting value. Amazon Web Services services
// teams define the default value for a SettingId. You can't create a new SettingId,
// but you can overwrite the default value if you have the ssm:UpdateServiceSetting
// permission for the setting. Use the UpdateServiceSetting API operation to
// change the default setting. Or use the ResetServiceSetting to change the
// value back to the original value defined by the Amazon Web Services service
// team.
//
// Query the current service setting for the Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetServiceSetting for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ServiceSettingNotFound
//     The specified service setting wasn't found. Either the service name or the
//     setting hasn't been provisioned by the Amazon Web Services service team.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting
func (c *SSM) GetServiceSetting(input *GetServiceSettingInput) (*GetServiceSettingOutput, error) {
	req, out := c.GetServiceSettingRequest(input)
	return out, req.Send()
}

// GetServiceSettingWithContext is the same as GetServiceSetting with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceSetting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetServiceSettingWithContext(ctx aws.Context, input *GetServiceSettingInput, opts ...request.Option) (*GetServiceSettingOutput, error) {
	req, out := c.GetServiceSettingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceSettingInternal = "GetServiceSettingInternal"

// GetServiceSettingInternalRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceSettingInternal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceSettingInternal for more information on using the GetServiceSettingInternal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceSettingInternalRequest method.
//	req, resp := client.GetServiceSettingInternalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSettingInternal
func (c *SSM) GetServiceSettingInternalRequest(input *GetServiceSettingInternalInput) (req *request.Request, output *GetServiceSettingInternalOutput) {
	op := &request.Operation{
		Name:       opGetServiceSettingInternal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceSettingInternalInput{}
	}

	output = &GetServiceSettingInternalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceSettingInternal API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetServiceSettingInternal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ServiceSettingNotFound
//     The specified service setting wasn't found. Either the service name or the
//     setting hasn't been provisioned by the Amazon Web Services service team.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSettingInternal
func (c *SSM) GetServiceSettingInternal(input *GetServiceSettingInternalInput) (*GetServiceSettingInternalOutput, error) {
	req, out := c.GetServiceSettingInternalRequest(input)
	return out, req.Send()
}

// GetServiceSettingInternalWithContext is the same as GetServiceSettingInternal with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceSettingInternal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetServiceSettingInternalWithContext(ctx aws.Context, input *GetServiceSettingInternalInput, opts ...request.Option) (*GetServiceSettingInternalOutput, error) {
	req, out := c.GetServiceSettingInternalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLabelParameterVersion = "LabelParameterVersion"

// LabelParameterVersionRequest generates a "aws/request.Request" representing the
// client's request for the LabelParameterVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LabelParameterVersion for more information on using the LabelParameterVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the LabelParameterVersionRequest method.
//	req, resp := client.LabelParameterVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion
func (c *SSM) LabelParameterVersionRequest(input *LabelParameterVersionInput) (req *request.Request, output *LabelParameterVersionOutput) {
	op := &request.Operation{
		Name:       opLabelParameterVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LabelParameterVersionInput{}
	}

	output = &LabelParameterVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LabelParameterVersion API operation for Amazon Simple Systems Management Service.
//
// A parameter label is a user-defined alias to help you manage different versions
// of a parameter. When you modify a parameter, Amazon Web Services Systems
// Manager automatically saves a new version and increments the version number
// by one. A label can help you remember the purpose of a parameter when there
// are multiple versions.
//
// Parameter labels have the following requirements and restrictions.
//
//   - A version of a parameter can have a maximum of 10 labels.
//
//   - You can't attach the same label to different versions of the same parameter.
//     For example, if version 1 has the label Production, then you can't attach
//     Production to version 2.
//
//   - You can move a label from one version of a parameter to another.
//
//   - You can't create a label when you create a new parameter. You must attach
//     a label to a specific version of a parameter.
//
//   - If you no longer want to use a parameter label, then you can either
//     delete it or move it to a different version of a parameter.
//
//   - A label can have a maximum of 100 characters.
//
//   - Labels can contain letters (case sensitive), numbers, periods (.), hyphens
//     (-), or underscores (_).
//
//   - Labels can't begin with a number, "aws" or "ssm" (not case sensitive).
//     If a label fails to meet these requirements, then the label isn't associated
//     with a parameter and the system displays it in the list of InvalidLabels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation LabelParameterVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
//   - ParameterNotFound
//     The parameter couldn't be found. Verify the name and try again.
//
//   - ParameterVersionNotFound
//     The specified parameter version wasn't found. Verify the parameter name and
//     version, and try again.
//
//   - ParameterVersionLabelLimitExceeded
//     A parameter version can have a maximum of ten labels.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion
func (c *SSM) LabelParameterVersion(input *LabelParameterVersionInput) (*LabelParameterVersionOutput, error) {
	req, out := c.LabelParameterVersionRequest(input)
	return out, req.Send()
}

// LabelParameterVersionWithContext is the same as LabelParameterVersion with the addition of
// the ability to pass a context and additional request options.
//
// See LabelParameterVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) LabelParameterVersionWithContext(ctx aws.Context, input *LabelParameterVersionInput, opts ...request.Option) (*LabelParameterVersionOutput, error) {
	req, out := c.LabelParameterVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociationVersions = "ListAssociationVersions"

// ListAssociationVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociationVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociationVersions for more information on using the ListAssociationVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAssociationVersionsRequest method.
//	req, resp := client.ListAssociationVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions
func (c *SSM) ListAssociationVersionsRequest(input *ListAssociationVersionsInput) (req *request.Request, output *ListAssociationVersionsOutput) {
	op := &request.Operation{
		Name:       opListAssociationVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociationVersionsInput{}
	}

	output = &ListAssociationVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociationVersions API operation for Amazon Simple Systems Management Service.
//
// Retrieves all versions of an association for a specific association ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListAssociationVersions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions
func (c *SSM) ListAssociationVersions(input *ListAssociationVersionsInput) (*ListAssociationVersionsOutput, error) {
	req, out := c.ListAssociationVersionsRequest(input)
	return out, req.Send()
}

// ListAssociationVersionsWithContext is the same as ListAssociationVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociationVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListAssociationVersionsWithContext(ctx aws.Context, input *ListAssociationVersionsInput, opts ...request.Option) (*ListAssociationVersionsOutput, error) {
	req, out := c.ListAssociationVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociationVersionsPages iterates over the pages of a ListAssociationVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociationVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAssociationVersions operation.
//	pageNum := 0
//	err := client.ListAssociationVersionsPages(params,
//	    func(page *ssm.ListAssociationVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListAssociationVersionsPages(input *ListAssociationVersionsInput, fn func(*ListAssociationVersionsOutput, bool) bool) error {
	return c.ListAssociationVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociationVersionsPagesWithContext same as ListAssociationVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListAssociationVersionsPagesWithContext(ctx aws.Context, input *ListAssociationVersionsInput, fn func(*ListAssociationVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociationVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociationVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociationVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssociations = "ListAssociations"

// ListAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociations for more information on using the ListAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAssociationsRequest method.
//	req, resp := client.ListAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations
func (c *SSM) ListAssociationsRequest(input *ListAssociationsInput) (req *request.Request, output *ListAssociationsOutput) {
	op := &request.Operation{
		Name:       opListAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociationsInput{}
	}

	output = &ListAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociations API operation for Amazon Simple Systems Management Service.
//
// Returns all State Manager associations in the current Amazon Web Services
// account and Amazon Web Services Region. You can limit the results to a specific
// State Manager association document or managed node by specifying a filter.
// State Manager is a capability of Amazon Web Services Systems Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations
func (c *SSM) ListAssociations(input *ListAssociationsInput) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	return out, req.Send()
}

// ListAssociationsWithContext is the same as ListAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListAssociationsWithContext(ctx aws.Context, input *ListAssociationsInput, opts ...request.Option) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociationsPages iterates over the pages of a ListAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAssociations operation.
//	pageNum := 0
//	err := client.ListAssociationsPages(params,
//	    func(page *ssm.ListAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListAssociationsPages(input *ListAssociationsInput, fn func(*ListAssociationsOutput, bool) bool) error {
	return c.ListAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociationsPagesWithContext same as ListAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListAssociationsPagesWithContext(ctx aws.Context, input *ListAssociationsInput, fn func(*ListAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCalendarEvents = "ListCalendarEvents"

// ListCalendarEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListCalendarEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCalendarEvents for more information on using the ListCalendarEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCalendarEventsRequest method.
//	req, resp := client.ListCalendarEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCalendarEvents
func (c *SSM) ListCalendarEventsRequest(input *ListCalendarEventsInput) (req *request.Request, output *ListCalendarEventsOutput) {
	op := &request.Operation{
		Name:       opListCalendarEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCalendarEventsInput{}
	}

	output = &ListCalendarEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCalendarEvents API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListCalendarEvents for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentType
//     The SSM document type isn't valid. Valid document types are described in
//     the DocumentType property.
//
//   - UnsupportedCalendarException
//     The calendar entry contained in the specified SSM document isn't supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCalendarEvents
func (c *SSM) ListCalendarEvents(input *ListCalendarEventsInput) (*ListCalendarEventsOutput, error) {
	req, out := c.ListCalendarEventsRequest(input)
	return out, req.Send()
}

// ListCalendarEventsWithContext is the same as ListCalendarEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListCalendarEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCalendarEventsWithContext(ctx aws.Context, input *ListCalendarEventsInput, opts ...request.Option) (*ListCalendarEventsOutput, error) {
	req, out := c.ListCalendarEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCommandInvocations = "ListCommandInvocations"

// ListCommandInvocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCommandInvocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCommandInvocations for more information on using the ListCommandInvocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCommandInvocationsRequest method.
//	req, resp := client.ListCommandInvocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations
func (c *SSM) ListCommandInvocationsRequest(input *ListCommandInvocationsInput) (req *request.Request, output *ListCommandInvocationsOutput) {
	op := &request.Operation{
		Name:       opListCommandInvocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandInvocationsInput{}
	}

	output = &ListCommandInvocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCommandInvocations API operation for Amazon Simple Systems Management Service.
//
// An invocation is copy of a command sent to a specific managed node. A command
// can apply to one or more managed nodes. A command invocation applies to one
// managed node. For example, if a user runs SendCommand against three managed
// nodes, then a command invocation is created for each requested managed node
// ID. ListCommandInvocations provide status about command execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListCommandInvocations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidCommandId
//     The specified command ID isn't valid. Verify the ID and try again.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations
func (c *SSM) ListCommandInvocations(input *ListCommandInvocationsInput) (*ListCommandInvocationsOutput, error) {
	req, out := c.ListCommandInvocationsRequest(input)
	return out, req.Send()
}

// ListCommandInvocationsWithContext is the same as ListCommandInvocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListCommandInvocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCommandInvocationsWithContext(ctx aws.Context, input *ListCommandInvocationsInput, opts ...request.Option) (*ListCommandInvocationsOutput, error) {
	req, out := c.ListCommandInvocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCommandInvocationsPages iterates over the pages of a ListCommandInvocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCommandInvocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCommandInvocations operation.
//	pageNum := 0
//	err := client.ListCommandInvocationsPages(params,
//	    func(page *ssm.ListCommandInvocationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListCommandInvocationsPages(input *ListCommandInvocationsInput, fn func(*ListCommandInvocationsOutput, bool) bool) error {
	return c.ListCommandInvocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCommandInvocationsPagesWithContext same as ListCommandInvocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCommandInvocationsPagesWithContext(ctx aws.Context, input *ListCommandInvocationsInput, fn func(*ListCommandInvocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCommandInvocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCommandInvocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCommandInvocationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCommands = "ListCommands"

// ListCommandsRequest generates a "aws/request.Request" representing the
// client's request for the ListCommands operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCommands for more information on using the ListCommands
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCommandsRequest method.
//	req, resp := client.ListCommandsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands
func (c *SSM) ListCommandsRequest(input *ListCommandsInput) (req *request.Request, output *ListCommandsOutput) {
	op := &request.Operation{
		Name:       opListCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandsInput{}
	}

	output = &ListCommandsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCommands API operation for Amazon Simple Systems Management Service.
//
// Lists the commands requested by users of the Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListCommands for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidCommandId
//     The specified command ID isn't valid. Verify the ID and try again.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands
func (c *SSM) ListCommands(input *ListCommandsInput) (*ListCommandsOutput, error) {
	req, out := c.ListCommandsRequest(input)
	return out, req.Send()
}

// ListCommandsWithContext is the same as ListCommands with the addition of
// the ability to pass a context and additional request options.
//
// See ListCommands for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCommandsWithContext(ctx aws.Context, input *ListCommandsInput, opts ...request.Option) (*ListCommandsOutput, error) {
	req, out := c.ListCommandsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCommandsPages iterates over the pages of a ListCommands operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCommands method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCommands operation.
//	pageNum := 0
//	err := client.ListCommandsPages(params,
//	    func(page *ssm.ListCommandsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListCommandsPages(input *ListCommandsInput, fn func(*ListCommandsOutput, bool) bool) error {
	return c.ListCommandsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCommandsPagesWithContext same as ListCommandsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCommandsPagesWithContext(ctx aws.Context, input *ListCommandsInput, fn func(*ListCommandsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCommandsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCommandsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCommandsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComplianceItems = "ListComplianceItems"

// ListComplianceItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListComplianceItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComplianceItems for more information on using the ListComplianceItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComplianceItemsRequest method.
//	req, resp := client.ListComplianceItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems
func (c *SSM) ListComplianceItemsRequest(input *ListComplianceItemsInput) (req *request.Request, output *ListComplianceItemsOutput) {
	op := &request.Operation{
		Name:       opListComplianceItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComplianceItemsInput{}
	}

	output = &ListComplianceItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComplianceItems API operation for Amazon Simple Systems Management Service.
//
// For a specified resource ID, this API operation returns a list of compliance
// statuses for different resource types. Currently, you can only specify one
// resource ID per call. List results depend on the criteria specified in the
// filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListComplianceItems for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceType
//     The resource type isn't valid. For example, if you are attempting to tag
//     an EC2 instance, the instance must be a registered managed node.
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems
func (c *SSM) ListComplianceItems(input *ListComplianceItemsInput) (*ListComplianceItemsOutput, error) {
	req, out := c.ListComplianceItemsRequest(input)
	return out, req.Send()
}

// ListComplianceItemsWithContext is the same as ListComplianceItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListComplianceItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListComplianceItemsWithContext(ctx aws.Context, input *ListComplianceItemsInput, opts ...request.Option) (*ListComplianceItemsOutput, error) {
	req, out := c.ListComplianceItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComplianceItemsPages iterates over the pages of a ListComplianceItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComplianceItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComplianceItems operation.
//	pageNum := 0
//	err := client.ListComplianceItemsPages(params,
//	    func(page *ssm.ListComplianceItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListComplianceItemsPages(input *ListComplianceItemsInput, fn func(*ListComplianceItemsOutput, bool) bool) error {
	return c.ListComplianceItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComplianceItemsPagesWithContext same as ListComplianceItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListComplianceItemsPagesWithContext(ctx aws.Context, input *ListComplianceItemsInput, fn func(*ListComplianceItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComplianceItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComplianceItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComplianceItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComplianceSummaries = "ListComplianceSummaries"

// ListComplianceSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListComplianceSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComplianceSummaries for more information on using the ListComplianceSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComplianceSummariesRequest method.
//	req, resp := client.ListComplianceSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries
func (c *SSM) ListComplianceSummariesRequest(input *ListComplianceSummariesInput) (req *request.Request, output *ListComplianceSummariesOutput) {
	op := &request.Operation{
		Name:       opListComplianceSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComplianceSummariesInput{}
	}

	output = &ListComplianceSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComplianceSummaries API operation for Amazon Simple Systems Management Service.
//
// Returns a summary count of compliant and non-compliant resources for a compliance
// type. For example, this call can return State Manager associations, patches,
// or custom compliance types according to the filter criteria that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListComplianceSummaries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries
func (c *SSM) ListComplianceSummaries(input *ListComplianceSummariesInput) (*ListComplianceSummariesOutput, error) {
	req, out := c.ListComplianceSummariesRequest(input)
	return out, req.Send()
}

// ListComplianceSummariesWithContext is the same as ListComplianceSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListComplianceSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListComplianceSummariesWithContext(ctx aws.Context, input *ListComplianceSummariesInput, opts ...request.Option) (*ListComplianceSummariesOutput, error) {
	req, out := c.ListComplianceSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComplianceSummariesPages iterates over the pages of a ListComplianceSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComplianceSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComplianceSummaries operation.
//	pageNum := 0
//	err := client.ListComplianceSummariesPages(params,
//	    func(page *ssm.ListComplianceSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListComplianceSummariesPages(input *ListComplianceSummariesInput, fn func(*ListComplianceSummariesOutput, bool) bool) error {
	return c.ListComplianceSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComplianceSummariesPagesWithContext same as ListComplianceSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListComplianceSummariesPagesWithContext(ctx aws.Context, input *ListComplianceSummariesInput, fn func(*ListComplianceSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComplianceSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComplianceSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComplianceSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConsumerAccounts = "ListConsumerAccounts"

// ListConsumerAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListConsumerAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConsumerAccounts for more information on using the ListConsumerAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConsumerAccountsRequest method.
//	req, resp := client.ListConsumerAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListConsumerAccounts
func (c *SSM) ListConsumerAccountsRequest(input *ListConsumerAccountsInput) (req *request.Request, output *ListConsumerAccountsOutput) {
	op := &request.Operation{
		Name:       opListConsumerAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListConsumerAccountsInput{}
	}

	output = &ListConsumerAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConsumerAccounts API operation for Amazon Simple Systems Management Service.
//
// Returns a paginated list of all consumer accounts which has shared resources.
// This API is used for reconcile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListConsumerAccounts for usage and error information.
//
// Returned Error Types:
//   - RAMInvalidParameterException
//     RAM call contains invalid parameter
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListConsumerAccounts
func (c *SSM) ListConsumerAccounts(input *ListConsumerAccountsInput) (*ListConsumerAccountsOutput, error) {
	req, out := c.ListConsumerAccountsRequest(input)
	return out, req.Send()
}

// ListConsumerAccountsWithContext is the same as ListConsumerAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListConsumerAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListConsumerAccountsWithContext(ctx aws.Context, input *ListConsumerAccountsInput, opts ...request.Option) (*ListConsumerAccountsOutput, error) {
	req, out := c.ListConsumerAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDocumentMetadataHistory = "ListDocumentMetadataHistory"

// ListDocumentMetadataHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListDocumentMetadataHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocumentMetadataHistory for more information on using the ListDocumentMetadataHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDocumentMetadataHistoryRequest method.
//	req, resp := client.ListDocumentMetadataHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory
func (c *SSM) ListDocumentMetadataHistoryRequest(input *ListDocumentMetadataHistoryInput) (req *request.Request, output *ListDocumentMetadataHistoryOutput) {
	op := &request.Operation{
		Name:       opListDocumentMetadataHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDocumentMetadataHistoryInput{}
	}

	output = &ListDocumentMetadataHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocumentMetadataHistory API operation for Amazon Simple Systems Management Service.
//
// Information about approval reviews for a version of a change template in
// Change Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListDocumentMetadataHistory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory
func (c *SSM) ListDocumentMetadataHistory(input *ListDocumentMetadataHistoryInput) (*ListDocumentMetadataHistoryOutput, error) {
	req, out := c.ListDocumentMetadataHistoryRequest(input)
	return out, req.Send()
}

// ListDocumentMetadataHistoryWithContext is the same as ListDocumentMetadataHistory with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocumentMetadataHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListDocumentMetadataHistoryWithContext(ctx aws.Context, input *ListDocumentMetadataHistoryInput, opts ...request.Option) (*ListDocumentMetadataHistoryOutput, error) {
	req, out := c.ListDocumentMetadataHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDocumentVersions = "ListDocumentVersions"

// ListDocumentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDocumentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocumentVersions for more information on using the ListDocumentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDocumentVersionsRequest method.
//	req, resp := client.ListDocumentVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions
func (c *SSM) ListDocumentVersionsRequest(input *ListDocumentVersionsInput) (req *request.Request, output *ListDocumentVersionsOutput) {
	op := &request.Operation{
		Name:       opListDocumentVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentVersionsInput{}
	}

	output = &ListDocumentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocumentVersions API operation for Amazon Simple Systems Management Service.
//
// List all versions for a document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListDocumentVersions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions
func (c *SSM) ListDocumentVersions(input *ListDocumentVersionsInput) (*ListDocumentVersionsOutput, error) {
	req, out := c.ListDocumentVersionsRequest(input)
	return out, req.Send()
}

// ListDocumentVersionsWithContext is the same as ListDocumentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocumentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListDocumentVersionsWithContext(ctx aws.Context, input *ListDocumentVersionsInput, opts ...request.Option) (*ListDocumentVersionsOutput, error) {
	req, out := c.ListDocumentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentVersionsPages iterates over the pages of a ListDocumentVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocumentVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDocumentVersions operation.
//	pageNum := 0
//	err := client.ListDocumentVersionsPages(params,
//	    func(page *ssm.ListDocumentVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListDocumentVersionsPages(input *ListDocumentVersionsInput, fn func(*ListDocumentVersionsOutput, bool) bool) error {
	return c.ListDocumentVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentVersionsPagesWithContext same as ListDocumentVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListDocumentVersionsPagesWithContext(ctx aws.Context, input *ListDocumentVersionsInput, fn func(*ListDocumentVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDocumentVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDocuments = "ListDocuments"

// ListDocumentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDocuments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocuments for more information on using the ListDocuments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDocumentsRequest method.
//	req, resp := client.ListDocumentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments
func (c *SSM) ListDocumentsRequest(input *ListDocumentsInput) (req *request.Request, output *ListDocumentsOutput) {
	op := &request.Operation{
		Name:       opListDocuments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentsInput{}
	}

	output = &ListDocumentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocuments API operation for Amazon Simple Systems Management Service.
//
// Returns all Systems Manager (SSM) documents in the current Amazon Web Services
// account and Amazon Web Services Region. You can limit the results of this
// request by using a filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListDocuments for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidFilterKey
//     The specified key isn't valid.
//
//   - InvalidDocumentOperation
//     You attempted to delete a document while it is still shared. You must stop
//     sharing the document before you can delete it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments
func (c *SSM) ListDocuments(input *ListDocumentsInput) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	return out, req.Send()
}

// ListDocumentsWithContext is the same as ListDocuments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocuments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListDocumentsWithContext(ctx aws.Context, input *ListDocumentsInput, opts ...request.Option) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentsPages iterates over the pages of a ListDocuments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocuments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDocuments operation.
//	pageNum := 0
//	err := client.ListDocumentsPages(params,
//	    func(page *ssm.ListDocumentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListDocumentsPages(input *ListDocumentsInput, fn func(*ListDocumentsOutput, bool) bool) error {
	return c.ListDocumentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentsPagesWithContext same as ListDocumentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListDocumentsPagesWithContext(ctx aws.Context, input *ListDocumentsInput, fn func(*ListDocumentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDocumentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstanceAssociations = "ListInstanceAssociations"

// ListInstanceAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstanceAssociations for more information on using the ListInstanceAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInstanceAssociationsRequest method.
//	req, resp := client.ListInstanceAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInstanceAssociations
func (c *SSM) ListInstanceAssociationsRequest(input *ListInstanceAssociationsInput) (req *request.Request, output *ListInstanceAssociationsOutput) {
	op := &request.Operation{
		Name:       opListInstanceAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListInstanceAssociationsInput{}
	}

	output = &ListInstanceAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceAssociations API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListInstanceAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInstanceAssociations
func (c *SSM) ListInstanceAssociations(input *ListInstanceAssociationsInput) (*ListInstanceAssociationsOutput, error) {
	req, out := c.ListInstanceAssociationsRequest(input)
	return out, req.Send()
}

// ListInstanceAssociationsWithContext is the same as ListInstanceAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstanceAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListInstanceAssociationsWithContext(ctx aws.Context, input *ListInstanceAssociationsInput, opts ...request.Option) (*ListInstanceAssociationsOutput, error) {
	req, out := c.ListInstanceAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInventoryEntries = "ListInventoryEntries"

// ListInventoryEntriesRequest generates a "aws/request.Request" representing the
// client's request for the ListInventoryEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInventoryEntries for more information on using the ListInventoryEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInventoryEntriesRequest method.
//	req, resp := client.ListInventoryEntriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries
func (c *SSM) ListInventoryEntriesRequest(input *ListInventoryEntriesInput) (req *request.Request, output *ListInventoryEntriesOutput) {
	op := &request.Operation{
		Name:       opListInventoryEntries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListInventoryEntriesInput{}
	}

	output = &ListInventoryEntriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInventoryEntries API operation for Amazon Simple Systems Management Service.
//
// A list of inventory items returned by the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListInventoryEntries for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InvalidInventoryResourceTypeException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries
func (c *SSM) ListInventoryEntries(input *ListInventoryEntriesInput) (*ListInventoryEntriesOutput, error) {
	req, out := c.ListInventoryEntriesRequest(input)
	return out, req.Send()
}

// ListInventoryEntriesWithContext is the same as ListInventoryEntries with the addition of
// the ability to pass a context and additional request options.
//
// See ListInventoryEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListInventoryEntriesWithContext(ctx aws.Context, input *ListInventoryEntriesInput, opts ...request.Option) (*ListInventoryEntriesOutput, error) {
	req, out := c.ListInventoryEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNodes = "ListNodes"

// ListNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodes for more information on using the ListNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNodesRequest method.
//	req, resp := client.ListNodesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListNodes
func (c *SSM) ListNodesRequest(input *ListNodesInput) (req *request.Request, output *ListNodesOutput) {
	op := &request.Operation{
		Name:       opListNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodesInput{}
	}

	output = &ListNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodes API operation for Amazon Simple Systems Management Service.
//
// Takes in filters and returns a list of managed nodes matching the filter
// criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListNodes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - ResourceDataSyncNotFoundException
//     The specified sync name wasn't found.
//
//   - UnsupportedOperationException
//     This operation is not supported for the current account. You must first enable
//     the Systems Manager integrated experience in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListNodes
func (c *SSM) ListNodes(input *ListNodesInput) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	return out, req.Send()
}

// ListNodesWithContext is the same as ListNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListNodesWithContext(ctx aws.Context, input *ListNodesInput, opts ...request.Option) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodesPages iterates over the pages of a ListNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNodes operation.
//	pageNum := 0
//	err := client.ListNodesPages(params,
//	    func(page *ssm.ListNodesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListNodesPages(input *ListNodesInput, fn func(*ListNodesOutput, bool) bool) error {
	return c.ListNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodesPagesWithContext same as ListNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListNodesPagesWithContext(ctx aws.Context, input *ListNodesInput, fn func(*ListNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodesSummary = "ListNodesSummary"

// ListNodesSummaryRequest generates a "aws/request.Request" representing the
// client's request for the ListNodesSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodesSummary for more information on using the ListNodesSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNodesSummaryRequest method.
//	req, resp := client.ListNodesSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListNodesSummary
func (c *SSM) ListNodesSummaryRequest(input *ListNodesSummaryInput) (req *request.Request, output *ListNodesSummaryOutput) {
	op := &request.Operation{
		Name:       opListNodesSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodesSummaryInput{}
	}

	output = &ListNodesSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodesSummary API operation for Amazon Simple Systems Management Service.
//
// Generates a summary of managed instance/node metadata based on the filters
// and aggregators you specify. Results are grouped by the input aggregator
// you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListNodesSummary for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidAggregatorException
//     The specified aggregator isn't valid for the group type. Verify that the
//     aggregator you provided is supported.
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - ResourceDataSyncNotFoundException
//     The specified sync name wasn't found.
//
//   - UnsupportedOperationException
//     This operation is not supported for the current account. You must first enable
//     the Systems Manager integrated experience in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListNodesSummary
func (c *SSM) ListNodesSummary(input *ListNodesSummaryInput) (*ListNodesSummaryOutput, error) {
	req, out := c.ListNodesSummaryRequest(input)
	return out, req.Send()
}

// ListNodesSummaryWithContext is the same as ListNodesSummary with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodesSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListNodesSummaryWithContext(ctx aws.Context, input *ListNodesSummaryInput, opts ...request.Option) (*ListNodesSummaryOutput, error) {
	req, out := c.ListNodesSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodesSummaryPages iterates over the pages of a ListNodesSummary operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodesSummary method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNodesSummary operation.
//	pageNum := 0
//	err := client.ListNodesSummaryPages(params,
//	    func(page *ssm.ListNodesSummaryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListNodesSummaryPages(input *ListNodesSummaryInput, fn func(*ListNodesSummaryOutput, bool) bool) error {
	return c.ListNodesSummaryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodesSummaryPagesWithContext same as ListNodesSummaryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListNodesSummaryPagesWithContext(ctx aws.Context, input *ListNodesSummaryInput, fn func(*ListNodesSummaryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodesSummaryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodesSummaryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodesSummaryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOpsItemEvents = "ListOpsItemEvents"

// ListOpsItemEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListOpsItemEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOpsItemEvents for more information on using the ListOpsItemEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOpsItemEventsRequest method.
//	req, resp := client.ListOpsItemEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents
func (c *SSM) ListOpsItemEventsRequest(input *ListOpsItemEventsInput) (req *request.Request, output *ListOpsItemEventsOutput) {
	op := &request.Operation{
		Name:       opListOpsItemEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOpsItemEventsInput{}
	}

	output = &ListOpsItemEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOpsItemEvents API operation for Amazon Simple Systems Management Service.
//
// Returns a list of all OpsItem events in the current Amazon Web Services Region
// and Amazon Web Services account. You can limit the results to events associated
// with specific OpsItems by specifying a filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListOpsItemEvents for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsItemNotFoundException
//     The specified OpsItem ID doesn't exist. Verify the ID and try again.
//
//   - OpsCenterInvalidArgumentException
//
//   - OpsItemLimitExceededException
//     The request caused OpsItems to exceed one or more quotas.
//
//   - OpsItemInvalidParameterException
//     A specified parameter argument isn't valid. Verify the available arguments
//     and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents
func (c *SSM) ListOpsItemEvents(input *ListOpsItemEventsInput) (*ListOpsItemEventsOutput, error) {
	req, out := c.ListOpsItemEventsRequest(input)
	return out, req.Send()
}

// ListOpsItemEventsWithContext is the same as ListOpsItemEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListOpsItemEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListOpsItemEventsWithContext(ctx aws.Context, input *ListOpsItemEventsInput, opts ...request.Option) (*ListOpsItemEventsOutput, error) {
	req, out := c.ListOpsItemEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOpsItemEventsPages iterates over the pages of a ListOpsItemEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOpsItemEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOpsItemEvents operation.
//	pageNum := 0
//	err := client.ListOpsItemEventsPages(params,
//	    func(page *ssm.ListOpsItemEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListOpsItemEventsPages(input *ListOpsItemEventsInput, fn func(*ListOpsItemEventsOutput, bool) bool) error {
	return c.ListOpsItemEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOpsItemEventsPagesWithContext same as ListOpsItemEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListOpsItemEventsPagesWithContext(ctx aws.Context, input *ListOpsItemEventsInput, fn func(*ListOpsItemEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOpsItemEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOpsItemEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOpsItemEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOpsItemRelatedItems = "ListOpsItemRelatedItems"

// ListOpsItemRelatedItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListOpsItemRelatedItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOpsItemRelatedItems for more information on using the ListOpsItemRelatedItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOpsItemRelatedItemsRequest method.
//	req, resp := client.ListOpsItemRelatedItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemRelatedItems
func (c *SSM) ListOpsItemRelatedItemsRequest(input *ListOpsItemRelatedItemsInput) (req *request.Request, output *ListOpsItemRelatedItemsOutput) {
	op := &request.Operation{
		Name:       opListOpsItemRelatedItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOpsItemRelatedItemsInput{}
	}

	output = &ListOpsItemRelatedItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOpsItemRelatedItems API operation for Amazon Simple Systems Management Service.
//
// Lists all related-item resources associated with a Systems Manager OpsCenter
// OpsItem. OpsCenter is a capability of Amazon Web Services Systems Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListOpsItemRelatedItems for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsItemInvalidParameterException
//     A specified parameter argument isn't valid. Verify the available arguments
//     and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemRelatedItems
func (c *SSM) ListOpsItemRelatedItems(input *ListOpsItemRelatedItemsInput) (*ListOpsItemRelatedItemsOutput, error) {
	req, out := c.ListOpsItemRelatedItemsRequest(input)
	return out, req.Send()
}

// ListOpsItemRelatedItemsWithContext is the same as ListOpsItemRelatedItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListOpsItemRelatedItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListOpsItemRelatedItemsWithContext(ctx aws.Context, input *ListOpsItemRelatedItemsInput, opts ...request.Option) (*ListOpsItemRelatedItemsOutput, error) {
	req, out := c.ListOpsItemRelatedItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOpsItemRelatedItemsPages iterates over the pages of a ListOpsItemRelatedItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOpsItemRelatedItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOpsItemRelatedItems operation.
//	pageNum := 0
//	err := client.ListOpsItemRelatedItemsPages(params,
//	    func(page *ssm.ListOpsItemRelatedItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListOpsItemRelatedItemsPages(input *ListOpsItemRelatedItemsInput, fn func(*ListOpsItemRelatedItemsOutput, bool) bool) error {
	return c.ListOpsItemRelatedItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOpsItemRelatedItemsPagesWithContext same as ListOpsItemRelatedItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListOpsItemRelatedItemsPagesWithContext(ctx aws.Context, input *ListOpsItemRelatedItemsInput, fn func(*ListOpsItemRelatedItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOpsItemRelatedItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOpsItemRelatedItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOpsItemRelatedItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOpsMetadata = "ListOpsMetadata"

// ListOpsMetadataRequest generates a "aws/request.Request" representing the
// client's request for the ListOpsMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOpsMetadata for more information on using the ListOpsMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOpsMetadataRequest method.
//	req, resp := client.ListOpsMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata
func (c *SSM) ListOpsMetadataRequest(input *ListOpsMetadataInput) (req *request.Request, output *ListOpsMetadataOutput) {
	op := &request.Operation{
		Name:       opListOpsMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOpsMetadataInput{}
	}

	output = &ListOpsMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOpsMetadata API operation for Amazon Simple Systems Management Service.
//
// Amazon Web Services Systems Manager calls this API operation when displaying
// all Application Manager OpsMetadata objects or blobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListOpsMetadata for usage and error information.
//
// Returned Error Types:
//
//   - OpsMetadataInvalidArgumentException
//     One of the arguments passed is invalid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata
func (c *SSM) ListOpsMetadata(input *ListOpsMetadataInput) (*ListOpsMetadataOutput, error) {
	req, out := c.ListOpsMetadataRequest(input)
	return out, req.Send()
}

// ListOpsMetadataWithContext is the same as ListOpsMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See ListOpsMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListOpsMetadataWithContext(ctx aws.Context, input *ListOpsMetadataInput, opts ...request.Option) (*ListOpsMetadataOutput, error) {
	req, out := c.ListOpsMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOpsMetadataPages iterates over the pages of a ListOpsMetadata operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOpsMetadata method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOpsMetadata operation.
//	pageNum := 0
//	err := client.ListOpsMetadataPages(params,
//	    func(page *ssm.ListOpsMetadataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListOpsMetadataPages(input *ListOpsMetadataInput, fn func(*ListOpsMetadataOutput, bool) bool) error {
	return c.ListOpsMetadataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOpsMetadataPagesWithContext same as ListOpsMetadataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListOpsMetadataPagesWithContext(ctx aws.Context, input *ListOpsMetadataInput, fn func(*ListOpsMetadataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOpsMetadataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOpsMetadataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOpsMetadataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceComplianceSummaries = "ListResourceComplianceSummaries"

// ListResourceComplianceSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceComplianceSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceComplianceSummaries for more information on using the ListResourceComplianceSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceComplianceSummariesRequest method.
//	req, resp := client.ListResourceComplianceSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries
func (c *SSM) ListResourceComplianceSummariesRequest(input *ListResourceComplianceSummariesInput) (req *request.Request, output *ListResourceComplianceSummariesOutput) {
	op := &request.Operation{
		Name:       opListResourceComplianceSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceComplianceSummariesInput{}
	}

	output = &ListResourceComplianceSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceComplianceSummaries API operation for Amazon Simple Systems Management Service.
//
// Returns a resource-level summary count. The summary includes information
// about compliant and non-compliant statuses and detailed compliance-item severity
// counts, according to the filter criteria you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListResourceComplianceSummaries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidFilter
//     The filter name isn't valid. Verify that you entered the correct name and
//     try again.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries
func (c *SSM) ListResourceComplianceSummaries(input *ListResourceComplianceSummariesInput) (*ListResourceComplianceSummariesOutput, error) {
	req, out := c.ListResourceComplianceSummariesRequest(input)
	return out, req.Send()
}

// ListResourceComplianceSummariesWithContext is the same as ListResourceComplianceSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceComplianceSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListResourceComplianceSummariesWithContext(ctx aws.Context, input *ListResourceComplianceSummariesInput, opts ...request.Option) (*ListResourceComplianceSummariesOutput, error) {
	req, out := c.ListResourceComplianceSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceComplianceSummariesPages iterates over the pages of a ListResourceComplianceSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceComplianceSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourceComplianceSummaries operation.
//	pageNum := 0
//	err := client.ListResourceComplianceSummariesPages(params,
//	    func(page *ssm.ListResourceComplianceSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListResourceComplianceSummariesPages(input *ListResourceComplianceSummariesInput, fn func(*ListResourceComplianceSummariesOutput, bool) bool) error {
	return c.ListResourceComplianceSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceComplianceSummariesPagesWithContext same as ListResourceComplianceSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListResourceComplianceSummariesPagesWithContext(ctx aws.Context, input *ListResourceComplianceSummariesInput, fn func(*ListResourceComplianceSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceComplianceSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceComplianceSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceComplianceSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourceDataSync = "ListResourceDataSync"

// ListResourceDataSyncRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceDataSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceDataSync for more information on using the ListResourceDataSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourceDataSyncRequest method.
//	req, resp := client.ListResourceDataSyncRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync
func (c *SSM) ListResourceDataSyncRequest(input *ListResourceDataSyncInput) (req *request.Request, output *ListResourceDataSyncOutput) {
	op := &request.Operation{
		Name:       opListResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceDataSyncInput{}
	}

	output = &ListResourceDataSyncOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceDataSync API operation for Amazon Simple Systems Management Service.
//
// Lists your resource data sync configurations. Includes information about
// the last time a sync attempted to start, the last sync status, and the last
// time a sync successfully completed.
//
// The number of sync configurations might be too large to return using a single
// call to ListResourceDataSync. You can limit the number of sync configurations
// returned by using the MaxResults parameter. To determine whether there are
// more sync configurations to list, check the value of NextToken in the output.
// If there are more sync configurations to list, you can request them by specifying
// the NextToken returned in the call to the parameter of a subsequent call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListResourceDataSync for usage and error information.
//
// Returned Error Types:
//
//   - ResourceDataSyncInvalidConfigurationException
//     The specified sync configuration is invalid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync
func (c *SSM) ListResourceDataSync(input *ListResourceDataSyncInput) (*ListResourceDataSyncOutput, error) {
	req, out := c.ListResourceDataSyncRequest(input)
	return out, req.Send()
}

// ListResourceDataSyncWithContext is the same as ListResourceDataSync with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceDataSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListResourceDataSyncWithContext(ctx aws.Context, input *ListResourceDataSyncInput, opts ...request.Option) (*ListResourceDataSyncOutput, error) {
	req, out := c.ListResourceDataSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourceDataSyncPages iterates over the pages of a ListResourceDataSync operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourceDataSync method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourceDataSync operation.
//	pageNum := 0
//	err := client.ListResourceDataSyncPages(params,
//	    func(page *ssm.ListResourceDataSyncOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSM) ListResourceDataSyncPages(input *ListResourceDataSyncInput, fn func(*ListResourceDataSyncOutput, bool) bool) error {
	return c.ListResourceDataSyncPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourceDataSyncPagesWithContext same as ListResourceDataSyncPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListResourceDataSyncPagesWithContext(ctx aws.Context, input *ListResourceDataSyncInput, fn func(*ListResourceDataSyncOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourceDataSyncInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourceDataSyncRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourceDataSyncOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourcesSupportPolicy = "ListResourcesSupportPolicy"

// ListResourcesSupportPolicyRequest generates a "aws/request.Request" representing the
// client's request for the ListResourcesSupportPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourcesSupportPolicy for more information on using the ListResourcesSupportPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourcesSupportPolicyRequest method.
//	req, resp := client.ListResourcesSupportPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourcesSupportPolicy
func (c *SSM) ListResourcesSupportPolicyRequest(input *ListResourcesSupportPolicyInput) (req *request.Request, output *ListResourcesSupportPolicyOutput) {
	op := &request.Operation{
		Name:       opListResourcesSupportPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourcesSupportPolicyInput{}
	}

	output = &ListResourcesSupportPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourcesSupportPolicy API operation for Amazon Simple Systems Management Service.
//
// # List all of the resources that have a policy document
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListResourcesSupportPolicy for usage and error information.
//
// Returned Error Types:
//   - RAMInvalidParameterException
//     RAM call contains invalid parameter
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourcesSupportPolicy
func (c *SSM) ListResourcesSupportPolicy(input *ListResourcesSupportPolicyInput) (*ListResourcesSupportPolicyOutput, error) {
	req, out := c.ListResourcesSupportPolicyRequest(input)
	return out, req.Send()
}

// ListResourcesSupportPolicyWithContext is the same as ListResourcesSupportPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourcesSupportPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListResourcesSupportPolicyWithContext(ctx aws.Context, input *ListResourcesSupportPolicyInput, opts ...request.Option) (*ListResourcesSupportPolicyOutput, error) {
	req, out := c.ListResourcesSupportPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListServiceSettingsInternal = "ListServiceSettingsInternal"

// ListServiceSettingsInternalRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceSettingsInternal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceSettingsInternal for more information on using the ListServiceSettingsInternal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceSettingsInternalRequest method.
//	req, resp := client.ListServiceSettingsInternalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListServiceSettingsInternal
func (c *SSM) ListServiceSettingsInternalRequest(input *ListServiceSettingsInternalInput) (req *request.Request, output *ListServiceSettingsInternalOutput) {
	op := &request.Operation{
		Name:       opListServiceSettingsInternal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListServiceSettingsInternalInput{}
	}

	output = &ListServiceSettingsInternalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceSettingsInternal API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListServiceSettingsInternal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidNextToken
//     The specified token isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListServiceSettingsInternal
func (c *SSM) ListServiceSettingsInternal(input *ListServiceSettingsInternalInput) (*ListServiceSettingsInternalOutput, error) {
	req, out := c.ListServiceSettingsInternalRequest(input)
	return out, req.Send()
}

// ListServiceSettingsInternalWithContext is the same as ListServiceSettingsInternal with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceSettingsInternal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListServiceSettingsInternalWithContext(ctx aws.Context, input *ListServiceSettingsInternalInput, opts ...request.Option) (*ListServiceSettingsInternalOutput, error) {
	req, out := c.ListServiceSettingsInternalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSharedResources = "ListSharedResources"

// ListSharedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListSharedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSharedResources for more information on using the ListSharedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSharedResourcesRequest method.
//	req, resp := client.ListSharedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListSharedResources
func (c *SSM) ListSharedResourcesRequest(input *ListSharedResourcesInput) (req *request.Request, output *ListSharedResourcesOutput) {
	op := &request.Operation{
		Name:       opListSharedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSharedResourcesInput{}
	}

	output = &ListSharedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSharedResources API operation for Amazon Simple Systems Management Service.
//
// Lists all of the resources an account has been shared to. This API is used
// for reconcile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListSharedResources for usage and error information.
//
// Returned Error Types:
//   - RAMInvalidParameterException
//     RAM call contains invalid parameter
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListSharedResources
func (c *SSM) ListSharedResources(input *ListSharedResourcesInput) (*ListSharedResourcesOutput, error) {
	req, out := c.ListSharedResourcesRequest(input)
	return out, req.Send()
}

// ListSharedResourcesWithContext is the same as ListSharedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListSharedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListSharedResourcesWithContext(ctx aws.Context, input *ListSharedResourcesInput, opts ...request.Option) (*ListSharedResourcesOutput, error) {
	req, out := c.ListSharedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource
func (c *SSM) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Simple Systems Management Service.
//
// Returns a list of the tags assigned to the specified resource.
//
// For information about the ID format for each supported resource type, see
// AddTagsToResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceType
//     The resource type isn't valid. For example, if you are attempting to tag
//     an EC2 instance, the instance must be a registered managed node.
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource
func (c *SSM) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLockServiceLinkedRole = "LockServiceLinkedRole"

// LockServiceLinkedRoleRequest generates a "aws/request.Request" representing the
// client's request for the LockServiceLinkedRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LockServiceLinkedRole for more information on using the LockServiceLinkedRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the LockServiceLinkedRoleRequest method.
//	req, resp := client.LockServiceLinkedRoleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LockServiceLinkedRole
func (c *SSM) LockServiceLinkedRoleRequest(input *LockServiceLinkedRoleInput) (req *request.Request, output *LockServiceLinkedRoleOutput) {
	op := &request.Operation{
		Name:       opLockServiceLinkedRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LockServiceLinkedRoleInput{}
	}

	output = &LockServiceLinkedRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LockServiceLinkedRole API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation LockServiceLinkedRole for usage and error information.
//
// Returned Error Types:
//
//   - ServiceLinkedRoleLockServiceException
//
//   - ServiceLinkedRoleLockClientException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LockServiceLinkedRole
func (c *SSM) LockServiceLinkedRole(input *LockServiceLinkedRoleInput) (*LockServiceLinkedRoleOutput, error) {
	req, out := c.LockServiceLinkedRoleRequest(input)
	return out, req.Send()
}

// LockServiceLinkedRoleWithContext is the same as LockServiceLinkedRole with the addition of
// the ability to pass a context and additional request options.
//
// See LockServiceLinkedRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) LockServiceLinkedRoleWithContext(ctx aws.Context, input *LockServiceLinkedRoleInput, opts ...request.Option) (*LockServiceLinkedRoleOutput, error) {
	req, out := c.LockServiceLinkedRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDocumentPermission = "ModifyDocumentPermission"

// ModifyDocumentPermissionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDocumentPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDocumentPermission for more information on using the ModifyDocumentPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyDocumentPermissionRequest method.
//	req, resp := client.ModifyDocumentPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission
func (c *SSM) ModifyDocumentPermissionRequest(input *ModifyDocumentPermissionInput) (req *request.Request, output *ModifyDocumentPermissionOutput) {
	op := &request.Operation{
		Name:       opModifyDocumentPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDocumentPermissionInput{}
	}

	output = &ModifyDocumentPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyDocumentPermission API operation for Amazon Simple Systems Management Service.
//
// Shares a Amazon Web Services Systems Manager document (SSM document)publicly
// or privately. If you share a document privately, you must specify the Amazon
// Web Services user IDs for those people who can use the document. If you share
// a document publicly, you must specify All as the account ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ModifyDocumentPermission for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidPermissionType
//     The permission type isn't supported. Share is the only supported permission
//     type.
//
//   - DocumentPermissionLimit
//     The document can't be shared with more Amazon Web Services accounts. You
//     can specify a maximum of 20 accounts per API operation to share a private
//     document.
//
//     By default, you can share a private document with a maximum of 1,000 accounts
//     and publicly share up to five documents.
//
//     If you need to increase the quota for privately or publicly shared Systems
//     Manager documents, contact Amazon Web Services Support.
//
//   - DocumentLimitExceeded
//     You can have at most 500 active SSM documents.
//
//   - InvalidDocumentOperation
//     You attempted to delete a document while it is still shared. You must stop
//     sharing the document before you can delete it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission
func (c *SSM) ModifyDocumentPermission(input *ModifyDocumentPermissionInput) (*ModifyDocumentPermissionOutput, error) {
	req, out := c.ModifyDocumentPermissionRequest(input)
	return out, req.Send()
}

// ModifyDocumentPermissionWithContext is the same as ModifyDocumentPermission with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDocumentPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ModifyDocumentPermissionWithContext(ctx aws.Context, input *ModifyDocumentPermissionInput, opts ...request.Option) (*ModifyDocumentPermissionOutput, error) {
	req, out := c.ModifyDocumentPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutCalendar = "PutCalendar"

// PutCalendarRequest generates a "aws/request.Request" representing the
// client's request for the PutCalendar operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutCalendar for more information on using the PutCalendar
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutCalendarRequest method.
//	req, resp := client.PutCalendarRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutCalendar
func (c *SSM) PutCalendarRequest(input *PutCalendarInput) (req *request.Request, output *PutCalendarOutput) {
	op := &request.Operation{
		Name:       opPutCalendar,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutCalendarInput{}
	}

	output = &PutCalendarOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutCalendar API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation PutCalendar for usage and error information.
//
// Returned Error Types:
//
//   - DocumentLimitExceeded
//     You can have at most 500 active SSM documents.
//
//   - DocumentVersionLimitExceeded
//     The document has too many versions. Delete one or more document versions
//     and try again.
//
//   - MaxDocumentSizeExceeded
//     The size limit of a document is 64 KB.
//
//   - DuplicateDocumentContent
//     The content of the association document matches another document. Change
//     the content of the document and try again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocumentType
//     The SSM document type isn't valid. Valid document types are described in
//     the DocumentType property.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutCalendar
func (c *SSM) PutCalendar(input *PutCalendarInput) (*PutCalendarOutput, error) {
	req, out := c.PutCalendarRequest(input)
	return out, req.Send()
}

// PutCalendarWithContext is the same as PutCalendar with the addition of
// the ability to pass a context and additional request options.
//
// See PutCalendar for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutCalendarWithContext(ctx aws.Context, input *PutCalendarInput, opts ...request.Option) (*PutCalendarOutput, error) {
	req, out := c.PutCalendarRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutComplianceItems = "PutComplianceItems"

// PutComplianceItemsRequest generates a "aws/request.Request" representing the
// client's request for the PutComplianceItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutComplianceItems for more information on using the PutComplianceItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutComplianceItemsRequest method.
//	req, resp := client.PutComplianceItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutComplianceItems
func (c *SSM) PutComplianceItemsRequest(input *PutComplianceItemsInput) (req *request.Request, output *PutComplianceItemsOutput) {
	op := &request.Operation{
		Name:       opPutComplianceItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutComplianceItemsInput{}
	}

	output = &PutComplianceItemsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutComplianceItems API operation for Amazon Simple Systems Management Service.
//
// Registers a compliance type and other compliance details on a designated
// resource. This operation lets you register custom compliance details with
// a resource. This call overwrites existing compliance information on the resource,
// so you must provide a full list of compliance items each time that you send
// the request.
//
// ComplianceType can be one of the following:
//
//   - ExecutionId: The execution ID when the patch, association, or custom
//     compliance item was applied.
//
//   - ExecutionType: Specify patch, association, or Custom:string.
//
//   - ExecutionTime. The time the patch, association, or custom compliance
//     item was applied to the managed node.
//
//   - Id: The patch, association, or custom compliance ID.
//
//   - Title: A title.
//
//   - Status: The status of the compliance item. For example, approved for
//     patches, or Failed for associations.
//
//   - Severity: A patch severity. For example, Critical.
//
//   - DocumentName: An SSM document name. For example, AWS-RunPatchBaseline.
//
//   - DocumentVersion: An SSM document version number. For example, 4.
//
//   - Classification: A patch classification. For example, security updates.
//
//   - PatchBaselineId: A patch baseline ID.
//
//   - PatchSeverity: A patch severity. For example, Critical.
//
//   - PatchState: A patch state. For example, InstancesWithFailedPatches.
//
//   - PatchGroup: The name of a patch group.
//
//   - InstalledTime: The time the association, patch, or custom compliance
//     item was applied to the resource. Specify the time by using the following
//     format: yyyy-MM-dd'T'HH:mm:ss'Z'
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation PutComplianceItems for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidItemContentException
//     One or more content items isn't valid.
//
//   - TotalSizeLimitExceededException
//     The size of inventory data has exceeded the total size limit for the resource.
//
//   - ItemSizeLimitExceededException
//     The inventory item size has exceeded the size limit.
//
//   - ComplianceTypeCountLimitExceededException
//     You specified too many custom compliance types. You can specify a maximum
//     of 10 different types.
//
//   - InvalidResourceType
//     The resource type isn't valid. For example, if you are attempting to tag
//     an EC2 instance, the instance must be a registered managed node.
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
//   - CustomSchemaCountLimitExceededException
//     You have exceeded the limit for custom schemas. Delete one or more custom
//     schemas and try again.
//
//   - UnsupportedInventorySchemaVersionException
//     Inventory item type schema version has to match supported versions in the
//     service. Check output of GetInventorySchema to see the available schema version
//     for each type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutComplianceItems
func (c *SSM) PutComplianceItems(input *PutComplianceItemsInput) (*PutComplianceItemsOutput, error) {
	req, out := c.PutComplianceItemsRequest(input)
	return out, req.Send()
}

// PutComplianceItemsWithContext is the same as PutComplianceItems with the addition of
// the ability to pass a context and additional request options.
//
// See PutComplianceItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutComplianceItemsWithContext(ctx aws.Context, input *PutComplianceItemsInput, opts ...request.Option) (*PutComplianceItemsOutput, error) {
	req, out := c.PutComplianceItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurePackageResult = "PutConfigurePackageResult"

// PutConfigurePackageResultRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurePackageResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurePackageResult for more information on using the PutConfigurePackageResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutConfigurePackageResultRequest method.
//	req, resp := client.PutConfigurePackageResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutConfigurePackageResult
func (c *SSM) PutConfigurePackageResultRequest(input *PutConfigurePackageResultInput) (req *request.Request, output *PutConfigurePackageResultOutput) {
	op := &request.Operation{
		Name:       opPutConfigurePackageResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigurePackageResultInput{}
	}

	output = &PutConfigurePackageResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurePackageResult API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation PutConfigurePackageResult for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The specified parameter to be shared could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutConfigurePackageResult
func (c *SSM) PutConfigurePackageResult(input *PutConfigurePackageResultInput) (*PutConfigurePackageResultOutput, error) {
	req, out := c.PutConfigurePackageResultRequest(input)
	return out, req.Send()
}

// PutConfigurePackageResultWithContext is the same as PutConfigurePackageResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurePackageResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutConfigurePackageResultWithContext(ctx aws.Context, input *PutConfigurePackageResultInput, opts ...request.Option) (*PutConfigurePackageResultOutput, error) {
	req, out := c.PutConfigurePackageResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInventory = "PutInventory"

// PutInventoryRequest generates a "aws/request.Request" representing the
// client's request for the PutInventory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInventory for more information on using the PutInventory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutInventoryRequest method.
//	req, resp := client.PutInventoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory
func (c *SSM) PutInventoryRequest(input *PutInventoryInput) (req *request.Request, output *PutInventoryOutput) {
	op := &request.Operation{
		Name:       opPutInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInventoryInput{}
	}

	output = &PutInventoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutInventory API operation for Amazon Simple Systems Management Service.
//
// Bulk update custom inventory items on one or more managed nodes. The request
// adds an inventory item, if it doesn't already exist, or updates an inventory
// item, if it does exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation PutInventory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidTypeNameException
//     The parameter type name isn't valid.
//
//   - InvalidItemContentException
//     One or more content items isn't valid.
//
//   - TotalSizeLimitExceededException
//     The size of inventory data has exceeded the total size limit for the resource.
//
//   - ItemSizeLimitExceededException
//     The inventory item size has exceeded the size limit.
//
//   - ItemContentMismatchException
//     The inventory item has invalid content.
//
//   - CustomSchemaCountLimitExceededException
//     You have exceeded the limit for custom schemas. Delete one or more custom
//     schemas and try again.
//
//   - UnsupportedInventorySchemaVersionException
//     Inventory item type schema version has to match supported versions in the
//     service. Check output of GetInventorySchema to see the available schema version
//     for each type.
//
//   - UnsupportedInventoryItemContextException
//     The Context attribute that you specified for the InventoryItem isn't allowed
//     for this inventory type. You can only use the Context attribute with inventory
//     types like AWS:ComplianceItem.
//
//   - InvalidInventoryItemContextException
//     You specified invalid keys or values in the Context attribute for InventoryItem.
//     Verify the keys and values, and try again.
//
//   - SubTypeCountLimitExceededException
//     The sub-type count exceeded the limit for the inventory type.
//
//   - InvalidInventoryResourceTypeException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory
func (c *SSM) PutInventory(input *PutInventoryInput) (*PutInventoryOutput, error) {
	req, out := c.PutInventoryRequest(input)
	return out, req.Send()
}

// PutInventoryWithContext is the same as PutInventory with the addition of
// the ability to pass a context and additional request options.
//
// See PutInventory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutInventoryWithContext(ctx aws.Context, input *PutInventoryInput, opts ...request.Option) (*PutInventoryOutput, error) {
	req, out := c.PutInventoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutParameter = "PutParameter"

// PutParameterRequest generates a "aws/request.Request" representing the
// client's request for the PutParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutParameter for more information on using the PutParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutParameterRequest method.
//	req, resp := client.PutParameterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter
func (c *SSM) PutParameterRequest(input *PutParameterInput) (req *request.Request, output *PutParameterOutput) {
	op := &request.Operation{
		Name:       opPutParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutParameterInput{}
	}

	output = &PutParameterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutParameter API operation for Amazon Simple Systems Management Service.
//
// Add a parameter to the system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation PutParameter for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidKeyId
//     The query key ID isn't valid.
//
//   - ParameterLimitExceeded
//     You have exceeded the number of parameters for this Amazon Web Services account.
//     Delete one or more parameters and try again.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
//   - ParameterAlreadyExists
//     The parameter already exists. You can't create duplicate parameters.
//
//   - HierarchyLevelLimitExceededException
//     A hierarchy can have a maximum of 15 levels. For more information, see Requirements
//     and constraints for parameter names (https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html)
//     in the Amazon Web Services Systems Manager User Guide.
//
//   - HierarchyTypeMismatchException
//     Parameter Store doesn't support changing a parameter type in a hierarchy.
//     For example, you can't change a parameter from a String type to a SecureString
//     type. You must create a new, unique parameter.
//
//   - InvalidAllowedPatternException
//     The request doesn't meet the regular expression requirement.
//
//   - ParameterMaxVersionLimitExceeded
//     Parameter Store retains the 100 most recently created versions of a parameter.
//     After this number of versions has been created, Parameter Store deletes the
//     oldest version when a new one is created. However, if the oldest version
//     has a label attached to it, Parameter Store won't delete the version and
//     instead presents this error message:
//
//     An error occurred (ParameterMaxVersionLimitExceeded) when calling the PutParameter
//     operation: You attempted to create a new version of parameter-name by calling
//     the PutParameter API with the overwrite flag. Version version-number, the
//     oldest version, can't be deleted because it has a label associated with it.
//     Move the label to another version of the parameter, and try again.
//
//     This safeguard is to prevent parameter versions with mission critical labels
//     assigned to them from being deleted. To continue creating new parameters,
//     first move the label from the oldest version of the parameter to a newer
//     one for use in your operations. For information about moving parameter labels,
//     see Move a parameter label (console) (https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-console-move)
//     or Move a parameter label (CLI) (https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-cli-move)
//     in the Amazon Web Services Systems Manager User Guide.
//
//   - ParameterPatternMismatchException
//     The parameter name isn't valid.
//
//   - UnsupportedParameterType
//     The parameter type isn't supported.
//
//   - PoliciesLimitExceededException
//     You specified more than the maximum number of allowed policies for the parameter.
//     The maximum is 10.
//
//   - InvalidPolicyTypeException
//     The policy type isn't supported. Parameter Store supports the following policy
//     types: Expiration, ExpirationNotification, and NoChangeNotification.
//
//   - InvalidPolicyAttributeException
//     A policy attribute or its value is invalid.
//
//   - IncompatiblePolicyException
//     There is a conflict in the policies specified for this parameter. You can't,
//     for example, specify two Expiration policies for a parameter. Review your
//     policies, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter
func (c *SSM) PutParameter(input *PutParameterInput) (*PutParameterOutput, error) {
	req, out := c.PutParameterRequest(input)
	return out, req.Send()
}

// PutParameterWithContext is the same as PutParameter with the addition of
// the ability to pass a context and additional request options.
//
// See PutParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutParameterWithContext(ctx aws.Context, input *PutParameterInput, opts ...request.Option) (*PutParameterOutput, error) {
	req, out := c.PutParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutResourcePolicy
func (c *SSM) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for Amazon Simple Systems Management Service.
//
// # Adds or Updates resource policies associated with a SSM resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourcePolicyInvalidParameterException
//     One or more parameters specified for the call aren't valid. Verify the parameters
//     and their values and try again.
//
//   - ResourcePolicyConflictException
//     The hash provided in the call doesn't match the stored hash. This exception
//     is thrown when trying to update an obsolete policy version or when multiple
//     requests to update a policy are sent.
//
//   - MalformedResourcePolicyDocumentException
//     The specified policy document is malformed or invalid, or excessive PutResourcePolicy
//     or DeleteResourcePolicy calls have been made.
//
//   - ResourceNotFoundException
//     The specified parameter to be shared could not be found.
//
//   - ResourcePolicyNotFoundException
//     No policies with the specified policy ID and hash could be found.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutResourcePolicy
func (c *SSM) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterDefaultPatchBaseline = "RegisterDefaultPatchBaseline"

// RegisterDefaultPatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDefaultPatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterDefaultPatchBaseline for more information on using the RegisterDefaultPatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterDefaultPatchBaselineRequest method.
//	req, resp := client.RegisterDefaultPatchBaselineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline
func (c *SSM) RegisterDefaultPatchBaselineRequest(input *RegisterDefaultPatchBaselineInput) (req *request.Request, output *RegisterDefaultPatchBaselineOutput) {
	op := &request.Operation{
		Name:       opRegisterDefaultPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDefaultPatchBaselineInput{}
	}

	output = &RegisterDefaultPatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterDefaultPatchBaseline API operation for Amazon Simple Systems Management Service.
//
// Defines the default patch baseline for the relevant operating system.
//
// To reset the Amazon Web Services-predefined patch baseline as the default,
// specify the full patch baseline Amazon Resource Name (ARN) as the baseline
// ID value. For example, for CentOS, specify arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed
// instead of pb-0574b43a65ea646ed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation RegisterDefaultPatchBaseline for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline
func (c *SSM) RegisterDefaultPatchBaseline(input *RegisterDefaultPatchBaselineInput) (*RegisterDefaultPatchBaselineOutput, error) {
	req, out := c.RegisterDefaultPatchBaselineRequest(input)
	return out, req.Send()
}

// RegisterDefaultPatchBaselineWithContext is the same as RegisterDefaultPatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterDefaultPatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterDefaultPatchBaselineWithContext(ctx aws.Context, input *RegisterDefaultPatchBaselineInput, opts ...request.Option) (*RegisterDefaultPatchBaselineOutput, error) {
	req, out := c.RegisterDefaultPatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterManagedInstance = "RegisterManagedInstance"

// RegisterManagedInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterManagedInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterManagedInstance for more information on using the RegisterManagedInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterManagedInstanceRequest method.
//	req, resp := client.RegisterManagedInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterManagedInstance
func (c *SSM) RegisterManagedInstanceRequest(input *RegisterManagedInstanceInput) (req *request.Request, output *RegisterManagedInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterManagedInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterManagedInstanceInput{}
	}

	output = &RegisterManagedInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterManagedInstance API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation RegisterManagedInstance for usage and error information.
//
// Returned Error Types:
//
//   - InvalidActivation
//     The activation isn't valid. The activation might have been deleted, or the
//     ActivationId and the ActivationCode don't match.
//
//   - ActivationExpired
//
//   - RegistrationLimitExceeded
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
//   - InvalidPublicKey
//
//   - InstanceAlreadyRegistered
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterManagedInstance
func (c *SSM) RegisterManagedInstance(input *RegisterManagedInstanceInput) (*RegisterManagedInstanceOutput, error) {
	req, out := c.RegisterManagedInstanceRequest(input)
	return out, req.Send()
}

// RegisterManagedInstanceWithContext is the same as RegisterManagedInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterManagedInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterManagedInstanceWithContext(ctx aws.Context, input *RegisterManagedInstanceInput, opts ...request.Option) (*RegisterManagedInstanceOutput, error) {
	req, out := c.RegisterManagedInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterPatchBaselineForPatchGroup = "RegisterPatchBaselineForPatchGroup"

// RegisterPatchBaselineForPatchGroupRequest generates a "aws/request.Request" representing the
// client's request for the RegisterPatchBaselineForPatchGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterPatchBaselineForPatchGroup for more information on using the RegisterPatchBaselineForPatchGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterPatchBaselineForPatchGroupRequest method.
//	req, resp := client.RegisterPatchBaselineForPatchGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup
func (c *SSM) RegisterPatchBaselineForPatchGroupRequest(input *RegisterPatchBaselineForPatchGroupInput) (req *request.Request, output *RegisterPatchBaselineForPatchGroupOutput) {
	op := &request.Operation{
		Name:       opRegisterPatchBaselineForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterPatchBaselineForPatchGroupInput{}
	}

	output = &RegisterPatchBaselineForPatchGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterPatchBaselineForPatchGroup API operation for Amazon Simple Systems Management Service.
//
// Registers a patch baseline for a patch group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation RegisterPatchBaselineForPatchGroup for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     Error returned if an attempt is made to register a patch group with a patch
//     baseline that is already registered with a different patch baseline.
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - ResourceLimitExceededException
//     Error returned when the caller has exceeded the default resource quotas.
//     For example, too many maintenance windows or patch baselines have been created.
//
//     For information about resource quotas in Systems Manager, see Systems Manager
//     service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup
func (c *SSM) RegisterPatchBaselineForPatchGroup(input *RegisterPatchBaselineForPatchGroupInput) (*RegisterPatchBaselineForPatchGroupOutput, error) {
	req, out := c.RegisterPatchBaselineForPatchGroupRequest(input)
	return out, req.Send()
}

// RegisterPatchBaselineForPatchGroupWithContext is the same as RegisterPatchBaselineForPatchGroup with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterPatchBaselineForPatchGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterPatchBaselineForPatchGroupWithContext(ctx aws.Context, input *RegisterPatchBaselineForPatchGroupInput, opts ...request.Option) (*RegisterPatchBaselineForPatchGroupOutput, error) {
	req, out := c.RegisterPatchBaselineForPatchGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterTargetWithMaintenanceWindow = "RegisterTargetWithMaintenanceWindow"

// RegisterTargetWithMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the RegisterTargetWithMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterTargetWithMaintenanceWindow for more information on using the RegisterTargetWithMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterTargetWithMaintenanceWindowRequest method.
//	req, resp := client.RegisterTargetWithMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow
func (c *SSM) RegisterTargetWithMaintenanceWindowRequest(input *RegisterTargetWithMaintenanceWindowInput) (req *request.Request, output *RegisterTargetWithMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opRegisterTargetWithMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTargetWithMaintenanceWindowInput{}
	}

	output = &RegisterTargetWithMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterTargetWithMaintenanceWindow API operation for Amazon Simple Systems Management Service.
//
// Registers a target with a maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation RegisterTargetWithMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//
//   - IdempotentParameterMismatch
//     Error returned when an idempotent operation is retried and the parameters
//     don't match the original call to the API with the same idempotency token.
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - ResourceLimitExceededException
//     Error returned when the caller has exceeded the default resource quotas.
//     For example, too many maintenance windows or patch baselines have been created.
//
//     For information about resource quotas in Systems Manager, see Systems Manager
//     service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow
func (c *SSM) RegisterTargetWithMaintenanceWindow(input *RegisterTargetWithMaintenanceWindowInput) (*RegisterTargetWithMaintenanceWindowOutput, error) {
	req, out := c.RegisterTargetWithMaintenanceWindowRequest(input)
	return out, req.Send()
}

// RegisterTargetWithMaintenanceWindowWithContext is the same as RegisterTargetWithMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterTargetWithMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterTargetWithMaintenanceWindowWithContext(ctx aws.Context, input *RegisterTargetWithMaintenanceWindowInput, opts ...request.Option) (*RegisterTargetWithMaintenanceWindowOutput, error) {
	req, out := c.RegisterTargetWithMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterTaskWithMaintenanceWindow = "RegisterTaskWithMaintenanceWindow"

// RegisterTaskWithMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the RegisterTaskWithMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterTaskWithMaintenanceWindow for more information on using the RegisterTaskWithMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterTaskWithMaintenanceWindowRequest method.
//	req, resp := client.RegisterTaskWithMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow
func (c *SSM) RegisterTaskWithMaintenanceWindowRequest(input *RegisterTaskWithMaintenanceWindowInput) (req *request.Request, output *RegisterTaskWithMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opRegisterTaskWithMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTaskWithMaintenanceWindowInput{}
	}

	output = &RegisterTaskWithMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterTaskWithMaintenanceWindow API operation for Amazon Simple Systems Management Service.
//
// Adds a new task to a maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation RegisterTaskWithMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//
//   - IdempotentParameterMismatch
//     Error returned when an idempotent operation is retried and the parameters
//     don't match the original call to the API with the same idempotency token.
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - ResourceLimitExceededException
//     Error returned when the caller has exceeded the default resource quotas.
//     For example, too many maintenance windows or patch baselines have been created.
//
//     For information about resource quotas in Systems Manager, see Systems Manager
//     service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - FeatureNotAvailableException
//     You attempted to register a LAMBDA or STEP_FUNCTIONS task in a region where
//     the corresponding service isn't available.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow
func (c *SSM) RegisterTaskWithMaintenanceWindow(input *RegisterTaskWithMaintenanceWindowInput) (*RegisterTaskWithMaintenanceWindowOutput, error) {
	req, out := c.RegisterTaskWithMaintenanceWindowRequest(input)
	return out, req.Send()
}

// RegisterTaskWithMaintenanceWindowWithContext is the same as RegisterTaskWithMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterTaskWithMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterTaskWithMaintenanceWindowWithContext(ctx aws.Context, input *RegisterTaskWithMaintenanceWindowInput, opts ...request.Option) (*RegisterTaskWithMaintenanceWindowOutput, error) {
	req, out := c.RegisterTaskWithMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveTagsFromResourceRequest method.
//	req, resp := client.RemoveTagsFromResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource
func (c *SSM) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for Amazon Simple Systems Management Service.
//
// Removes tag keys from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidResourceType
//     The resource type isn't valid. For example, if you are attempting to tag
//     an EC2 instance, the instance must be a registered managed node.
//
//   - InvalidResourceId
//     The resource ID isn't valid. Verify that you entered the correct ID and try
//     again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource
func (c *SSM) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestManagedInstanceRoleToken = "RequestManagedInstanceRoleToken"

// RequestManagedInstanceRoleTokenRequest generates a "aws/request.Request" representing the
// client's request for the RequestManagedInstanceRoleToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestManagedInstanceRoleToken for more information on using the RequestManagedInstanceRoleToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RequestManagedInstanceRoleTokenRequest method.
//	req, resp := client.RequestManagedInstanceRoleTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RequestManagedInstanceRoleToken
func (c *SSM) RequestManagedInstanceRoleTokenRequest(input *RequestManagedInstanceRoleTokenInput) (req *request.Request, output *RequestManagedInstanceRoleTokenOutput) {
	op := &request.Operation{
		Name:       opRequestManagedInstanceRoleToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestManagedInstanceRoleTokenInput{}
	}

	output = &RequestManagedInstanceRoleTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestManagedInstanceRoleToken API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation RequestManagedInstanceRoleToken for usage and error information.
//
// Returned Error Types:
//
//   - MachineFingerprintDoesNotMatch
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RequestManagedInstanceRoleToken
func (c *SSM) RequestManagedInstanceRoleToken(input *RequestManagedInstanceRoleTokenInput) (*RequestManagedInstanceRoleTokenOutput, error) {
	req, out := c.RequestManagedInstanceRoleTokenRequest(input)
	return out, req.Send()
}

// RequestManagedInstanceRoleTokenWithContext is the same as RequestManagedInstanceRoleToken with the addition of
// the ability to pass a context and additional request options.
//
// See RequestManagedInstanceRoleToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RequestManagedInstanceRoleTokenWithContext(ctx aws.Context, input *RequestManagedInstanceRoleTokenInput, opts ...request.Option) (*RequestManagedInstanceRoleTokenOutput, error) {
	req, out := c.RequestManagedInstanceRoleTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetServiceSetting = "ResetServiceSetting"

// ResetServiceSettingRequest generates a "aws/request.Request" representing the
// client's request for the ResetServiceSetting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetServiceSetting for more information on using the ResetServiceSetting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResetServiceSettingRequest method.
//	req, resp := client.ResetServiceSettingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResetServiceSetting
func (c *SSM) ResetServiceSettingRequest(input *ResetServiceSettingInput) (req *request.Request, output *ResetServiceSettingOutput) {
	op := &request.Operation{
		Name:       opResetServiceSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetServiceSettingInput{}
	}

	output = &ResetServiceSettingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetServiceSetting API operation for Amazon Simple Systems Management Service.
//
// ServiceSetting is an account-level setting for an Amazon Web Services service.
// This setting defines how a user interacts with or uses a service or a feature
// of a service. For example, if an Amazon Web Services service charges money
// to the account based on feature or service usage, then the Amazon Web Services
// service team might create a default setting of "false". This means the user
// can't use this feature unless they change the setting to "true" and intentionally
// opt in for a paid feature.
//
// Services map a SettingId object to a setting value. Amazon Web Services services
// teams define the default value for a SettingId. You can't create a new SettingId,
// but you can overwrite the default value if you have the ssm:UpdateServiceSetting
// permission for the setting. Use the GetServiceSetting API operation to view
// the current value. Use the UpdateServiceSetting API operation to change the
// default setting.
//
// Reset the service setting for the account to the default value as provisioned
// by the Amazon Web Services service team.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ResetServiceSetting for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ServiceSettingNotFound
//     The specified service setting wasn't found. Either the service name or the
//     setting hasn't been provisioned by the Amazon Web Services service team.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResetServiceSetting
func (c *SSM) ResetServiceSetting(input *ResetServiceSettingInput) (*ResetServiceSettingOutput, error) {
	req, out := c.ResetServiceSettingRequest(input)
	return out, req.Send()
}

// ResetServiceSettingWithContext is the same as ResetServiceSetting with the addition of
// the ability to pass a context and additional request options.
//
// See ResetServiceSetting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ResetServiceSettingWithContext(ctx aws.Context, input *ResetServiceSettingInput, opts ...request.Option) (*ResetServiceSettingOutput, error) {
	req, out := c.ResetServiceSettingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeSession = "ResumeSession"

// ResumeSessionRequest generates a "aws/request.Request" representing the
// client's request for the ResumeSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeSession for more information on using the ResumeSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResumeSessionRequest method.
//	req, resp := client.ResumeSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResumeSession
func (c *SSM) ResumeSessionRequest(input *ResumeSessionInput) (req *request.Request, output *ResumeSessionOutput) {
	op := &request.Operation{
		Name:       opResumeSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResumeSessionInput{}
	}

	output = &ResumeSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResumeSession API operation for Amazon Simple Systems Management Service.
//
// Reconnects a session to a managed node after it has been disconnected. Connections
// can be resumed for disconnected sessions, but not terminated sessions.
//
// This command is primarily for use by client machines to automatically reconnect
// during intermittent network issues. It isn't intended for any other use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ResumeSession for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - BadRequest
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResumeSession
func (c *SSM) ResumeSession(input *ResumeSessionInput) (*ResumeSessionOutput, error) {
	req, out := c.ResumeSessionRequest(input)
	return out, req.Send()
}

// ResumeSessionWithContext is the same as ResumeSession with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ResumeSessionWithContext(ctx aws.Context, input *ResumeSessionInput, opts ...request.Option) (*ResumeSessionOutput, error) {
	req, out := c.ResumeSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendAutomationSignal = "SendAutomationSignal"

// SendAutomationSignalRequest generates a "aws/request.Request" representing the
// client's request for the SendAutomationSignal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendAutomationSignal for more information on using the SendAutomationSignal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendAutomationSignalRequest method.
//	req, resp := client.SendAutomationSignalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal
func (c *SSM) SendAutomationSignalRequest(input *SendAutomationSignalInput) (req *request.Request, output *SendAutomationSignalOutput) {
	op := &request.Operation{
		Name:       opSendAutomationSignal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendAutomationSignalInput{}
	}

	output = &SendAutomationSignalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendAutomationSignal API operation for Amazon Simple Systems Management Service.
//
// Sends a signal to an Automation execution to change the current behavior
// or status of the execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation SendAutomationSignal for usage and error information.
//
// Returned Error Types:
//
//   - AutomationExecutionNotFoundException
//     There is no automation execution information for the requested automation
//     execution ID.
//
//   - AutomationStepNotFoundException
//     The specified step name and execution ID don't exist. Verify the information
//     and try again.
//
//   - InvalidAutomationSignalException
//     The signal isn't valid for the current Automation execution.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal
func (c *SSM) SendAutomationSignal(input *SendAutomationSignalInput) (*SendAutomationSignalOutput, error) {
	req, out := c.SendAutomationSignalRequest(input)
	return out, req.Send()
}

// SendAutomationSignalWithContext is the same as SendAutomationSignal with the addition of
// the ability to pass a context and additional request options.
//
// See SendAutomationSignal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) SendAutomationSignalWithContext(ctx aws.Context, input *SendAutomationSignalInput, opts ...request.Option) (*SendAutomationSignalOutput, error) {
	req, out := c.SendAutomationSignalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendCommand = "SendCommand"

// SendCommandRequest generates a "aws/request.Request" representing the
// client's request for the SendCommand operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendCommand for more information on using the SendCommand
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendCommandRequest method.
//	req, resp := client.SendCommandRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand
func (c *SSM) SendCommandRequest(input *SendCommandInput) (req *request.Request, output *SendCommandOutput) {
	op := &request.Operation{
		Name:       opSendCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendCommandInput{}
	}

	output = &SendCommandOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendCommand API operation for Amazon Simple Systems Management Service.
//
// Runs commands on one or more managed nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation SendCommand for usage and error information.
//
// Returned Error Types:
//
//   - DuplicateInstanceId
//     You can't specify a managed node ID in more than one association.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - InvalidOutputFolder
//     The S3 bucket doesn't exist.
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
//   - UnsupportedPlatformType
//     The document doesn't support the platform type of the given managed node
//     IDs. For example, you sent an document for a Windows managed node to a Linux
//     node.
//
//   - MaxDocumentSizeExceeded
//     The size limit of a document is 64 KB.
//
//   - InvalidRole
//     The role name can't contain invalid characters. Also verify that you specified
//     an IAM role for notifications that includes the required trust policy. For
//     information about configuring the IAM role for Run Command notifications,
//     see Monitoring Systems Manager status changes using Amazon SNS notifications
//     (https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html)
//     in the Amazon Web Services Systems Manager User Guide.
//
//   - InvalidNotificationConfig
//     One or more configuration items isn't valid. Verify that a valid Amazon Resource
//     Name (ARN) was provided for an Amazon Simple Notification Service topic.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand
func (c *SSM) SendCommand(input *SendCommandInput) (*SendCommandOutput, error) {
	req, out := c.SendCommandRequest(input)
	return out, req.Send()
}

// SendCommandWithContext is the same as SendCommand with the addition of
// the ability to pass a context and additional request options.
//
// See SendCommand for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) SendCommandWithContext(ctx aws.Context, input *SendCommandInput, opts ...request.Option) (*SendCommandOutput, error) {
	req, out := c.SendCommandRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAccessRequest = "StartAccessRequest"

// StartAccessRequestRequest generates a "aws/request.Request" representing the
// client's request for the StartAccessRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAccessRequest for more information on using the StartAccessRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAccessRequestRequest method.
//	req, resp := client.StartAccessRequestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAccessRequest
func (c *SSM) StartAccessRequestRequest(input *StartAccessRequestInput) (req *request.Request, output *StartAccessRequestOutput) {
	op := &request.Operation{
		Name:       opStartAccessRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAccessRequestInput{}
	}

	output = &StartAccessRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAccessRequest API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation StartAccessRequest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ResourceNotFoundException
//     The specified parameter to be shared could not be found.
//
//   - ServiceQuotaExceededException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAccessRequest
func (c *SSM) StartAccessRequest(input *StartAccessRequestInput) (*StartAccessRequestOutput, error) {
	req, out := c.StartAccessRequestRequest(input)
	return out, req.Send()
}

// StartAccessRequestWithContext is the same as StartAccessRequest with the addition of
// the ability to pass a context and additional request options.
//
// See StartAccessRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartAccessRequestWithContext(ctx aws.Context, input *StartAccessRequestInput, opts ...request.Option) (*StartAccessRequestOutput, error) {
	req, out := c.StartAccessRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAssociationsOnce = "StartAssociationsOnce"

// StartAssociationsOnceRequest generates a "aws/request.Request" representing the
// client's request for the StartAssociationsOnce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAssociationsOnce for more information on using the StartAssociationsOnce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAssociationsOnceRequest method.
//	req, resp := client.StartAssociationsOnceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnce
func (c *SSM) StartAssociationsOnceRequest(input *StartAssociationsOnceInput) (req *request.Request, output *StartAssociationsOnceOutput) {
	op := &request.Operation{
		Name:       opStartAssociationsOnce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAssociationsOnceInput{}
	}

	output = &StartAssociationsOnceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartAssociationsOnce API operation for Amazon Simple Systems Management Service.
//
// Runs an association immediately and only one time. This operation can be
// helpful when troubleshooting associations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation StartAssociationsOnce for usage and error information.
//
// Returned Error Types:
//
//   - InvalidAssociation
//     The association isn't valid or doesn't exist.
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnce
func (c *SSM) StartAssociationsOnce(input *StartAssociationsOnceInput) (*StartAssociationsOnceOutput, error) {
	req, out := c.StartAssociationsOnceRequest(input)
	return out, req.Send()
}

// StartAssociationsOnceWithContext is the same as StartAssociationsOnce with the addition of
// the ability to pass a context and additional request options.
//
// See StartAssociationsOnce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartAssociationsOnceWithContext(ctx aws.Context, input *StartAssociationsOnceInput, opts ...request.Option) (*StartAssociationsOnceOutput, error) {
	req, out := c.StartAssociationsOnceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAutomationExecution = "StartAutomationExecution"

// StartAutomationExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartAutomationExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAutomationExecution for more information on using the StartAutomationExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAutomationExecutionRequest method.
//	req, resp := client.StartAutomationExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution
func (c *SSM) StartAutomationExecutionRequest(input *StartAutomationExecutionInput) (req *request.Request, output *StartAutomationExecutionOutput) {
	op := &request.Operation{
		Name:       opStartAutomationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAutomationExecutionInput{}
	}

	output = &StartAutomationExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAutomationExecution API operation for Amazon Simple Systems Management Service.
//
// Initiates execution of an Automation runbook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation StartAutomationExecution for usage and error information.
//
// Returned Error Types:
//
//   - AutomationDefinitionNotFoundException
//     An Automation runbook with the specified name couldn't be found.
//
//   - InvalidAutomationExecutionParametersException
//     The supplied parameters for invoking the specified Automation runbook are
//     incorrect. For example, they may not match the set of parameters permitted
//     for the specified Automation document.
//
//   - AutomationExecutionLimitExceededException
//     The number of simultaneously running Automation executions exceeded the allowable
//     limit.
//
//   - AutomationDefinitionVersionNotFoundException
//     An Automation runbook with the specified name and version couldn't be found.
//
//   - IdempotentParameterMismatch
//     Error returned when an idempotent operation is retried and the parameters
//     don't match the original call to the API with the same idempotency token.
//
//   - InvalidTarget
//     The target isn't valid or doesn't exist. It might not be configured for Systems
//     Manager or you might not have permission to perform the operation.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution
func (c *SSM) StartAutomationExecution(input *StartAutomationExecutionInput) (*StartAutomationExecutionOutput, error) {
	req, out := c.StartAutomationExecutionRequest(input)
	return out, req.Send()
}

// StartAutomationExecutionWithContext is the same as StartAutomationExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartAutomationExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartAutomationExecutionWithContext(ctx aws.Context, input *StartAutomationExecutionInput, opts ...request.Option) (*StartAutomationExecutionOutput, error) {
	req, out := c.StartAutomationExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartChangeRequestExecution = "StartChangeRequestExecution"

// StartChangeRequestExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartChangeRequestExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChangeRequestExecution for more information on using the StartChangeRequestExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartChangeRequestExecutionRequest method.
//	req, resp := client.StartChangeRequestExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartChangeRequestExecution
func (c *SSM) StartChangeRequestExecutionRequest(input *StartChangeRequestExecutionInput) (req *request.Request, output *StartChangeRequestExecutionOutput) {
	op := &request.Operation{
		Name:       opStartChangeRequestExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartChangeRequestExecutionInput{}
	}

	output = &StartChangeRequestExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartChangeRequestExecution API operation for Amazon Simple Systems Management Service.
//
// Creates a change request for Change Manager. The Automation runbooks specified
// in the change request run only after all required approvals for the change
// request have been received.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation StartChangeRequestExecution for usage and error information.
//
// Returned Error Types:
//
//   - AutomationDefinitionNotFoundException
//     An Automation runbook with the specified name couldn't be found.
//
//   - InvalidAutomationExecutionParametersException
//     The supplied parameters for invoking the specified Automation runbook are
//     incorrect. For example, they may not match the set of parameters permitted
//     for the specified Automation document.
//
//   - AutomationExecutionLimitExceededException
//     The number of simultaneously running Automation executions exceeded the allowable
//     limit.
//
//   - AutomationDefinitionVersionNotFoundException
//     An Automation runbook with the specified name and version couldn't be found.
//
//   - IdempotentParameterMismatch
//     Error returned when an idempotent operation is retried and the parameters
//     don't match the original call to the API with the same idempotency token.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - AutomationDefinitionNotApprovedException
//     Indicates that the Change Manager change template used in the change request
//     was rejected or is still in a pending state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartChangeRequestExecution
func (c *SSM) StartChangeRequestExecution(input *StartChangeRequestExecutionInput) (*StartChangeRequestExecutionOutput, error) {
	req, out := c.StartChangeRequestExecutionRequest(input)
	return out, req.Send()
}

// StartChangeRequestExecutionWithContext is the same as StartChangeRequestExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartChangeRequestExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartChangeRequestExecutionWithContext(ctx aws.Context, input *StartChangeRequestExecutionInput, opts ...request.Option) (*StartChangeRequestExecutionOutput, error) {
	req, out := c.StartChangeRequestExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExecutionPreview = "StartExecutionPreview"

// StartExecutionPreviewRequest generates a "aws/request.Request" representing the
// client's request for the StartExecutionPreview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExecutionPreview for more information on using the StartExecutionPreview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartExecutionPreviewRequest method.
//	req, resp := client.StartExecutionPreviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartExecutionPreview
func (c *SSM) StartExecutionPreviewRequest(input *StartExecutionPreviewInput) (req *request.Request, output *StartExecutionPreviewOutput) {
	op := &request.Operation{
		Name:       opStartExecutionPreview,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExecutionPreviewInput{}
	}

	output = &StartExecutionPreviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExecutionPreview API operation for Amazon Simple Systems Management Service.
//
// Initiates the process of creating a preview showing the effects that running
// a specified Automation runbook would have on the targeted resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation StartExecutionPreview for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartExecutionPreview
func (c *SSM) StartExecutionPreview(input *StartExecutionPreviewInput) (*StartExecutionPreviewOutput, error) {
	req, out := c.StartExecutionPreviewRequest(input)
	return out, req.Send()
}

// StartExecutionPreviewWithContext is the same as StartExecutionPreview with the addition of
// the ability to pass a context and additional request options.
//
// See StartExecutionPreview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartExecutionPreviewWithContext(ctx aws.Context, input *StartExecutionPreviewInput, opts ...request.Option) (*StartExecutionPreviewOutput, error) {
	req, out := c.StartExecutionPreviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSession = "StartSession"

// StartSessionRequest generates a "aws/request.Request" representing the
// client's request for the StartSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSession for more information on using the StartSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSessionRequest method.
//	req, resp := client.StartSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSession
func (c *SSM) StartSessionRequest(input *StartSessionInput) (req *request.Request, output *StartSessionOutput) {
	op := &request.Operation{
		Name:       opStartSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSessionInput{}
	}

	output = &StartSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSession API operation for Amazon Simple Systems Management Service.
//
// Initiates a connection to a target (for example, a managed node) for a Session
// Manager session. Returns a URL and token that can be used to open a WebSocket
// connection for sending input and receiving outputs.
//
// Amazon Web Services CLI usage: start-session is an interactive command that
// requires the Session Manager plugin to be installed on the client machine
// making the call. For information, see Install the Session Manager plugin
// for the Amazon Web Services CLI (https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently
// supported by Amazon Web Services Tools for PowerShell on Windows local machines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation StartSession for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
//   - TargetNotConnected
//     The specified target managed node for the session isn't fully configured
//     for use with Session Manager. For more information, see Setting up Session
//     Manager (https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html)
//     in the Amazon Web Services Systems Manager User Guide. This error is also
//     returned if you attempt to start a session on a managed node that is located
//     in a different account or Region
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSession
func (c *SSM) StartSession(input *StartSessionInput) (*StartSessionOutput, error) {
	req, out := c.StartSessionRequest(input)
	return out, req.Send()
}

// StartSessionWithContext is the same as StartSession with the addition of
// the ability to pass a context and additional request options.
//
// See StartSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartSessionWithContext(ctx aws.Context, input *StartSessionInput, opts ...request.Option) (*StartSessionOutput, error) {
	req, out := c.StartSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopAutomationExecution = "StopAutomationExecution"

// StopAutomationExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopAutomationExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopAutomationExecution for more information on using the StopAutomationExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopAutomationExecutionRequest method.
//	req, resp := client.StopAutomationExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution
func (c *SSM) StopAutomationExecutionRequest(input *StopAutomationExecutionInput) (req *request.Request, output *StopAutomationExecutionOutput) {
	op := &request.Operation{
		Name:       opStopAutomationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAutomationExecutionInput{}
	}

	output = &StopAutomationExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopAutomationExecution API operation for Amazon Simple Systems Management Service.
//
// Stop an Automation that is currently running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation StopAutomationExecution for usage and error information.
//
// Returned Error Types:
//
//   - AutomationExecutionNotFoundException
//     There is no automation execution information for the requested automation
//     execution ID.
//
//   - InvalidAutomationStatusUpdateException
//     The specified update status operation isn't valid.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution
func (c *SSM) StopAutomationExecution(input *StopAutomationExecutionInput) (*StopAutomationExecutionOutput, error) {
	req, out := c.StopAutomationExecutionRequest(input)
	return out, req.Send()
}

// StopAutomationExecutionWithContext is the same as StopAutomationExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopAutomationExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StopAutomationExecutionWithContext(ctx aws.Context, input *StopAutomationExecutionInput, opts ...request.Option) (*StopAutomationExecutionOutput, error) {
	req, out := c.StopAutomationExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateSession = "TerminateSession"

// TerminateSessionRequest generates a "aws/request.Request" representing the
// client's request for the TerminateSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateSession for more information on using the TerminateSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TerminateSessionRequest method.
//	req, resp := client.TerminateSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/TerminateSession
func (c *SSM) TerminateSessionRequest(input *TerminateSessionInput) (req *request.Request, output *TerminateSessionOutput) {
	op := &request.Operation{
		Name:       opTerminateSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateSessionInput{}
	}

	output = &TerminateSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateSession API operation for Amazon Simple Systems Management Service.
//
// Permanently ends a session and closes the data connection between the Session
// Manager client and SSM Agent on the managed node. A terminated session can't
// be resumed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation TerminateSession for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/TerminateSession
func (c *SSM) TerminateSession(input *TerminateSessionInput) (*TerminateSessionOutput, error) {
	req, out := c.TerminateSessionRequest(input)
	return out, req.Send()
}

// TerminateSessionWithContext is the same as TerminateSession with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) TerminateSessionWithContext(ctx aws.Context, input *TerminateSessionInput, opts ...request.Option) (*TerminateSessionOutput, error) {
	req, out := c.TerminateSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnlabelParameterVersion = "UnlabelParameterVersion"

// UnlabelParameterVersionRequest generates a "aws/request.Request" representing the
// client's request for the UnlabelParameterVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnlabelParameterVersion for more information on using the UnlabelParameterVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UnlabelParameterVersionRequest method.
//	req, resp := client.UnlabelParameterVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UnlabelParameterVersion
func (c *SSM) UnlabelParameterVersionRequest(input *UnlabelParameterVersionInput) (req *request.Request, output *UnlabelParameterVersionOutput) {
	op := &request.Operation{
		Name:       opUnlabelParameterVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnlabelParameterVersionInput{}
	}

	output = &UnlabelParameterVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnlabelParameterVersion API operation for Amazon Simple Systems Management Service.
//
// Remove a label or labels from a parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UnlabelParameterVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
//   - ParameterNotFound
//     The parameter couldn't be found. Verify the name and try again.
//
//   - ParameterVersionNotFound
//     The specified parameter version wasn't found. Verify the parameter name and
//     version, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UnlabelParameterVersion
func (c *SSM) UnlabelParameterVersion(input *UnlabelParameterVersionInput) (*UnlabelParameterVersionOutput, error) {
	req, out := c.UnlabelParameterVersionRequest(input)
	return out, req.Send()
}

// UnlabelParameterVersionWithContext is the same as UnlabelParameterVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UnlabelParameterVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UnlabelParameterVersionWithContext(ctx aws.Context, input *UnlabelParameterVersionInput, opts ...request.Option) (*UnlabelParameterVersionOutput, error) {
	req, out := c.UnlabelParameterVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnlockServiceLinkedRole = "UnlockServiceLinkedRole"

// UnlockServiceLinkedRoleRequest generates a "aws/request.Request" representing the
// client's request for the UnlockServiceLinkedRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnlockServiceLinkedRole for more information on using the UnlockServiceLinkedRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UnlockServiceLinkedRoleRequest method.
//	req, resp := client.UnlockServiceLinkedRoleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UnlockServiceLinkedRole
func (c *SSM) UnlockServiceLinkedRoleRequest(input *UnlockServiceLinkedRoleInput) (req *request.Request, output *UnlockServiceLinkedRoleOutput) {
	op := &request.Operation{
		Name:       opUnlockServiceLinkedRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnlockServiceLinkedRoleInput{}
	}

	output = &UnlockServiceLinkedRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnlockServiceLinkedRole API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UnlockServiceLinkedRole for usage and error information.
//
// Returned Error Types:
//
//   - ServiceLinkedRoleLockServiceException
//
//   - ServiceLinkedRoleLockClientException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UnlockServiceLinkedRole
func (c *SSM) UnlockServiceLinkedRole(input *UnlockServiceLinkedRoleInput) (*UnlockServiceLinkedRoleOutput, error) {
	req, out := c.UnlockServiceLinkedRoleRequest(input)
	return out, req.Send()
}

// UnlockServiceLinkedRoleWithContext is the same as UnlockServiceLinkedRole with the addition of
// the ability to pass a context and additional request options.
//
// See UnlockServiceLinkedRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UnlockServiceLinkedRoleWithContext(ctx aws.Context, input *UnlockServiceLinkedRoleInput, opts ...request.Option) (*UnlockServiceLinkedRoleOutput, error) {
	req, out := c.UnlockServiceLinkedRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssociation = "UpdateAssociation"

// UpdateAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssociation for more information on using the UpdateAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAssociationRequest method.
//	req, resp := client.UpdateAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation
func (c *SSM) UpdateAssociationRequest(input *UpdateAssociationInput) (req *request.Request, output *UpdateAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssociationInput{}
	}

	output = &UpdateAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssociation API operation for Amazon Simple Systems Management Service.
//
// Updates an association. You can update the association name and version,
// the document version, schedule, parameters, and Amazon Simple Storage Service
// (Amazon S3) output. When you call UpdateAssociation, the system removes all
// optional parameters from the request and overwrites the association with
// null values for those parameters. This is by design. You must specify all
// optional parameters in the call, even if you are not changing the parameters.
// This includes the Name parameter. Before calling this API action, we recommend
// that you call the DescribeAssociation API operation and make a note of all
// optional parameters required for your UpdateAssociation call.
//
// In order to call this API operation, a user, group, or role must be granted
// permission to call the DescribeAssociation API operation. If you don't have
// permission to call DescribeAssociation, then you receive the following error:
// An error occurred (AccessDeniedException) when calling the UpdateAssociation
// operation: User: <user_arn> isn't authorized to perform: ssm:DescribeAssociation
// on resource: <resource_arn>
//
// When you update an association, the association immediately runs against
// the specified targets. You can add the ApplyOnlyAtCronInterval parameter
// to run the association during the next schedule run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateAssociation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidSchedule
//     The schedule is invalid. Verify your cron or rate expression and try again.
//
//   - InvalidParameters
//     You must specify values for all required parameters in the Amazon Web Services
//     Systems Manager document (SSM document). You can only supply values to parameters
//     defined in the SSM document.
//
//   - InvalidOutputLocation
//     The output location isn't valid or doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
//   - InvalidUpdate
//     The update isn't valid.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidTarget
//     The target isn't valid or doesn't exist. It might not be configured for Systems
//     Manager or you might not have permission to perform the operation.
//
//   - InvalidAssociationVersion
//     The version you specified isn't valid. Use ListAssociationVersions to view
//     all versions of an association according to the association ID. Or, use the
//     $LATEST parameter to view the latest version of the association.
//
//   - AssociationVersionLimitExceeded
//     You have reached the maximum number versions allowed for an association.
//     Each association has a limit of 1,000 versions.
//
//   - InvalidTargetMaps
//     TargetMap parameter isn't valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation
func (c *SSM) UpdateAssociation(input *UpdateAssociationInput) (*UpdateAssociationOutput, error) {
	req, out := c.UpdateAssociationRequest(input)
	return out, req.Send()
}

// UpdateAssociationWithContext is the same as UpdateAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateAssociationWithContext(ctx aws.Context, input *UpdateAssociationInput, opts ...request.Option) (*UpdateAssociationOutput, error) {
	req, out := c.UpdateAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssociationStatus = "UpdateAssociationStatus"

// UpdateAssociationStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssociationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssociationStatus for more information on using the UpdateAssociationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAssociationStatusRequest method.
//	req, resp := client.UpdateAssociationStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus
func (c *SSM) UpdateAssociationStatusRequest(input *UpdateAssociationStatusInput) (req *request.Request, output *UpdateAssociationStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssociationStatusInput{}
	}

	output = &UpdateAssociationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssociationStatus API operation for Amazon Simple Systems Management Service.
//
// Updates the status of the Amazon Web Services Systems Manager document (SSM
// document) associated with the specified managed node.
//
// UpdateAssociationStatus is primarily used by the Amazon Web Services Systems
// Manager Agent (SSM Agent) to report status updates about your associations
// and is only used for associations created with the InstanceId legacy parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateAssociationStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
//   - StatusUnchanged
//     The updated status is the same as the current status.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus
func (c *SSM) UpdateAssociationStatus(input *UpdateAssociationStatusInput) (*UpdateAssociationStatusOutput, error) {
	req, out := c.UpdateAssociationStatusRequest(input)
	return out, req.Send()
}

// UpdateAssociationStatusWithContext is the same as UpdateAssociationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssociationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateAssociationStatusWithContext(ctx aws.Context, input *UpdateAssociationStatusInput, opts ...request.Option) (*UpdateAssociationStatusOutput, error) {
	req, out := c.UpdateAssociationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocument = "UpdateDocument"

// UpdateDocumentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocument for more information on using the UpdateDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDocumentRequest method.
//	req, resp := client.UpdateDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument
func (c *SSM) UpdateDocumentRequest(input *UpdateDocumentInput) (req *request.Request, output *UpdateDocumentOutput) {
	op := &request.Operation{
		Name:       opUpdateDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDocumentInput{}
	}

	output = &UpdateDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDocument API operation for Amazon Simple Systems Management Service.
//
// Updates one or more values for an SSM document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateDocument for usage and error information.
//
// Returned Error Types:
//
//   - MaxDocumentSizeExceeded
//     The size limit of a document is 64 KB.
//
//   - DocumentVersionLimitExceeded
//     The document has too many versions. Delete one or more document versions
//     and try again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - DuplicateDocumentContent
//     The content of the association document matches another document. Change
//     the content of the document and try again.
//
//   - DuplicateDocumentVersionName
//     The version name has already been used in this document. Specify a different
//     version name, and then try again.
//
//   - InvalidDocumentContent
//     The content for the document isn't valid.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - InvalidDocumentSchemaVersion
//     The version of the document schema isn't supported.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentOperation
//     You attempted to delete a document while it is still shared. You must stop
//     sharing the document before you can delete it.
//
//   - AutomationDefinitionNotFoundException
//     An Automation runbook with the specified name couldn't be found.
//
//   - AutomationDefinitionVersionNotFoundException
//     An Automation runbook with the specified name and version couldn't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument
func (c *SSM) UpdateDocument(input *UpdateDocumentInput) (*UpdateDocumentOutput, error) {
	req, out := c.UpdateDocumentRequest(input)
	return out, req.Send()
}

// UpdateDocumentWithContext is the same as UpdateDocument with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateDocumentWithContext(ctx aws.Context, input *UpdateDocumentInput, opts ...request.Option) (*UpdateDocumentOutput, error) {
	req, out := c.UpdateDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocumentDefaultVersion = "UpdateDocumentDefaultVersion"

// UpdateDocumentDefaultVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocumentDefaultVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocumentDefaultVersion for more information on using the UpdateDocumentDefaultVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDocumentDefaultVersionRequest method.
//	req, resp := client.UpdateDocumentDefaultVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion
func (c *SSM) UpdateDocumentDefaultVersionRequest(input *UpdateDocumentDefaultVersionInput) (req *request.Request, output *UpdateDocumentDefaultVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDocumentDefaultVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDocumentDefaultVersionInput{}
	}

	output = &UpdateDocumentDefaultVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDocumentDefaultVersion API operation for Amazon Simple Systems Management Service.
//
// Set the default version of a document.
//
// If you change a document version for a State Manager association, Systems
// Manager immediately runs the association unless you previously specifed the
// apply-only-at-cron-interval parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateDocumentDefaultVersion for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - InvalidDocumentSchemaVersion
//     The version of the document schema isn't supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion
func (c *SSM) UpdateDocumentDefaultVersion(input *UpdateDocumentDefaultVersionInput) (*UpdateDocumentDefaultVersionOutput, error) {
	req, out := c.UpdateDocumentDefaultVersionRequest(input)
	return out, req.Send()
}

// UpdateDocumentDefaultVersionWithContext is the same as UpdateDocumentDefaultVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocumentDefaultVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateDocumentDefaultVersionWithContext(ctx aws.Context, input *UpdateDocumentDefaultVersionInput, opts ...request.Option) (*UpdateDocumentDefaultVersionOutput, error) {
	req, out := c.UpdateDocumentDefaultVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocumentMetadata = "UpdateDocumentMetadata"

// UpdateDocumentMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocumentMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocumentMetadata for more information on using the UpdateDocumentMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDocumentMetadataRequest method.
//	req, resp := client.UpdateDocumentMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentMetadata
func (c *SSM) UpdateDocumentMetadataRequest(input *UpdateDocumentMetadataInput) (req *request.Request, output *UpdateDocumentMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateDocumentMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDocumentMetadataInput{}
	}

	output = &UpdateDocumentMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDocumentMetadata API operation for Amazon Simple Systems Management Service.
//
// Updates information related to approval reviews for a specific version of
// a change template in Change Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateDocumentMetadata for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidDocument
//     The specified SSM document doesn't exist.
//
//   - InvalidDocumentOperation
//     You attempted to delete a document while it is still shared. You must stop
//     sharing the document before you can delete it.
//
//   - InvalidDocumentVersion
//     The document version isn't valid or doesn't exist.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentMetadata
func (c *SSM) UpdateDocumentMetadata(input *UpdateDocumentMetadataInput) (*UpdateDocumentMetadataOutput, error) {
	req, out := c.UpdateDocumentMetadataRequest(input)
	return out, req.Send()
}

// UpdateDocumentMetadataWithContext is the same as UpdateDocumentMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocumentMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateDocumentMetadataWithContext(ctx aws.Context, input *UpdateDocumentMetadataInput, opts ...request.Option) (*UpdateDocumentMetadataOutput, error) {
	req, out := c.UpdateDocumentMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstanceAssociationStatus = "UpdateInstanceAssociationStatus"

// UpdateInstanceAssociationStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstanceAssociationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstanceAssociationStatus for more information on using the UpdateInstanceAssociationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInstanceAssociationStatusRequest method.
//	req, resp := client.UpdateInstanceAssociationStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateInstanceAssociationStatus
func (c *SSM) UpdateInstanceAssociationStatusRequest(input *UpdateInstanceAssociationStatusInput) (req *request.Request, output *UpdateInstanceAssociationStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateInstanceAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceAssociationStatusInput{}
	}

	output = &UpdateInstanceAssociationStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstanceAssociationStatus API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateInstanceAssociationStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - AssociationDoesNotExist
//     The specified association doesn't exist.
//
//   - InvalidAssociationVersion
//     The version you specified isn't valid. Use ListAssociationVersions to view
//     all versions of an association according to the association ID. Or, use the
//     $LATEST parameter to view the latest version of the association.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateInstanceAssociationStatus
func (c *SSM) UpdateInstanceAssociationStatus(input *UpdateInstanceAssociationStatusInput) (*UpdateInstanceAssociationStatusOutput, error) {
	req, out := c.UpdateInstanceAssociationStatusRequest(input)
	return out, req.Send()
}

// UpdateInstanceAssociationStatusWithContext is the same as UpdateInstanceAssociationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstanceAssociationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateInstanceAssociationStatusWithContext(ctx aws.Context, input *UpdateInstanceAssociationStatusInput, opts ...request.Option) (*UpdateInstanceAssociationStatusOutput, error) {
	req, out := c.UpdateInstanceAssociationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstanceInformation = "UpdateInstanceInformation"

// UpdateInstanceInformationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstanceInformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstanceInformation for more information on using the UpdateInstanceInformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInstanceInformationRequest method.
//	req, resp := client.UpdateInstanceInformationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateInstanceInformation
func (c *SSM) UpdateInstanceInformationRequest(input *UpdateInstanceInformationInput) (req *request.Request, output *UpdateInstanceInformationOutput) {
	op := &request.Operation{
		Name:       opUpdateInstanceInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceInformationInput{}
	}

	output = &UpdateInstanceInformationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstanceInformation API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateInstanceInformation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - InvalidInstanceInformationValue
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateInstanceInformation
func (c *SSM) UpdateInstanceInformation(input *UpdateInstanceInformationInput) (*UpdateInstanceInformationOutput, error) {
	req, out := c.UpdateInstanceInformationRequest(input)
	return out, req.Send()
}

// UpdateInstanceInformationWithContext is the same as UpdateInstanceInformation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstanceInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateInstanceInformationWithContext(ctx aws.Context, input *UpdateInstanceInformationInput, opts ...request.Option) (*UpdateInstanceInformationOutput, error) {
	req, out := c.UpdateInstanceInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMaintenanceWindow = "UpdateMaintenanceWindow"

// UpdateMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMaintenanceWindow for more information on using the UpdateMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMaintenanceWindowRequest method.
//	req, resp := client.UpdateMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow
func (c *SSM) UpdateMaintenanceWindowRequest(input *UpdateMaintenanceWindowInput) (req *request.Request, output *UpdateMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceWindowInput{}
	}

	output = &UpdateMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMaintenanceWindow API operation for Amazon Simple Systems Management Service.
//
// Updates an existing maintenance window. Only specified parameters are modified.
//
// The value you specify for Duration determines the specific end time for the
// maintenance window based on the time it begins. No maintenance window tasks
// are permitted to start after the resulting endtime minus the number of hours
// you specify for Cutoff. For example, if the maintenance window starts at
// 3 PM, the duration is three hours, and the value you specify for Cutoff is
// one hour, no maintenance window tasks can start after 5 PM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow
func (c *SSM) UpdateMaintenanceWindow(input *UpdateMaintenanceWindowInput) (*UpdateMaintenanceWindowOutput, error) {
	req, out := c.UpdateMaintenanceWindowRequest(input)
	return out, req.Send()
}

// UpdateMaintenanceWindowWithContext is the same as UpdateMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateMaintenanceWindowWithContext(ctx aws.Context, input *UpdateMaintenanceWindowInput, opts ...request.Option) (*UpdateMaintenanceWindowOutput, error) {
	req, out := c.UpdateMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMaintenanceWindowTarget = "UpdateMaintenanceWindowTarget"

// UpdateMaintenanceWindowTargetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceWindowTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMaintenanceWindowTarget for more information on using the UpdateMaintenanceWindowTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMaintenanceWindowTargetRequest method.
//	req, resp := client.UpdateMaintenanceWindowTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget
func (c *SSM) UpdateMaintenanceWindowTargetRequest(input *UpdateMaintenanceWindowTargetInput) (req *request.Request, output *UpdateMaintenanceWindowTargetOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceWindowTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceWindowTargetInput{}
	}

	output = &UpdateMaintenanceWindowTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMaintenanceWindowTarget API operation for Amazon Simple Systems Management Service.
//
// Modifies the target of an existing maintenance window. You can change the
// following:
//
//   - Name
//
//   - Description
//
//   - Owner
//
//   - IDs for an ID target
//
//   - Tags for a Tag target
//
//   - From any supported tag type to another. The three supported tag types
//     are ID target, Tag target, and resource group. For more information, see
//     Target.
//
// If a parameter is null, then the corresponding field isn't modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateMaintenanceWindowTarget for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget
func (c *SSM) UpdateMaintenanceWindowTarget(input *UpdateMaintenanceWindowTargetInput) (*UpdateMaintenanceWindowTargetOutput, error) {
	req, out := c.UpdateMaintenanceWindowTargetRequest(input)
	return out, req.Send()
}

// UpdateMaintenanceWindowTargetWithContext is the same as UpdateMaintenanceWindowTarget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMaintenanceWindowTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateMaintenanceWindowTargetWithContext(ctx aws.Context, input *UpdateMaintenanceWindowTargetInput, opts ...request.Option) (*UpdateMaintenanceWindowTargetOutput, error) {
	req, out := c.UpdateMaintenanceWindowTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMaintenanceWindowTask = "UpdateMaintenanceWindowTask"

// UpdateMaintenanceWindowTaskRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceWindowTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMaintenanceWindowTask for more information on using the UpdateMaintenanceWindowTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMaintenanceWindowTaskRequest method.
//	req, resp := client.UpdateMaintenanceWindowTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTask
func (c *SSM) UpdateMaintenanceWindowTaskRequest(input *UpdateMaintenanceWindowTaskInput) (req *request.Request, output *UpdateMaintenanceWindowTaskOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceWindowTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceWindowTaskInput{}
	}

	output = &UpdateMaintenanceWindowTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMaintenanceWindowTask API operation for Amazon Simple Systems Management Service.
//
// Modifies a task assigned to a maintenance window. You can't change the task
// type, but you can change the following values:
//
//   - TaskARN. For example, you can change a RUN_COMMAND task from AWS-RunPowerShellScript
//     to AWS-RunShellScript.
//
//   - ServiceRoleArn
//
//   - TaskInvocationParameters
//
//   - Priority
//
//   - MaxConcurrency
//
//   - MaxErrors
//
// One or more targets must be specified for maintenance window Run Command-type
// tasks. Depending on the task, targets are optional for other maintenance
// window task types (Automation, Lambda, and Step Functions). For more information
// about running tasks that don't specify targets, see Registering maintenance
// window tasks without targets (https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// If the value for a parameter in UpdateMaintenanceWindowTask is null, then
// the corresponding field isn't modified. If you set Replace to true, then
// all fields required by the RegisterTaskWithMaintenanceWindow operation are
// required for this request. Optional fields that aren't specified are set
// to null.
//
// When you update a maintenance window task that has options specified in TaskInvocationParameters,
// you must provide again all the TaskInvocationParameters values that you want
// to retain. The values you don't specify again are removed. For example, suppose
// that when you registered a Run Command task, you specified TaskInvocationParameters
// values for Comment, NotificationConfig, and OutputS3BucketName. If you update
// the maintenance window task and specify only a different OutputS3BucketName
// value, the values for Comment and NotificationConfig are removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateMaintenanceWindowTask for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTask
func (c *SSM) UpdateMaintenanceWindowTask(input *UpdateMaintenanceWindowTaskInput) (*UpdateMaintenanceWindowTaskOutput, error) {
	req, out := c.UpdateMaintenanceWindowTaskRequest(input)
	return out, req.Send()
}

// UpdateMaintenanceWindowTaskWithContext is the same as UpdateMaintenanceWindowTask with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMaintenanceWindowTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateMaintenanceWindowTaskWithContext(ctx aws.Context, input *UpdateMaintenanceWindowTaskInput, opts ...request.Option) (*UpdateMaintenanceWindowTaskOutput, error) {
	req, out := c.UpdateMaintenanceWindowTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateManagedInstancePublicKey = "UpdateManagedInstancePublicKey"

// UpdateManagedInstancePublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateManagedInstancePublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateManagedInstancePublicKey for more information on using the UpdateManagedInstancePublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateManagedInstancePublicKeyRequest method.
//	req, resp := client.UpdateManagedInstancePublicKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstancePublicKey
func (c *SSM) UpdateManagedInstancePublicKeyRequest(input *UpdateManagedInstancePublicKeyInput) (req *request.Request, output *UpdateManagedInstancePublicKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateManagedInstancePublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateManagedInstancePublicKeyInput{}
	}

	output = &UpdateManagedInstancePublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateManagedInstancePublicKey API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateManagedInstancePublicKey for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - PublicKeyAlreadyRegistered
//
//   - InvalidPublicKey
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstancePublicKey
func (c *SSM) UpdateManagedInstancePublicKey(input *UpdateManagedInstancePublicKeyInput) (*UpdateManagedInstancePublicKeyOutput, error) {
	req, out := c.UpdateManagedInstancePublicKeyRequest(input)
	return out, req.Send()
}

// UpdateManagedInstancePublicKeyWithContext is the same as UpdateManagedInstancePublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateManagedInstancePublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateManagedInstancePublicKeyWithContext(ctx aws.Context, input *UpdateManagedInstancePublicKeyInput, opts ...request.Option) (*UpdateManagedInstancePublicKeyOutput, error) {
	req, out := c.UpdateManagedInstancePublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateManagedInstanceRole = "UpdateManagedInstanceRole"

// UpdateManagedInstanceRoleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateManagedInstanceRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateManagedInstanceRole for more information on using the UpdateManagedInstanceRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateManagedInstanceRoleRequest method.
//	req, resp := client.UpdateManagedInstanceRoleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole
func (c *SSM) UpdateManagedInstanceRoleRequest(input *UpdateManagedInstanceRoleInput) (req *request.Request, output *UpdateManagedInstanceRoleOutput) {
	op := &request.Operation{
		Name:       opUpdateManagedInstanceRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateManagedInstanceRoleInput{}
	}

	output = &UpdateManagedInstanceRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateManagedInstanceRole API operation for Amazon Simple Systems Management Service.
//
// Changes the Identity and Access Management (IAM) role that is assigned to
// the on-premises server, edge device, or virtual machines (VM). IAM roles
// are first assigned to these hybrid nodes during the activation process. For
// more information, see CreateActivation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateManagedInstanceRole for usage and error information.
//
// Returned Error Types:
//
//   - InvalidInstanceId
//     The following problems can cause this exception:
//
//   - You don't have permission to access the managed node.
//
//   - Amazon Web Services Systems Manager Agent (SSM Agent) isn't running.
//     Verify that SSM Agent is running.
//
//   - SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM
//     Agent.
//
//   - The managed node isn't in a valid state. Valid states are: Running,
//     Pending, Stopped, and Stopping. Invalid states are: Shutting-down and
//     Terminated.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole
func (c *SSM) UpdateManagedInstanceRole(input *UpdateManagedInstanceRoleInput) (*UpdateManagedInstanceRoleOutput, error) {
	req, out := c.UpdateManagedInstanceRoleRequest(input)
	return out, req.Send()
}

// UpdateManagedInstanceRoleWithContext is the same as UpdateManagedInstanceRole with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateManagedInstanceRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateManagedInstanceRoleWithContext(ctx aws.Context, input *UpdateManagedInstanceRoleInput, opts ...request.Option) (*UpdateManagedInstanceRoleOutput, error) {
	req, out := c.UpdateManagedInstanceRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOpsItem = "UpdateOpsItem"

// UpdateOpsItemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOpsItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOpsItem for more information on using the UpdateOpsItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOpsItemRequest method.
//	req, resp := client.UpdateOpsItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsItem
func (c *SSM) UpdateOpsItemRequest(input *UpdateOpsItemInput) (req *request.Request, output *UpdateOpsItemOutput) {
	op := &request.Operation{
		Name:       opUpdateOpsItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOpsItemInput{}
	}

	output = &UpdateOpsItemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOpsItem API operation for Amazon Simple Systems Management Service.
//
// Edit or change an OpsItem. You must have permission in Identity and Access
// Management (IAM) to update an OpsItem. For more information, see Set up OpsCenter
// (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Operations engineers and IT professionals use Amazon Web Services Systems
// Manager OpsCenter to view, investigate, and remediate operational issues
// impacting the performance and health of their Amazon Web Services resources.
// For more information, see Amazon Web Services Systems Manager OpsCenter (https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
// in the Amazon Web Services Systems Manager User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateOpsItem for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - OpsItemNotFoundException
//     The specified OpsItem ID doesn't exist. Verify the ID and try again.
//
//   - OpsItemConflictException
//     The specified OpsItem is in the process of being deleted.
//
//   - OpsCenterInvalidArgumentException
//
//   - OpsItemAlreadyExistsException
//     The OpsItem already exists.
//
//   - OpsItemLimitExceededException
//     The request caused OpsItems to exceed one or more quotas.
//
//   - OpsItemInvalidParameterException
//     A specified parameter argument isn't valid. Verify the available arguments
//     and try again.
//
//   - OpsItemAccessDeniedException
//     You don't have permission to view OpsItems in the specified account. Verify
//     that your account is configured either as a Systems Manager delegated administrator
//     or that you are logged into the Organizations management account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsItem
func (c *SSM) UpdateOpsItem(input *UpdateOpsItemInput) (*UpdateOpsItemOutput, error) {
	req, out := c.UpdateOpsItemRequest(input)
	return out, req.Send()
}

// UpdateOpsItemWithContext is the same as UpdateOpsItem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOpsItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateOpsItemWithContext(ctx aws.Context, input *UpdateOpsItemInput, opts ...request.Option) (*UpdateOpsItemOutput, error) {
	req, out := c.UpdateOpsItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOpsMetadata = "UpdateOpsMetadata"

// UpdateOpsMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOpsMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOpsMetadata for more information on using the UpdateOpsMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOpsMetadataRequest method.
//	req, resp := client.UpdateOpsMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsMetadata
func (c *SSM) UpdateOpsMetadataRequest(input *UpdateOpsMetadataInput) (req *request.Request, output *UpdateOpsMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateOpsMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOpsMetadataInput{}
	}

	output = &UpdateOpsMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateOpsMetadata API operation for Amazon Simple Systems Management Service.
//
// Amazon Web Services Systems Manager calls this API operation when you edit
// OpsMetadata in Application Manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateOpsMetadata for usage and error information.
//
// Returned Error Types:
//
//   - OpsMetadataNotFoundException
//     The OpsMetadata object doesn't exist.
//
//   - OpsMetadataInvalidArgumentException
//     One of the arguments passed is invalid.
//
//   - OpsMetadataKeyLimitExceededException
//     The OpsMetadata object exceeds the maximum number of OpsMetadata keys that
//     you can assign to an application in Application Manager.
//
//   - OpsMetadataTooManyUpdatesException
//     The system is processing too many concurrent updates. Wait a few moments
//     and try again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsMetadata
func (c *SSM) UpdateOpsMetadata(input *UpdateOpsMetadataInput) (*UpdateOpsMetadataOutput, error) {
	req, out := c.UpdateOpsMetadataRequest(input)
	return out, req.Send()
}

// UpdateOpsMetadataWithContext is the same as UpdateOpsMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOpsMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateOpsMetadataWithContext(ctx aws.Context, input *UpdateOpsMetadataInput, opts ...request.Option) (*UpdateOpsMetadataOutput, error) {
	req, out := c.UpdateOpsMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateParameterDataInternal = "UpdateParameterDataInternal"

// UpdateParameterDataInternalRequest generates a "aws/request.Request" representing the
// client's request for the UpdateParameterDataInternal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateParameterDataInternal for more information on using the UpdateParameterDataInternal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateParameterDataInternalRequest method.
//	req, resp := client.UpdateParameterDataInternalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateParameterDataInternal
func (c *SSM) UpdateParameterDataInternalRequest(input *UpdateParameterDataInternalInput) (req *request.Request, output *UpdateParameterDataInternalOutput) {
	op := &request.Operation{
		Name:       opUpdateParameterDataInternal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateParameterDataInternalInput{}
	}

	output = &UpdateParameterDataInternalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateParameterDataInternal API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateParameterDataInternal for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateParameterDataInternal
func (c *SSM) UpdateParameterDataInternal(input *UpdateParameterDataInternalInput) (*UpdateParameterDataInternalOutput, error) {
	req, out := c.UpdateParameterDataInternalRequest(input)
	return out, req.Send()
}

// UpdateParameterDataInternalWithContext is the same as UpdateParameterDataInternal with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateParameterDataInternal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateParameterDataInternalWithContext(ctx aws.Context, input *UpdateParameterDataInternalInput, opts ...request.Option) (*UpdateParameterDataInternalOutput, error) {
	req, out := c.UpdateParameterDataInternalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePatchBaseline = "UpdatePatchBaseline"

// UpdatePatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePatchBaseline for more information on using the UpdatePatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePatchBaselineRequest method.
//	req, resp := client.UpdatePatchBaselineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline
func (c *SSM) UpdatePatchBaselineRequest(input *UpdatePatchBaselineInput) (req *request.Request, output *UpdatePatchBaselineOutput) {
	op := &request.Operation{
		Name:       opUpdatePatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePatchBaselineInput{}
	}

	output = &UpdatePatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePatchBaseline API operation for Amazon Simple Systems Management Service.
//
// Modifies an existing patch baseline. Fields not specified in the request
// are left unchanged.
//
// For information about valid key-value pairs in PatchFilters for each supported
// operating system type, see PatchFilter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdatePatchBaseline for usage and error information.
//
// Returned Error Types:
//
//   - DoesNotExistException
//     Error returned when the ID specified for a resource, such as a maintenance
//     window or patch baseline, doesn't exist.
//
//     For information about resource quotas in Amazon Web Services Systems Manager,
//     see Systems Manager service quotas (https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm)
//     in the Amazon Web Services General Reference.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline
func (c *SSM) UpdatePatchBaseline(input *UpdatePatchBaselineInput) (*UpdatePatchBaselineOutput, error) {
	req, out := c.UpdatePatchBaselineRequest(input)
	return out, req.Send()
}

// UpdatePatchBaselineWithContext is the same as UpdatePatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdatePatchBaselineWithContext(ctx aws.Context, input *UpdatePatchBaselineInput, opts ...request.Option) (*UpdatePatchBaselineOutput, error) {
	req, out := c.UpdatePatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceDataSync = "UpdateResourceDataSync"

// UpdateResourceDataSyncRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceDataSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceDataSync for more information on using the UpdateResourceDataSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResourceDataSyncRequest method.
//	req, resp := client.UpdateResourceDataSyncRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateResourceDataSync
func (c *SSM) UpdateResourceDataSyncRequest(input *UpdateResourceDataSyncInput) (req *request.Request, output *UpdateResourceDataSyncOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceDataSyncInput{}
	}

	output = &UpdateResourceDataSyncOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResourceDataSync API operation for Amazon Simple Systems Management Service.
//
// Update a resource data sync. After you create a resource data sync for a
// Region, you can't change the account options for that sync. For example,
// if you create a sync in the us-east-2 (Ohio) Region and you choose the Include
// only the current account option, you can't edit that sync later and choose
// the Include all accounts from my Organizations configuration option. Instead,
// you must delete the first resource data sync, and create a new one.
//
// This API operation only supports a resource data sync that was created with
// a SyncFromSource SyncType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateResourceDataSync for usage and error information.
//
// Returned Error Types:
//
//   - ResourceDataSyncNotFoundException
//     The specified sync name wasn't found.
//
//   - ResourceDataSyncInvalidConfigurationException
//     The specified sync configuration is invalid.
//
//   - ResourceDataSyncConflictException
//     Another UpdateResourceDataSync request is being processed. Wait a few minutes
//     and try again.
//
//   - InternalServerError
//     An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateResourceDataSync
func (c *SSM) UpdateResourceDataSync(input *UpdateResourceDataSyncInput) (*UpdateResourceDataSyncOutput, error) {
	req, out := c.UpdateResourceDataSyncRequest(input)
	return out, req.Send()
}

// UpdateResourceDataSyncWithContext is the same as UpdateResourceDataSync with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceDataSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateResourceDataSyncWithContext(ctx aws.Context, input *UpdateResourceDataSyncInput, opts ...request.Option) (*UpdateResourceDataSyncOutput, error) {
	req, out := c.UpdateResourceDataSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceSharingStateV2 = "UpdateResourceSharingStateV2"

// UpdateResourceSharingStateV2Request generates a "aws/request.Request" representing the
// client's request for the UpdateResourceSharingStateV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceSharingStateV2 for more information on using the UpdateResourceSharingStateV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResourceSharingStateV2Request method.
//	req, resp := client.UpdateResourceSharingStateV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateResourceSharingStateV2
func (c *SSM) UpdateResourceSharingStateV2Request(input *UpdateResourceSharingStateV2Input) (req *request.Request, output *UpdateResourceSharingStateV2Output) {
	op := &request.Operation{
		Name:       opUpdateResourceSharingStateV2,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceSharingStateV2Input{}
	}

	output = &UpdateResourceSharingStateV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourceSharingStateV2 API operation for Amazon Simple Systems Management Service.
//
// Updates resource sharing state if sequence number matches.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateResourceSharingStateV2 for usage and error information.
//
// Returned Error Types:
//
//   - RAMResourceNotFoundException
//     ROS cannot find a resource with the given resource ARN
//
//   - RAMInternalIdMismatchException
//     InternalId provided by RAM does not match current Internal ID in ROS
//
//   - RAMResourceNotSharedException
//     ROS receives unshared action when user does not have resource shared
//
//   - RAMInvalidSequenceNumberException
//     ROS receives a different sequence number than expected
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateResourceSharingStateV2
func (c *SSM) UpdateResourceSharingStateV2(input *UpdateResourceSharingStateV2Input) (*UpdateResourceSharingStateV2Output, error) {
	req, out := c.UpdateResourceSharingStateV2Request(input)
	return out, req.Send()
}

// UpdateResourceSharingStateV2WithContext is the same as UpdateResourceSharingStateV2 with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceSharingStateV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateResourceSharingStateV2WithContext(ctx aws.Context, input *UpdateResourceSharingStateV2Input, opts ...request.Option) (*UpdateResourceSharingStateV2Output, error) {
	req, out := c.UpdateResourceSharingStateV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceSetting = "UpdateServiceSetting"

// UpdateServiceSettingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceSetting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceSetting for more information on using the UpdateServiceSetting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceSettingRequest method.
//	req, resp := client.UpdateServiceSettingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateServiceSetting
func (c *SSM) UpdateServiceSettingRequest(input *UpdateServiceSettingInput) (req *request.Request, output *UpdateServiceSettingOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceSettingInput{}
	}

	output = &UpdateServiceSettingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServiceSetting API operation for Amazon Simple Systems Management Service.
//
// ServiceSetting is an account-level setting for an Amazon Web Services service.
// This setting defines how a user interacts with or uses a service or a feature
// of a service. For example, if an Amazon Web Services service charges money
// to the account based on feature or service usage, then the Amazon Web Services
// service team might create a default setting of "false". This means the user
// can't use this feature unless they change the setting to "true" and intentionally
// opt in for a paid feature.
//
// Services map a SettingId object to a setting value. Amazon Web Services services
// teams define the default value for a SettingId. You can't create a new SettingId,
// but you can overwrite the default value if you have the ssm:UpdateServiceSetting
// permission for the setting. Use the GetServiceSetting API operation to view
// the current value. Or, use the ResetServiceSetting to change the value back
// to the original value defined by the Amazon Web Services service team.
//
// Update the service setting for the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateServiceSetting for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ServiceSettingNotFound
//     The specified service setting wasn't found. Either the service name or the
//     setting hasn't been provisioned by the Amazon Web Services service team.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateServiceSetting
func (c *SSM) UpdateServiceSetting(input *UpdateServiceSettingInput) (*UpdateServiceSettingOutput, error) {
	req, out := c.UpdateServiceSettingRequest(input)
	return out, req.Send()
}

// UpdateServiceSettingWithContext is the same as UpdateServiceSetting with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceSetting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateServiceSettingWithContext(ctx aws.Context, input *UpdateServiceSettingInput, opts ...request.Option) (*UpdateServiceSettingOutput, error) {
	req, out := c.UpdateServiceSettingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceSettingInternal = "UpdateServiceSettingInternal"

// UpdateServiceSettingInternalRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceSettingInternal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceSettingInternal for more information on using the UpdateServiceSettingInternal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceSettingInternalRequest method.
//	req, resp := client.UpdateServiceSettingInternalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateServiceSettingInternal
func (c *SSM) UpdateServiceSettingInternalRequest(input *UpdateServiceSettingInternalInput) (req *request.Request, output *UpdateServiceSettingInternalOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceSettingInternal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceSettingInternalInput{}
	}

	output = &UpdateServiceSettingInternalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServiceSettingInternal API operation for Amazon Simple Systems Management Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateServiceSettingInternal for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     An error occurred on the server side.
//
//   - ServiceSettingNotFound
//     The specified service setting wasn't found. Either the service name or the
//     setting hasn't been provisioned by the Amazon Web Services service team.
//
//   - TooManyUpdates
//     There are concurrent updates for a resource that supports one update at a
//     time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateServiceSettingInternal
func (c *SSM) UpdateServiceSettingInternal(input *UpdateServiceSettingInternalInput) (*UpdateServiceSettingInternalOutput, error) {
	req, out := c.UpdateServiceSettingInternalRequest(input)
	return out, req.Send()
}

// UpdateServiceSettingInternalWithContext is the same as UpdateServiceSettingInternal with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceSettingInternal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateServiceSettingInternalWithContext(ctx aws.Context, input *UpdateServiceSettingInternalInput, opts ...request.Option) (*UpdateServiceSettingInternalOutput, error) {
	req, out := c.UpdateServiceSettingInternalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateResourceSharing = "ValidateResourceSharing"

// ValidateResourceSharingRequest generates a "aws/request.Request" representing the
// client's request for the ValidateResourceSharing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateResourceSharing for more information on using the ValidateResourceSharing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateResourceSharingRequest method.
//	req, resp := client.ValidateResourceSharingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ValidateResourceSharing
func (c *SSM) ValidateResourceSharingRequest(input *ValidateResourceSharingInput) (req *request.Request, output *ValidateResourceSharingOutput) {
	op := &request.Operation{
		Name:       opValidateResourceSharing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateResourceSharingInput{}
	}

	output = &ValidateResourceSharingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateResourceSharing API operation for Amazon Simple Systems Management Service.
//
// Validate if a given resource with a given internal id (if applicable) can
// be shared by a given owner account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ValidateResourceSharing for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ValidateResourceSharing
func (c *SSM) ValidateResourceSharing(input *ValidateResourceSharingInput) (*ValidateResourceSharingOutput, error) {
	req, out := c.ValidateResourceSharingRequest(input)
	return out, req.Send()
}

// ValidateResourceSharingWithContext is the same as ValidateResourceSharing with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateResourceSharing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ValidateResourceSharingWithContext(ctx aws.Context, input *ValidateResourceSharingInput, opts ...request.Option) (*ValidateResourceSharingOutput, error) {
	req, out := c.ValidateResourceSharingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessControlConfiguration struct {
	_ struct{} `type:"structure"`

	ApiAction *string `type:"string" enum:"ApiAction"`

	Permission *string `type:"string" enum:"Permission"`

	Type *string `type:"string" enum:"Type"`

	TypeId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlConfiguration) GoString() string {
	return s.String()
}

// SetApiAction sets the ApiAction field's value.
func (s *AccessControlConfiguration) SetApiAction(v string) *AccessControlConfiguration {
	s.ApiAction = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *AccessControlConfiguration) SetPermission(v string) *AccessControlConfiguration {
	s.Permission = &v
	return s
}

// SetType sets the Type field's value.
func (s *AccessControlConfiguration) SetType(v string) *AccessControlConfiguration {
	s.Type = &v
	return s
}

// SetTypeId sets the TypeId field's value.
func (s *AccessControlConfiguration) SetTypeId(v string) *AccessControlConfiguration {
	s.TypeId = &v
	return s
}

// Information includes the Amazon Web Services account ID where the current
// document is shared and the version shared with that account.
type AccountSharingInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID where the current document is shared.
	AccountId *string `type:"string"`

	// The version of the current document shared with the account.
	SharedDocumentVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSharingInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSharingInfo) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountSharingInfo) SetAccountId(v string) *AccountSharingInfo {
	s.AccountId = &v
	return s
}

// SetSharedDocumentVersion sets the SharedDocumentVersion field's value.
func (s *AccountSharingInfo) SetSharedDocumentVersion(v string) *AccountSharingInfo {
	s.SharedDocumentVersion = &v
	return s
}

// An activation registers one or more on-premises servers or virtual machines
// (VMs) with Amazon Web Services so that you can configure those servers or
// VMs using Run Command. A server or VM that has been registered with Amazon
// Web Services Systems Manager is called a managed node.
type Activation struct {
	_ struct{} `type:"structure"`

	// The ID created by Systems Manager when you submitted the activation.
	ActivationId *string `min:"36" type:"string"`

	// The date the activation was created.
	CreatedDate *time.Time `type:"timestamp"`

	// A name for the managed node when it is created.
	DefaultInstanceName *string `type:"string"`

	// A user defined description of the activation.
	Description *string `type:"string"`

	// The date when this activation can no longer be used to register managed nodes.
	ExpirationDate *time.Time `type:"timestamp"`

	// Whether or not the activation is expired.
	Expired *bool `type:"boolean"`

	// The Identity and Access Management (IAM) role to assign to the managed node.
	IamRole *string `min:"1" type:"string"`

	// The maximum number of managed nodes that can be registered using this activation.
	RegistrationLimit *int64 `min:"1" type:"integer"`

	// The number of managed nodes already registered with this activation.
	RegistrationsCount *int64 `min:"1" type:"integer"`

	// Tags assigned to the activation.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Activation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Activation) GoString() string {
	return s.String()
}

// SetActivationId sets the ActivationId field's value.
func (s *Activation) SetActivationId(v string) *Activation {
	s.ActivationId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Activation) SetCreatedDate(v time.Time) *Activation {
	s.CreatedDate = &v
	return s
}

// SetDefaultInstanceName sets the DefaultInstanceName field's value.
func (s *Activation) SetDefaultInstanceName(v string) *Activation {
	s.DefaultInstanceName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Activation) SetDescription(v string) *Activation {
	s.Description = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *Activation) SetExpirationDate(v time.Time) *Activation {
	s.ExpirationDate = &v
	return s
}

// SetExpired sets the Expired field's value.
func (s *Activation) SetExpired(v bool) *Activation {
	s.Expired = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *Activation) SetIamRole(v string) *Activation {
	s.IamRole = &v
	return s
}

// SetRegistrationLimit sets the RegistrationLimit field's value.
func (s *Activation) SetRegistrationLimit(v int64) *Activation {
	s.RegistrationLimit = &v
	return s
}

// SetRegistrationsCount sets the RegistrationsCount field's value.
func (s *Activation) SetRegistrationsCount(v int64) *Activation {
	s.RegistrationsCount = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Activation) SetTags(v []*Tag) *Activation {
	s.Tags = v
	return s
}

type ActivationExpired struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivationExpired) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivationExpired) GoString() string {
	return s.String()
}

func newErrorActivationExpired(v protocol.ResponseMetadata) error {
	return &ActivationExpired{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ActivationExpired) Code() string {
	return "ActivationExpired"
}

// Message returns the exception's message.
func (s *ActivationExpired) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ActivationExpired) OrigErr() error {
	return nil
}

func (s *ActivationExpired) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ActivationExpired) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ActivationExpired) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddAccessGrantInput struct {
	_ struct{} `type:"structure"`

	// AccessControlConfiguration is a required field
	AccessControlConfiguration *AccessControlConfiguration `type:"structure" required:"true"`

	// GroupArn is a required field
	GroupArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddAccessGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddAccessGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAccessGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddAccessGrantInput"}
	if s.AccessControlConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessControlConfiguration"))
	}
	if s.GroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlConfiguration sets the AccessControlConfiguration field's value.
func (s *AddAccessGrantInput) SetAccessControlConfiguration(v *AccessControlConfiguration) *AddAccessGrantInput {
	s.AccessControlConfiguration = v
	return s
}

// SetGroupArn sets the GroupArn field's value.
func (s *AddAccessGrantInput) SetGroupArn(v string) *AddAccessGrantInput {
	s.GroupArn = &v
	return s
}

type AddAccessGrantOutput struct {
	_ struct{} `type:"structure"`

	AccessGrantId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddAccessGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddAccessGrantOutput) GoString() string {
	return s.String()
}

// SetAccessGrantId sets the AccessGrantId field's value.
func (s *AddAccessGrantOutput) SetAccessGrantId(v string) *AddAccessGrantOutput {
	s.AccessGrantId = &v
	return s
}

type AddEventsForExploreSsmActionsInput struct {
	_ struct{} `type:"structure"`

	ExplorationId *string `type:"string"`

	Hypothesis *string `min:"1" type:"string"`

	HypothesisContentType *string `min:"1" type:"string"`

	HypothesisInfo *HypothesisInfo `type:"structure"`

	HypothesisProviderType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEventsForExploreSsmActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEventsForExploreSsmActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddEventsForExploreSsmActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddEventsForExploreSsmActionsInput"}
	if s.Hypothesis != nil && len(*s.Hypothesis) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Hypothesis", 1))
	}
	if s.HypothesisContentType != nil && len(*s.HypothesisContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HypothesisContentType", 1))
	}
	if s.HypothesisProviderType != nil && len(*s.HypothesisProviderType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HypothesisProviderType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExplorationId sets the ExplorationId field's value.
func (s *AddEventsForExploreSsmActionsInput) SetExplorationId(v string) *AddEventsForExploreSsmActionsInput {
	s.ExplorationId = &v
	return s
}

// SetHypothesis sets the Hypothesis field's value.
func (s *AddEventsForExploreSsmActionsInput) SetHypothesis(v string) *AddEventsForExploreSsmActionsInput {
	s.Hypothesis = &v
	return s
}

// SetHypothesisContentType sets the HypothesisContentType field's value.
func (s *AddEventsForExploreSsmActionsInput) SetHypothesisContentType(v string) *AddEventsForExploreSsmActionsInput {
	s.HypothesisContentType = &v
	return s
}

// SetHypothesisInfo sets the HypothesisInfo field's value.
func (s *AddEventsForExploreSsmActionsInput) SetHypothesisInfo(v *HypothesisInfo) *AddEventsForExploreSsmActionsInput {
	s.HypothesisInfo = v
	return s
}

// SetHypothesisProviderType sets the HypothesisProviderType field's value.
func (s *AddEventsForExploreSsmActionsInput) SetHypothesisProviderType(v string) *AddEventsForExploreSsmActionsInput {
	s.HypothesisProviderType = &v
	return s
}

type AddEventsForExploreSsmActionsOutput struct {
	_ struct{} `type:"structure"`

	ExplorationId *string `type:"string"`

	HypothesisId *string `type:"string"`

	HypothesisServiceTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEventsForExploreSsmActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddEventsForExploreSsmActionsOutput) GoString() string {
	return s.String()
}

// SetExplorationId sets the ExplorationId field's value.
func (s *AddEventsForExploreSsmActionsOutput) SetExplorationId(v string) *AddEventsForExploreSsmActionsOutput {
	s.ExplorationId = &v
	return s
}

// SetHypothesisId sets the HypothesisId field's value.
func (s *AddEventsForExploreSsmActionsOutput) SetHypothesisId(v string) *AddEventsForExploreSsmActionsOutput {
	s.HypothesisId = &v
	return s
}

// SetHypothesisServiceTimestamp sets the HypothesisServiceTimestamp field's value.
func (s *AddEventsForExploreSsmActionsOutput) SetHypothesisServiceTimestamp(v time.Time) *AddEventsForExploreSsmActionsOutput {
	s.HypothesisServiceTimestamp = &v
	return s
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ID you want to tag.
	//
	// Use the ID of the resource. Here are some examples:
	//
	// MaintenanceWindow: mw-012345abcde
	//
	// PatchBaseline: pb-012345abcde
	//
	// Automation: example-c160-4567-8519-012345abcde
	//
	// OpsMetadata object: ResourceID for tagging is created from the Amazon Resource
	// Name (ARN) for the object. Specifically, ResourceID is created from the strings
	// that come after the word opsmetadata in the ARN. For example, an OpsMetadata
	// object with an ARN of arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager
	// has a ResourceID of either aws/ssm/MyGroup/appmanager or /aws/ssm/MyGroup/appmanager.
	//
	// For the Document and Parameter values, use the name of the resource. If you're
	// tagging a shared document, you must use the full ARN of the document.
	//
	// ManagedInstance: mi-012345abcde
	//
	// The ManagedInstance type for this API operation is only for on-premises managed
	// nodes. You must specify the name of the managed node in the following format:
	// mi-ID_number . For example, mi-1a2b3c4d5e6f.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Specifies the type of resource you are tagging.
	//
	// The ManagedInstance type for this API operation is for on-premises managed
	// nodes. You must specify the name of the managed node in the following format:
	// mi-ID_number . For example, mi-1a2b3c4d5e6f.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceTypeForTagging"`

	// One or more tags. The value parameter is required.
	//
	// Don't enter personally identifiable information in this field.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AddTagsToResourceInput) SetResourceId(v string) *AddTagsToResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AddTagsToResourceInput) SetResourceType(v string) *AddTagsToResourceInput {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// A CloudWatch alarm you apply to an automation or command.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The name of your CloudWatch alarm.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alarm) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Alarm) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Alarm"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Alarm) SetName(v string) *Alarm {
	s.Name = &v
	return s
}

// The details for the CloudWatch alarm you want to apply to an automation or
// command.
type AlarmConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch alarm specified in the configuration.
	//
	// Alarms is a required field
	Alarms []*Alarm `min:"1" type:"list" required:"true"`

	// When this value is true, your automation or command continues to run in cases
	// where we can’t retrieve alarm status information from CloudWatch. In cases
	// where we successfully retrieve an alarm status of OK or INSUFFICIENT_DATA,
	// the automation or command continues to run, regardless of this value. Default
	// is false.
	IgnorePollAlarmFailure *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlarmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlarmConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlarmConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlarmConfiguration"}
	if s.Alarms == nil {
		invalidParams.Add(request.NewErrParamRequired("Alarms"))
	}
	if s.Alarms != nil && len(s.Alarms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alarms", 1))
	}
	if s.Alarms != nil {
		for i, v := range s.Alarms {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Alarms", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarms sets the Alarms field's value.
func (s *AlarmConfiguration) SetAlarms(v []*Alarm) *AlarmConfiguration {
	s.Alarms = v
	return s
}

// SetIgnorePollAlarmFailure sets the IgnorePollAlarmFailure field's value.
func (s *AlarmConfiguration) SetIgnorePollAlarmFailure(v bool) *AlarmConfiguration {
	s.IgnorePollAlarmFailure = &v
	return s
}

// The details about the state of your CloudWatch alarm.
type AlarmStateInformation struct {
	_ struct{} `type:"structure"`

	// The name of your CloudWatch alarm.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The state of your CloudWatch alarm.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ExternalAlarmState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlarmStateInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlarmStateInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlarmStateInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlarmStateInformation"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AlarmStateInformation) SetName(v string) *AlarmStateInformation {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *AlarmStateInformation) SetState(v string) *AlarmStateInformation {
	s.State = &v
	return s
}

// Error returned if an attempt is made to register a patch group with a patch
// baseline that is already registered with a different patch baseline.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssignResourceInput struct {
	_ struct{} `type:"structure"`

	// AssigneeId is a required field
	AssigneeId *string `min:"1" type:"string" required:"true"`

	// AssigneeType is a required field
	AssigneeType *string `type:"string" required:"true" enum:"AssigneeType"`

	// IdcInstanceArn is a required field
	IdcInstanceArn *string `min:"10" type:"string" required:"true"`

	// ResourceArns is a required field
	ResourceArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssignResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssignResourceInput"}
	if s.AssigneeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssigneeId"))
	}
	if s.AssigneeId != nil && len(*s.AssigneeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssigneeId", 1))
	}
	if s.AssigneeType == nil {
		invalidParams.Add(request.NewErrParamRequired("AssigneeType"))
	}
	if s.IdcInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IdcInstanceArn"))
	}
	if s.IdcInstanceArn != nil && len(*s.IdcInstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IdcInstanceArn", 10))
	}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}
	if s.ResourceArns != nil && len(s.ResourceArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssigneeId sets the AssigneeId field's value.
func (s *AssignResourceInput) SetAssigneeId(v string) *AssignResourceInput {
	s.AssigneeId = &v
	return s
}

// SetAssigneeType sets the AssigneeType field's value.
func (s *AssignResourceInput) SetAssigneeType(v string) *AssignResourceInput {
	s.AssigneeType = &v
	return s
}

// SetIdcInstanceArn sets the IdcInstanceArn field's value.
func (s *AssignResourceInput) SetIdcInstanceArn(v string) *AssignResourceInput {
	s.IdcInstanceArn = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *AssignResourceInput) SetResourceArns(v []*string) *AssignResourceInput {
	s.ResourceArns = v
	return s
}

type AssignResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignResourceOutput) GoString() string {
	return s.String()
}

type AssociateOpsItemRelatedItemInput struct {
	_ struct{} `type:"structure"`

	// The type of association that you want to create between an OpsItem and a
	// resource. OpsCenter supports IsParentOf and RelatesTo association types.
	//
	// AssociationType is a required field
	AssociationType *string `min:"1" type:"string" required:"true"`

	// The ID of the OpsItem to which you want to associate a resource as a related
	// item.
	//
	// OpsItemId is a required field
	OpsItemId *string `min:"1" type:"string" required:"true"`

	// The type of resource that you want to associate with an OpsItem. OpsCenter
	// supports the following types:
	//
	// AWS::SSMIncidents::IncidentRecord: an Incident Manager incident.
	//
	// AWS::SSM::Document: a Systems Manager (SSM) document.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services resource that you
	// want to associate with the OpsItem.
	//
	// ResourceUri is a required field
	ResourceUri *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateOpsItemRelatedItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateOpsItemRelatedItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateOpsItemRelatedItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateOpsItemRelatedItemInput"}
	if s.AssociationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationType"))
	}
	if s.AssociationType != nil && len(*s.AssociationType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationType", 1))
	}
	if s.OpsItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("OpsItemId"))
	}
	if s.OpsItemId != nil && len(*s.OpsItemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OpsItemId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}
	if s.ResourceUri == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceUri"))
	}
	if s.ResourceUri != nil && len(*s.ResourceUri) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceUri", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationType sets the AssociationType field's value.
func (s *AssociateOpsItemRelatedItemInput) SetAssociationType(v string) *AssociateOpsItemRelatedItemInput {
	s.AssociationType = &v
	return s
}

// SetOpsItemId sets the OpsItemId field's value.
func (s *AssociateOpsItemRelatedItemInput) SetOpsItemId(v string) *AssociateOpsItemRelatedItemInput {
	s.OpsItemId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AssociateOpsItemRelatedItemInput) SetResourceType(v string) *AssociateOpsItemRelatedItemInput {
	s.ResourceType = &v
	return s
}

// SetResourceUri sets the ResourceUri field's value.
func (s *AssociateOpsItemRelatedItemInput) SetResourceUri(v string) *AssociateOpsItemRelatedItemInput {
	s.ResourceUri = &v
	return s
}

type AssociateOpsItemRelatedItemOutput struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateOpsItemRelatedItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateOpsItemRelatedItemOutput) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociateOpsItemRelatedItemOutput) SetAssociationId(v string) *AssociateOpsItemRelatedItemOutput {
	s.AssociationId = &v
	return s
}

// You must disassociate a document from all managed nodes before you can delete
// it.
type AssociatedInstances struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedInstances) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedInstances) GoString() string {
	return s.String()
}

func newErrorAssociatedInstances(v protocol.ResponseMetadata) error {
	return &AssociatedInstances{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AssociatedInstances) Code() string {
	return "AssociatedInstances"
}

// Message returns the exception's message.
func (s *AssociatedInstances) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AssociatedInstances) OrigErr() error {
	return nil
}

func (s *AssociatedInstances) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AssociatedInstances) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AssociatedInstances) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes an association of a Amazon Web Services Systems Manager document
// (SSM document) and a managed node.
type Association struct {
	_ struct{} `type:"structure"`

	// The ID created by the system when you create an association. An association
	// is a binding between a document and a set of targets with a schedule.
	AssociationId *string `type:"string"`

	// The association name.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// The version of the document used in the association. If you change a document
	// version for a State Manager association, Systems Manager immediately runs
	// the association unless you previously specifed the apply-only-at-cron-interval
	// parameter.
	//
	// State Manager doesn't support running associations that use a new version
	// of a document if that document is shared from another account. State Manager
	// always runs the default version of a document if shared from another account,
	// even though the Systems Manager console shows that a new version was processed.
	// If you want to run an association using a new version of a document shared
	// form another account, you must set the document version to default.
	DocumentVersion *string `type:"string"`

	// The number of hours that an association can run on specified targets. After
	// the resulting cutoff time passes, associations that are currently running
	// are cancelled, and no pending executions are started on remaining targets.
	Duration *int64 `min:"1" type:"integer"`

	// The managed node ID.
	InstanceId *string `min:"10" type:"string"`

	// The date on which the association was last run.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The name of the SSM document.
	Name *string `type:"string"`

	// Information about the association.
	Overview *AssociationOverview `type:"structure"`

	// A cron expression that specifies a schedule when the association runs. The
	// schedule runs in Coordinated Universal Time (UTC).
	ScheduleExpression *string `min:"1" type:"string"`

	// Number of days to wait after the scheduled day to run an association.
	ScheduleOffset *int64 `min:"1" type:"integer"`

	// A key-value mapping of document parameters to target resources. Both Targets
	// and TargetMaps can't be specified together.
	TargetMaps []map[string][]*string `type:"list"`

	// The managed nodes targeted by the request to create an association. You can
	// target all managed nodes in an Amazon Web Services account by specifying
	// the InstanceIds key with a value of *.
	Targets []*Target `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Association) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Association) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *Association) SetAssociationId(v string) *Association {
	s.AssociationId = &v
	return s
}

// SetAssociationName sets the AssociationName field's value.
func (s *Association) SetAssociationName(v string) *Association {
	s.AssociationName = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *Association) SetAssociationVersion(v string) *Association {
	s.AssociationVersion = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *Association) SetDocumentVersion(v string) *Association {
	s.DocumentVersion = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *Association) SetDuration(v int64) *Association {
	s.Duration = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Association) SetInstanceId(v string) *Association {
	s.InstanceId = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *Association) SetLastExecutionDate(v time.Time) *Association {
	s.LastExecutionDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Association) SetName(v string) *Association {
	s.Name = &v
	return s
}

// SetOverview sets the Overview field's value.
func (s *Association) SetOverview(v *AssociationOverview) *Association {
	s.Overview = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Association) SetScheduleExpression(v string) *Association {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleOffset sets the ScheduleOffset field's value.
func (s *Association) SetScheduleOffset(v int64) *Association {
	s.ScheduleOffset = &v
	return s
}

// SetTargetMaps sets the TargetMaps field's value.
func (s *Association) SetTargetMaps(v []map[string][]*string) *Association {
	s.TargetMaps = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Association) SetTargets(v []*Target) *Association {
	s.Targets = v
	return s
}

// The specified association already exists.
type AssociationAlreadyExists struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationAlreadyExists) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationAlreadyExists) GoString() string {
	return s.String()
}

func newErrorAssociationAlreadyExists(v protocol.ResponseMetadata) error {
	return &AssociationAlreadyExists{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AssociationAlreadyExists) Code() string {
	return "AssociationAlreadyExists"
}

// Message returns the exception's message.
func (s *AssociationAlreadyExists) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AssociationAlreadyExists) OrigErr() error {
	return nil
}

func (s *AssociationAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AssociationAlreadyExists) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AssociationAlreadyExists) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the parameters for a document.
type AssociationDescription struct {
	_ struct{} `type:"structure"`

	// The details for the CloudWatch alarm you want to apply to an automation or
	// command.
	AlarmConfiguration *AlarmConfiguration `type:"structure"`

	ApplyAutomationForNewTargets *bool `type:"boolean"`

	// By default, when you create a new associations, the system runs it immediately
	// after it is created and then according to the schedule you specified. Specify
	// this option if you don't want an association to run immediately after you
	// create it. This parameter isn't supported for rate expressions.
	ApplyOnlyAtCronInterval *bool `type:"boolean"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association name.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	AutomationExecutionMode *string `type:"string" enum:"AutomationExecutionMode"`

	// Choose the parameter that will define how your automation will branch out.
	// This target is required for associations that use an Automation runbook and
	// target resources by using rate controls. Automation is a capability of Amazon
	// Web Services Systems Manager.
	AutomationTargetParameterName *string `min:"1" type:"string"`

	// The names or Amazon Resource Names (ARNs) of the Change Calendar type documents
	// your associations are gated under. The associations only run when that change
	// calendar is open. For more information, see Amazon Web Services Systems Manager
	// Change Calendar (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar).
	CalendarNames []*string `min:"1" type:"list"`

	// The severity level that is assigned to the association.
	ComplianceSeverity *string `type:"string" enum:"AssociationComplianceSeverity"`

	// The date when the association was made.
	Date *time.Time `type:"timestamp"`

	DistributionPreferencesDocument *string `type:"string"`

	DistributionPreferencesDocumentVersion *string `type:"string"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The number of hours that an association can run on specified targets. After
	// the resulting cutoff time passes, associations that are currently running
	// are cancelled, and no pending executions are started on remaining targets.
	Duration *int64 `min:"1" type:"integer"`

	// The managed node ID.
	InstanceId *string `min:"10" type:"string"`

	// The date on which the association was last run.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The last date on which the association was successfully run.
	LastSuccessfulExecutionDate *time.Time `type:"timestamp"`

	// The date when the association was last updated.
	LastUpdateAssociationDate *time.Time `type:"timestamp"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new managed node starts and attempts to run an association while Systems
	// Manager is running MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new managed node will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 managed nodes and set MaxError to 10%, then the system stops sending
	// the request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name of the SSM document.
	Name *string `type:"string"`

	// An S3 bucket where you want to store the output details of the request.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// Information about the association.
	Overview *AssociationOverview `type:"structure"`

	// A description of the parameters for a document.
	//
	// Parameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssociationDescription's
	// String and GoString methods.
	Parameters map[string][]*string `type:"map" sensitive:"true"`

	// A cron expression that specifies a schedule when the association runs.
	ScheduleExpression *string `min:"1" type:"string"`

	// Number of days to wait after the scheduled day to run an association.
	ScheduleOffset *int64 `min:"1" type:"integer"`

	ServiceRole *string `type:"string"`

	// The association status.
	Status *AssociationStatus `type:"structure"`

	// The mode for generating association compliance. You can specify AUTO or MANUAL.
	// In AUTO mode, the system uses the status of the association execution to
	// determine the compliance status. If the association execution runs successfully,
	// then the association is COMPLIANT. If the association execution doesn't run
	// successfully, the association is NON-COMPLIANT.
	//
	// In MANUAL mode, you must specify the AssociationId as a parameter for the
	// PutComplianceItems API operation. In this case, compliance data isn't managed
	// by State Manager, a capability of Amazon Web Services Systems Manager. It
	// is managed by your direct call to the PutComplianceItems API operation.
	//
	// By default, all associations use AUTO mode.
	SyncCompliance *string `type:"string" enum:"AssociationSyncCompliance"`

	// The combination of Amazon Web Services Regions and Amazon Web Services accounts
	// where you want to run the association.
	TargetLocations []*TargetLocation `min:"1" type:"list"`

	// A key-value mapping of document parameters to target resources. Both Targets
	// and TargetMaps can't be specified together.
	TargetMaps []map[string][]*string `type:"list"`

	// The managed nodes targeted by the request.
	Targets []*Target `type:"list"`

	// The CloudWatch alarm that was invoked during the association.
	TriggeredAlarms []*AlarmStateInformation `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationDescription) GoString() string {
	return s.String()
}

// SetAlarmConfiguration sets the AlarmConfiguration field's value.
func (s *AssociationDescription) SetAlarmConfiguration(v *AlarmConfiguration) *AssociationDescription {
	s.AlarmConfiguration = v
	return s
}

// SetApplyAutomationForNewTargets sets the ApplyAutomationForNewTargets field's value.
func (s *AssociationDescription) SetApplyAutomationForNewTargets(v bool) *AssociationDescription {
	s.ApplyAutomationForNewTargets = &v
	return s
}

// SetApplyOnlyAtCronInterval sets the ApplyOnlyAtCronInterval field's value.
func (s *AssociationDescription) SetApplyOnlyAtCronInterval(v bool) *AssociationDescription {
	s.ApplyOnlyAtCronInterval = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociationDescription) SetAssociationId(v string) *AssociationDescription {
	s.AssociationId = &v
	return s
}

// SetAssociationName sets the AssociationName field's value.
func (s *AssociationDescription) SetAssociationName(v string) *AssociationDescription {
	s.AssociationName = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *AssociationDescription) SetAssociationVersion(v string) *AssociationDescription {
	s.AssociationVersion = &v
	return s
}

// SetAutomationExecutionMode sets the AutomationExecutionMode field's value.
func (s *AssociationDescription) SetAutomationExecutionMode(v string) *AssociationDescription {
	s.AutomationExecutionMode = &v
	return s
}

// SetAutomationTargetParameterName sets the AutomationTargetParameterName field's value.
func (s *AssociationDescription) SetAutomationTargetParameterName(v string) *AssociationDescription {
	s.AutomationTargetParameterName = &v
	return s
}

// SetCalendarNames sets the CalendarNames field's value.
func (s *AssociationDescription) SetCalendarNames(v []*string) *AssociationDescription {
	s.CalendarNames = v
	return s
}

// SetComplianceSeverity sets the ComplianceSeverity field's value.
func (s *AssociationDescription) SetComplianceSeverity(v string) *AssociationDescription {
	s.ComplianceSeverity = &v
	return s
}

// SetDate sets the Date field's value.
func (s *AssociationDescription) SetDate(v time.Time) *AssociationDescription {
	s.Date = &v
	return s
}

// SetDistributionPreferencesDocument sets the DistributionPreferencesDocument field's value.
func (s *AssociationDescription) SetDistributionPreferencesDocument(v string) *AssociationDescription {
	s.DistributionPreferencesDocument = &v
	return s
}

// SetDistributionPreferencesDocumentVersion sets the DistributionPreferencesDocumentVersion field's value.
func (s *AssociationDescription) SetDistributionPreferencesDocumentVersion(v string) *AssociationDescription {
	s.DistributionPreferencesDocumentVersion = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *AssociationDescription) SetDocumentVersion(v string) *AssociationDescription {
	s.DocumentVersion = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *AssociationDescription) SetDuration(v int64) *AssociationDescription {
	s.Duration = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociationDescription) SetInstanceId(v string) *AssociationDescription {
	s.InstanceId = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *AssociationDescription) SetLastExecutionDate(v time.Time) *AssociationDescription {
	s.LastExecutionDate = &v
	return s
}

// SetLastSuccessfulExecutionDate sets the LastSuccessfulExecutionDate field's value.
func (s *AssociationDescription) SetLastSuccessfulExecutionDate(v time.Time) *AssociationDescription {
	s.LastSuccessfulExecutionDate = &v
	return s
}

// SetLastUpdateAssociationDate sets the LastUpdateAssociationDate field's value.
func (s *AssociationDescription) SetLastUpdateAssociationDate(v time.Time) *AssociationDescription {
	s.LastUpdateAssociationDate = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AssociationDescription) SetMaxConcurrency(v string) *AssociationDescription {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *AssociationDescription) SetMaxErrors(v string) *AssociationDescription {
	s.MaxErrors = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociationDescription) SetName(v string) *AssociationDescription {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *AssociationDescription) SetOutputLocation(v *InstanceAssociationOutputLocation) *AssociationDescription {
	s.OutputLocation = v
	return s
}

// SetOverview sets the Overview field's value.
func (s *AssociationDescription) SetOverview(v *AssociationOverview) *AssociationDescription {
	s.Overview = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *AssociationDescription) SetParameters(v map[string][]*string) *AssociationDescription {
	s.Parameters = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *AssociationDescription) SetScheduleExpression(v string) *AssociationDescription {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleOffset sets the ScheduleOffset field's value.
func (s *AssociationDescription) SetScheduleOffset(v int64) *AssociationDescription {
	s.ScheduleOffset = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *AssociationDescription) SetServiceRole(v string) *AssociationDescription {
	s.ServiceRole = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociationDescription) SetStatus(v *AssociationStatus) *AssociationDescription {
	s.Status = v
	return s
}

// SetSyncCompliance sets the SyncCompliance field's value.
func (s *AssociationDescription) SetSyncCompliance(v string) *AssociationDescription {
	s.SyncCompliance = &v
	return s
}

// SetTargetLocations sets the TargetLocations field's value.
func (s *AssociationDescription) SetTargetLocations(v []*TargetLocation) *AssociationDescription {
	s.TargetLocations = v
	return s
}

// SetTargetMaps sets the TargetMaps field's value.
func (s *AssociationDescription) SetTargetMaps(v []map[string][]*string) *AssociationDescription {
	s.TargetMaps = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AssociationDescription) SetTargets(v []*Target) *AssociationDescription {
	s.Targets = v
	return s
}

// SetTriggeredAlarms sets the TriggeredAlarms field's value.
func (s *AssociationDescription) SetTriggeredAlarms(v []*AlarmStateInformation) *AssociationDescription {
	s.TriggeredAlarms = v
	return s
}

// The specified association doesn't exist.
type AssociationDoesNotExist struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationDoesNotExist) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationDoesNotExist) GoString() string {
	return s.String()
}

func newErrorAssociationDoesNotExist(v protocol.ResponseMetadata) error {
	return &AssociationDoesNotExist{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AssociationDoesNotExist) Code() string {
	return "AssociationDoesNotExist"
}

// Message returns the exception's message.
func (s *AssociationDoesNotExist) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AssociationDoesNotExist) OrigErr() error {
	return nil
}

func (s *AssociationDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AssociationDoesNotExist) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AssociationDoesNotExist) RequestID() string {
	return s.RespMetadata.RequestID
}

// Includes information about the specified association.
type AssociationExecution struct {
	_ struct{} `type:"structure"`

	// The details for the CloudWatch alarm you want to apply to an automation or
	// command.
	AlarmConfiguration *AlarmConfiguration `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// The time the execution started.
	CreatedTime *time.Time `type:"timestamp"`

	// Detailed status information about the execution.
	DetailedStatus *string `type:"string"`

	// The execution ID for the association.
	ExecutionId *string `type:"string"`

	// The date of the last execution.
	LastExecutionDate *time.Time `type:"timestamp"`

	// An aggregate status of the resources in the execution based on the status
	// type.
	ResourceCountByStatus *string `type:"string"`

	// The status of the association execution.
	Status *string `type:"string"`

	// The CloudWatch alarms that were invoked by the association.
	TriggeredAlarms []*AlarmStateInformation `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecution) GoString() string {
	return s.String()
}

// SetAlarmConfiguration sets the AlarmConfiguration field's value.
func (s *AssociationExecution) SetAlarmConfiguration(v *AlarmConfiguration) *AssociationExecution {
	s.AlarmConfiguration = v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociationExecution) SetAssociationId(v string) *AssociationExecution {
	s.AssociationId = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *AssociationExecution) SetAssociationVersion(v string) *AssociationExecution {
	s.AssociationVersion = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AssociationExecution) SetCreatedTime(v time.Time) *AssociationExecution {
	s.CreatedTime = &v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *AssociationExecution) SetDetailedStatus(v string) *AssociationExecution {
	s.DetailedStatus = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *AssociationExecution) SetExecutionId(v string) *AssociationExecution {
	s.ExecutionId = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *AssociationExecution) SetLastExecutionDate(v time.Time) *AssociationExecution {
	s.LastExecutionDate = &v
	return s
}

// SetResourceCountByStatus sets the ResourceCountByStatus field's value.
func (s *AssociationExecution) SetResourceCountByStatus(v string) *AssociationExecution {
	s.ResourceCountByStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociationExecution) SetStatus(v string) *AssociationExecution {
	s.Status = &v
	return s
}

// SetTriggeredAlarms sets the TriggeredAlarms field's value.
func (s *AssociationExecution) SetTriggeredAlarms(v []*AlarmStateInformation) *AssociationExecution {
	s.TriggeredAlarms = v
	return s
}

// The specified execution ID doesn't exist. Verify the ID number and try again.
type AssociationExecutionDoesNotExist struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecutionDoesNotExist) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecutionDoesNotExist) GoString() string {
	return s.String()
}

func newErrorAssociationExecutionDoesNotExist(v protocol.ResponseMetadata) error {
	return &AssociationExecutionDoesNotExist{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AssociationExecutionDoesNotExist) Code() string {
	return "AssociationExecutionDoesNotExist"
}

// Message returns the exception's message.
func (s *AssociationExecutionDoesNotExist) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AssociationExecutionDoesNotExist) OrigErr() error {
	return nil
}

func (s *AssociationExecutionDoesNotExist) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AssociationExecutionDoesNotExist) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AssociationExecutionDoesNotExist) RequestID() string {
	return s.RespMetadata.RequestID
}

// Filters used in the request.
type AssociationExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The key value used in the request.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" enum:"AssociationExecutionFilterKey"`

	// The filter type specified in the request.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"AssociationFilterOperatorType"`

	// The value specified for the key.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecutionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationExecutionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationExecutionFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AssociationExecutionFilter) SetKey(v string) *AssociationExecutionFilter {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssociationExecutionFilter) SetType(v string) *AssociationExecutionFilter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AssociationExecutionFilter) SetValue(v string) *AssociationExecutionFilter {
	s.Value = &v
	return s
}

// Includes information about the specified association execution.
type AssociationExecutionTarget struct {
	_ struct{} `type:"structure"`

	// The details for the CloudWatch alarm you want to apply to an automation or
	// command.
	AlarmConfiguration *AlarmConfiguration `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// Detailed information about the execution status.
	DetailedStatus *string `type:"string"`

	// The execution ID.
	ExecutionId *string `type:"string"`

	// The date of the last execution.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The location where the association details are saved.
	OutputSource *OutputSource `type:"structure"`

	// The resource ID, for example, the managed node ID where the association ran.
	ResourceId *string `min:"1" type:"string"`

	// The resource type, for example, EC2.
	ResourceType *string `min:"1" type:"string"`

	// The association execution status.
	Status *string `type:"string"`

	TriggeredAlarms []*AlarmStateInformation `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecutionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecutionTarget) GoString() string {
	return s.String()
}

// SetAlarmConfiguration sets the AlarmConfiguration field's value.
func (s *AssociationExecutionTarget) SetAlarmConfiguration(v *AlarmConfiguration) *AssociationExecutionTarget {
	s.AlarmConfiguration = v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociationExecutionTarget) SetAssociationId(v string) *AssociationExecutionTarget {
	s.AssociationId = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *AssociationExecutionTarget) SetAssociationVersion(v string) *AssociationExecutionTarget {
	s.AssociationVersion = &v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *AssociationExecutionTarget) SetDetailedStatus(v string) *AssociationExecutionTarget {
	s.DetailedStatus = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *AssociationExecutionTarget) SetExecutionId(v string) *AssociationExecutionTarget {
	s.ExecutionId = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *AssociationExecutionTarget) SetLastExecutionDate(v time.Time) *AssociationExecutionTarget {
	s.LastExecutionDate = &v
	return s
}

// SetOutputSource sets the OutputSource field's value.
func (s *AssociationExecutionTarget) SetOutputSource(v *OutputSource) *AssociationExecutionTarget {
	s.OutputSource = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociationExecutionTarget) SetResourceId(v string) *AssociationExecutionTarget {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AssociationExecutionTarget) SetResourceType(v string) *AssociationExecutionTarget {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociationExecutionTarget) SetStatus(v string) *AssociationExecutionTarget {
	s.Status = &v
	return s
}

// SetTriggeredAlarms sets the TriggeredAlarms field's value.
func (s *AssociationExecutionTarget) SetTriggeredAlarms(v []*AlarmStateInformation) *AssociationExecutionTarget {
	s.TriggeredAlarms = v
	return s
}

// Filters for the association execution.
type AssociationExecutionTargetsFilter struct {
	_ struct{} `type:"structure"`

	// The key value used in the request.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" enum:"AssociationExecutionTargetsFilterKey"`

	// The value specified for the key.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecutionTargetsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationExecutionTargetsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationExecutionTargetsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationExecutionTargetsFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AssociationExecutionTargetsFilter) SetKey(v string) *AssociationExecutionTargetsFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AssociationExecutionTargetsFilter) SetValue(v string) *AssociationExecutionTargetsFilter {
	s.Value = &v
	return s
}

// Describes a filter.
type AssociationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// InstanceId has been deprecated.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"AssociationFilterKey"`

	// The filter value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AssociationFilter) SetKey(v string) *AssociationFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AssociationFilter) SetValue(v string) *AssociationFilter {
	s.Value = &v
	return s
}

// You can have at most 2,000 active associations.
type AssociationLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationLimitExceeded) GoString() string {
	return s.String()
}

func newErrorAssociationLimitExceeded(v protocol.ResponseMetadata) error {
	return &AssociationLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AssociationLimitExceeded) Code() string {
	return "AssociationLimitExceeded"
}

// Message returns the exception's message.
func (s *AssociationLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AssociationLimitExceeded) OrigErr() error {
	return nil
}

func (s *AssociationLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AssociationLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AssociationLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the association.
type AssociationOverview struct {
	_ struct{} `type:"structure"`

	// Returns the number of targets for the association status. For example, if
	// you created an association with two managed nodes, and one of them was successful,
	// this would return the count of managed nodes by status.
	AssociationStatusAggregatedCount map[string]*int64 `type:"map"`

	// A detailed status of the association.
	DetailedStatus *string `type:"string"`

	// The status of the association. Status can be: Pending, Success, or Failed.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationOverview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationOverview) GoString() string {
	return s.String()
}

// SetAssociationStatusAggregatedCount sets the AssociationStatusAggregatedCount field's value.
func (s *AssociationOverview) SetAssociationStatusAggregatedCount(v map[string]*int64) *AssociationOverview {
	s.AssociationStatusAggregatedCount = v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *AssociationOverview) SetDetailedStatus(v string) *AssociationOverview {
	s.DetailedStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociationOverview) SetStatus(v string) *AssociationOverview {
	s.Status = &v
	return s
}

// Describes an association status.
type AssociationStatus struct {
	_ struct{} `type:"structure"`

	// A user-defined string.
	AdditionalInfo *string `type:"string"`

	// The date when the status changed.
	//
	// Date is a required field
	Date *time.Time `type:"timestamp" required:"true"`

	// The reason for the status.
	//
	// Message is a required field
	Message *string `min:"1" type:"string" required:"true"`

	// The status.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"AssociationStatusName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationStatus"}
	if s.Date == nil {
		invalidParams.Add(request.NewErrParamRequired("Date"))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *AssociationStatus) SetAdditionalInfo(v string) *AssociationStatus {
	s.AdditionalInfo = &v
	return s
}

// SetDate sets the Date field's value.
func (s *AssociationStatus) SetDate(v time.Time) *AssociationStatus {
	s.Date = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssociationStatus) SetMessage(v string) *AssociationStatus {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociationStatus) SetName(v string) *AssociationStatus {
	s.Name = &v
	return s
}

// Information about the association version.
type AssociationVersionInfo struct {
	_ struct{} `type:"structure"`

	ApplyAutomationForNewTargets *bool `type:"boolean"`

	// By default, when you create a new associations, the system runs it immediately
	// after it is created and then according to the schedule you specified. Specify
	// this option if you don't want an association to run immediately after you
	// create it. This parameter isn't supported for rate expressions.
	ApplyOnlyAtCronInterval *bool `type:"boolean"`

	// The ID created by the system when the association was created.
	AssociationId *string `type:"string"`

	// The name specified for the association version when the association version
	// was created.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	AutomationExecutionMode *string `type:"string" enum:"AutomationExecutionMode"`

	// The names or Amazon Resource Names (ARNs) of the Change Calendar type documents
	// your associations are gated under. The associations for this version only
	// run when that Change Calendar is open. For more information, see Amazon Web
	// Services Systems Manager Change Calendar (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar).
	CalendarNames []*string `min:"1" type:"list"`

	// The severity level that is assigned to the association.
	ComplianceSeverity *string `type:"string" enum:"AssociationComplianceSeverity"`

	// The date the association version was created.
	CreatedDate *time.Time `type:"timestamp"`

	DistributionPreferencesDocument *string `type:"string"`

	DistributionPreferencesDocumentVersion *string `type:"string"`

	// The version of an Amazon Web Services Systems Manager document (SSM document)
	// used when the association version was created.
	DocumentVersion *string `type:"string"`

	// The number of hours that an association can run on specified targets. After
	// the resulting cutoff time passes, associations that are currently running
	// are cancelled, and no pending executions are started on remaining targets.
	Duration *int64 `min:"1" type:"integer"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new managed node starts and attempts to run an association while Systems
	// Manager is running MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new managed node will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 managed nodes and set MaxError to 10%, then the system stops sending
	// the request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name specified when the association was created.
	Name *string `type:"string"`

	// The location in Amazon S3 specified for the association when the association
	// version was created.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// Parameters specified when the association version was created.
	//
	// Parameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssociationVersionInfo's
	// String and GoString methods.
	Parameters map[string][]*string `type:"map" sensitive:"true"`

	// The cron or rate schedule specified for the association when the association
	// version was created.
	ScheduleExpression *string `min:"1" type:"string"`

	// Number of days to wait after the scheduled day to run an association.
	ScheduleOffset *int64 `min:"1" type:"integer"`

	// The mode for generating association compliance. You can specify AUTO or MANUAL.
	// In AUTO mode, the system uses the status of the association execution to
	// determine the compliance status. If the association execution runs successfully,
	// then the association is COMPLIANT. If the association execution doesn't run
	// successfully, the association is NON-COMPLIANT.
	//
	// In MANUAL mode, you must specify the AssociationId as a parameter for the
	// PutComplianceItems API operation. In this case, compliance data isn't managed
	// by State Manager, a capability of Amazon Web Services Systems Manager. It
	// is managed by your direct call to the PutComplianceItems API operation.
	//
	// By default, all associations use AUTO mode.
	SyncCompliance *string `type:"string" enum:"AssociationSyncCompliance"`

	// The combination of Amazon Web Services Regions and Amazon Web Services accounts
	// where you wanted to run the association when this association version was
	// created.
	TargetLocations []*TargetLocation `min:"1" type:"list"`

	// A key-value mapping of document parameters to target resources. Both Targets
	// and TargetMaps can't be specified together.
	TargetMaps []map[string][]*string `type:"list"`

	// The targets specified for the association when the association version was
	// created.
	Targets []*Target `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationVersionInfo) GoString() string {
	return s.String()
}

// SetApplyAutomationForNewTargets sets the ApplyAutomationForNewTargets field's value.
func (s *AssociationVersionInfo) SetApplyAutomationForNewTargets(v bool) *AssociationVersionInfo {
	s.ApplyAutomationForNewTargets = &v
	return s
}

// SetApplyOnlyAtCronInterval sets the ApplyOnlyAtCronInterval field's value.
func (s *AssociationVersionInfo) SetApplyOnlyAtCronInterval(v bool) *AssociationVersionInfo {
	s.ApplyOnlyAtCronInterval = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociationVersionInfo) SetAssociationId(v string) *AssociationVersionInfo {
	s.AssociationId = &v
	return s
}

// SetAssociationName sets the AssociationName field's value.
func (s *AssociationVersionInfo) SetAssociationName(v string) *AssociationVersionInfo {
	s.AssociationName = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *AssociationVersionInfo) SetAssociationVersion(v string) *AssociationVersionInfo {
	s.AssociationVersion = &v
	return s
}

// SetAutomationExecutionMode sets the AutomationExecutionMode field's value.
func (s *AssociationVersionInfo) SetAutomationExecutionMode(v string) *AssociationVersionInfo {
	s.AutomationExecutionMode = &v
	return s
}

// SetCalendarNames sets the CalendarNames field's value.
func (s *AssociationVersionInfo) SetCalendarNames(v []*string) *AssociationVersionInfo {
	s.CalendarNames = v
	return s
}

// SetComplianceSeverity sets the ComplianceSeverity field's value.
func (s *AssociationVersionInfo) SetComplianceSeverity(v string) *AssociationVersionInfo {
	s.ComplianceSeverity = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AssociationVersionInfo) SetCreatedDate(v time.Time) *AssociationVersionInfo {
	s.CreatedDate = &v
	return s
}

// SetDistributionPreferencesDocument sets the DistributionPreferencesDocument field's value.
func (s *AssociationVersionInfo) SetDistributionPreferencesDocument(v string) *AssociationVersionInfo {
	s.DistributionPreferencesDocument = &v
	return s
}

// SetDistributionPreferencesDocumentVersion sets the DistributionPreferencesDocumentVersion field's value.
func (s *AssociationVersionInfo) SetDistributionPreferencesDocumentVersion(v string) *AssociationVersionInfo {
	s.DistributionPreferencesDocumentVersion = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *AssociationVersionInfo) SetDocumentVersion(v string) *AssociationVersionInfo {
	s.DocumentVersion = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *AssociationVersionInfo) SetDuration(v int64) *AssociationVersionInfo {
	s.Duration = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AssociationVersionInfo) SetMaxConcurrency(v string) *AssociationVersionInfo {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *AssociationVersionInfo) SetMaxErrors(v string) *AssociationVersionInfo {
	s.MaxErrors = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociationVersionInfo) SetName(v string) *AssociationVersionInfo {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *AssociationVersionInfo) SetOutputLocation(v *InstanceAssociationOutputLocation) *AssociationVersionInfo {
	s.OutputLocation = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *AssociationVersionInfo) SetParameters(v map[string][]*string) *AssociationVersionInfo {
	s.Parameters = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *AssociationVersionInfo) SetScheduleExpression(v string) *AssociationVersionInfo {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleOffset sets the ScheduleOffset field's value.
func (s *AssociationVersionInfo) SetScheduleOffset(v int64) *AssociationVersionInfo {
	s.ScheduleOffset = &v
	return s
}

// SetSyncCompliance sets the SyncCompliance field's value.
func (s *AssociationVersionInfo) SetSyncCompliance(v string) *AssociationVersionInfo {
	s.SyncCompliance = &v
	return s
}

// SetTargetLocations sets the TargetLocations field's value.
func (s *AssociationVersionInfo) SetTargetLocations(v []*TargetLocation) *AssociationVersionInfo {
	s.TargetLocations = v
	return s
}

// SetTargetMaps sets the TargetMaps field's value.
func (s *AssociationVersionInfo) SetTargetMaps(v []map[string][]*string) *AssociationVersionInfo {
	s.TargetMaps = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AssociationVersionInfo) SetTargets(v []*Target) *AssociationVersionInfo {
	s.Targets = v
	return s
}

// You have reached the maximum number versions allowed for an association.
// Each association has a limit of 1,000 versions.
type AssociationVersionLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationVersionLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationVersionLimitExceeded) GoString() string {
	return s.String()
}

func newErrorAssociationVersionLimitExceeded(v protocol.ResponseMetadata) error {
	return &AssociationVersionLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AssociationVersionLimitExceeded) Code() string {
	return "AssociationVersionLimitExceeded"
}

// Message returns the exception's message.
func (s *AssociationVersionLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AssociationVersionLimitExceeded) OrigErr() error {
	return nil
}

func (s *AssociationVersionLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AssociationVersionLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AssociationVersionLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that includes attributes that describe a document attachment.
type AttachmentContent struct {
	_ struct{} `type:"structure"`

	// The cryptographic hash value of the document content.
	Hash *string `type:"string"`

	// The hash algorithm used to calculate the hash value.
	HashType *string `type:"string" enum:"AttachmentHashType"`

	// The name of an attachment.
	Name *string `type:"string"`

	// The size of an attachment in bytes.
	Size *int64 `type:"long"`

	// The URL location of the attachment content.
	Url *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentContent) GoString() string {
	return s.String()
}

// SetHash sets the Hash field's value.
func (s *AttachmentContent) SetHash(v string) *AttachmentContent {
	s.Hash = &v
	return s
}

// SetHashType sets the HashType field's value.
func (s *AttachmentContent) SetHashType(v string) *AttachmentContent {
	s.HashType = &v
	return s
}

// SetName sets the Name field's value.
func (s *AttachmentContent) SetName(v string) *AttachmentContent {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *AttachmentContent) SetSize(v int64) *AttachmentContent {
	s.Size = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *AttachmentContent) SetUrl(v string) *AttachmentContent {
	s.Url = &v
	return s
}

// An attribute of an attachment, such as the attachment name.
type AttachmentInformation struct {
	_ struct{} `type:"structure"`

	// The name of the attachment.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentInformation) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AttachmentInformation) SetName(v string) *AttachmentInformation {
	s.Name = &v
	return s
}

// Identifying information about a document attachment, including the file name
// and a key-value pair that identifies the location of an attachment to a document.
type AttachmentsSource struct {
	_ struct{} `type:"structure"`

	// The key of a key-value pair that identifies the location of an attachment
	// to a document.
	Key *string `type:"string" enum:"AttachmentsSourceKey"`

	// The name of the document attachment file.
	Name *string `type:"string"`

	// The value of a key-value pair that identifies the location of an attachment
	// to a document. The format for Value depends on the type of key you specify.
	//
	//    * For the key SourceUrl, the value is an S3 bucket location. For example:
	//    "Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]
	//
	//    * For the key S3FileUrl, the value is a file in an S3 bucket. For example:
	//    "Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]
	//
	//    * For the key AttachmentReference, the value is constructed from the name
	//    of another SSM document in your account, a version number of that document,
	//    and a file attached to that document version that you want to reuse. For
	//    example: "Values": [ "MyOtherDocument/3/my-other-file.py" ] However, if
	//    the SSM document is shared with you from another account, the full SSM
	//    document ARN must be specified instead of the document name only. For
	//    example: "Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py"
	//    ]
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentsSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentsSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachmentsSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachmentsSource"}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AttachmentsSource) SetKey(v string) *AttachmentsSource {
	s.Key = &v
	return s
}

// SetName sets the Name field's value.
func (s *AttachmentsSource) SetName(v string) *AttachmentsSource {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AttachmentsSource) SetValues(v []*string) *AttachmentsSource {
	s.Values = v
	return s
}

type AutomationAction struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	Inputs []*AutomationArgument `type:"list"`

	Name *string `min:"7" type:"string"`

	Outputs []*AutomationArgument `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *AutomationAction) SetDescription(v string) *AutomationAction {
	s.Description = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *AutomationAction) SetInputs(v []*AutomationArgument) *AutomationAction {
	s.Inputs = v
	return s
}

// SetName sets the Name field's value.
func (s *AutomationAction) SetName(v string) *AutomationAction {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AutomationAction) SetOutputs(v []*AutomationArgument) *AutomationAction {
	s.Outputs = v
	return s
}

type AutomationActionNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationActionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationActionNotFoundException) GoString() string {
	return s.String()
}

func newErrorAutomationActionNotFoundException(v protocol.ResponseMetadata) error {
	return &AutomationActionNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationActionNotFoundException) Code() string {
	return "AutomationActionNotFoundException"
}

// Message returns the exception's message.
func (s *AutomationActionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationActionNotFoundException) OrigErr() error {
	return nil
}

func (s *AutomationActionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationActionNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationActionNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AutomationArgument struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Regex *string `type:"string"`

	Required *bool `type:"boolean"`

	Type *string `type:"string" enum:"AutomationArgumentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationArgument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationArgument) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AutomationArgument) SetName(v string) *AutomationArgument {
	s.Name = &v
	return s
}

// SetRegex sets the Regex field's value.
func (s *AutomationArgument) SetRegex(v string) *AutomationArgument {
	s.Regex = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *AutomationArgument) SetRequired(v bool) *AutomationArgument {
	s.Required = &v
	return s
}

// SetType sets the Type field's value.
func (s *AutomationArgument) SetType(v string) *AutomationArgument {
	s.Type = &v
	return s
}

// Indicates that the Change Manager change template used in the change request
// was rejected or is still in a pending state.
type AutomationDefinitionNotApprovedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationDefinitionNotApprovedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationDefinitionNotApprovedException) GoString() string {
	return s.String()
}

func newErrorAutomationDefinitionNotApprovedException(v protocol.ResponseMetadata) error {
	return &AutomationDefinitionNotApprovedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationDefinitionNotApprovedException) Code() string {
	return "AutomationDefinitionNotApprovedException"
}

// Message returns the exception's message.
func (s *AutomationDefinitionNotApprovedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationDefinitionNotApprovedException) OrigErr() error {
	return nil
}

func (s *AutomationDefinitionNotApprovedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationDefinitionNotApprovedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationDefinitionNotApprovedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Automation runbook with the specified name couldn't be found.
type AutomationDefinitionNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationDefinitionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationDefinitionNotFoundException) GoString() string {
	return s.String()
}

func newErrorAutomationDefinitionNotFoundException(v protocol.ResponseMetadata) error {
	return &AutomationDefinitionNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationDefinitionNotFoundException) Code() string {
	return "AutomationDefinitionNotFoundException"
}

// Message returns the exception's message.
func (s *AutomationDefinitionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationDefinitionNotFoundException) OrigErr() error {
	return nil
}

func (s *AutomationDefinitionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationDefinitionNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationDefinitionNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Automation runbook with the specified name and version couldn't be found.
type AutomationDefinitionVersionNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationDefinitionVersionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationDefinitionVersionNotFoundException) GoString() string {
	return s.String()
}

func newErrorAutomationDefinitionVersionNotFoundException(v protocol.ResponseMetadata) error {
	return &AutomationDefinitionVersionNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationDefinitionVersionNotFoundException) Code() string {
	return "AutomationDefinitionVersionNotFoundException"
}

// Message returns the exception's message.
func (s *AutomationDefinitionVersionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationDefinitionVersionNotFoundException) OrigErr() error {
	return nil
}

func (s *AutomationDefinitionVersionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationDefinitionVersionNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationDefinitionVersionNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Detailed information about the current state of an individual Automation
// execution.
type AutomationExecution struct {
	_ struct{} `type:"structure"`

	// The details for the CloudWatch alarm applied to your automation.
	AlarmConfiguration *AlarmConfiguration `type:"structure"`

	// The ID of a State Manager association used in the Automation operation.
	AssociationId *string `type:"string"`

	// The execution ID.
	AutomationExecutionId *string `min:"36" type:"string"`

	// The execution status of the Automation.
	AutomationExecutionStatus *string `type:"string" enum:"AutomationExecutionStatus"`

	// The subtype of the Automation operation. Currently, the only supported value
	// is ChangeRequest.
	AutomationSubtype *string `type:"string" enum:"AutomationSubtype"`

	// The name of the Change Manager change request.
	ChangeRequestName *string `min:"1" type:"string"`

	CloudWatchAlarms []*string `min:"1" type:"list"`

	// The action of the step that is currently running.
	CurrentAction *string `type:"string"`

	// The name of the step that is currently running.
	CurrentStepName *string `type:"string"`

	// The name of the Automation runbook used during the execution.
	DocumentName *string `type:"string"`

	// The version of the document to use during execution.
	DocumentVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the user who ran the automation.
	ExecutedBy *string `type:"string"`

	// The time the execution finished.
	ExecutionEndTime *time.Time `type:"timestamp"`

	// The time the execution started.
	ExecutionStartTime *time.Time `type:"timestamp"`

	// A message describing why an execution has failed, if the status is set to
	// Failed.
	FailureMessage *string `type:"string"`

	// The MaxConcurrency value specified by the user when the execution started.
	MaxConcurrency *string `min:"1" type:"string"`

	// The MaxErrors value specified by the user when the execution started.
	MaxErrors *string `min:"1" type:"string"`

	// The automation execution mode.
	Mode *string `type:"string" enum:"ExecutionMode"`

	// The ID of an OpsItem that is created to represent a Change Manager change
	// request.
	OpsItemId *string `type:"string"`

	// The list of execution outputs as defined in the Automation runbook.
	Outputs map[string][]*string `min:"1" type:"map"`

	// The key-value map of execution parameters, which were supplied when calling
	// StartAutomationExecution.
	Parameters map[string][]*string `min:"1" type:"map"`

	// The AutomationExecutionId of the parent automation.
	ParentAutomationExecutionId *string `min:"36" type:"string"`

	// An aggregate of step execution statuses displayed in the Amazon Web Services
	// Systems Manager console for a multi-Region and multi-account Automation execution.
	ProgressCounters *ProgressCounters `type:"structure"`

	// A list of resolved targets in the rate control execution.
	ResolvedTargets *ResolvedTargets `type:"structure"`

	// Information about the Automation runbooks that are run as part of a runbook
	// workflow.
	//
	// The Automation runbooks specified for the runbook workflow can't run until
	// all required approvals for the change request have been received.
	Runbooks []*Runbook `min:"1" type:"list"`

	ScheduleExpression *string `min:"1" type:"string"`

	ScheduledAutomationExecutionID *string `min:"36" type:"string"`

	// The date and time the Automation operation is scheduled to start.
	ScheduledTime *time.Time `type:"timestamp"`

	// A list of details about the current state of all steps that comprise an execution.
	// An Automation runbook contains a list of steps that are run in order.
	StepExecutions []*StepExecution `type:"list"`

	// A boolean value that indicates if the response contains the full list of
	// the Automation step executions. If true, use the DescribeAutomationStepExecutions
	// API operation to get the full list of step executions.
	StepExecutionsTruncated *bool `type:"boolean"`

	// The target of the execution.
	Target *string `type:"string"`

	// The combination of Amazon Web Services Regions and/or Amazon Web Services
	// accounts where you want to run the Automation.
	TargetLocations []*TargetLocation `min:"1" type:"list"`

	// A publicly accessible URL for a file that contains the TargetLocations body.
	// Currently, only files in presigned Amazon S3 buckets are supported
	TargetLocationsURL *string `type:"string"`

	// The specified key-value mapping of document parameters to target resources.
	TargetMaps []map[string][]*string `type:"list"`

	// The parameter name.
	TargetParameterName *string `min:"1" type:"string"`

	// The specified targets.
	Targets []*Target `type:"list"`

	// The CloudWatch alarm that was invoked by the automation.
	TriggeredAlarms []*AlarmStateInformation `min:"1" type:"list"`

	// Variables defined for the automation.
	Variables map[string][]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecution) GoString() string {
	return s.String()
}

// SetAlarmConfiguration sets the AlarmConfiguration field's value.
func (s *AutomationExecution) SetAlarmConfiguration(v *AlarmConfiguration) *AutomationExecution {
	s.AlarmConfiguration = v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AutomationExecution) SetAssociationId(v string) *AutomationExecution {
	s.AssociationId = &v
	return s
}

// SetAutomationExecutionId sets the AutomationExecutionId field's value.
func (s *AutomationExecution) SetAutomationExecutionId(v string) *AutomationExecution {
	s.AutomationExecutionId = &v
	return s
}

// SetAutomationExecutionStatus sets the AutomationExecutionStatus field's value.
func (s *AutomationExecution) SetAutomationExecutionStatus(v string) *AutomationExecution {
	s.AutomationExecutionStatus = &v
	return s
}

// SetAutomationSubtype sets the AutomationSubtype field's value.
func (s *AutomationExecution) SetAutomationSubtype(v string) *AutomationExecution {
	s.AutomationSubtype = &v
	return s
}

// SetChangeRequestName sets the ChangeRequestName field's value.
func (s *AutomationExecution) SetChangeRequestName(v string) *AutomationExecution {
	s.ChangeRequestName = &v
	return s
}

// SetCloudWatchAlarms sets the CloudWatchAlarms field's value.
func (s *AutomationExecution) SetCloudWatchAlarms(v []*string) *AutomationExecution {
	s.CloudWatchAlarms = v
	return s
}

// SetCurrentAction sets the CurrentAction field's value.
func (s *AutomationExecution) SetCurrentAction(v string) *AutomationExecution {
	s.CurrentAction = &v
	return s
}

// SetCurrentStepName sets the CurrentStepName field's value.
func (s *AutomationExecution) SetCurrentStepName(v string) *AutomationExecution {
	s.CurrentStepName = &v
	return s
}

// SetDocumentName sets the DocumentName field's value.
func (s *AutomationExecution) SetDocumentName(v string) *AutomationExecution {
	s.DocumentName = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *AutomationExecution) SetDocumentVersion(v string) *AutomationExecution {
	s.DocumentVersion = &v
	return s
}

// SetExecutedBy sets the ExecutedBy field's value.
func (s *AutomationExecution) SetExecutedBy(v string) *AutomationExecution {
	s.ExecutedBy = &v
	return s
}

// SetExecutionEndTime sets the ExecutionEndTime field's value.
func (s *AutomationExecution) SetExecutionEndTime(v time.Time) *AutomationExecution {
	s.ExecutionEndTime = &v
	return s
}

// SetExecutionStartTime sets the ExecutionStartTime field's value.
func (s *AutomationExecution) SetExecutionStartTime(v time.Time) *AutomationExecution {
	s.ExecutionStartTime = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *AutomationExecution) SetFailureMessage(v string) *AutomationExecution {
	s.FailureMessage = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AutomationExecution) SetMaxConcurrency(v string) *AutomationExecution {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *AutomationExecution) SetMaxErrors(v string) *AutomationExecution {
	s.MaxErrors = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AutomationExecution) SetMode(v string) *AutomationExecution {
	s.Mode = &v
	return s
}

// SetOpsItemId sets the OpsItemId field's value.
func (s *AutomationExecution) SetOpsItemId(v string) *AutomationExecution {
	s.OpsItemId = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AutomationExecution) SetOutputs(v map[string][]*string) *AutomationExecution {
	s.Outputs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *AutomationExecution) SetParameters(v map[string][]*string) *AutomationExecution {
	s.Parameters = v
	return s
}

// SetParentAutomationExecutionId sets the ParentAutomationExecutionId field's value.
func (s *AutomationExecution) SetParentAutomationExecutionId(v string) *AutomationExecution {
	s.ParentAutomationExecutionId = &v
	return s
}

// SetProgressCounters sets the ProgressCounters field's value.
func (s *AutomationExecution) SetProgressCounters(v *ProgressCounters) *AutomationExecution {
	s.ProgressCounters = v
	return s
}

// SetResolvedTargets sets the ResolvedTargets field's value.
func (s *AutomationExecution) SetResolvedTargets(v *ResolvedTargets) *AutomationExecution {
	s.ResolvedTargets = v
	return s
}

// SetRunbooks sets the Runbooks field's value.
func (s *AutomationExecution) SetRunbooks(v []*Runbook) *AutomationExecution {
	s.Runbooks = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *AutomationExecution) SetScheduleExpression(v string) *AutomationExecution {
	s.ScheduleExpression = &v
	return s
}

// SetScheduledAutomationExecutionID sets the ScheduledAutomationExecutionID field's value.
func (s *AutomationExecution) SetScheduledAutomationExecutionID(v string) *AutomationExecution {
	s.ScheduledAutomationExecutionID = &v
	return s
}

// SetScheduledTime sets the ScheduledTime field's value.
func (s *AutomationExecution) SetScheduledTime(v time.Time) *AutomationExecution {
	s.ScheduledTime = &v
	return s
}

// SetStepExecutions sets the StepExecutions field's value.
func (s *AutomationExecution) SetStepExecutions(v []*StepExecution) *AutomationExecution {
	s.StepExecutions = v
	return s
}

// SetStepExecutionsTruncated sets the StepExecutionsTruncated field's value.
func (s *AutomationExecution) SetStepExecutionsTruncated(v bool) *AutomationExecution {
	s.StepExecutionsTruncated = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *AutomationExecution) SetTarget(v string) *AutomationExecution {
	s.Target = &v
	return s
}

// SetTargetLocations sets the TargetLocations field's value.
func (s *AutomationExecution) SetTargetLocations(v []*TargetLocation) *AutomationExecution {
	s.TargetLocations = v
	return s
}

// SetTargetLocationsURL sets the TargetLocationsURL field's value.
func (s *AutomationExecution) SetTargetLocationsURL(v string) *AutomationExecution {
	s.TargetLocationsURL = &v
	return s
}

// SetTargetMaps sets the TargetMaps field's value.
func (s *AutomationExecution) SetTargetMaps(v []map[string][]*string) *AutomationExecution {
	s.TargetMaps = v
	return s
}

// SetTargetParameterName sets the TargetParameterName field's value.
func (s *AutomationExecution) SetTargetParameterName(v string) *AutomationExecution {
	s.TargetParameterName = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AutomationExecution) SetTargets(v []*Target) *AutomationExecution {
	s.Targets = v
	return s
}

// SetTriggeredAlarms sets the TriggeredAlarms field's value.
func (s *AutomationExecution) SetTriggeredAlarms(v []*AlarmStateInformation) *AutomationExecution {
	s.TriggeredAlarms = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *AutomationExecution) SetVariables(v map[string][]*string) *AutomationExecution {
	s.Variables = v
	return s
}

// A filter used to match specific automation executions. This is used to limit
// the scope of Automation execution information returned.
type AutomationExecutionFilter struct {
	_ struct{} `type:"structure"`

	// One or more keys to limit the results.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" enum:"AutomationExecutionFilterKey"`

	// The values used to limit the execution information associated with the filter's
	// key.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomationExecutionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomationExecutionFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AutomationExecutionFilter) SetKey(v string) *AutomationExecutionFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AutomationExecutionFilter) SetValues(v []*string) *AutomationExecutionFilter {
	s.Values = v
	return s
}

// Information about the optional inputs that can be specified for an automation
// execution preview.
type AutomationExecutionInputs struct {
	_ struct{} `type:"structure"`

	// Information about parameters that can be specified for the preview operation.
	Parameters map[string][]*string `min:"1" type:"map"`

	// Information about the Amazon Web Services Regions and Amazon Web Services
	// accounts targeted by the Automation execution preview operation.
	TargetLocations []*TargetLocation `min:"1" type:"list"`

	// A publicly accessible URL for a file that contains the TargetLocations body.
	// Currently, only files in presigned Amazon S3 buckets are supported.
	TargetLocationsURL *string `type:"string"`

	// A key-value mapping of document parameters to target resources. Both Targets
	// and TargetMaps can't be specified together.
	TargetMaps []map[string][]*string `type:"list"`

	// The name of the parameter used as the target resource for the rate-controlled
	// execution. Required if you specify targets.
	TargetParameterName *string `min:"1" type:"string"`

	// Information about the resources that would be included in the actual runbook
	// execution, if it were to be run. Both Targets and TargetMaps can't be specified
	// together.
	Targets []*Target `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionInputs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionInputs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomationExecutionInputs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomationExecutionInputs"}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}
	if s.TargetLocations != nil && len(s.TargetLocations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetLocations", 1))
	}
	if s.TargetParameterName != nil && len(*s.TargetParameterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetParameterName", 1))
	}
	if s.TargetLocations != nil {
		for i, v := range s.TargetLocations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetLocations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *AutomationExecutionInputs) SetParameters(v map[string][]*string) *AutomationExecutionInputs {
	s.Parameters = v
	return s
}

// SetTargetLocations sets the TargetLocations field's value.
func (s *AutomationExecutionInputs) SetTargetLocations(v []*TargetLocation) *AutomationExecutionInputs {
	s.TargetLocations = v
	return s
}

// SetTargetLocationsURL sets the TargetLocationsURL field's value.
func (s *AutomationExecutionInputs) SetTargetLocationsURL(v string) *AutomationExecutionInputs {
	s.TargetLocationsURL = &v
	return s
}

// SetTargetMaps sets the TargetMaps field's value.
func (s *AutomationExecutionInputs) SetTargetMaps(v []map[string][]*string) *AutomationExecutionInputs {
	s.TargetMaps = v
	return s
}

// SetTargetParameterName sets the TargetParameterName field's value.
func (s *AutomationExecutionInputs) SetTargetParameterName(v string) *AutomationExecutionInputs {
	s.TargetParameterName = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AutomationExecutionInputs) SetTargets(v []*Target) *AutomationExecutionInputs {
	s.Targets = v
	return s
}

// The number of simultaneously running Automation executions exceeded the allowable
// limit.
type AutomationExecutionLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionLimitExceededException) GoString() string {
	return s.String()
}

func newErrorAutomationExecutionLimitExceededException(v protocol.ResponseMetadata) error {
	return &AutomationExecutionLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationExecutionLimitExceededException) Code() string {
	return "AutomationExecutionLimitExceededException"
}

// Message returns the exception's message.
func (s *AutomationExecutionLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationExecutionLimitExceededException) OrigErr() error {
	return nil
}

func (s *AutomationExecutionLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationExecutionLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationExecutionLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about a specific Automation execution.
type AutomationExecutionMetadata struct {
	_ struct{} `type:"structure"`

	// The details for the CloudWatch alarm applied to your automation.
	AlarmConfiguration *AlarmConfiguration `type:"structure"`

	// The ID of a State Manager association used in the Automation operation.
	AssociationId *string `type:"string"`

	// The execution ID.
	AutomationExecutionId *string `min:"36" type:"string"`

	// The status of the execution.
	AutomationExecutionStatus *string `type:"string" enum:"AutomationExecutionStatus"`

	// The subtype of the Automation operation. Currently, the only supported value
	// is ChangeRequest.
	AutomationSubtype *string `type:"string" enum:"AutomationSubtype"`

	// Use this filter with DescribeAutomationExecutions. Specify either Local or
	// CrossAccount. CrossAccount is an Automation that runs in multiple Amazon
	// Web Services Regions and Amazon Web Services accounts. For more information,
	// see Running automations in multiple Amazon Web Services Regions and accounts
	// (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html)
	// in the Amazon Web Services Systems Manager User Guide.
	AutomationType *string `type:"string" enum:"AutomationType"`

	// The name of the Change Manager change request.
	ChangeRequestName *string `min:"1" type:"string"`

	// The action of the step that is currently running.
	CurrentAction *string `type:"string"`

	// The name of the step that is currently running.
	CurrentStepName *string `type:"string"`

	// The name of the Automation runbook used during execution.
	DocumentName *string `type:"string"`

	// The document version used during the execution.
	DocumentVersion *string `type:"string"`

	// The IAM role ARN of the user who ran the automation.
	ExecutedBy *string `type:"string"`

	// The time the execution finished. This isn't populated if the execution is
	// still in progress.
	ExecutionEndTime *time.Time `type:"timestamp"`

	// The time the execution started.
	ExecutionStartTime *time.Time `type:"timestamp"`

	// The list of execution outputs as defined in the Automation runbook.
	FailureMessage *string `type:"string"`

	// An S3 bucket where execution information is stored.
	LogFile *string `type:"string"`

	// The MaxConcurrency value specified by the user when starting the automation.
	MaxConcurrency *string `min:"1" type:"string"`

	// The MaxErrors value specified by the user when starting the automation.
	MaxErrors *string `min:"1" type:"string"`

	// The Automation execution mode.
	Mode *string `type:"string" enum:"ExecutionMode"`

	// The ID of an OpsItem that is created to represent a Change Manager change
	// request.
	OpsItemId *string `type:"string"`

	// The list of execution outputs as defined in the Automation runbook.
	Outputs map[string][]*string `min:"1" type:"map"`

	// The execution ID of the parent automation.
	ParentAutomationExecutionId *string `min:"36" type:"string"`

	// A list of targets that resolved during the execution.
	ResolvedTargets *ResolvedTargets `type:"structure"`

	// Information about the Automation runbooks that are run during a runbook workflow
	// in Change Manager.
	//
	// The Automation runbooks specified for the runbook workflow can't run until
	// all required approvals for the change request have been received.
	Runbooks []*Runbook `min:"1" type:"list"`

	ScheduleExpression *string `min:"1" type:"string"`

	ScheduledAutomationExecutionID *string `min:"36" type:"string"`

	// The date and time the Automation operation is scheduled to start.
	ScheduledTime *time.Time `type:"timestamp"`

	// The list of execution outputs as defined in the Automation runbook.
	Target *string `type:"string"`

	TargetLocations []*TargetLocation `min:"1" type:"list"`

	// A publicly accessible URL for a file that contains the TargetLocations body.
	// Currently, only files in presigned Amazon S3 buckets are supported
	TargetLocationsURL *string `type:"string"`

	// The specified key-value mapping of document parameters to target resources.
	TargetMaps []map[string][]*string `type:"list"`

	// The list of execution outputs as defined in the Automation runbook.
	TargetParameterName *string `min:"1" type:"string"`

	// The targets defined by the user when starting the automation.
	Targets []*Target `type:"list"`

	// The CloudWatch alarm that was invoked by the automation.
	TriggeredAlarms []*AlarmStateInformation `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionMetadata) GoString() string {
	return s.String()
}

// SetAlarmConfiguration sets the AlarmConfiguration field's value.
func (s *AutomationExecutionMetadata) SetAlarmConfiguration(v *AlarmConfiguration) *AutomationExecutionMetadata {
	s.AlarmConfiguration = v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AutomationExecutionMetadata) SetAssociationId(v string) *AutomationExecutionMetadata {
	s.AssociationId = &v
	return s
}

// SetAutomationExecutionId sets the AutomationExecutionId field's value.
func (s *AutomationExecutionMetadata) SetAutomationExecutionId(v string) *AutomationExecutionMetadata {
	s.AutomationExecutionId = &v
	return s
}

// SetAutomationExecutionStatus sets the AutomationExecutionStatus field's value.
func (s *AutomationExecutionMetadata) SetAutomationExecutionStatus(v string) *AutomationExecutionMetadata {
	s.AutomationExecutionStatus = &v
	return s
}

// SetAutomationSubtype sets the AutomationSubtype field's value.
func (s *AutomationExecutionMetadata) SetAutomationSubtype(v string) *AutomationExecutionMetadata {
	s.AutomationSubtype = &v
	return s
}

// SetAutomationType sets the AutomationType field's value.
func (s *AutomationExecutionMetadata) SetAutomationType(v string) *AutomationExecutionMetadata {
	s.AutomationType = &v
	return s
}

// SetChangeRequestName sets the ChangeRequestName field's value.
func (s *AutomationExecutionMetadata) SetChangeRequestName(v string) *AutomationExecutionMetadata {
	s.ChangeRequestName = &v
	return s
}

// SetCurrentAction sets the CurrentAction field's value.
func (s *AutomationExecutionMetadata) SetCurrentAction(v string) *AutomationExecutionMetadata {
	s.CurrentAction = &v
	return s
}

// SetCurrentStepName sets the CurrentStepName field's value.
func (s *AutomationExecutionMetadata) SetCurrentStepName(v string) *AutomationExecutionMetadata {
	s.CurrentStepName = &v
	return s
}

// SetDocumentName sets the DocumentName field's value.
func (s *AutomationExecutionMetadata) SetDocumentName(v string) *AutomationExecutionMetadata {
	s.DocumentName = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *AutomationExecutionMetadata) SetDocumentVersion(v string) *AutomationExecutionMetadata {
	s.DocumentVersion = &v
	return s
}

// SetExecutedBy sets the ExecutedBy field's value.
func (s *AutomationExecutionMetadata) SetExecutedBy(v string) *AutomationExecutionMetadata {
	s.ExecutedBy = &v
	return s
}

// SetExecutionEndTime sets the ExecutionEndTime field's value.
func (s *AutomationExecutionMetadata) SetExecutionEndTime(v time.Time) *AutomationExecutionMetadata {
	s.ExecutionEndTime = &v
	return s
}

// SetExecutionStartTime sets the ExecutionStartTime field's value.
func (s *AutomationExecutionMetadata) SetExecutionStartTime(v time.Time) *AutomationExecutionMetadata {
	s.ExecutionStartTime = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *AutomationExecutionMetadata) SetFailureMessage(v string) *AutomationExecutionMetadata {
	s.FailureMessage = &v
	return s
}

// SetLogFile sets the LogFile field's value.
func (s *AutomationExecutionMetadata) SetLogFile(v string) *AutomationExecutionMetadata {
	s.LogFile = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AutomationExecutionMetadata) SetMaxConcurrency(v string) *AutomationExecutionMetadata {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *AutomationExecutionMetadata) SetMaxErrors(v string) *AutomationExecutionMetadata {
	s.MaxErrors = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AutomationExecutionMetadata) SetMode(v string) *AutomationExecutionMetadata {
	s.Mode = &v
	return s
}

// SetOpsItemId sets the OpsItemId field's value.
func (s *AutomationExecutionMetadata) SetOpsItemId(v string) *AutomationExecutionMetadata {
	s.OpsItemId = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AutomationExecutionMetadata) SetOutputs(v map[string][]*string) *AutomationExecutionMetadata {
	s.Outputs = v
	return s
}

// SetParentAutomationExecutionId sets the ParentAutomationExecutionId field's value.
func (s *AutomationExecutionMetadata) SetParentAutomationExecutionId(v string) *AutomationExecutionMetadata {
	s.ParentAutomationExecutionId = &v
	return s
}

// SetResolvedTargets sets the ResolvedTargets field's value.
func (s *AutomationExecutionMetadata) SetResolvedTargets(v *ResolvedTargets) *AutomationExecutionMetadata {
	s.ResolvedTargets = v
	return s
}

// SetRunbooks sets the Runbooks field's value.
func (s *AutomationExecutionMetadata) SetRunbooks(v []*Runbook) *AutomationExecutionMetadata {
	s.Runbooks = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *AutomationExecutionMetadata) SetScheduleExpression(v string) *AutomationExecutionMetadata {
	s.ScheduleExpression = &v
	return s
}

// SetScheduledAutomationExecutionID sets the ScheduledAutomationExecutionID field's value.
func (s *AutomationExecutionMetadata) SetScheduledAutomationExecutionID(v string) *AutomationExecutionMetadata {
	s.ScheduledAutomationExecutionID = &v
	return s
}

// SetScheduledTime sets the ScheduledTime field's value.
func (s *AutomationExecutionMetadata) SetScheduledTime(v time.Time) *AutomationExecutionMetadata {
	s.ScheduledTime = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *AutomationExecutionMetadata) SetTarget(v string) *AutomationExecutionMetadata {
	s.Target = &v
	return s
}

// SetTargetLocations sets the TargetLocations field's value.
func (s *AutomationExecutionMetadata) SetTargetLocations(v []*TargetLocation) *AutomationExecutionMetadata {
	s.TargetLocations = v
	return s
}

// SetTargetLocationsURL sets the TargetLocationsURL field's value.
func (s *AutomationExecutionMetadata) SetTargetLocationsURL(v string) *AutomationExecutionMetadata {
	s.TargetLocationsURL = &v
	return s
}

// SetTargetMaps sets the TargetMaps field's value.
func (s *AutomationExecutionMetadata) SetTargetMaps(v []map[string][]*string) *AutomationExecutionMetadata {
	s.TargetMaps = v
	return s
}

// SetTargetParameterName sets the TargetParameterName field's value.
func (s *AutomationExecutionMetadata) SetTargetParameterName(v string) *AutomationExecutionMetadata {
	s.TargetParameterName = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AutomationExecutionMetadata) SetTargets(v []*Target) *AutomationExecutionMetadata {
	s.Targets = v
	return s
}

// SetTriggeredAlarms sets the TriggeredAlarms field's value.
func (s *AutomationExecutionMetadata) SetTriggeredAlarms(v []*AlarmStateInformation) *AutomationExecutionMetadata {
	s.TriggeredAlarms = v
	return s
}

// There is no automation execution information for the requested automation
// execution ID.
type AutomationExecutionNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionNotFoundException) GoString() string {
	return s.String()
}

func newErrorAutomationExecutionNotFoundException(v protocol.ResponseMetadata) error {
	return &AutomationExecutionNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationExecutionNotFoundException) Code() string {
	return "AutomationExecutionNotFoundException"
}

// Message returns the exception's message.
func (s *AutomationExecutionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationExecutionNotFoundException) OrigErr() error {
	return nil
}

func (s *AutomationExecutionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationExecutionNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationExecutionNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the results of the execution preview.
type AutomationExecutionPreview struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon Web Services Regions targeted by the execution
	// preview.
	Regions []*string `min:"1" type:"list"`

	// Information about the type of impact a runbook step would have on a resource.
	//
	//    * Mutating: The runbook step would make changes to the targets through
	//    actions that create, modify, or delete resources.
	//
	//    * Non_Mutating: The runbook step would retrieve data about resources but
	//    not make changes to them. This category generally includes Describe*,
	//    List*, Get*, and similar read-only API actions.
	//
	//    * Undetermined: An undetermined step invokes executions performed by another
	//    orchestration service like Lambda, Step Functions, or Amazon Web Services
	//    Systems Manager Run Command. An undetermined step might also call a third-party
	//    API. Systems Manager Automation doesn't know the outcome of the orchestration
	//    processes or third-party API executions, so the results of the steps are
	//    undetermined.
	StepPreviews map[string]*int64 `type:"map"`

	// Information that provides a preview of what the impact of running the specified
	// Automation runbook would be.
	TargetPreviews []*TargetPreview `type:"list"`

	// Information about the Amazon Web Services accounts that were included in
	// the execution preview.
	TotalAccounts *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionPreview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationExecutionPreview) GoString() string {
	return s.String()
}

// SetRegions sets the Regions field's value.
func (s *AutomationExecutionPreview) SetRegions(v []*string) *AutomationExecutionPreview {
	s.Regions = v
	return s
}

// SetStepPreviews sets the StepPreviews field's value.
func (s *AutomationExecutionPreview) SetStepPreviews(v map[string]*int64) *AutomationExecutionPreview {
	s.StepPreviews = v
	return s
}

// SetTargetPreviews sets the TargetPreviews field's value.
func (s *AutomationExecutionPreview) SetTargetPreviews(v []*TargetPreview) *AutomationExecutionPreview {
	s.TargetPreviews = v
	return s
}

// SetTotalAccounts sets the TotalAccounts field's value.
func (s *AutomationExecutionPreview) SetTotalAccounts(v int64) *AutomationExecutionPreview {
	s.TotalAccounts = &v
	return s
}

type AutomationParameter struct {
	_ struct{} `type:"structure"`

	Name *string `min:"1" type:"string"`

	Type *string `type:"string" enum:"AutomationParameterType"`

	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationParameter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AutomationParameter) SetName(v string) *AutomationParameter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AutomationParameter) SetType(v string) *AutomationParameter {
	s.Type = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AutomationParameter) SetValues(v []*string) *AutomationParameter {
	s.Values = v
	return s
}

// The specified step name and execution ID don't exist. Verify the information
// and try again.
type AutomationStepNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationStepNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomationStepNotFoundException) GoString() string {
	return s.String()
}

func newErrorAutomationStepNotFoundException(v protocol.ResponseMetadata) error {
	return &AutomationStepNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AutomationStepNotFoundException) Code() string {
	return "AutomationStepNotFoundException"
}

// Message returns the exception's message.
func (s *AutomationStepNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AutomationStepNotFoundException) OrigErr() error {
	return nil
}

func (s *AutomationStepNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AutomationStepNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AutomationStepNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BadRequest struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequest) GoString() string {
	return s.String()
}

func newErrorBadRequest(v protocol.ResponseMetadata) error {
	return &BadRequest{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequest) Code() string {
	return "BadRequest"
}

// Message returns the exception's message.
func (s *BadRequest) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequest) OrigErr() error {
	return nil
}

func (s *BadRequest) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequest) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequest) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines the basic information about a patch baseline override.
type BaselineOverride struct {
	_ struct{} `type:"structure"`

	// A set of rules defining the approval rules for a patch baseline.
	ApprovalRules *PatchRuleGroup `type:"structure"`

	// A list of explicitly approved patches for the baseline.
	//
	// For information about accepted formats for lists of approved patches and
	// rejected patches, see Package name formats for approved and rejected patch
	// lists (https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
	// in the Amazon Web Services Systems Manager User Guide.
	ApprovedPatches []*string `type:"list"`

	// Defines the compliance level for approved patches. When an approved patch
	// is reported as missing, this value describes the severity of the compliance
	// violation.
	ApprovedPatchesComplianceLevel *string `type:"string" enum:"PatchComplianceLevel"`

	// Indicates whether the list of approved patches includes non-security updates
	// that should be applied to the managed nodes. The default value is false.
	// Applies to Linux managed nodes only.
	ApprovedPatchesEnableNonSecurity *bool `type:"boolean"`

	// A set of patch filters, typically used for approval rules.
	GlobalFilters *PatchFilterGroup `type:"structure"`

	// The operating system rule used by the patch baseline override.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// A list of explicitly rejected patches for the baseline.
	//
	// For information about accepted formats for lists of approved patches and
	// rejected patches, see Package name formats for approved and rejected patch
	// lists (https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
	// in the Amazon Web Services Systems Manager User Guide.
	RejectedPatches []*string `type:"list"`

	// The action for Patch Manager to take on patches included in the RejectedPackages
	// list. A patch can be allowed only if it is a dependency of another package,
	// or blocked entirely along with packages that include it as a dependency.
	RejectedPatchesAction *string `type:"string" enum:"PatchAction"`

	// Information about the patches to use to update the managed nodes, including
	// target operating systems and source repositories. Applies to Linux managed
	// nodes only.
	Sources []*PatchSource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaselineOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BaselineOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BaselineOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BaselineOverride"}
	if s.ApprovalRules != nil {
		if err := s.ApprovalRules.Validate(); err != nil {
			invalidParams.AddNested("ApprovalRules", err.(request.ErrInvalidParams))
		}
	}
	if s.GlobalFilters != nil {
		if err := s.GlobalFilters.Validate(); err != nil {
			invalidParams.AddNested("GlobalFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApprovalRules sets the ApprovalRules field's value.
func (s *BaselineOverride) SetApprovalRules(v *PatchRuleGroup) *BaselineOverride {
	s.ApprovalRules = v
	return s
}

// SetApprovedPatches sets the ApprovedPatches field's value.
func (s *BaselineOverride) SetApprovedPatches(v []*string) *BaselineOverride {
	s.ApprovedPatches = v
	return s
}

// SetApprovedPatchesComplianceLevel sets the ApprovedPatchesComplianceLevel field's value.
func (s *BaselineOverride) SetApprovedPatchesComplianceLevel(v string) *BaselineOverride {
	s.ApprovedPatchesComplianceLevel = &v
	return s
}

// SetApprovedPatchesEnableNonSecurity sets the ApprovedPatchesEnableNonSecurity field's value.
func (s *BaselineOverride) SetApprovedPatchesEnableNonSecurity(v bool) *BaselineOverride {
	s.ApprovedPatchesEnableNonSecurity = &v
	return s
}

// SetGlobalFilters sets the GlobalFilters field's value.
func (s *BaselineOverride) SetGlobalFilters(v *PatchFilterGroup) *BaselineOverride {
	s.GlobalFilters = v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *BaselineOverride) SetOperatingSystem(v string) *BaselineOverride {
	s.OperatingSystem = &v
	return s
}

// SetRejectedPatches sets the RejectedPatches field's value.
func (s *BaselineOverride) SetRejectedPatches(v []*string) *BaselineOverride {
	s.RejectedPatches = v
	return s
}

// SetRejectedPatchesAction sets the RejectedPatchesAction field's value.
func (s *BaselineOverride) SetRejectedPatchesAction(v string) *BaselineOverride {
	s.RejectedPatchesAction = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *BaselineOverride) SetSources(v []*PatchSource) *BaselineOverride {
	s.Sources = v
	return s
}

type CancelCommandInput struct {
	_ struct{} `type:"structure"`

	// The ID of the command you want to cancel.
	//
	// CommandId is a required field
	CommandId *string `min:"36" type:"string" required:"true"`

	CommandSignature *CommandSignature `type:"structure"`

	// (Optional) A list of managed node IDs on which you want to cancel the command.
	// If not provided, the command is canceled on every node on which it was requested.
	InstanceIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelCommandInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelCommandInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelCommandInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelCommandInput"}
	if s.CommandId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommandId"))
	}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CommandId", 36))
	}
	if s.CommandSignature != nil {
		if err := s.CommandSignature.Validate(); err != nil {
			invalidParams.AddNested("CommandSignature", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommandId sets the CommandId field's value.
func (s *CancelCommandInput) SetCommandId(v string) *CancelCommandInput {
	s.CommandId = &v
	return s
}

// SetCommandSignature sets the CommandSignature field's value.
func (s *CancelCommandInput) SetCommandSignature(v *CommandSignature) *CancelCommandInput {
	s.CommandSignature = v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *CancelCommandInput) SetInstanceIds(v []*string) *CancelCommandInput {
	s.InstanceIds = v
	return s
}

// Whether or not the command was successfully canceled. There is no guarantee
// that a request can be canceled.
type CancelCommandOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelCommandOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelCommandOutput) GoString() string {
	return s.String()
}

type CancelMaintenanceWindowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the maintenance window execution to stop.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMaintenanceWindowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMaintenanceWindowExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelMaintenanceWindowExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelMaintenanceWindowExecutionInput"}
	if s.WindowExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowExecutionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *CancelMaintenanceWindowExecutionInput) SetWindowExecutionId(v string) *CancelMaintenanceWindowExecutionInput {
	s.WindowExecutionId = &v
	return s
}
