// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// InhibitRuleApplyConfiguration represents an declarative configuration of the InhibitRule type for use
// with apply.
type InhibitRuleApplyConfiguration struct {
	TargetMatch []MatcherApplyConfiguration `json:"targetMatch,omitempty"`
	SourceMatch []MatcherApplyConfiguration `json:"sourceMatch,omitempty"`
	Equal       []string                    `json:"equal,omitempty"`
}

// InhibitRuleApplyConfiguration constructs an declarative configuration of the InhibitRule type for use with
// apply.
func InhibitRule() *InhibitRuleApplyConfiguration {
	return &InhibitRuleApplyConfiguration{}
}

// WithTargetMatch adds the given value to the TargetMatch field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TargetMatch field.
func (b *InhibitRuleApplyConfiguration) WithTargetMatch(values ...*MatcherApplyConfiguration) *InhibitRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTargetMatch")
		}
		b.TargetMatch = append(b.TargetMatch, *values[i])
	}
	return b
}

// WithSourceMatch adds the given value to the SourceMatch field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the SourceMatch field.
func (b *InhibitRuleApplyConfiguration) WithSourceMatch(values ...*MatcherApplyConfiguration) *InhibitRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSourceMatch")
		}
		b.SourceMatch = append(b.SourceMatch, *values[i])
	}
	return b
}

// WithEqual adds the given value to the Equal field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Equal field.
func (b *InhibitRuleApplyConfiguration) WithEqual(values ...string) *InhibitRuleApplyConfiguration {
	for i := range values {
		b.Equal = append(b.Equal, values[i])
	}
	return b
}
