// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package httptracer

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpfConnectionInfoT struct {
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type bpfEgressKeyT struct {
	S_port uint16
	D_port uint16
}

type bpfTcHttpCtx struct {
	XtraBytes uint32
	State     uint8
}

type bpfTcL7ArgsT struct {
	Tp struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	ExtraBytes uint32
	Key        uint32
}

type bpfTpInfoPidT struct {
	Tp struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type bpfTraceMapKeyT struct {
	Conn bpfConnectionInfoT
	Type uint32
}

// loadBpf returns the embedded CollectionSpec for bpf.
func loadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf: %w", err)
	}

	return spec, err
}

// loadBpfObjects loads bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpfObjects
//	*bpfPrograms
//	*bpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfSpecs struct {
	bpfProgramSpecs
	bpfMapSpecs
	bpfVariableSpecs
}

// bpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfProgramSpecs struct {
	BeylaExtendSkb     *ebpf.ProgramSpec `ebpf:"beyla_extend_skb"`
	BeylaTcHttpEgress  *ebpf.ProgramSpec `ebpf:"beyla_tc_http_egress"`
	BeylaTcHttpIngress *ebpf.ProgramSpec `ebpf:"beyla_tc_http_ingress"`
}

// bpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfMapSpecs struct {
	IncomingTraceMap *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	OutgoingTraceMap *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	TcHttpCtxMap     *ebpf.MapSpec `ebpf:"tc_http_ctx_map"`
	TcL7ArgsMem      *ebpf.MapSpec `ebpf:"tc_l7_args_mem"`
	TcL7JumpTable    *ebpf.MapSpec `ebpf:"tc_l7_jump_table"`
	TraceMap         *ebpf.MapSpec `ebpf:"trace_map"`
}

// bpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfVariableSpecs struct {
	EXTEND_SIZE       *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX         *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	Ip4ip6Prefix      *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2       *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// bpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfObjects struct {
	bpfPrograms
	bpfMaps
	bpfVariables
}

func (o *bpfObjects) Close() error {
	return _BpfClose(
		&o.bpfPrograms,
		&o.bpfMaps,
	)
}

// bpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfMaps struct {
	IncomingTraceMap *ebpf.Map `ebpf:"incoming_trace_map"`
	OutgoingTraceMap *ebpf.Map `ebpf:"outgoing_trace_map"`
	TcHttpCtxMap     *ebpf.Map `ebpf:"tc_http_ctx_map"`
	TcL7ArgsMem      *ebpf.Map `ebpf:"tc_l7_args_mem"`
	TcL7JumpTable    *ebpf.Map `ebpf:"tc_l7_jump_table"`
	TraceMap         *ebpf.Map `ebpf:"trace_map"`
}

func (m *bpfMaps) Close() error {
	return _BpfClose(
		m.IncomingTraceMap,
		m.OutgoingTraceMap,
		m.TcHttpCtxMap,
		m.TcL7ArgsMem,
		m.TcL7JumpTable,
		m.TraceMap,
	)
}

// bpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfVariables struct {
	EXTEND_SIZE       *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX         *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.Variable `ebpf:"disable_black_box_cp"`
	Ip4ip6Prefix      *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2       *ebpf.Variable `ebpf:"unused_http2"`
}

// bpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfPrograms struct {
	BeylaExtendSkb     *ebpf.Program `ebpf:"beyla_extend_skb"`
	BeylaTcHttpEgress  *ebpf.Program `ebpf:"beyla_tc_http_egress"`
	BeylaTcHttpIngress *ebpf.Program `ebpf:"beyla_tc_http_ingress"`
}

func (p *bpfPrograms) Close() error {
	return _BpfClose(
		p.BeylaExtendSkb,
		p.BeylaTcHttpEgress,
		p.BeylaTcHttpIngress,
	)
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
