var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { bigrams } from "../../utils";
import { agg } from "../twolayer/agg";
import { greedy } from "../twolayer/greedy";
import { crossings } from "../utils";
import { dfs } from "./dfs";
/** @internal */
function buildOperator(options) {
    function twoLayerCall(layers) {
        const reversed = layers.slice().reverse();
        // save optimal ordering
        let opt = layers.map((l) => l.slice());
        let optCrossings = crossings(opt);
        for (const init of options.inits) {
            init(layers);
            let changed = true;
            for (let i = 0; i < options.passes && changed; ++i) {
                changed = false;
                // top down
                for (const [upper, bottom] of bigrams(layers)) {
                    const init = bottom.slice();
                    options.order(upper, bottom, true);
                    if (bottom.some((node, i) => init[i] !== node)) {
                        changed = true;
                    }
                }
                const topDownCrossings = crossings(layers);
                if (topDownCrossings < optCrossings) {
                    optCrossings = topDownCrossings;
                    opt = layers.map((l) => l.slice());
                }
                // bottom up
                for (const [lower, topl] of bigrams(reversed)) {
                    const init = topl.slice();
                    options.order(topl, lower, false);
                    if (topl.some((node, i) => init[i] !== node)) {
                        changed = true;
                    }
                }
                const bottomUpCrossings = crossings(layers);
                if (bottomUpCrossings < optCrossings) {
                    optCrossings = bottomUpCrossings;
                    opt = layers.map((l) => l.slice());
                }
            }
        }
        // replace optimal ordering
        layers.splice(0, layers.length, ...opt);
    }
    function order(ord) {
        if (ord === undefined) {
            return options.order;
        }
        else {
            const { order: _ } = options, rest = __rest(options, ["order"]);
            return buildOperator(Object.assign(Object.assign({}, rest), { order: ord }));
        }
    }
    twoLayerCall.order = order;
    function inits(val) {
        if (val === undefined) {
            return [...options.inits];
        }
        else if (val.length) {
            const { inits: _ } = options, rest = __rest(options, ["inits"]);
            // not sure why the cast here is necessary
            return buildOperator(Object.assign(Object.assign({}, rest), { inits: [...val] }));
        }
        else {
            throw new Error("inits must be a non-empty array, maybe you intended the singleton noop: `[() => undefined]`");
        }
    }
    twoLayerCall.inits = inits;
    function passes(val) {
        if (val === undefined) {
            return options.passes;
        }
        else if (val <= 0) {
            throw new Error("number of passes must be positive");
        }
        else {
            return buildOperator(Object.assign(Object.assign({}, options), { passes: val }));
        }
    }
    twoLayerCall.passes = passes;
    return twoLayerCall;
}
/**
 * Create a default {@link TwoLayerOperator}, bundled as
 * {@link decrossTwoLayer}.
 */
export function twoLayer(...args) {
    if (args.length) {
        throw new Error(`got arguments to twoLayer(${args}), but constructor takes no arguments.`);
    }
    return buildOperator({
        order: greedy().base(agg()),
        inits: [dfs(), dfs().topDown(false)],
        passes: 24,
    });
}
