/**
 * The {@link GreedyOperator} assigns nodes close to the mean of their parents,
 * then spreads them out.
 *
 * @packageDocumentation
 */
import { CoordOperator } from ".";
/**
 * A {@link CoordOperator} that tries to place nodes close to their parents
 *
 * Nodes that can't be placed at the mean of their parents' location, will be
 * spaced out with their priority equal to their degree.
 *
 * This is generally slower than {@link CenterOperator} but still reasonably
 * fast.
 *
 * Create with {@link greedy}.
 *
 * <img alt="greedy example" src="media://sugi-simplex-opt-greedy.png" width="400">
 */
export declare type GreedyOperator = CoordOperator<unknown, unknown>;
/**
 * Create a new {@link GreedyOperator}, bundled as {@link coordGreedy}.
 */
export declare function greedy(...args: never[]): GreedyOperator;
