/**
 * Stopgap for esnext iterable features
 *
 * @internal
 * @packageDocumentation
 */
/** elements with their zero based index */
export function* entries(iter) {
    let index = 0;
    for (const element of iter) {
        yield [index++, element];
    }
}
/** iterable flat map */
export function* flatMap(iter, callback) {
    for (const [index, element] of entries(iter)) {
        yield* callback(element, index);
    }
}
/** iterable reduce */
export function reduce(iter, callback, initialValue) {
    let accumulator = initialValue;
    for (const [index, element] of entries(iter)) {
        accumulator = callback(accumulator, element, index);
    }
    return accumulator;
}
/** iterable map */
export function* map(iter, callback) {
    for (const [index, element] of entries(iter)) {
        yield callback(element, index);
    }
}
export function* filter(iter, callback) {
    for (const [index, element] of entries(iter)) {
        if (callback(element, index)) {
            yield element;
        }
    }
}
/** iterable some */
export function some(iter, callback) {
    for (const [index, element] of entries(iter)) {
        if (callback(element, index)) {
            return true;
        }
    }
    return false;
}
/** iterable every */
export function every(iter, callback) {
    return !some(iter, (e, i) => !callback(e, i));
}
/** iterator over array reverse */
export function* reverse(arr) {
    for (let i = arr.length; i != 0;) {
        yield arr[--i];
    }
}
