/**
 * Stopgap for esnext iterable features
 *
 * @internal
 * @packageDocumentation
 */
/** iterable callback that maps a value into another */
export interface MapCallback<T, S> {
    (element: T, index: number): S;
}
/** reduce callback */
export interface ReduceCallback<T, S> {
    (accumulator: S, currentValue: T, index: number): S;
}
/** filter guard callback */
export interface FilterGuardCallback<T, S extends T> {
    (element: T, index: number): element is S;
}
/** elements with their zero based index */
export declare function entries<T>(iter: Iterable<T>): IterableIterator<[number, T]>;
/** iterable flat map */
export declare function flatMap<T, S>(iter: Iterable<T>, callback: MapCallback<T, Iterable<S>>): IterableIterator<S>;
/** iterable reduce */
export declare function reduce<T, S>(iter: Iterable<T>, callback: ReduceCallback<T, S>, initialValue: S): S;
/** iterable map */
export declare function map<T, S>(iter: Iterable<T>, callback: MapCallback<T, S>): IterableIterator<S>;
/** guard iterable filter */
export declare function filter<T, S extends T>(iter: Iterable<T>, callback: FilterGuardCallback<T, S>): IterableIterator<S>;
/** generic iterable filter */
export declare function filter<T>(iter: Iterable<T>, callback: MapCallback<T, boolean>): IterableIterator<T>;
/** iterable some */
export declare function some<T>(iter: Iterable<T>, callback: MapCallback<T, boolean>): boolean;
/** iterable every */
export declare function every<T>(iter: Iterable<T>, callback: MapCallback<T, boolean>): boolean;
/** iterator over array reverse */
export declare function reverse<T>(arr: readonly T[]): IterableIterator<T>;
