import { LaneOperator } from ".";
/**
 * A lane operator that assigns lanes greedily, but quickly.
 *
 * Create with {@link greedy}.
 *
 * @example
 *
 * A top down example
 * <img alt="grid example" src="media://grid-greedy-topdown.png" width="200">
 *
 * @example
 *
 * A bottom up example
 * <img alt="grid example" src="media://grid-greedy-bottomup.png" width="200">
 */
export interface GreedyOperator extends LaneOperator<unknown, unknown> {
    /**
     * Set whether the greedy assignment should be top-down or bottom-up.
     * (default: true)
     */
    topDown(val: boolean): GreedyOperator;
    /**
     * Get whether the current operator is set to assign top-down..
     */
    topDown(): boolean;
    /**
     * Set whether to used compressed output
     *
     * If output is compressed a free lane will be chosen over minimizing edge
     * lengths. (default: true)
     */
    compressed(val: boolean): GreedyOperator;
    /** Get the current compressed setting */
    compressed(): boolean;
    /**
     * Set whether to assign bidirectional indices
     *
     * The first node will be assigned lane zero. If bidirectional, the lanes can
     * fan out in either direction from there, otherwise new lanes will always be
     * added to the right. (default: false)
     */
    bidirectional(val: boolean): GreedyOperator;
    /** Get the current bidirectional setting */
    bidirectional(): boolean;
}
/**
 * Create a default {@link GreedyOperator}, bundled as {@link laneGreedy}.
 */
export declare function greedy(...args: never[]): GreedyOperator;
