import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import * as React from 'react';
import { createElement } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { TruncatedText } from './TruncatedText.js';
import { customVariant, customColor, customWeight } from './utils.js';

const Text = React.forwardRef(
  ({ element = "span", variant, weight, color, truncate, italic, textAlignment, children, tabular, ...restProps }, ref) => {
    const styles = useStyles2(getTextStyles, element, variant, color, weight, truncate, italic, textAlignment, tabular);
    const childElement = (ref2) => {
      return createElement(
        element,
        {
          ...restProps,
          style: void 0,
          // Remove the style prop to avoid overriding the styles
          className: styles,
          // When overflowing, the internalRef is passed to the tooltip, which forwards it to the child element
          ref: ref2
        },
        children
      );
    };
    if (!truncate || element === "span") {
      return childElement(void 0);
    }
    return /* @__PURE__ */ jsx(
      TruncatedText,
      {
        childElement,
        children,
        ref
      }
    );
  }
);
Text.displayName = "Text";
const getTextStyles = (theme, element, variant, color, weight, truncate, italic, textAlignment, tabular) => {
  return css([
    {
      margin: 0,
      padding: 0,
      ...customVariant(theme, element, variant)
    },
    variant && {
      ...theme.typography[variant]
    },
    color && {
      color: customColor(color, theme)
    },
    weight && {
      fontWeight: customWeight(weight, theme)
    },
    truncate && {
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    },
    italic && {
      fontStyle: "italic"
    },
    textAlignment && {
      textAlign: textAlignment
    },
    tabular && {
      fontFeatureSettings: '"tnum"'
    }
  ]);
};

export { Text };
//# sourceMappingURL=Text.js.map
