import { jsx } from 'react/jsx-runtime';
import '@grafana/data';
import { useTheme2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { IconButton } from '../IconButton/IconButton.js';
import { getSelectStyles } from './getSelectStyles.js';

const MultiValueContainer = ({ innerProps, children }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsx("div", { ...innerProps, className: styles.multiValueContainer, children });
};
const MultiValueRemove = ({ children, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ jsx(IconButton, { ...innerProps, name: "times", size: "sm", className: styles.multiValueRemove, tooltip: "Remove" });
};

export { MultiValueContainer, MultiValueRemove };
//# sourceMappingURL=MultiValue.js.map
