import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { InlineFieldRow } from '../Forms/InlineFieldRow.js';
import { InlineLabel } from '../Forms/InlineLabel.js';

const SegmentSection = ({
  label,
  htmlFor,
  children,
  fill
}) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsxs(InlineFieldRow, { children: [
    /* @__PURE__ */ jsx(InlineLabel, { htmlFor, width: 12, className: styles.label, children: label }),
    children,
    fill && /* @__PURE__ */ jsx("div", { className: styles.fill, children: /* @__PURE__ */ jsx(InlineLabel, { children: "" }) })
  ] }) });
};
const getStyles = (theme) => ({
  label: css({
    color: theme.colors.primary.text
  }),
  fill: css({
    flexGrow: 1,
    marginBottom: theme.spacing(0.5)
  })
});

export { SegmentSection };
//# sourceMappingURL=SegmentSection.js.map
