import { jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { Component } from 'react';

const ModalsContext = React.createContext({
  component: null,
  props: {},
  showModal: () => {
  },
  hideModal: () => {
  }
});
class ModalsProvider extends Component {
  constructor(props) {
    super(props);
    this.showModal = (component, props) => {
      this.setState({
        component,
        props
      });
    };
    this.hideModal = () => {
      this.setState({
        component: null,
        props: {}
      });
    };
    this.state = {
      component: props.component || null,
      props: props.props || {},
      showModal: this.showModal,
      hideModal: this.hideModal
    };
  }
  render() {
    return /* @__PURE__ */ jsx(ModalsContext.Provider, { value: this.state, children: this.props.children });
  }
}
const ModalRoot = () => /* @__PURE__ */ jsx(ModalsContext.Consumer, { children: ({ component: Component2, props }) => {
  return Component2 ? /* @__PURE__ */ jsx(Component2, { ...props }) : null;
} });
const ModalsController = ModalsContext.Consumer;

export { ModalRoot, ModalsContext, ModalsController, ModalsProvider };
//# sourceMappingURL=ModalsContext.js.map
