import { jsxs, jsx } from 'react/jsx-runtime';
import { selectors } from '@grafana/e2e-selectors';
import { Trans, t } from '../../../utils/i18n.js';
import { IconButton } from '../../IconButton/IconButton.js';
import { Stack } from '../../Layout/Stack/Stack.js';
import { TimePickerTitle } from './TimePickerTitle.js';

function Header({ onClose }) {
  return /* @__PURE__ */ jsxs(Stack, { justifyContent: "space-between", children: [
    /* @__PURE__ */ jsx(TimePickerTitle, { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "time-picker.calendar.select-time", children: "Select a time range" }) }),
    /* @__PURE__ */ jsx(
      IconButton,
      {
        "data-testid": selectors.components.TimePicker.calendar.closeButton,
        tooltip: t(`time-picker.calendar.close`, "Close calendar"),
        name: "times",
        variant: "secondary",
        onClick: onClose
      }
    )
  ] });
}
Header.displayName = "Header";

export { Header };
//# sourceMappingURL=CalendarHeader.js.map
