import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { InlineField } from '../Forms/InlineField.js';
import { FormField } from '../FormField/FormField.js';
import { SecretFormField } from '../SecretFormField/SecretFormField.js';

const BasicAuthSettings = ({ dataSourceConfig, onChange }) => {
  const password = dataSourceConfig.secureJsonData ? dataSourceConfig.secureJsonData.basicAuthPassword : "";
  const onPasswordReset = () => {
    onChange({
      ...dataSourceConfig,
      secureJsonData: {
        ...dataSourceConfig.secureJsonData,
        basicAuthPassword: ""
      },
      secureJsonFields: {
        ...dataSourceConfig.secureJsonFields,
        basicAuthPassword: false
      }
    });
  };
  const onPasswordChange = (event) => {
    onChange({
      ...dataSourceConfig,
      secureJsonData: {
        ...dataSourceConfig.secureJsonData,
        basicAuthPassword: event.currentTarget.value
      }
    });
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(InlineField, { disabled: dataSourceConfig.readOnly, children: /* @__PURE__ */ jsx(
      FormField,
      {
        label: "User",
        labelWidth: 10,
        inputWidth: 18,
        placeholder: "user",
        value: dataSourceConfig.basicAuthUser,
        onChange: (event) => onChange({ ...dataSourceConfig, basicAuthUser: event.currentTarget.value })
      }
    ) }),
    /* @__PURE__ */ jsx(InlineField, { disabled: dataSourceConfig.readOnly, children: /* @__PURE__ */ jsx(
      SecretFormField,
      {
        isConfigured: !!(dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.basicAuthPassword),
        value: password || "",
        inputWidth: 18,
        labelWidth: 10,
        onReset: onPasswordReset,
        onChange: onPasswordChange
      }
    ) })
  ] });
};

export { BasicAuthSettings };
//# sourceMappingURL=BasicAuthSettings.js.map
