import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { selectors } from '@grafana/e2e-selectors';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { linkModelToContextMenuItems, actionModelToContextMenuItems } from '../../utils/dataLinks.js';
import { WithContextMenu } from '../ContextMenu/WithContextMenu.js';
import { MenuGroup } from '../Menu/MenuGroup.js';
import { MenuItem } from '../Menu/MenuItem.js';

const DataLinksContextMenu = ({ children, links, actions, style }) => {
  const styles = useStyles2(getStyles);
  const itemsGroup = [
    { items: linkModelToContextMenuItems(links), label: Boolean(links().length) ? "Data links" : "" }
  ];
  const hasActions = Boolean(actions == null ? void 0 : actions.length);
  if (hasActions) {
    itemsGroup.push({ items: actionModelToContextMenuItems(actions), label: "Actions" });
  }
  const linksCounter = itemsGroup[0].items.length;
  const renderMenuGroupItems = () => {
    return itemsGroup.map((group, groupIdx) => /* @__PURE__ */ jsx(MenuGroup, { label: group.label, children: (group.items || []).map((item, itemIdx) => /* @__PURE__ */ jsx(
      MenuItem,
      {
        url: item.url,
        label: item.label,
        target: item.target,
        icon: item.icon,
        active: item.active,
        onClick: item.onClick,
        className: styles.itemWrapper
      },
      `${group.label}-${groupIdx}-${itemIdx}}`
    )) }, `${group.label}${groupIdx}`));
  };
  const targetClassName = css({
    cursor: "context-menu"
  });
  if (linksCounter > 1 || hasActions) {
    return /* @__PURE__ */ jsx(WithContextMenu, { renderMenuItems: renderMenuGroupItems, children: ({ openMenu }) => {
      return children({ openMenu, targetClassName });
    } });
  } else {
    const linkModel = links()[0];
    return /* @__PURE__ */ jsx(
      "a",
      {
        href: linkModel.href,
        onClick: linkModel.onClick,
        target: linkModel.target,
        title: linkModel.title,
        style: { ...style, overflow: "hidden", display: "flex" },
        "data-testid": selectors.components.DataLinksContextMenu.singleLink,
        children: children({})
      }
    );
  }
};
const getStyles = (theme) => ({
  itemWrapper: css({
    fontSize: 12
  })
});

export { DataLinksContextMenu };
//# sourceMappingURL=DataLinksContextMenu.js.map
