"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionInstrumentation = void 0;
var faro_core_1 = require("@grafana/faro-core");
var metas_1 = require("../../metas");
var sessionManager_1 = require("./sessionManager");
var PersistentSessionsManager_1 = require("./sessionManager/PersistentSessionsManager");
var sessionManagerUtils_1 = require("./sessionManager/sessionManagerUtils");
var SessionInstrumentation = /** @class */ (function (_super) {
    __extends(SessionInstrumentation, _super);
    function SessionInstrumentation() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = '@grafana/faro-web-sdk:instrumentation-session';
        _this.version = faro_core_1.VERSION;
        return _this;
    }
    SessionInstrumentation.prototype.sendSessionStartEvent = function (meta) {
        var _a, _b;
        var session = meta.session;
        if (session && session.id !== ((_a = this.notifiedSession) === null || _a === void 0 ? void 0 : _a.id)) {
            if (this.notifiedSession && this.notifiedSession.id === ((_b = session.attributes) === null || _b === void 0 ? void 0 : _b['previousSession'])) {
                this.api.pushEvent(faro_core_1.EVENT_SESSION_EXTEND, {}, undefined, { skipDedupe: true });
                this.notifiedSession = session;
                return;
            }
            this.notifiedSession = session;
            // no need to add attributes and session id, they are included as part of meta
            // automatically
            this.api.pushEvent(faro_core_1.EVENT_SESSION_START, {}, undefined, { skipDedupe: true });
        }
    };
    SessionInstrumentation.prototype.createInitialSession = function (SessionManager, sessionsConfig) {
        var _a, _b, _c, _d, _e, _f;
        var storedUserSession = SessionManager.fetchUserSession();
        if (sessionsConfig.persistent && sessionsConfig.maxSessionPersistenceTime && storedUserSession) {
            var now = (0, faro_core_1.dateNow)();
            var shouldClearPersistentSession = storedUserSession.lastActivity < now - sessionsConfig.maxSessionPersistenceTime;
            if (shouldClearPersistentSession) {
                PersistentSessionsManager_1.PersistentSessionsManager.removeUserSession();
                storedUserSession = null;
            }
        }
        var lifecycleType;
        var initialSession;
        if ((0, sessionManagerUtils_1.isUserSessionValid)(storedUserSession)) {
            var sessionId = storedUserSession === null || storedUserSession === void 0 ? void 0 : storedUserSession.sessionId;
            initialSession = (0, sessionManagerUtils_1.createUserSessionObject)({
                sessionId: sessionId,
                isSampled: storedUserSession.isSampled || false,
                started: storedUserSession === null || storedUserSession === void 0 ? void 0 : storedUserSession.started,
            });
            var storedUserSessionMeta = storedUserSession === null || storedUserSession === void 0 ? void 0 : storedUserSession.sessionMeta;
            // For resumed sessions we want to merge the previous overrides with the configured ones.
            // If the same key is present in both, the new one will override the old one.
            var overrides = __assign(__assign({}, (_a = sessionsConfig.session) === null || _a === void 0 ? void 0 : _a.overrides), storedUserSessionMeta === null || storedUserSessionMeta === void 0 ? void 0 : storedUserSessionMeta.overrides);
            initialSession.sessionMeta = __assign(__assign({}, sessionsConfig.session), { id: sessionId, attributes: __assign(__assign(__assign({}, (_b = sessionsConfig.session) === null || _b === void 0 ? void 0 : _b.attributes), storedUserSessionMeta === null || storedUserSessionMeta === void 0 ? void 0 : storedUserSessionMeta.attributes), { 
                    // For valid resumed sessions we do not want to recalculate the sampling decision on each init phase.
                    isSampled: initialSession.isSampled.toString() }), overrides: overrides });
            lifecycleType = faro_core_1.EVENT_SESSION_RESUME;
        }
        else {
            var sessionId = (_d = (_c = sessionsConfig.session) === null || _c === void 0 ? void 0 : _c.id) !== null && _d !== void 0 ? _d : (0, metas_1.createSession)().id;
            initialSession = (0, sessionManagerUtils_1.createUserSessionObject)({
                sessionId: sessionId,
                isSampled: (0, sessionManager_1.isSampled)(),
            });
            var overrides = (_e = sessionsConfig.session) === null || _e === void 0 ? void 0 : _e.overrides;
            initialSession.sessionMeta = __assign({ id: sessionId, attributes: __assign({ isSampled: initialSession.isSampled.toString() }, (_f = sessionsConfig.session) === null || _f === void 0 ? void 0 : _f.attributes) }, (overrides ? { overrides: overrides } : {}));
            lifecycleType = faro_core_1.EVENT_SESSION_START;
        }
        return { initialSession: initialSession, lifecycleType: lifecycleType };
    };
    SessionInstrumentation.prototype.registerBeforeSendHook = function (SessionManager) {
        var _a;
        var updateSession = new SessionManager().updateSession;
        (_a = this.transports) === null || _a === void 0 ? void 0 : _a.addBeforeSendHooks(function (item) {
            var _a, _b, _c;
            updateSession();
            var attributes = (_a = item.meta.session) === null || _a === void 0 ? void 0 : _a.attributes;
            if (attributes && (attributes === null || attributes === void 0 ? void 0 : attributes['isSampled']) === 'true') {
                var newItem = JSON.parse(JSON.stringify(item));
                var newAttributes = (_b = newItem.meta.session) === null || _b === void 0 ? void 0 : _b.attributes;
                newAttributes === null || newAttributes === void 0 ? true : delete newAttributes['isSampled'];
                if (Object.keys(newAttributes !== null && newAttributes !== void 0 ? newAttributes : {}).length === 0) {
                    (_c = newItem.meta.session) === null || _c === void 0 ? true : delete _c.attributes;
                }
                return newItem;
            }
            return null;
        });
    };
    SessionInstrumentation.prototype.initialize = function () {
        this.logDebug('init session instrumentation');
        var sessionTrackingConfig = this.config.sessionTracking;
        if (sessionTrackingConfig === null || sessionTrackingConfig === void 0 ? void 0 : sessionTrackingConfig.enabled) {
            var SessionManager = (0, sessionManager_1.getSessionManagerByConfig)(sessionTrackingConfig);
            this.registerBeforeSendHook(SessionManager);
            var _a = this.createInitialSession(SessionManager, sessionTrackingConfig), initialSession = _a.initialSession, lifecycleType = _a.lifecycleType;
            SessionManager.storeUserSession(initialSession);
            var initialSessionMeta = initialSession.sessionMeta;
            this.notifiedSession = initialSessionMeta;
            this.api.setSession(initialSessionMeta);
            if (lifecycleType === faro_core_1.EVENT_SESSION_START) {
                this.api.pushEvent(faro_core_1.EVENT_SESSION_START, {}, undefined, { skipDedupe: true });
            }
            if (lifecycleType === faro_core_1.EVENT_SESSION_RESUME) {
                this.api.pushEvent(faro_core_1.EVENT_SESSION_RESUME, {}, undefined, { skipDedupe: true });
            }
        }
        this.metas.addListener(this.sendSessionStartEvent.bind(this));
    };
    return SessionInstrumentation;
}(faro_core_1.BaseInstrumentation));
exports.SessionInstrumentation = SessionInstrumentation;
//# sourceMappingURL=instrumentation.js.map