"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsoleInstrumentation = void 0;
var faro_core_1 = require("@grafana/faro-core");
var getErrorDetails_1 = require("../errors/getErrorDetails");
var ConsoleInstrumentation = /** @class */ (function (_super) {
    __extends(ConsoleInstrumentation, _super);
    function ConsoleInstrumentation(options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this) || this;
        _this.options = options;
        _this.name = '@grafana/faro-web-sdk:instrumentation-console';
        _this.version = faro_core_1.VERSION;
        _this.errorSerializer = faro_core_1.defaultLogArgsSerializer;
        return _this;
    }
    ConsoleInstrumentation.prototype.initialize = function () {
        var _this = this;
        var _a, _b, _c, _d;
        this.options = __assign(__assign({}, this.options), this.config.consoleInstrumentation);
        var serializeErrors = ((_a = this.options) === null || _a === void 0 ? void 0 : _a.serializeErrors) || !!((_b = this.options) === null || _b === void 0 ? void 0 : _b.errorSerializer);
        this.errorSerializer = serializeErrors
            ? ((_d = (_c = this.options) === null || _c === void 0 ? void 0 : _c.errorSerializer) !== null && _d !== void 0 ? _d : faro_core_1.defaultErrorArgsSerializer)
            : faro_core_1.defaultLogArgsSerializer;
        faro_core_1.allLogLevels
            .filter(function (level) { var _a, _b; return !((_b = (_a = _this.options) === null || _a === void 0 ? void 0 : _a.disabledLevels) !== null && _b !== void 0 ? _b : ConsoleInstrumentation.defaultDisabledLevels).includes(level); })
            .forEach(function (level) {
            /* eslint-disable-next-line no-console */
            console[level] = function () {
                var _a;
                var _b, _c;
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                try {
                    if (level === faro_core_1.LogLevel.ERROR && !((_b = _this.options) === null || _b === void 0 ? void 0 : _b.consoleErrorAsLog)) {
                        var _d = (0, getErrorDetails_1.getDetailsFromConsoleErrorArgs)(args, _this.errorSerializer), value = _d.value, type = _d.type, stackFrames = _d.stackFrames;
                        if (value && !type && !stackFrames) {
                            _this.api.pushError(new Error(ConsoleInstrumentation.consoleErrorPrefix + value));
                            return;
                        }
                        _this.api.pushError(new Error(ConsoleInstrumentation.consoleErrorPrefix + value), { type: type, stackFrames: stackFrames });
                    }
                    else if (level === faro_core_1.LogLevel.ERROR && ((_c = _this.options) === null || _c === void 0 ? void 0 : _c.consoleErrorAsLog)) {
                        var _e = (0, getErrorDetails_1.getDetailsFromConsoleErrorArgs)(args, _this.errorSerializer), value = _e.value, type = _e.type, stackFrames = _e.stackFrames;
                        _this.api.pushLog(value ? [ConsoleInstrumentation.consoleErrorPrefix + value] : args, {
                            level: level,
                            context: {
                                value: value !== null && value !== void 0 ? value : '',
                                type: type !== null && type !== void 0 ? type : '',
                                stackFrames: (stackFrames === null || stackFrames === void 0 ? void 0 : stackFrames.length) ? (0, faro_core_1.defaultErrorArgsSerializer)(stackFrames) : '',
                            },
                        });
                    }
                    else {
                        _this.api.pushLog(args, { level: level });
                    }
                }
                catch (err) {
                    _this.logError(err);
                }
                finally {
                    (_a = _this.unpatchedConsole)[level].apply(_a, args);
                }
            };
        });
    };
    ConsoleInstrumentation.defaultDisabledLevels = [faro_core_1.LogLevel.DEBUG, faro_core_1.LogLevel.TRACE, faro_core_1.LogLevel.LOG];
    ConsoleInstrumentation.consoleErrorPrefix = 'console.error: ';
    return ConsoleInstrumentation;
}(faro_core_1.BaseInstrumentation));
exports.ConsoleInstrumentation = ConsoleInstrumentation;
//# sourceMappingURL=instrumentation.js.map