"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
var __1 = require("..");
var utils_1 = require("../utils");
var utils_2 = require("./utils");
describe('utils', function () {
    describe('mergeResourceSpans', function () {
        it('tests merging with empty traces or resourceSpans', function () {
            expect((0, utils_2.mergeResourceSpans)()).toEqual(undefined);
        });
        it('tests merging with empty traces and some resourceSpans', function () {
            var rs = [generateResourceSpan('thisspan')];
            expect((0, utils_2.mergeResourceSpans)(undefined, rs)).toEqual({ resourceSpans: rs });
        });
        it('tests merging with traces that do not have a resource and resourceSpans', function () {
            var traces = generateTraceEvent('trace');
            traces.payload.resourceSpans = [];
            var rs = [generateResourceSpan('thisspan')];
            expect((0, utils_2.mergeResourceSpans)(traces.payload, rs)).toEqual({ resourceSpans: [] });
        });
        it('tests merging with traces and resourceSpans', function () {
            var _a, _b, _c, _d;
            var traces = generateTraceEvent('trace');
            var rs = [generateResourceSpan('thisspan')];
            expect((0, utils_2.mergeResourceSpans)(traces.payload, rs)).toEqual(__assign(__assign({}, traces.payload), { resourceSpans: [
                    __assign(__assign({}, (((_a = traces.payload.resourceSpans) === null || _a === void 0 ? void 0 : _a[0]) || [])), { scopeSpans: __spreadArray(__spreadArray([], (((_c = (_b = traces.payload.resourceSpans) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c.scopeSpans) || []), true), (((_d = rs[0]) === null || _d === void 0 ? void 0 : _d.scopeSpans) || []), true) }),
                ] }));
        });
    });
    describe('getTransportBody', function () {
        it('test creating a body with a single item', function () {
            var log = generateLog('This is a log');
            var body = (0, __1.getTransportBody)([log]);
            expect(body).toEqual({
                logs: [log.payload],
                meta: {},
            });
        });
        it('test creating a body with a two items of the same type', function () {
            var log1 = generateLog('This is a log');
            var log2 = generateLog('This is also a log');
            var body = (0, __1.getTransportBody)([log1, log2]);
            expect(body).toEqual({
                logs: [log1.payload, log2.payload],
                meta: {},
            });
        });
        it('test creating a body with a items different type (no trace)', function () {
            var log = generateLog('This is a log');
            var event = generateEvent('session_start');
            var exception = generateException('TypeError');
            var body = (0, __1.getTransportBody)([log, event, exception]);
            expect(body).toEqual({
                logs: [log.payload],
                events: [event.payload],
                exceptions: [exception.payload],
                meta: {},
            });
        });
        it('test creating a body with a items different type (with traces)', function () {
            var _a, _b, _c, _d, _e, _f;
            var log1 = generateLog('This is a log');
            var log2 = generateLog('This is also a log');
            var trace1 = generateTraceEvent('session_start');
            var trace2 = generateTraceEvent('session_end');
            var body = (0, __1.getTransportBody)([log1, log2, trace1, trace2]);
            expect(body).toEqual({
                logs: [log1.payload, log2.payload],
                traces: {
                    resourceSpans: [
                        {
                            resource: (_b = (_a = trace1.payload.resourceSpans) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.resource,
                            scopeSpans: __spreadArray(__spreadArray([], (((_d = (_c = trace1.payload.resourceSpans) === null || _c === void 0 ? void 0 : _c[0]) === null || _d === void 0 ? void 0 : _d.scopeSpans) || []), true), (((_f = (_e = trace2.payload.resourceSpans) === null || _e === void 0 ? void 0 : _e[0]) === null || _f === void 0 ? void 0 : _f.scopeSpans) || []), true),
                        },
                    ],
                },
                meta: {},
            });
        });
    });
});
function generateLog(message, meta) {
    if (meta === void 0) { meta = {}; }
    return {
        type: __1.TransportItemType.LOG,
        payload: {
            context: {},
            level: utils_1.LogLevel.LOG,
            message: message,
            timestamp: (0, utils_1.getCurrentTimestamp)(),
        },
        meta: meta,
    };
}
function generateException(value, meta) {
    if (meta === void 0) { meta = {}; }
    return {
        type: __1.TransportItemType.EXCEPTION,
        payload: {
            value: value,
            type: 'exception',
            timestamp: (0, utils_1.getCurrentTimestamp)(),
        },
        meta: meta,
    };
}
function generateEvent(name, meta) {
    if (meta === void 0) { meta = {}; }
    return {
        type: __1.TransportItemType.EVENT,
        payload: {
            name: name,
            timestamp: (0, utils_1.getCurrentTimestamp)(),
        },
        meta: meta,
    };
}
function generateResourceSpan(name) {
    return {
        resource: {
            attributes: [],
            droppedAttributesCount: 0,
        },
        scopeSpans: [
            {
                scope: {
                    name: '@opentelemetry/instrumentation-document-load',
                    version: '0.31.0',
                },
                spans: [
                    {
                        traceId: 'd6bba34860089d3a4ee58df0811b2f5f',
                        spanId: '22c85dd7b7c674e8',
                        parentSpanId: '16cff06b28240ca6',
                        name: 'resourceFetch',
                        kind: 1,
                        startTimeUnixNano: 1679329154423000000,
                        endTimeUnixNano: 1679329154449000000,
                        attributes: [
                            {
                                key: 'session_id',
                                value: {
                                    stringValue: 'KBw5UzUuvF',
                                },
                            },
                            {
                                key: 'component',
                                value: {
                                    stringValue: 'document-load',
                                },
                            },
                            {
                                key: 'http.url',
                                value: {
                                    stringValue: 'http://localhost:5173/@fs/Users/marcoschaefer/Code/faro-web-sdk/packages/web-sdk/dist/esm/transports/otlp/index.js?t=1679329135042',
                                },
                            },
                            {
                                key: 'http.response_content_length',
                                value: {
                                    intValue: 671,
                                },
                            },
                        ],
                        droppedAttributesCount: 0,
                        events: [
                            {
                                attributes: [],
                                name: name,
                                timeUnixNano: 1679329154423000000,
                                droppedAttributesCount: 0,
                            },
                        ],
                        droppedEventsCount: 0,
                        status: {
                            code: 0,
                        },
                        links: [],
                        droppedLinksCount: 0,
                    },
                ],
            },
        ],
    };
}
function generateTraceEvent(name, meta) {
    if (meta === void 0) { meta = {}; }
    return {
        type: __1.TransportItemType.TRACE,
        payload: {
            resourceSpans: [generateResourceSpan(name)],
        },
        meta: meta,
    };
}
//# sourceMappingURL=utils.test.js.map