"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeInstrumentations = void 0;
function initializeInstrumentations(unpatchedConsole, internalLogger, config, metas, transports, api) {
    internalLogger.debug('Initializing instrumentations');
    var instrumentations = [];
    var add = function () {
        var newInstrumentations = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            newInstrumentations[_i] = arguments[_i];
        }
        internalLogger.debug('Adding instrumentations');
        newInstrumentations.forEach(function (newInstrumentation) {
            internalLogger.debug("Adding \"".concat(newInstrumentation.name, "\" instrumentation"));
            var exists = instrumentations.some(function (existingInstrumentation) { return existingInstrumentation.name === newInstrumentation.name; });
            if (exists) {
                internalLogger.warn("Instrumentation ".concat(newInstrumentation.name, " is already added"));
                return;
            }
            newInstrumentation.unpatchedConsole = unpatchedConsole;
            newInstrumentation.internalLogger = internalLogger;
            newInstrumentation.config = config;
            newInstrumentation.metas = metas;
            newInstrumentation.transports = transports;
            newInstrumentation.api = api;
            instrumentations.push(newInstrumentation);
            newInstrumentation.initialize();
        });
    };
    var remove = function () {
        var instrumentationsToRemove = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            instrumentationsToRemove[_i] = arguments[_i];
        }
        internalLogger.debug('Removing instrumentations');
        instrumentationsToRemove.forEach(function (instrumentationToRemove) {
            var _a, _b;
            internalLogger.debug("Removing \"".concat(instrumentationToRemove.name, "\" instrumentation"));
            var existingInstrumentationIndex = instrumentations.reduce(function (acc, existingInstrumentation, existingTransportIndex) {
                if (acc === null && existingInstrumentation.name === instrumentationToRemove.name) {
                    return existingTransportIndex;
                }
                return null;
            }, null);
            if (!existingInstrumentationIndex) {
                internalLogger.warn("Instrumentation \"".concat(instrumentationToRemove.name, "\" is not added"));
                return;
            }
            (_b = (_a = instrumentations[existingInstrumentationIndex]).destroy) === null || _b === void 0 ? void 0 : _b.call(_a);
            instrumentations.splice(existingInstrumentationIndex, 1);
        });
    };
    return {
        add: add,
        get instrumentations() {
            return __spreadArray([], instrumentations, true);
        },
        remove: remove,
    };
}
exports.initializeInstrumentations = initializeInstrumentations;
//# sourceMappingURL=initialize.js.map