---
name: release checklist
about: release checklist template
title: New release for afterburn
labels: jira,kind/release
warning: |
    ⚠️ Template generated by https://github.com/coreos/repo-templates; do not edit downstream
---

# Release process

This project uses [cargo-release][cargo-release] in order to prepare new releases, tag and sign the relevant git commit, and publish the resulting artifacts to [crates.io][crates-io].
The release process follows the usual PR-and-review flow, allowing an external reviewer to have a final check before publishing.

In order to ease downstream packaging of Rust binaries, an archive of vendored dependencies is also provided (only relevant for offline builds).

## Requirements

This guide requires:

 * A web browser (and network connectivity)
 * `git`
 * [GPG setup][GPG setup] and personal key for signing
 * `cargo` (suggested: latest stable toolchain from [rustup][rustup])
 * `cargo-release` (suggested: `cargo install -f cargo-release`)
 * `cargo vendor-filterer` (suggested: `cargo install -f cargo-vendor-filterer`)
 * Write access to this GitHub project
 * A verified account on crates.io
 * Membership in the [Fedora CoreOS Crates Owners group](https://github.com/orgs/coreos/teams/fedora-coreos-crates-owners/members), which will give you upload access to crates.io

## Release checklist

These steps show how to release version `x.y.z` on the `origin` remote (this can be checked via `git remote -av`).
Push access to the upstream repository is required in order to publish the new tag and the PR branch.

:warning:: if `origin` is not the name of the locally configured remote that points to the upstream git repository (i.e. `git@github.com:coreos/afterburn.git`), be sure to assign the correct remote name to the `UPSTREAM_REMOTE` variable.

- prepare environment:
  - [ ] `RELEASE_VER=x.y.z`
  - [ ] `UPSTREAM_REMOTE=origin`
  - [ ] `git checkout -b pre-release-${RELEASE_VER}`

- check `Cargo.toml` for unintended increases of lower version bounds:
  - [ ] `git diff $(git describe --abbrev=0) Cargo.toml`

- update all dependencies:
  - [ ] `cargo update`
  - [ ] `git add Cargo.lock && git commit -m "cargo: update dependencies"`

- write release notes:
  - [ ] write release notes in `docs/release-notes.md`
  - [ ] `git add docs/release-notes.md && git commit -m "docs/release-notes: update for release ${RELEASE_VER}"`

- land the changes:
  - [ ] PR the changes, get them reviewed, approved and merged
  - [ ] if doing a branched release, also include a PR to merge the `docs/release-notes.md` changes into main

- make sure the project is clean:
  - [ ] Make sure `cargo-release` and `cargo-vendor-filterer` are up to date: `cargo install cargo-release cargo-vendor-filterer`
  - [ ] `git checkout main && git pull ${UPSTREAM_REMOTE} main`
  - [ ] `cargo vendor-filterer target/vendor`
  - [ ] `cargo test --all-features --config 'source.crates-io.replace-with="vv"' --config 'source.vv.directory="target/vendor"'`
  - [ ] `cargo clean`
  - [ ] `git clean -fd`

- create release commit on a dedicated branch and tag it (the commit and tag will be signed with the GPG signing key you configured):
  - [ ] `git checkout -b release-${RELEASE_VER}`
  - [ ] `cargo release --execute ${RELEASE_VER}` (and confirm the version when prompted)

- open and merge a PR for this release:
  - [ ] `git push ${UPSTREAM_REMOTE} release-${RELEASE_VER}`
  - [ ] open a web browser and create a PR for the branch above
  - [ ] make sure the resulting PR contains exactly one commit
  - [ ] get the PR reviewed, approved and merged

- publish the artifacts (tag and crate):
  - [ ] `git checkout v${RELEASE_VER}`
  - [ ] verify that `grep "^version = \"${RELEASE_VER}\"$" Cargo.toml` produces output
  - [ ] `git push ${UPSTREAM_REMOTE} v${RELEASE_VER}`
  - [ ] `cargo publish`

- assemble vendor archive:
  - [ ] `cargo vendor-filterer --format=tar.gz --prefix=vendor target/afterburn-${RELEASE_VER}-vendor.tar.gz`

- publish this release on GitHub:
  - [ ] find the new tag in the [GitHub tag list](https://github.com/coreos/afterburn/tags), click the triple dots menu, and create a release for it
  - [ ] copy in the changelog from the release notes doc
  - [ ] upload `target/afterburn-${RELEASE_VER}-vendor.tar.gz`
  - [ ] record digests of local artifacts:
    - `sha256sum target/package/afterburn-${RELEASE_VER}.crate`
    - `sha256sum target/afterburn-${RELEASE_VER}-vendor.tar.gz`
  - [ ] publish release

- clean up the local environment (optional, but recommended):
  - [ ] `cargo clean`
  - [ ] `git checkout main`
  - [ ] `git pull ${UPSTREAM_REMOTE} main`
  - [ ] `git push ${UPSTREAM_REMOTE} :pre-release-${RELEASE_VER} :release-${RELEASE_VER}`
  - [ ] `git branch -d pre-release-${RELEASE_VER} release-${RELEASE_VER}`

- Fedora packaging:
  - [ ] update the `rust-afterburn` spec file in [Fedora](https://src.fedoraproject.org/rpms/rust-afterburn)
    - bump the `Version`
    - switch the `Release` back to `1%{?dist}`
    - remove any patches obsoleted by the new release
    - update changelog
  - [ ] run `spectool -g -S rust-afterburn.spec`
  - [ ] run `kinit your_fas_account@FEDORAPROJECT.ORG`
  - [ ] run `fedpkg new-sources $(spectool -S rust-afterburn.spec | sed 's:.*/::')`
  - [ ] PR the changes in [Fedora](https://src.fedoraproject.org/rpms/rust-afterburn)
  - [ ] once the PR merges to rawhide, merge rawhide into the other relevant branches (e.g. f41) then push those, for example:
    ```bash
    git checkout rawhide
    git pull --ff-only
    git checkout f41
    git merge --ff-only rawhide
    git push origin f41
    ```
  - [ ] on each of those branches run `fedpkg build`
  - [ ] once the builds have finished, submit them to [bodhi](https://bodhi.fedoraproject.org/updates/new), filling in:
    - `rust-afterburn` for `Packages`
    - selecting the build(s) that just completed, except for the rawhide one (which gets submitted automatically)
    - writing brief release notes like "New upstream release; see release notes at `link to GitHub release`"
    - leave `Update name` blank
    - `Type`, `Severity` and `Suggestion` can be left as `unspecified` unless it is a security release. In that case select `security` with the appropriate severity.
    - `Stable karma` and `Unstable` karma can be set to `2` and `-1`, respectively.
  - [ ] [submit a fast-track](https://github.com/coreos/fedora-coreos-config/actions/workflows/add-override.yml) for FCOS testing-devel
  - [ ] [submit a fast-track](https://github.com/coreos/fedora-coreos-config/actions/workflows/add-override.yml) for FCOS next-devel if it is [open](https://github.com/coreos/fedora-coreos-pipeline/blob/main/next-devel/README.md)

CentOS Stream 9 packaging:
  - [ ] Create a `rebase-c9s-afterburn` issue in the internal team-operations repo and follow the steps there

CentOS Stream 10 packaging:
  - [ ] Create a `rebase-c10s-afterburn` issue in the internal team-operations repo and follow the steps there

[cargo-release]: https://github.com/sunng87/cargo-release
[rustup]: https://rustup.rs/
[crates-io]: https://crates.io/
[GPG setup]: https://docs.github.com/en/github/authenticating-to-github/managing-commit-signature-verification
