# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## These strings are used so that the window has a title in tools that
## enumerate/look for window titles. It is not normally visible anywhere.


## Used as list items in sharing menu


##

# Variables:
#   $origin (String): The website origin (e.g. www.mozilla.org)
#   $itemList (String): A formatted list of items (e.g. "camera, microphone and tab audio")
webrtc-sharing-menuitem =
    .label = { $origin } ({ $itemList })

## These strings will display as a tooltip on supported systems where we show
## device sharing state in the OS notification area. We do not use these strings
## on macOS, as global menu bar items do not have native tooltips.


## Tooltips used by the legacy global sharing indicator


## These strings are only used on Mac for menus attached to icons
## near the clock on the mac menubar.
## Variables:
##   $streamTitle (String): the title of the tab using the share.
##   $tabCount (Number): the title of the tab using the share.

webrtc-indicator-menuitem-sharing-camera-with =
    .label = Partagiér la camèrâ avouèc “{ $streamTitle }”
webrtc-indicator-menuitem-sharing-microphone-with =
    .label = Partagiér lo microfono avouèc “{ $streamTitle }”
webrtc-indicator-menuitem-sharing-application-with =
    .label = Partagiér una aplicacion avouèc “{ $streamTitle }”
webrtc-indicator-menuitem-sharing-screen-with =
    .label = Partagiér l'ècran avouèc “{ $streamTitle }”
webrtc-indicator-menuitem-sharing-window-with =
    .label = Partagiér la fenétra avouèc “{ $streamTitle }”
webrtc-indicator-menuitem-sharing-browser-with =
    .label = Partagiér la tirèta avouèc “{ $streamTitle }”

## Variables:
##   $origin (String): the website origin (e.g. www.mozilla.org).


## Special phrasing for sharing devices when the origin is a file url.


## Variables:
##   $origin (String): the first party origin.
##   $thirdParty (String): the third party origin.


##


## These buttons are the possible answers to the various prompts in the "webrtc-allow-share-*" strings.


##

