# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## These strings are used for errors when installing OpenSearch engines, e.g.
## via "Add Search Engine" on the address bar or search bar.
## Variables
## $location-url (String) - the URL of the OpenSearch engine that was attempted to be installed.

opensearch-error-duplicate-title = Bal me ket
opensearch-error-duplicate-desc = { -brand-short-name } pe onongo romo keto larwak me yeny ki bot "{ $location-url }" pien ot aceli ki nying marwate ni dong tye.
opensearch-error-format-title = Kit mape atir
opensearch-error-format-desc = { -brand-short-name } pe onongo twero keto injin yeny ki ii: { $location-url }
opensearch-error-download-title = Bal me gam
opensearch-error-download-desc = { -brand-short-name } pe onongo romo gamo larwak me yeny ki bot: { $location-url }

##

searchbar-submit =
    .tooltiptext = Cwal yeny
# This string is displayed in the search box when the input field is empty
searchbar-input =
    .placeholder = Yeny
searchbar-icon =
    .tooltiptext = Yeny

## Infobar shown when search engine is removed and replaced.
## Variables
## $oldEngine (String) - the search engine to be removed.
## $newEngine (String) - the search engine to replace the removed search engine.


## Infobar shown when default search engine is reset due to an issue reading the settings file.
## Variables
## $newEngine (String) - the name of the new default search engine.


## Infobar shown when user is prompted to install search engine.
## Variables
## $engineName (String) - the name of the search engine to install.


## The following strings are used as input labels.

add-engine-window =
    .title = Med Ingin me Yeny
    .style = min-width: 32em;
add-engine-name = Nying ingin me yeny

## The following placeholders are shown in the inputs when adding a new engine.


## The following strings are used as error messages.


## The following strings are used as labels for the dialog's buttons.

