sys.version_info(major=3, minor=11, micro=1, releaselevel='final', serial=0)

### Timing comparison of `int` functions

| Input type        | builtin (ms)       | fastnumbers (ms)   |
| ----------------: | -----------------: | -----------------: |
|  Small Int String |   13.492 ± 0.373   | **11.004 ± 0.258** |
|        Int String |   14.725 ± 0.386   | **13.151 ± 0.878** |
| Medium Int String |   17.223 ± 0.514   | **13.367 ± 0.789** |
|  Large Int String | **23.453 ± 0.366** |   24.611 ± 0.654   |
|               Int |  **7.815 ± 0.774** |    9.287 ± 0.252   |
|             Float | **18.610 ± 0.782** |   21.966 ± 0.445   |

### Timing comparison of `float` functions

| Input type         | builtin (ms)       | fastnumbers (ms)   |
| -----------------: | -----------------: | -----------------: |
|   Small Int String |  **8.422 ± 0.285** |   13.397 ± 0.791   |
|         Int String |  **9.293 ± 0.262** |   13.264 ± 0.384   |
|  Medium Int String | **10.383 ± 0.474** |   13.756 ± 0.411   |
|   Large Int String |   32.028 ± 0.870   | **18.679 ± 0.575** |
| Small Float String |  **8.601 ± 0.228** |   13.438 ± 0.299   |
|       Float String |   29.338 ± 0.904   | **15.230 ± 0.283** |
| Large Float String |   54.412 ± 1.534   | **15.528 ± 0.310** |
|                Int |  **3.988 ± 0.145** |   11.259 ± 0.415   |
|              Float |  **2.859 ± 0.071** |    9.968 ± 0.152   |

### Timing comparison of `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  157.691 ± 3.084   |  28.967 ± 0.130 | **24.579 ± 0.427** |
|   Small Int String | **19.136 ± 0.057** |  50.437 ± 0.767 |   23.320 ± 0.133   |
|         Int String | **20.313 ± 0.080** |  55.102 ± 0.458 |   25.452 ± 0.183   |
|  Medium Int String | **21.998 ± 0.087** |  66.150 ± 1.078 |   27.011 ± 0.158   |
|   Large Int String | **29.871 ± 0.110** |  90.713 ± 1.015 |   38.452 ± 0.730   |
| Small Float String |  149.079 ± 1.796   |  32.175 ± 1.127 | **24.148 ± 0.082** |
|       Float String |  158.483 ± 2.146   |  39.361 ± 1.154 | **23.777 ± 0.055** |
| Large Float String |  163.482 ± 1.390   |  39.387 ± 0.058 | **24.483 ± 0.198** |
|                Int | **11.471 ± 0.036** | 103.820 ± 1.877 |   20.630 ± 0.674   |
|              Float | **22.415 ± 0.033** | 117.185 ± 2.730 |   34.055 ± 0.577   |

### Timing comparison of `float` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |   85.899 ± 1.685   |  34.438 ± 0.029 | **27.620 ± 0.039** |
|   Small Int String | **13.120 ± 0.063** |  60.600 ± 0.875 |   26.335 ± 0.056   |
|         Int String | **13.260 ± 0.093** |  61.402 ± 1.131 |   26.676 ± 0.025   |
|  Medium Int String | **14.652 ± 0.038** |  69.095 ± 1.247 |   27.654 ± 0.041   |
|   Large Int String |   37.885 ± 0.059   | 114.112 ± 1.530 | **33.053 ± 0.115** |
| Small Float String | **12.880 ± 0.079** |  54.909 ± 0.201 |   26.930 ± 0.340   |
|       Float String |   33.225 ± 0.077   |  94.197 ± 1.488 | **28.975 ± 0.070** |
| Large Float String |   57.571 ± 0.094   | 125.751 ± 2.583 | **28.249 ± 0.043** |
|                Int |  **7.938 ± 1.187** | 102.491 ± 0.703 |   23.810 ± 0.084   |
|              Float |  **6.043 ± 0.050** | 100.980 ± 2.115 |   21.932 ± 0.042   |

### Timing comparison of `float` (but coerce to `int` if possible) functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |   83.327 ± 1.149   |  63.467 ± 0.155 | **28.862 ± 0.455** |
|   Small Int String |   29.489 ± 0.660   |  51.649 ± 0.812 | **26.198 ± 0.055** |
|         Int String |   31.617 ± 0.445   |  56.614 ± 0.215 | **28.697 ± 0.326** |
|  Medium Int String |   35.158 ± 0.498   |  67.712 ± 1.921 | **29.901 ± 0.538** |
|   Large Int String |   70.937 ± 0.204   |  91.398 ± 1.357 | **41.242 ± 0.149** |
| Small Float String |   30.544 ± 1.709   |  86.300 ± 0.604 | **28.901 ± 0.490** |
|       Float String |   67.938 ± 0.177   | 130.818 ± 0.727 | **37.817 ± 0.663** |
| Large Float String |  130.273 ± 2.353   | 159.576 ± 0.289 | **54.364 ± 1.010** |
|                Int | **22.603 ± 0.042** | 103.948 ± 1.462 |   23.448 ± 0.250   |
|              Float |   49.514 ± 0.890   | 104.917 ± 3.527 | **33.458 ± 0.429** |

### Timing comparison of forced `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  228.547 ± 3.790   |  53.770 ± 1.224 | **23.360 ± 0.405** |
|   Small Int String | **16.869 ± 0.029** |  44.043 ± 0.141 |   21.237 ± 0.045   |
|         Int String | **17.910 ± 0.042** |  49.156 ± 0.728 |   23.583 ± 0.124   |
|  Medium Int String | **20.093 ± 0.089** |  93.487 ± 0.869 |   24.909 ± 0.079   |
|   Large Int String | **26.315 ± 0.400** | 135.438 ± 1.671 |   34.653 ± 0.040   |
| Small Float String |  150.824 ± 0.739   |  84.492 ± 0.824 | **23.743 ± 0.577** |
|       Float String |  186.660 ± 1.306   | 131.185 ± 0.389 | **31.834 ± 0.034** |
| Large Float String |  228.777 ± 1.286   | 176.667 ± 0.883 | **47.630 ± 0.656** |
|                Int | **10.418 ± 0.012** |  94.272 ± 0.812 |   18.056 ± 0.035   |
|              Float | **20.310 ± 0.030** | 108.679 ± 2.302 |   30.374 ± 0.185   |

### Timing comparison of forced `int` functions with error handling and denoising

| Input type        | Python (ms)        | fastnumbers (ms)   |
| ----------------: | -----------------: | -----------------: |
|  Small Int String |  139.105 ± 2.718   | **27.289 ± 0.059** |
|        Int String |  142.486 ± 3.238   | **29.521 ± 0.106** |
| Medium Int String |  151.376 ± 0.612   | **30.803 ± 0.725** |
|  Large Int String |  176.196 ± 1.995   | **41.034 ± 0.729** |
|               Int | **13.228 ± 0.022** |   23.824 ± 0.031   |
|             Float | **40.349 ± 0.051** |  147.275 ± 1.867   |

### Timing comparison to check if value can be converted to `int`

| Input type         | try/except (ms) | regex (ms)     | fastnumbers (ms)   |
| -----------------: | --------------: | -------------: | -----------------: |
|  Non-number String | 140.090 ± 1.949 | 34.232 ± 0.834 | **11.001 ± 0.014** |
|   Small Int String |  18.800 ± 0.090 | 40.024 ± 0.056 | **10.813 ± 0.024** |
|         Int String |  19.621 ± 0.040 | 43.323 ± 0.099 | **11.117 ± 0.021** |
|  Medium Int String |  22.261 ± 1.016 | 49.623 ± 0.056 | **11.314 ± 0.050** |
|   Large Int String |  27.774 ± 0.231 | 64.847 ± 0.236 | **11.245 ± 0.024** |
| Small Float String | 133.269 ± 0.912 | 37.699 ± 0.090 | **11.772 ± 0.066** |
|       Float String | 143.097 ± 1.082 | 44.030 ± 0.051 | **12.864 ± 0.091** |
| Large Float String | 145.790 ± 1.723 | 44.044 ± 0.084 | **12.968 ± 0.035** |
|                Int |  12.097 ± 0.037 | 12.761 ± 0.057 |  **9.626 ± 0.037** |
|              Float |  22.631 ± 0.749 | 11.333 ± 0.017 |  **9.631 ± 0.066** |

### Timing comparison to check if value can be converted to `float`

| Input type         | try/except (ms)   | regex (ms)     | fastnumbers (ms)   |
| -----------------: | ----------------: | -------------: | -----------------: |
|  Non-number String |  72.317 ± 1.182   | 37.780 ± 0.045 | **11.799 ± 0.078** |
|   Small Int String |  12.818 ± 0.088   | 50.080 ± 0.714 | **11.701 ± 0.035** |
|         Int String |  13.335 ± 0.027   | 53.343 ± 1.050 | **11.946 ± 0.027** |
|  Medium Int String |  14.497 ± 0.009   | 59.209 ± 0.108 | **12.105 ± 0.064** |
|   Large Int String |  35.766 ± 0.751   | 74.814 ± 0.921 | **12.123 ± 0.026** |
| Small Float String |  13.294 ± 0.116   | 50.389 ± 4.640 | **12.713 ± 0.064** |
|       Float String |  32.504 ± 0.808   | 63.549 ± 0.101 | **13.780 ± 0.043** |
| Large Float String |  54.379 ± 0.046   | 71.365 ± 0.614 | **14.281 ± 1.074** |
|                Int | **8.261 ± 0.042** | 12.730 ± 0.030 |   10.359 ± 0.039   |
|              Float | **6.942 ± 0.043** | 11.528 ± 0.070 |   10.269 ± 0.044   |

### Timing comparison to check if value can be converted to `float` or `int`

| Input type         | try/except (ms)    | regex (ms)     | fastnumbers (ms)   |
| -----------------: | -----------------: | -------------: | -----------------: |
|  Non-number String |   76.922 ± 2.015   | 37.577 ± 0.742 | **11.969 ± 0.074** |
|   Small Int String | **11.434 ± 0.028** | 50.550 ± 0.297 |   11.830 ± 0.030   |
|         Int String | **11.938 ± 0.040** | 53.539 ± 0.330 |   12.078 ± 0.021   |
|  Medium Int String |   13.153 ± 0.026   | 60.581 ± 0.797 | **12.188 ± 0.027** |
|   Large Int String |   33.873 ± 0.086   | 76.177 ± 2.773 | **12.235 ± 0.065** |
| Small Float String | **11.782 ± 0.038** | 49.166 ± 0.931 |   12.728 ± 0.064   |
|       Float String |   30.677 ± 0.107   | 62.722 ± 0.170 | **13.788 ± 0.026** |
| Large Float String |   53.265 ± 0.783   | 70.607 ± 1.505 | **13.818 ± 0.052** |
|                Int |  **6.830 ± 0.050** | 11.113 ± 0.032 |   10.123 ± 0.048   |
|              Float |  **5.612 ± 0.048** |  9.511 ± 0.044 |   10.203 ± 0.033   |

### Timing comparison to check if value can be coerced losslessly to `int`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String | 221.356 ± 3.128 |  49.047 ± 0.861 | **10.732 ± 0.225** |
|   Small Int String |  30.695 ± 0.475 |  29.109 ± 0.522 | **10.581 ± 0.015** |
|         Int String |  32.416 ± 0.144 |  32.272 ± 0.177 | **10.844 ± 0.065** |
|  Medium Int String |  38.298 ± 1.225 |  38.599 ± 0.158 | **10.938 ± 0.058** |
|   Large Int String |  71.065 ± 0.084 |  53.337 ± 0.172 | **11.363 ± 1.014** |
| Small Float String | 147.631 ± 0.605 |  72.999 ± 1.437 | **11.479 ± 0.070** |
|       Float String | 175.277 ± 1.268 | 112.006 ± 0.128 | **12.399 ± 0.013** |
| Large Float String | 201.598 ± 1.203 | 142.936 ± 1.686 | **12.458 ± 0.016** |
|                Int |  18.633 ± 0.025 |  96.076 ± 1.847 |  **9.109 ± 0.064** |
|              Float |  41.923 ± 0.442 | 130.741 ± 0.619 |  **9.079 ± 0.046** |

### Timing comparison of `map` option vs. iterating over `try_float` for a 50 element list

| Input type         | [try_float(x) for x in iterable] (ms) | list(map(try_float, iterable)) (ms) | list(try_float(iterable, map=True)) (ms) | try_float(iterable, map=list) (ms) |
| -----------------: | ------------------------------------: | ----------------------------------: | ---------------------------------------: | ---------------------------------: |
|  Non-number String |                     1299.311 ± 5.254  |                   1247.241 ± 7.474  |                         560.809 ± 1.190  |               **494.486 ± 2.851**  |
|   Small Int String |                     1273.276 ± 1.030  |                   1255.641 ± 6.403  |                         516.167 ± 4.905  |               **446.821 ± 1.338**  |
|         Int String |                     1322.434 ± 6.277  |                   1272.047 ± 8.492  |                         534.366 ± 1.571  |               **477.241 ± 10.376** |
|  Medium Int String |                     1416.366 ± 40.058 |                   1349.562 ± 9.407  |                         566.972 ± 3.462  |               **519.710 ± 29.221** |
|   Large Int String |                     1696.123 ± 20.949 |                   1665.578 ± 7.963  |                         840.430 ± 27.274 |               **751.934 ± 2.454**  |
| Small Float String |                     1433.688 ± 3.826  |                   1373.735 ± 5.937  |                         578.460 ± 1.822  |               **506.822 ± 1.503**  |
|       Float String |                     1461.269 ± 64.907 |                   1353.288 ± 1.358  |                         607.726 ± 1.668  |               **544.253 ± 1.179**  |
| Large Float String |                     1406.407 ± 2.045  |                   1362.415 ± 2.180  |                         617.822 ± 3.848  |               **559.996 ± 5.369**  |
|                Int |                     1203.485 ± 27.449 |                   1201.125 ± 67.883 |                         462.555 ± 23.075 |               **361.679 ± 2.566**  |
|              Float |                     1176.710 ± 11.387 |                   1116.375 ± 3.596  |                         390.160 ± 7.244  |               **327.914 ± 18.740** |

### Timing comparison of `try_array` vs. `map` option for a 50 element list to a numpy array

| Input type         | np.array(try_float(iterable, map=True)) (ms) | try_array(iterable) (ms) | try_array(iterable, output) (ms) |
| -----------------: | -------------------------------------------: | -----------------------: | -------------------------------: |
|   Small Int String |                             743.050 ± 22.348 |         321.168 ± 2.414  |             **290.426 ± 1.651**  |
|         Int String |                             738.374 ± 9.285  |         347.425 ± 1.084  |             **327.643 ± 10.743** |
|  Medium Int String |                             758.418 ± 3.978  |         363.158 ± 7.683  |             **329.252 ± 2.910**  |
|   Large Int String |                            1008.926 ± 15.124 |         588.733 ± 5.415  |             **562.032 ± 3.643**  |
| Small Float String |                             750.907 ± 11.667 |         351.727 ± 6.960  |             **323.021 ± 5.012**  |
|       Float String |                             839.672 ± 4.795  |         443.952 ± 8.718  |             **408.523 ± 3.236**  |
| Large Float String |                             862.456 ± 20.592 |         452.004 ± 1.994  |             **444.893 ± 39.630** |
|                Int |                             656.702 ± 42.060 |         388.861 ± 22.340 |             **339.328 ± 6.071**  |
|              Float |                             527.822 ± 14.362 |         271.859 ± 2.069  |             **243.611 ± 0.738**  |

