/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.threeten.extra.Temporals;

public final class Months
implements TemporalAmount,
Comparable<Months>,
Serializable {
    public static final Months ZERO = new Months(0);
    public static final Months ONE = new Months(1);
    private static final long serialVersionUID = -8903767091325669093L;
    private static final int MONTHS_PER_YEAR = 12;
    private static final Pattern PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?", 2);
    private final int months;

    public static Months of(int months) {
        if (months == 0) {
            return ZERO;
        }
        if (months == 1) {
            return ONE;
        }
        return new Months(months);
    }

    public static Months ofYears(int years) {
        if (years == 0) {
            return ZERO;
        }
        return new Months(Math.multiplyExact(years, 12));
    }

    public static Months from(TemporalAmount amount) {
        if (amount instanceof Months) {
            return (Months)amount;
        }
        Objects.requireNonNull(amount, "amount");
        int months = 0;
        for (TemporalUnit unit : amount.getUnits()) {
            long value = amount.get(unit);
            if (value == 0L) continue;
            long[] converted = Temporals.convertAmount(value, unit, ChronoUnit.MONTHS);
            if (converted[1] != 0L) {
                throw new DateTimeException("Amount could not be converted to a whole number of months: " + value + " " + unit);
            }
            months = Math.addExact(months, Math.toIntExact(converted[0]));
        }
        return Months.of(months);
    }

    public static Months parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches()) {
            int negate = "-".equals(matcher.group(1)) ? -1 : 1;
            String weeksStr = matcher.group(2);
            String daysStr = matcher.group(3);
            if (weeksStr != null || daysStr != null) {
                int months = 0;
                if (daysStr != null) {
                    try {
                        months = Integer.parseInt(daysStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new DateTimeParseException("Text cannot be parsed to a Months, non-numeric months", text, 0, ex);
                    }
                }
                if (weeksStr != null) {
                    try {
                        int years = Math.multiplyExact(Integer.parseInt(weeksStr), 12);
                        months = Math.addExact(months, years);
                    }
                    catch (NumberFormatException ex) {
                        throw new DateTimeParseException("Text cannot be parsed to a Months, non-numeric years", text, 0, ex);
                    }
                }
                return Months.of(Math.multiplyExact(months, negate));
            }
        }
        throw new DateTimeParseException("Text cannot be parsed to a Months", text, 0);
    }

    public static Months between(Temporal startDateInclusive, Temporal endDateExclusive) {
        return Months.of(Math.toIntExact(ChronoUnit.MONTHS.between(startDateInclusive, endDateExclusive)));
    }

    private Months(int months) {
        this.months = months;
    }

    private Object readResolve() {
        return Months.of(this.months);
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.MONTHS) {
            return this.months;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.singletonList(ChronoUnit.MONTHS);
    }

    public int getAmount() {
        return this.months;
    }

    public Months plus(TemporalAmount amountToAdd) {
        return this.plus(Months.from(amountToAdd).getAmount());
    }

    public Months plus(int months) {
        if (months == 0) {
            return this;
        }
        return Months.of(Math.addExact(this.months, months));
    }

    public Months minus(TemporalAmount amountToAdd) {
        return this.minus(Months.from(amountToAdd).getAmount());
    }

    public Months minus(int months) {
        if (months == 0) {
            return this;
        }
        return Months.of(Math.subtractExact(this.months, months));
    }

    public Months multipliedBy(int scalar) {
        if (scalar == 1) {
            return this;
        }
        return Months.of(Math.multiplyExact(this.months, scalar));
    }

    public Months dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Months.of(this.months / divisor);
    }

    public Months negated() {
        return this.multipliedBy(-1);
    }

    public Months abs() {
        return this.months < 0 ? this.negated() : this;
    }

    public Period toPeriod() {
        return Period.ofMonths(this.months);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.months != 0) {
            temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.months != 0) {
            temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
        }
        return temporal;
    }

    @Override
    public int compareTo(Months otherAmount) {
        int thisValue = this.months;
        int otherValue = otherAmount.months;
        return Integer.compare(thisValue, otherValue);
    }

    public boolean equals(Object otherAmount) {
        if (this == otherAmount) {
            return true;
        }
        if (otherAmount instanceof Months) {
            Months other = (Months)otherAmount;
            return this.months == other.months;
        }
        return false;
    }

    public int hashCode() {
        return this.months;
    }

    public String toString() {
        return "P" + this.months + "M";
    }
}

